/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.util;

import com.ibm.ws.portletcontainer.util.PortletContainerCacheHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortletContainerAccessHelper {
    private static final String CLASS_NAME = PortletContainerCacheHelper.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private static final int PORTLET_PATH_LENGTH = "/portlet/".length();

    public static String getInternalPortletMapping(String string, String string2) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getInternalPortletMapping", new Object[]{string, string2});
        }
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = string + "/portlet/" + string2;
        logger.exiting(CLASS_NAME, "getInternalPortletMapping", string3);
        return string3;
    }

    public static String getPortletURI(String string, String string2) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getPortletURI", new Object[]{string, string2});
        }
        if (string == null || string2 == null) {
            return null;
        }
        if (string.length() > string2.length()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getPortletURI", "Given context cannot be longer than the internalPortletMapping.");
            }
            return null;
        }
        String string3 = string2.substring(string.length(), string2.length());
        if (string3.startsWith("/portlet/")) {
            string3 = string3.substring(PORTLET_PATH_LENGTH - 1, string3.length());
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "getPortletURI", "Found portlet name: " + string3);
            }
            string3 = string.concat(string3);
        } else {
            string3 = null;
        }
        logger.exiting(CLASS_NAME, "getPortletURI", string3);
        return string3;
    }
}

