/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.util;

import com.ibm.ws.portletcontainer.core.CoreUtils;
import com.ibm.ws.portletcontainer.core.InternalPortletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.portlet.PortletResponse;

public class PortletContainerCacheHelper {
    private static final String CLASS_NAME = PortletContainerCacheHelper.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private static final List attributes;

    public static List getRequestAttributeExcludeList() {
        return attributes;
    }

    public static Integer getExpirationCache(PortletResponse portletResponse) {
        String[] stringArray;
        logger.entering(CLASS_NAME, "getExpirationCache", portletResponse);
        InternalPortletResponse internalPortletResponse = CoreUtils.getInternalResponse(portletResponse);
        Integer n = internalPortletResponse.getPortletWindow().getPortletDefinition().getExpirationCache();
        if (n != null && (stringArray = (String[])internalPortletResponse.getProperties().get("portlet.expiration-cache")) != null && stringArray.length > 0) {
            n = Integer.valueOf(stringArray[0]);
        }
        logger.exiting(CLASS_NAME, "getExpirationCache", n);
        return n;
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>(9);
        arrayList.add("com.ibm.ws.portletcontainer.core.method");
        arrayList.add("javax.portlet.request");
        arrayList.add("javax.portlet.response");
        arrayList.add("javax.portlet.config");
        arrayList.add("javax.portlet.userinfo");
        arrayList.add("javax.portlet.title");
        arrayList.add("com.ibm.websphere.portlet.filter");
        arrayList.add("com.ibm.websphere.portlet.action");
        arrayList.add("com.ibm.ws.portletcontainer.portletserving.PortletServingServlet.active");
        attributes = Collections.unmodifiableList(arrayList);
    }
}

