/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.util;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionSerializationTracer {
    private static final String CLASS_NAME = SessionSerializationTracer.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");

    public static void check(String string, Object object) {
        if (logger.isLoggable(Level.FINE)) {
            if (object == null) {
                return;
            }
            boolean bl = false;
            if (!(object instanceof Serializable)) {
                logger.logp(Level.SEVERE, CLASS_NAME, "check", "portlet.session.nonserializable.2", new Object[]{string, object.getClass()});
                bl = true;
            } else if (logger.isLoggable(Level.FINEST)) {
                try {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(new ByteArrayOutputStream());
                    objectOutputStream.writeObject(object);
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.util.SessionSerializationTracer.check", (String)"51");
                    logger.logp(Level.SEVERE, CLASS_NAME, "check", "portlet.session.serializable.2", new Object[]{string, object.getClass()});
                    bl = true;
                }
            }
            if (bl && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.SEVERE, CLASS_NAME, "check", "Caller of session.setAttribute", new Exception());
            }
        }
    }
}

