/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.util;

import com.ibm.ws.ffdc.FFDCFilter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StringUtils {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    public static final String lineSeparator;

    public static String nameOf(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("StringUtils: Argument \"aClass\" cannot be null.");
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static void newLine(StringBuffer stringBuffer, int n) {
        stringBuffer.append(lineSeparator);
        StringUtils.indent(stringBuffer, n);
    }

    public static void indent(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
    }

    public static String[] copy(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public static Map copyParameters(Map map) {
        HashMap hashMap = new HashMap(map);
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Parameter map keys must not be null and of type java.lang.String.");
            }
            try {
                entry.setValue(StringUtils.copy((String[])entry.getValue()));
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.portletcontainer.util.StringUtils.copyParameters", (String)"107");
                throw new IllegalArgumentException("Parameter map values must not be null and of type java.lang.String[].");
            }
        }
        return hashMap;
    }

    public static boolean isAbsoluteURL(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("http://") || string.startsWith("https://");
    }

    static {
        int n;
        dontNeedEncoding = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            dontNeedEncoding.set(n);
        }
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        lineSeparator = System.getProperty("line.separator");
    }
}

