/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.util;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlParser {
    private static final String CLASS_NAME = XmlParser.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private static final String XML_PARSER_PROPERTY_FILE = "META-INF/portletcontainer-val.properties";
    private static final Properties defaultProps;
    private Properties props;
    private boolean propsInitialized;
    private static XmlParser instance;

    public static XmlParser getInstance() {
        return instance;
    }

    private XmlParser() {
    }

    private void initProperties() throws IOException {
        logger.entering(CLASS_NAME, "initProperties");
        this.propsInitialized = true;
        this.props = new Properties(defaultProps);
        Object object = this.getClass().getClassLoader().getResources(XML_PARSER_PROPERTY_FILE);
        while (object.hasMoreElements()) {
            URL uRL = object.nextElement();
            InputStream inputStream = uRL.openStream();
            this.props.load(inputStream);
        }
        if (logger.isLoggable(Level.FINER)) {
            object = new PrintWriter(new StringWriter());
            this.props.list((PrintWriter)object);
            logger.exiting(CLASS_NAME, "initProperties", object.toString());
        }
    }

    public Document parseXml(InputStream inputStream, String string, String[] stringArray, String[] stringArray2) throws IOException, SAXException {
        Object object;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "parseXml", new Object[]{inputStream, string});
        }
        if (!this.propsInitialized) {
            this.initProperties();
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Object object2 = this.props.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            String string2 = this.props.getProperty((String)object);
            if ("xsdSource".equals(string2)) {
                documentBuilderFactory.setAttribute((String)object, new Object[]{this.createInputSource(string)});
                continue;
            }
            documentBuilderFactory.setAttribute((String)object, Boolean.valueOf(string2));
        }
        try {
            object2 = documentBuilderFactory.newDocumentBuilder();
            ((DocumentBuilder)object2).setErrorHandler(new ErrorHandler());
            ((DocumentBuilder)object2).setEntityResolver(new EntityResolver(stringArray, stringArray2));
            object = ((DocumentBuilder)object2).parse(inputStream);
            object.normalize();
            logger.exiting(CLASS_NAME, "parseXml", object);
            return object;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException((Throwable)parserConfigurationException, (String)"com.ibm.ws.portletcontainer.portletserving.filter.PortletFilterXmlParser.parseFilterXml", (String)"60");
            throw new SAXException("Failed creating DocumentBuilder", parserConfigurationException);
        }
    }

    private InputSource createInputSource(String string) {
        InputSource inputSource = new InputSource(XmlParser.class.getResourceAsStream(string));
        return inputSource;
    }

    static {
        Properties properties = new Properties();
        properties.setProperty("http://xml.org/sax/features/validation", "true");
        properties.setProperty("http://apache.org/xml/features/validation/schema", "true");
        properties.setProperty("http://xml.org/sax/features/namespaces", "true");
        properties.setProperty("http://apache.org/xml/features/dom/include-ignorable-whitespace", "false");
        properties.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", "xsdSource");
        defaultProps = properties;
        instance = new XmlParser();
    }

    public static class EntityResolver
    implements org.xml.sax.EntityResolver {
        public String publicDTD = null;
        public String[] resourceDTDs = new String[1];
        public String[] resourceDTDNames = new String[1];

        public EntityResolver(String string, String string2, String string3) {
            this.publicDTD = string;
            this.resourceDTDs[0] = string2;
            this.resourceDTDNames[0] = string3;
        }

        public EntityResolver(String[] stringArray, String[] stringArray2) {
            this.resourceDTDs = stringArray;
            this.resourceDTDNames = stringArray2;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            for (int i = 0; i < this.resourceDTDNames.length; ++i) {
                if ((string == null || !string.equals(this.publicDTD)) && (string2 == null || !string2.endsWith(this.resourceDTDNames[i]))) continue;
                InputStream inputStream = this.getClass().getResourceAsStream(this.resourceDTDs[i]);
                if (inputStream != null) {
                    return new InputSource(inputStream);
                }
                throw new SAXException("XML configuration DTD not found: " + this.resourceDTDs[i]);
            }
            throw new SAXException("External entites are not permitted in XML configuration files");
        }
    }

    public static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }
}

