/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.util.impl;

import com.ibm.ws.portletcontainer.util.NamespaceMapper;
import com.ibm.wsspi.portletcontainer.ObjectID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NamespaceMapperImpl
implements NamespaceMapper {
    private static final String CLASS_NAME = NamespaceMapperImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    public static final String NAMESPACE_PREFIX = "ns_";
    public static final int NAMESPACE_PREFIX_LENGTH = "ns_".length();
    public static final char NAMESPACE_SEPERATOR = '_';
    private static final int OID_LENGTH_GUESS = 10;

    public String encode(ObjectID objectID, String string) {
        int n = NAMESPACE_PREFIX_LENGTH + 1 + 10 + string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(NAMESPACE_PREFIX);
        stringBuffer.append(this.encode(objectID));
        stringBuffer.append('_');
        stringBuffer.append(string);
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "encode", "[" + objectID + ',' + string + "] -> [" + stringBuffer.toString() + ']');
        }
        return stringBuffer.toString();
    }

    public String encode(ObjectID objectID, ObjectID objectID2, String string) {
        String string2 = this.encode(objectID);
        String string3 = this.encode(objectID2);
        int n = NAMESPACE_PREFIX_LENGTH + 1 + 1 + string2.length() + string3.length() + string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(NAMESPACE_PREFIX);
        stringBuffer.append(string2);
        stringBuffer.append('_');
        stringBuffer.append(string3);
        stringBuffer.append('_');
        stringBuffer.append(string);
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "encode", "[" + objectID + ',' + objectID2 + ',' + string + "] -> [" + stringBuffer.toString() + ']');
        }
        return stringBuffer.toString();
    }

    public String decode(ObjectID objectID, String string) {
        String string2 = this.encode(objectID);
        String string3 = null;
        if (NamespaceMapperImpl.isInNamespace(string2, string)) {
            int n = NAMESPACE_PREFIX_LENGTH + string2.length() + 1;
            string3 = string.substring(n);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "decode", "[" + objectID + ',' + string + "] -> [" + string3 + ']');
        }
        return string3;
    }

    private String encode(ObjectID objectID) {
        char[] cArray = objectID.toString().toCharArray();
        StringBuffer stringBuffer = new StringBuffer((int)((double)cArray.length * 1.5));
        for (int i = 0; i < cArray.length; ++i) {
            if (!Character.isJavaIdentifierPart(cArray[i])) {
                stringBuffer.append("0x");
                String string = Integer.toHexString(cArray[i]);
                for (int j = 4; j > string.length(); --j) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    private static boolean isInNamespace(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = string2.length();
        if (n3 <= (n = NAMESPACE_PREFIX_LENGTH + n2) || string2.charAt(n) != '_') {
            return false;
        }
        if (!string2.regionMatches(true, 0, NAMESPACE_PREFIX, 0, NAMESPACE_PREFIX_LENGTH)) {
            return false;
        }
        return string2.regionMatches(true, NAMESPACE_PREFIX_LENGTH, string, 0, n2);
    }
}

