/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.webextension;

import com.ibm.websphere.servlet.event.ServletContextEventSource;
import com.ibm.websphere.servlet.event.ServletInvocationListener;
import com.ibm.ws.portletcontainer.core.PortletServlet;
import com.ibm.ws.portletcontainer.core.impl.ServletInvocationListenerImpl;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.servlet.ServletDefinition;
import com.ibm.ws.portletcontainer.om.servlet.WebApplicationDefinition;
import com.ibm.ws.portletcontainer.registry.webapplicationdefinitionregistry.WebApplicationDefinitionRegistry;
import com.ibm.ws.portletcontainer.util.CacheHelper;
import com.ibm.ws.portletcontainer.webextension.PortletServletWrapper;
import com.ibm.ws.webcontainer.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.ServletConfigParmMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class PortletExtensionProcessor
extends WebExtensionProcessor {
    private final Object lock;
    private Map sconfigMap;
    private static final String CLASS_NAME = PortletExtensionProcessor.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");

    public PortletExtensionProcessor(IServletContext iServletContext) throws Exception {
        super(iServletContext);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "PortletExtensionProcessor", iServletContext);
        }
        this.lock = new Object();
        this.sconfigMap = Collections.synchronizedMap(new HashMap());
        this.addPatternList();
        logger.exiting(CLASS_NAME, "PortletExtensionProcessor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "handleRequest", new Object[]{servletRequest, servletResponse});
        }
        if (servletRequest instanceof HttpServletRequest) {
            String string;
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            String string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            String string3 = null;
            if (string2 == null) {
                string3 = httpServletRequest.getServletPath();
                if (httpServletRequest.getPathInfo() != null) {
                    string3 = string3 + httpServletRequest.getPathInfo();
                }
            } else {
                string = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
                string3 = string2;
                if (string != null) {
                    string3 = string3 + string;
                }
            }
            string = null;
            Object object = this.lock;
            synchronized (object) {
                string = this.extensionContext.getMappingTarget(string3);
                if (string == this) {
                    IServletConfig iServletConfig = this.getServletConfig(string3);
                    string = this.createServletWrapper(iServletConfig);
                    this.extensionContext.replaceMappingTarget(string3, (RequestProcessor)string);
                }
            }
            string.handleRequest(servletRequest, servletResponse);
        }
        logger.exiting(CLASS_NAME, "handleRequest");
    }

    public List getPatternList() {
        logger.entering(CLASS_NAME, "getPatternList");
        logger.exiting(CLASS_NAME, "getPatternList", Collections.EMPTY_LIST);
        return Collections.EMPTY_LIST;
    }

    private void addPatternList() throws Exception {
        logger.entering(CLASS_NAME, "addPatternList");
        WebApplicationDefinition webApplicationDefinition = WebApplicationDefinitionRegistry.getInstance().getWebApplicationDefinition(this.extensionContext.getContextPath());
        if (webApplicationDefinition != null) {
            ArrayList arrayList = new ArrayList();
            boolean bl = logger.isLoggable(Level.FINEST);
            Iterator iterator = webApplicationDefinition.getPortletApplicationDefinition().getPortletDefinitionList().iterator();
            while (iterator.hasNext()) {
                PortletDefinition portletDefinition = (PortletDefinition)iterator.next();
                ServletDefinition servletDefinition = portletDefinition.getServletDefinition();
                String string = servletDefinition.getServletMapping().getUrlPattern();
                IServletConfig iServletConfig = this.createServletConfig(string, portletDefinition);
                if (bl) {
                    logger.logp(Level.FINEST, CLASS_NAME, "addPatternList", "Registering uri: " + string);
                }
                ServletContextEventSource servletContextEventSource = (ServletContextEventSource)iServletConfig.getServletContext().getAttribute("com.ibm.websphere.servlet.event.ServletContextEventSource");
                servletContextEventSource.addServletInvocationListener((ServletInvocationListener)new ServletInvocationListenerImpl());
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "addPatternList", "InvocationListener registered: " + this.extensionContext.getContextPath());
                }
                this.extensionContext.addMappingTarget(string, (RequestProcessor)this);
            }
            this.extensionContext.addMappingTarget("/portlet/*", (RequestProcessor)this);
        }
        logger.exiting(CLASS_NAME, "addPatternList");
    }

    public IServletWrapper createServletWrapper(IServletConfig iServletConfig) throws Exception {
        PortletServletWrapper portletServletWrapper = new PortletServletWrapper(this.extensionContext);
        portletServletWrapper.initialize(iServletConfig);
        return portletServletWrapper;
    }

    public IServletConfig createServletConfig(String string, PortletDefinition portletDefinition) throws ServletException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createServletConfig", new Object[]{string, portletDefinition});
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("portlet.class", portletDefinition.getClassName());
        HashMap<Class, PortletDefinition> hashMap2 = new HashMap<Class, PortletDefinition>();
        hashMap2.put(PortletDefinition.class, portletDefinition);
        ServletConfigParmMap servletConfigParmMap = new ServletConfigParmMap();
        servletConfigParmMap.put(ServletConfigParmMap.SERVLETNAME, (Object)portletDefinition.getName());
        servletConfigParmMap.put(ServletConfigParmMap.DISPLAYNAME, (Object)portletDefinition.getName());
        servletConfigParmMap.put(ServletConfigParmMap.SERVLETCONTEXT, (Object)this.extensionContext);
        servletConfigParmMap.put(ServletConfigParmMap.ISJSP, (Object)Boolean.FALSE);
        servletConfigParmMap.put(ServletConfigParmMap.INITPARAMS, hashMap);
        servletConfigParmMap.put(ServletConfigParmMap.FILENAME, (Object)string);
        servletConfigParmMap.put(ServletConfigParmMap.CLASSNAME, (Object)PortletServlet.class.getName());
        servletConfigParmMap.put(ServletConfigParmMap.ATTRIBUTE, hashMap2);
        servletConfigParmMap.put(ServletConfigParmMap.CACHINGENABLED, (Object)CacheHelper.isCachingEnabled(portletDefinition));
        servletConfigParmMap.put(ServletConfigParmMap.STATISTICSENABLED, (Object)Boolean.FALSE);
        IServletConfig iServletConfig = this.createConfig(string, servletConfigParmMap);
        this.sconfigMap.put(string, iServletConfig);
        logger.exiting(CLASS_NAME, "createServletConfig", iServletConfig);
        return iServletConfig;
    }

    public IServletConfig getServletConfig(String string) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "getServletConfig", string);
        }
        IServletConfig iServletConfig = (IServletConfig)this.sconfigMap.get(string);
        logger.exiting(CLASS_NAME, "getServletConfig", iServletConfig);
        return iServletConfig;
    }
}

