/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.portletcontainer;

import com.ibm.wsspi.portletcontainer.IdentifierNamespace;
import com.ibm.wsspi.portletcontainer.ObjectID;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import java.util.HashMap;
import java.util.Map;

public class PortletWindowIdentifierAdapter
implements PortletWindowIdentifier {
    private String contextRoot;
    private String portletName;
    private Map scopeToIdMap;
    private static final IdentifierNamespace[] NAMESPACES = new IdentifierNamespace[]{IdentifierNamespace.REQUEST, IdentifierNamespace.SESSION, IdentifierNamespace.MARKUP, IdentifierNamespace.URL, IdentifierNamespace.LOGGING};

    public PortletWindowIdentifierAdapter(String string, String string2, ObjectID objectID) {
        this.contextRoot = string;
        this.portletName = string2;
        this.scopeToIdMap = new HashMap();
        int n = 0;
        while (n < NAMESPACES.length) {
            this.scopeToIdMap.put(NAMESPACES[n++], objectID);
        }
    }

    public PortletWindowIdentifierAdapter(String string, String string2, Map map) {
        this.contextRoot = string;
        this.portletName = string2;
        this.scopeToIdMap = map;
        int n = 0;
        while (n < NAMESPACES.length) {
            if (map.containsKey(NAMESPACES[n++])) continue;
            throw new IllegalArgumentException("Parameter scopeToIdMap does not contain all IdentifierNamespace scopes.");
        }
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public ObjectID getId(IdentifierNamespace identifierNamespace) {
        return (ObjectID)this.scopeToIdMap.get(identifierNamespace);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PortletWindowIdentifier)) {
            return false;
        }
        PortletWindowIdentifier portletWindowIdentifier = (PortletWindowIdentifier)object;
        boolean bl = true;
        for (int i = 0; i < NAMESPACES.length && bl; ++i) {
            bl = this.getId(NAMESPACES[i]).equals(portletWindowIdentifier.getId(NAMESPACES[i]));
        }
        return bl && this.portletName.equals(portletWindowIdentifier.getPortletName()) && this.contextRoot.equals(portletWindowIdentifier.getContextRoot());
    }

    public String toString() {
        return "PortletWindowIdentifier[" + this.getId(IdentifierNamespace.LOGGING) + ", " + this.contextRoot + ", " + this.portletName + "]";
    }
}

