/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.portletcontainer.util;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.portletcontainer.portletserving.core.PortletControlParameter;
import com.ibm.ws.portletcontainer.portletserving.util.URLTokenizer;
import com.ibm.wsspi.portletcontainer.InvalidURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

public class PortletURLHelper {
    private static final String CLASS_NAME = PortletURLHelper.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private String context;
    private String portletName;
    private String portletWindowId;
    private String version;
    private boolean action;
    private String portletMode;
    private String windowState;
    private Map rParams = new HashMap();
    public static final String URL_TARGET_WINDOWID = "com.ibm.wsspi.portlet.url.target.wid";
    public static final String URL_PREFIX = "com.ibm.wsspi.portlet.url.prefix";
    public static final String URL_SUFFIX = "com.ibm.wsspi.portlet.url.suffix";
    public static final String URL_QUERYPARAMS = "com.ibm.wsspi.portlet.url.queryparams";

    public PortletURLHelper(String string) throws InvalidURLException {
        this.analyzeURL(string);
    }

    public PortletURLHelper(String string, String string2, String string3) throws InvalidURLException {
        this.context = string;
        this.portletName = string2;
        this.analyzePathInfo(string3);
    }

    public String getContext() {
        return this.context;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public String getPortletWindowId() {
        return this.portletWindowId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isAction() {
        return this.action;
    }

    public String getPortletMode() {
        return this.portletMode;
    }

    public String getWindowState() {
        return this.windowState;
    }

    public Map getRenderParameters() {
        return this.rParams;
    }

    public static PortletMode getPortletMode(String string) {
        if (string == null) {
            return null;
        }
        if (PortletMode.VIEW.toString().equals(string)) {
            return PortletMode.VIEW;
        }
        if (PortletMode.EDIT.toString().equals(string)) {
            return PortletMode.EDIT;
        }
        if (PortletMode.HELP.toString().equals(string)) {
            return PortletMode.HELP;
        }
        return new PortletMode(string);
    }

    public static WindowState getWindowState(String string) {
        if (string == null) {
            return null;
        }
        if (WindowState.NORMAL.toString().equals(string)) {
            return WindowState.NORMAL;
        }
        if (WindowState.MAXIMIZED.toString().equals(string)) {
            return WindowState.MAXIMIZED;
        }
        if (WindowState.MINIMIZED.toString().equals(string)) {
            return WindowState.MINIMIZED;
        }
        return new WindowState(string);
    }

    private void analyzePathInfo(String string) throws InvalidURLException {
        logger.entering(CLASS_NAME, "analyzePathInfo", string);
        boolean bl = logger.isLoggable(Level.FINEST);
        if (string == null) {
            string = "";
        }
        URLTokenizer uRLTokenizer = new URLTokenizer(string, "/");
        this.analyzePathInfo(uRLTokenizer, bl);
        logger.exiting(CLASS_NAME, "analyzePathInfo");
    }

    private void analyzeURL(String string) throws InvalidURLException {
        logger.entering(CLASS_NAME, "analyzeURL", string);
        boolean bl = logger.isLoggable(Level.FINEST);
        URLTokenizer uRLTokenizer = new URLTokenizer(string, "/");
        this.context = uRLTokenizer.nextToken();
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "analyzeURL", "context: " + this.context);
        }
        this.verifyParameterValue(this.context);
        this.portletName = uRLTokenizer.nextToken();
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "analyzeURL", "portletName: " + this.portletName);
        }
        this.verifyParameterValue(this.portletName);
        this.analyzePathInfo(uRLTokenizer, bl);
        logger.exiting(CLASS_NAME, "analyzeURL");
    }

    private void analyzePathInfo(URLTokenizer uRLTokenizer, boolean bl) throws InvalidURLException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "analyzePathInfo", uRLTokenizer);
        }
        this.version = "1.0";
        if (uRLTokenizer.hasMoreTokens()) {
            String string;
            this.portletWindowId = uRLTokenizer.nextToken();
            if (bl) {
                logger.logp(Level.FINEST, CLASS_NAME, "analyzePathInfo", "PortletWindowId: " + this.portletWindowId);
            }
            this.verifyParameterValue(this.portletWindowId);
            String string2 = string = uRLTokenizer.hasMoreTokens() ? uRLTokenizer.nextToken() : "";
            if (PortletControlParameter.isVersionParam(string)) {
                String[] stringArray = this.analyzePortletStateToken(string, bl);
                this.version = stringArray[1];
                if (bl) {
                    logger.logp(Level.FINEST, CLASS_NAME, "analyzePathInfo", "Version: " + this.version);
                }
                if (!"1.0".equalsIgnoreCase(this.version)) {
                    throw new InvalidURLException(this.getInvalidURLMessage());
                }
                string = this.analyzePortletState(uRLTokenizer, bl);
            }
            if (!"".equals(string)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "analyzePathInfo", "Last unanalyzed token:" + string);
                }
                throw new InvalidURLException(this.getInvalidURLMessage());
            }
        } else {
            this.portletWindowId = "default";
        }
        logger.exiting(CLASS_NAME, "analyzePathInfo");
    }

    private String analyzePortletState(URLTokenizer uRLTokenizer, boolean bl) throws InvalidURLException {
        String[] stringArray;
        String string;
        String string2 = string = uRLTokenizer.hasMoreTokens() ? uRLTokenizer.nextToken() : "";
        if (PortletControlParameter.isActionParam(string)) {
            if (bl) {
                logger.logp(Level.FINEST, CLASS_NAME, "analyzePortletState", "Recognized Action.");
            }
            this.action = true;
            String string3 = string = uRLTokenizer.hasMoreTokens() ? uRLTokenizer.nextToken() : "";
        }
        if (PortletControlParameter.isPortletModeParam(string)) {
            stringArray = this.analyzePortletStateToken(string, bl);
            this.portletMode = stringArray[1];
            String string4 = string = uRLTokenizer.hasMoreTokens() ? uRLTokenizer.nextToken() : "";
        }
        if (PortletControlParameter.isWindowStateParam(string)) {
            stringArray = this.analyzePortletStateToken(string, bl);
            this.windowState = stringArray[1];
            String string5 = string = uRLTokenizer.hasMoreTokens() ? uRLTokenizer.nextToken() : "";
        }
        if (PortletControlParameter.isRenderParam(string)) {
            boolean bl2 = true;
            while (bl2) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
                String string6 = stringTokenizer.nextToken();
                if (!PortletControlParameter.isStateControlParamName(string6)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "analyzePortletState", "Last unanalyzed token:" + string6);
                    }
                    throw new InvalidURLException(this.getInvalidURLMessage());
                }
                if (!stringTokenizer.hasMoreTokens()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "analyzePortletState", "Render parameters must at least have a name.");
                    }
                    throw new InvalidURLException(this.getInvalidURLMessage());
                }
                String string7 = PortletControlParameter.decodeParameterName(stringTokenizer.nextToken());
                this.verifyParameterValue(string7);
                String[] stringArray2 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    stringArray2 = new String[stringTokenizer.countTokens()];
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string8 = stringTokenizer.nextToken();
                        this.verifyParameterValue(string8);
                        stringArray2[n] = PortletControlParameter.decodeValue(string8);
                        ++n;
                    }
                }
                if (bl) {
                    logger.logp(Level.FINEST, CLASS_NAME, "analyzePortletState", "RParam Name: " + string7 + " - Values: " + stringArray2);
                }
                this.rParams.put(string7, stringArray2);
                string = uRLTokenizer.hasMoreTokens() ? uRLTokenizer.nextToken() : "";
                if (PortletControlParameter.isRenderParam(string)) continue;
                bl2 = false;
            }
        }
        return string;
    }

    private String[] analyzePortletStateToken(String string, boolean bl) throws InvalidURLException {
        String[] stringArray;
        logger.entering(CLASS_NAME, "analyzeControlParameterToken", string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.countTokens() != 2) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "analyzeControlParameterToken", "Control parameter token must have name and value:" + string);
            }
            throw new InvalidURLException(this.getInvalidURLMessage());
        }
        stringArray = new String[]{PortletControlParameter.decodeParameterName(stringTokenizer.nextToken()), PortletControlParameter.decodeParameterValue(stringArray[0], stringTokenizer.nextToken())};
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "analyzeControlParameterToken", "Name: " + stringArray[0] + " - Value: " + stringArray[1]);
        }
        this.verifyParameterValue(stringArray[1]);
        logger.exiting(CLASS_NAME, "analyzeControlParameterToken", stringArray);
        return stringArray;
    }

    private void verifyParameterValue(String string) throws InvalidURLException {
        if ("".equals(string)) {
            throw new InvalidURLException(this.getInvalidURLMessage());
        }
    }

    private String getInvalidURLMessage() {
        return nls.getString("portletserving.invalid.url.error.0", "An InvalidURLException occurred. The provided portlet url is invalid.");
    }

    public static String encodeParameter(String string) {
        return PortletControlParameter.encodeValue(string);
    }
}

