/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.utils.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleXMLParser {
    private Document m_document = null;
    private static final String S_PATH_SEPARATOR = "/";
    private static final String S_EMPTY = "";
    private static final String S_UTF_8 = "UTF-8";
    private static final String S_YES = "yes";
    private static final String S_NO = "no";
    private static final String S_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private static final String S_N_INDENT_AMOUNT = "4";

    public SimpleXMLParser(Document document) {
        this.m_document = document;
    }

    public SimpleXMLParser(File file) throws ParserConfigurationException, SAXException, IOException {
        this(file, true);
    }

    public SimpleXMLParser(File file, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = this.getDocumentBuilder(bl);
        FileInputStream fileInputStream = new FileInputStream(file);
        this.m_document = documentBuilder.parse(fileInputStream);
        fileInputStream.close();
    }

    public SimpleXMLParser(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        this(inputStream, true);
    }

    public SimpleXMLParser(InputStream inputStream, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = this.getDocumentBuilder(bl);
        this.m_document = documentBuilder.parse(inputStream);
    }

    public SimpleXMLParser(String string) throws ParserConfigurationException, SAXException, IOException {
        this(string, true);
    }

    public SimpleXMLParser(String string, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = this.getDocumentBuilder(bl);
        this.m_document = documentBuilder.parse(new InputSource(new StringReader(string)));
    }

    public static Document createNewDocument() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    public static Element addNestedElement(String string, String string2, Hashtable hashtable, Node node) {
        Document document = null;
        document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement(string);
        if (string2 != null) {
            SimpleXMLParser.setNodeText(element, string2);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement().toString();
                String string4 = hashtable.get(string3).toString();
                element.setAttribute(string3, string4);
            }
        }
        if (node.hasChildNodes() && node.getLastChild().getNodeType() == 3) {
            node.insertBefore(element, node.getLastChild());
        } else {
            node.appendChild(element);
        }
        return element;
    }

    public Document getDocument() {
        return this.m_document;
    }

    public static String getNodeText(Node node) {
        String string = S_EMPTY;
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0 && node.getNodeType() == 2) {
            return node.getNodeValue();
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 3 || node2.getNodeType() == 4) {
                string = string + node2.getNodeValue();
            }
            if (node2.getNodeType() != 5) continue;
            string = string + SimpleXMLParser.getNodeText(node2);
        }
        return string;
    }

    public static void setNodeText(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            node.removeChild(node2);
        }
        Text text = node.getOwnerDocument().createTextNode(string);
        node.appendChild(text);
    }

    public static String getNodeAttributeValue(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 != null) {
            return SimpleXMLParser.getNodeText(node2);
        }
        return null;
    }

    public static Hashtable getAttriNameAndValueMap(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            hashtable.put(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i).getNodeValue());
        }
        return hashtable;
    }

    public static void setNodeAttributeValue(Node node, String string, String string2) {
        if (node.getNodeType() != 1) {
            return;
        }
        Element element = (Element)node;
        element.setAttribute(string, string2);
    }

    public static Vector getRelativeNodes(Node node, String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, S_PATH_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        Vector vector2 = new Vector(Arrays.asList(node));
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = vector.elementAt(i).toString();
            vector2 = SimpleXMLParser.getAllNamedChildNodes(vector2, string2);
        }
        return vector2;
    }

    public Vector getNodes(String string) {
        return SimpleXMLParser.getRelativeNodes(this.m_document, string);
    }

    public static Vector getChildElements(Node node) {
        NodeList nodeList = node.getChildNodes();
        Vector<Node> vector = new Vector<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            vector.add(node2);
        }
        return vector;
    }

    public static Vector getAllNamedChildNodes(Node node, String string) {
        Object object;
        if (node.getNodeType() != 1 && node.getNodeType() != 9) {
            return new Vector();
        }
        NodeList nodeList = null;
        if (node.getNodeType() == 1) {
            object = (Element)node;
            nodeList = object.getElementsByTagName(string);
        } else {
            object = (Document)node;
            nodeList = object.getElementsByTagName(string);
        }
        object = new Vector();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getParentNode() != node) continue;
            ((Vector)object).add(node2);
        }
        return object;
    }

    public static Vector getAllNamedChildNodes(Node node, String[] stringArray) {
        Vector vector = new Vector();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            vector.addAll(SimpleXMLParser.getAllNamedChildNodes(node, stringArray[i]));
        }
        return vector;
    }

    public static void deleteChildNodes(Node node, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            node.removeChild((Node)vector.elementAt(i));
        }
    }

    public static String getNodeAsXML(Node node, boolean bl) throws TransformerConfigurationException, TransformerException, UnsupportedEncodingException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(new PrintWriter(byteArrayOutputStream));
        transformer.setOutputProperty("indent", S_YES);
        transformer.setOutputProperty("encoding", S_UTF_8);
        transformer.setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
        if (!bl) {
            transformer.setOutputProperty("omit-xml-declaration", S_YES);
        } else {
            transformer.setOutputProperty("omit-xml-declaration", S_NO);
        }
        transformer.transform(dOMSource, streamResult);
        return byteArrayOutputStream.toString(S_UTF_8);
    }

    private static Vector getAllNamedChildNodes(Vector vector, String string) {
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            vector2.addAll(SimpleXMLParser.getAllNamedChildNodes(node, string));
        }
        return vector2;
    }

    private DocumentBuilder getDocumentBuilder(boolean bl) throws FactoryConfigurationError, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setExpandEntityReferences(true);
        documentBuilderFactory.setIgnoringComments(bl);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder;
    }
}

