/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nws.ejs.ras;

import java.util.logging.Level;
import java.util.logging.Logger;

public class TraceComponent {
    Logger logger = null;
    boolean entryExitEnabled = false;
    boolean debugEnabled = false;
    boolean eventEnabled = false;
    boolean warningEnabled = false;
    String baseClassName = null;
    static boolean anyTracingEnabled = false;

    protected TraceComponent(Logger logger, String string) {
        this.logger = logger;
        this.baseClassName = string;
        if (this.logger != null) {
            this.entryExitEnabled = this.logger.isLoggable(Level.FINER);
            this.debugEnabled = this.logger.isLoggable(Level.FINEST);
            this.eventEnabled = this.logger.isLoggable(Level.FINE);
            if (this.entryExitEnabled || this.debugEnabled || this.eventEnabled) {
                anyTracingEnabled = true;
            }
            this.warningEnabled = this.logger.isLoggable(Level.WARNING);
        }
    }

    public static boolean isAnyTracingEnabled() {
        return anyTracingEnabled;
    }

    public boolean isEntryEnabled() {
        return this.entryExitEnabled;
    }

    public boolean isExitEnabled() {
        return this.entryExitEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isEventEnabled() {
        return this.eventEnabled;
    }

    public boolean isWarningEnabled() {
        return this.warningEnabled;
    }

    public void debug(String string) {
        this.logger.logp(Level.FINEST, this.baseClassName, null, string);
    }

    public void debug(String string, Object object) {
        if (object != null) {
            this.debug(string + " " + object.toString());
        } else {
            this.debug(string);
        }
    }

    public void debug(String string, Object[] objectArray) {
        if (objectArray != null) {
            String string2 = string;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                string2 = string2 + " " + objectArray[i].toString();
            }
            this.debug(string2);
        } else {
            this.debug(string);
        }
    }

    public void logEntry(String string) {
        this.logger.logp(Level.FINER, this.baseClassName, null, string + " Entry");
    }

    public void logEntry(String string, Object object) {
        if (object != null) {
            this.logEntry(string + " " + object.toString());
        } else {
            this.logEntry(string);
        }
    }

    public void logEntry(String string, Object[] objectArray) {
        if (objectArray != null) {
            String string2 = string;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                string2 = string2 + " " + objectArray[i].toString();
            }
            this.logEntry(string2);
        } else {
            this.logEntry(string);
        }
    }

    public void logExit(String string) {
        this.logger.logp(Level.FINER, this.baseClassName, null, string + " Exit");
    }

    public void logExit(String string, Object object) {
        if (object != null) {
            this.logExit(string + " " + object.toString());
        } else {
            this.logExit(string);
        }
    }

    public void logExit(String string, Object[] objectArray) {
        if (objectArray != null) {
            String string2 = string;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                string2 = string2 + " " + objectArray[i].toString();
            }
            this.logExit(string2);
        } else {
            this.logExit(string);
        }
    }

    public void log(Level level, String string, String string2) {
        if (this.logger != null) {
            this.logger.logp(level, this.baseClassName, null, string);
        }
    }

    public void log(Level level, String string, Object[] objectArray, String string2) {
        if (this.logger != null) {
            this.logger.logp(level, this.baseClassName, (String)null, string, objectArray);
        }
    }
}

