/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.TCPChannelDiagnosticModule;
import com.ibm.ws.tcp.channel.impl.ValidateUtils;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPConfigConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TCPChannelConfiguration
implements TCPConfigConstants {
    private static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration";
    protected static final String NEW_BUFF_SIZE = "newConnectionBufferSize";
    protected static final String LINGER = "soLinger";
    protected static final String NO_DELAY = "tcpNoDelay";
    protected static final String REUSE_ADDR = "soReuseAddr";
    protected static final String KEEP_ALIVE = "keepAlive";
    protected static final String BLOCKING_CHANNEL = "blockingChannel";
    protected static final String BACKLOG = "listenBacklog";
    protected static final String DIRECT_BUFFS = "allocateBuffersDirect";
    protected static final String ACCEPT_THREAD = "acceptThread";
    protected static final String COMM_OPTION = "commOption";
    protected static final String DUMP_STATS_INTERVAL = "dumpStatsInterval";
    protected static final String ENDPOINT_NAME = "endPointName";
    protected static final String CHAIN_TYPE_KEY = "chainType";
    protected static final String ZAIO_RESOLVE_FOREIGN_HOSTNAMES_KEY = "zaioResolveForeignHostnames";
    protected static final String ZAIO_FREE_INITIAL_BUFFER_KEY = "zaioFreeInitialBuffers";
    private static final TraceComponent tc = Tr.register(TCPChannelConfiguration.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private ChannelData channelData = null;
    private Map channelProperties = null;
    private int maxOpenConnections = 20000;
    private String threadPoolName = null;
    private int listenBacklog = 511;
    private int newConnectionBufferSize = 8192;
    private int port = 80;
    private String hostname = "*";
    private int inactivityTimeout = 60000;
    private String[] addressExcludeList = null;
    private String[] hostNameExcludeList = null;
    private String[] addressIncludeList = null;
    private String[] hostNameIncludeList = null;
    private int allocateBuffersDirect = 1;
    private int tcpNoDelay = 1;
    private int soLinger = -1;
    private int soReuseAddress = 1;
    private int keepAlive = 1;
    private int blockingChannel = 0;
    private int receiveBufferSize = -1;
    private int sendBufferSize = -1;
    private int acceptThread = 0;
    private int dumpStatsInterval = 0;
    private String endPointName = null;
    private static final int COMM_OPTION_FORCE_NIO = 0;
    private static final int COMM_OPTION_DONT_FORCE_NIO = 1;
    private int commOption = 1;
    private boolean inbound;
    private String externalName = null;
    private boolean dispatchWorkToThreads = true;

    protected TCPChannelConfiguration(ChannelData channelData) throws ChannelException {
        this.channelData = channelData;
        this.inbound = this.channelData.isInbound();
        this.channelProperties = this.channelData.getPropertyBag();
        this.externalName = this.channelData.getExternalName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TCPChannelConfiguration");
        }
        if (this.channelProperties == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "TCPChannelConfiguration object constructed with null properties");
            }
            throw new ChannelException("TCPChannelConfiguration constructed with null properties");
        }
        this.setValues();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TCPChannelConfiguration");
        }
    }

    private void setValues() throws ChannelException {
        Set set = this.channelProperties.keySet();
        Iterator iterator = set.iterator();
        String string = null;
        int n = ValidateUtils.VALIDATE_OK;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ChannelException channelException = null;
        int n5 = this.soReuseAddress = this.isInbound() ? 0 : 1;
        while (iterator.hasNext() && n == ValidateUtils.VALIDATE_OK) {
            string = (String)iterator.next();
            try {
                String string2;
                if (this.inbound) {
                    if (string.equalsIgnoreCase("hostname")) {
                        n4 = 1;
                        this.hostname = (String)this.channelProperties.get(string);
                        if (this.hostname != null) continue;
                        n = ValidateUtils.VALIDATE_ERROR;
                        continue;
                    }
                    if (string.equalsIgnoreCase("port")) {
                        n4 = 0;
                        n2 = 0;
                        n3 = 65535;
                        this.port = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testPort(this.port);
                        continue;
                    }
                    if (string.equalsIgnoreCase("maxOpenConnections")) {
                        n4 = 0;
                        n2 = 1;
                        n3 = 128000;
                        this.maxOpenConnections = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testMaxConnections(this.maxOpenConnections);
                        continue;
                    }
                    if (string.equalsIgnoreCase(NEW_BUFF_SIZE)) {
                        n4 = 0;
                        n2 = ValidateUtils.NEW_BUFF_SIZE_MIN;
                        n3 = ValidateUtils.NEW_BUFF_SIZE_MAX;
                        this.newConnectionBufferSize = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testNewBuffSize(this.newConnectionBufferSize);
                        continue;
                    }
                    if (string.equalsIgnoreCase(BACKLOG)) {
                        n4 = 0;
                        n2 = ValidateUtils.LISTEN_BACKLOG_MIN;
                        n3 = ValidateUtils.LISTEN_BACKLOG_MAX;
                        this.listenBacklog = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testListenBacklog(this.listenBacklog);
                        continue;
                    }
                    if (string.equalsIgnoreCase("addressExcludeList")) {
                        n4 = 3;
                        string2 = this.channelProperties.get(string);
                        this.addressExcludeList = string2 instanceof String ? this.convertToArray(string2) : (String[])string2;
                        n = ValidateUtils.testIsStringIPAddressesValid(this.addressExcludeList);
                        if (n == ValidateUtils.VALIDATE_OK) continue;
                        Tr.error(tc, "ADDRESS_EXCLUDE_LIST_INVALID", new Object[]{this.externalName});
                        channelException = new ChannelException("An entry in the address exclude list for a TCP Channel was not valid.  Valid values consist of a valid String. Channel Name: " + this.externalName);
                        break;
                    }
                    if (string.equalsIgnoreCase("addressIncludeList")) {
                        n4 = 3;
                        string2 = this.channelProperties.get(string);
                        this.addressIncludeList = string2 instanceof String ? this.convertToArray(string2) : (String[])string2;
                        n = ValidateUtils.testIsStringIPAddressesValid(this.addressIncludeList);
                        if (n == ValidateUtils.VALIDATE_OK) continue;
                        Tr.error(tc, "ADDRESS_INCLUDE_LIST_INVALID", new Object[]{this.externalName});
                        channelException = new ChannelException("An entry in the address include list for a TCP Channel was not valid.  Valid values consist of a valid String. Channel Name: " + this.externalName);
                        break;
                    }
                    if (string.equalsIgnoreCase("hostNameExcludeList")) {
                        n4 = 3;
                        string2 = this.channelProperties.get(string);
                        if (string2 instanceof String) {
                            this.hostNameExcludeList = this.convertToArray(string2);
                            continue;
                        }
                        this.hostNameExcludeList = (String[])string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("hostNameIncludeList")) {
                        n4 = 3;
                        string2 = this.channelProperties.get(string);
                        if (string2 instanceof String) {
                            this.hostNameIncludeList = this.convertToArray(string2);
                            continue;
                        }
                        this.hostNameIncludeList = (String[])string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase(ACCEPT_THREAD)) {
                        n4 = 0;
                        n2 = ValidateUtils.ACCEPT_THREAD_MIN;
                        n3 = ValidateUtils.ACCEPT_THREAD_MAX;
                        this.acceptThread = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testAcceptThread(this.acceptThread);
                        continue;
                    }
                    if (string.equalsIgnoreCase(DIRECT_BUFFS)) {
                        n4 = 2;
                        this.allocateBuffersDirect = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testBooleanFormat2(this.allocateBuffersDirect);
                        continue;
                    }
                    if (string.equalsIgnoreCase(ENDPOINT_NAME)) {
                        n4 = 1;
                        this.endPointName = (String)this.channelProperties.get(string);
                        if (this.endPointName != null) continue;
                        n = ValidateUtils.VALIDATE_ERROR;
                        continue;
                    }
                }
                if (string.equalsIgnoreCase(REUSE_ADDR)) {
                    n4 = 2;
                    this.soReuseAddress = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testBooleanFormat2(this.soReuseAddress);
                    continue;
                }
                if (string.equalsIgnoreCase("pureNonblocking")) {
                    string2 = (String)this.channelProperties.get(string);
                    if (!Boolean.toString(true).equalsIgnoreCase(string2) && !Boolean.toString(false).equalsIgnoreCase(string2)) {
                        n = ValidateUtils.VALIDATE_ERROR;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error with dispatch work to threads value = " + string2);
                        }
                    } else {
                        boolean bl = Boolean.valueOf(string2);
                        this.dispatchWorkToThreads = !bl;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Dispatch work to threads = " + this.dispatchWorkToThreads);
                    continue;
                }
                if (string.equalsIgnoreCase(NO_DELAY)) {
                    n4 = 2;
                    this.tcpNoDelay = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testBooleanFormat2(this.tcpNoDelay);
                    continue;
                }
                if (string.equalsIgnoreCase(LINGER)) {
                    n4 = 0;
                    n2 = ValidateUtils.LINGER_MIN;
                    n3 = ValidateUtils.LINGER_MAX;
                    this.soLinger = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testLinger(this.soLinger);
                    continue;
                }
                if (string.equalsIgnoreCase(KEEP_ALIVE)) {
                    n4 = 2;
                    this.keepAlive = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testBooleanFormat2(this.keepAlive);
                    continue;
                }
                if (string.equalsIgnoreCase(BLOCKING_CHANNEL)) {
                    n4 = 2;
                    this.blockingChannel = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testBooleanFormat2(this.blockingChannel);
                    this.commOption = 0;
                    continue;
                }
                if (string.equalsIgnoreCase("receiveBufferSize")) {
                    n4 = 0;
                    n2 = 4;
                    n3 = 0x1000000;
                    this.receiveBufferSize = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testReceiveBufferSize(this.receiveBufferSize);
                    continue;
                }
                if (string.equalsIgnoreCase("sendBufferSize")) {
                    n4 = 0;
                    n2 = 4;
                    n3 = 0x1000000;
                    this.sendBufferSize = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testSendBufferSize(this.sendBufferSize);
                    continue;
                }
                if (string.equalsIgnoreCase("threadPoolName")) {
                    n4 = 1;
                    this.threadPoolName = (String)this.channelProperties.get(string);
                    continue;
                }
                if (string.equalsIgnoreCase("inactivityTimeout")) {
                    n4 = 0;
                    n2 = 0;
                    n3 = 3600;
                    this.inactivityTimeout = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testInactivityTimeout(this.inactivityTimeout);
                    if (n != ValidateUtils.VALIDATE_OK || this.inactivityTimeout == ValidateUtils.INACTIVITY_TIMEOUT_NO_TIMEOUT) continue;
                    this.inactivityTimeout *= 1000;
                    continue;
                }
                if (string.equalsIgnoreCase(COMM_OPTION)) {
                    if (this.blockingChannel == 1) {
                        Tr.debug(tc, "blockingChannel set while attempting to override CommOption, CommOption override ignored");
                        continue;
                    }
                    n4 = 0;
                    n2 = 0;
                    n3 = 1;
                    this.commOption = Integer.parseInt((String)this.channelProperties.get(string));
                    n = ValidateUtils.testCommOption(this.commOption);
                    continue;
                }
                if (string.equalsIgnoreCase(DUMP_STATS_INTERVAL)) {
                    n4 = 0;
                    n2 = 0;
                    n3 = 3600;
                    this.dumpStatsInterval = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testDumpStatsInterval(this.dumpStatsInterval);
                    continue;
                }
                if (string.equalsIgnoreCase("chainData") || string.equalsIgnoreCase(CHAIN_TYPE_KEY) || string.equalsIgnoreCase(ZAIO_RESOLVE_FOREIGN_HOSTNAMES_KEY) || string.equalsIgnoreCase(ZAIO_FREE_INITIAL_BUFFER_KEY)) continue;
                string2 = this.channelProperties.get(string);
                if (string2 instanceof String) {
                    Tr.warning(tc, "CONFIG_KEY_NOT_VALID", new Object[]{this.externalName, string, string2});
                    continue;
                }
                Tr.warning(tc, "CONFIG_KEY_NOT_VALID", new Object[]{this.externalName, string, ""});
            }
            catch (NumberFormatException numberFormatException) {
                Tr.error(tc, "CONFIG_VALUE_NUMBER_EXCEPTION", new Object[]{this.externalName, string, (String)this.channelProperties.get(string)});
                channelException = new ChannelException("TCP Channel Caught a NumberFormatException processing property, Channel Name: " + this.externalName + " Property name: " + string + " value: " + (String)this.channelProperties.get(string), numberFormatException);
                FFDCFilter.processException((Throwable)channelException, CLASS_NAME, "101", this);
                throw channelException;
            }
        }
        if (n != ValidateUtils.VALIDATE_OK) {
            if (n4 == 0) {
                Tr.error(tc, "CONFIG_VALUE_NOT_VALID_INT", new Object[]{this.externalName, string, (String)this.channelProperties.get(string), "" + n2, "" + n3});
                channelException = new ChannelException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.externalName + " name: " + string + " value: " + (String)this.channelProperties.get(string) + "minimum Value: " + n2 + "maximum Value: " + n3);
            } else if (n4 == 2) {
                Tr.error(tc, "CONFIG_VALUE_NOT_VALID_BOOLEAN2", new Object[]{this.externalName, string, (String)this.channelProperties.get(string)});
                channelException = new ChannelException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.externalName + " name: " + string + " value: " + (String)this.channelProperties.get(string) + " Valid Range: 0 - False, 1 - True");
            } else if (n4 == 1) {
                if ((String)this.channelProperties.get(string) == null) {
                    Tr.error(tc, "CONFIG_VALUE_NOT_VALID_NULL_STRING", new Object[]{this.externalName, string});
                    channelException = new ChannelException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.externalName + " name: " + string + " value: null");
                } else {
                    Tr.error(tc, "CONFIG_VALUE_NOT_VALID_STRING", new Object[]{this.externalName, string, (String)this.channelProperties.get(string)});
                    channelException = new ChannelException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.externalName + " name: " + string + " value: " + (String)this.channelProperties.get(string));
                }
            }
            if (channelException != null) {
                FFDCFilter.processException(channelException, CLASS_NAME, "102", this);
                throw channelException;
            }
        }
    }

    protected boolean checkAndSetValues(ChannelData channelData) {
        ChannelData channelData2 = channelData;
        boolean bl = channelData2.isInbound();
        Map map = this.channelData.getPropertyBag();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        String string = null;
        int n = ValidateUtils.VALIDATE_OK;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string2 = null;
        String string3 = null;
        boolean bl2 = true;
        int n7 = this.maxOpenConnections;
        int n8 = this.inactivityTimeout;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        while (iterator.hasNext() && n == ValidateUtils.VALIDATE_OK) {
            string = (String)iterator.next();
            try {
                Object object;
                if (bl) {
                    if (string.equalsIgnoreCase("hostname")) {
                        n4 = 1;
                        string2 = this.hostname;
                        if (((String)this.channelProperties.get(string)).equals(this.hostname)) continue;
                        n = ValidateUtils.VALIDATE_NOT_EQUAL;
                        continue;
                    }
                    if (string.equalsIgnoreCase("port")) {
                        n4 = 0;
                        n5 = this.port;
                        if (new Integer((String)this.channelProperties.get(string)) == this.port) continue;
                        n = ValidateUtils.VALIDATE_NOT_EQUAL;
                        continue;
                    }
                    if (string.equalsIgnoreCase("maxOpenConnections")) {
                        n4 = 0;
                        n2 = 1;
                        n3 = 128000;
                        n7 = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testMaxConnections(n7);
                        continue;
                    }
                    if (string.equalsIgnoreCase(NEW_BUFF_SIZE)) {
                        n4 = 0;
                        n5 = this.newConnectionBufferSize;
                        if (new Integer((String)this.channelProperties.get(string)) == this.newConnectionBufferSize) continue;
                        n = ValidateUtils.VALIDATE_NOT_EQUAL;
                        continue;
                    }
                    if (string.equalsIgnoreCase(BACKLOG)) {
                        n4 = 0;
                        n5 = this.listenBacklog;
                        if (new Integer((String)this.channelProperties.get(string)) == this.listenBacklog) continue;
                        n = ValidateUtils.VALIDATE_NOT_EQUAL;
                        continue;
                    }
                    if (string.equalsIgnoreCase("addressExcludeList")) {
                        n4 = 3;
                        object = this.channelProperties.get(string);
                        stringArray = object instanceof String ? this.convertToArray((String)object) : (String[])object;
                        n = ValidateUtils.testIsStringIPAddressesValid(stringArray);
                        if (n == ValidateUtils.VALIDATE_OK) continue;
                        Tr.error(tc, "ADDRESS_EXCLUDE_LIST_INVALID", new Object[]{this.externalName});
                        break;
                    }
                    if (string.equalsIgnoreCase("addressIncludeList")) {
                        n4 = 3;
                        object = this.channelProperties.get(string);
                        stringArray2 = object instanceof String ? this.convertToArray((String)object) : (String[])object;
                        n = ValidateUtils.testIsStringIPAddressesValid(stringArray);
                        if (n == ValidateUtils.VALIDATE_OK) continue;
                        Tr.error(tc, "ADDRESS_INCLUDE_LIST_INVALID", new Object[]{this.externalName});
                        break;
                    }
                    if (string.equalsIgnoreCase("hostNameExcludeList")) {
                        n4 = 3;
                        object = this.channelProperties.get(string);
                        if (object instanceof String) {
                            stringArray3 = this.convertToArray((String)object);
                            continue;
                        }
                        stringArray3 = (String[])object;
                        continue;
                    }
                    if (string.equalsIgnoreCase("hostNameIncludeList")) {
                        n4 = 3;
                        object = this.channelProperties.get(string);
                        if (object instanceof String) {
                            stringArray4 = this.convertToArray((String)object);
                            continue;
                        }
                        stringArray4 = (String[])object;
                        continue;
                    }
                    if (string.equalsIgnoreCase(ENDPOINT_NAME)) {
                        n4 = 1;
                        string2 = this.endPointName;
                        if (((String)this.channelProperties.get(string)).equals(string2)) continue;
                        n = ValidateUtils.VALIDATE_NOT_EQUAL;
                        continue;
                    }
                }
                if (string.equalsIgnoreCase(NO_DELAY)) {
                    n4 = 2;
                    n5 = this.tcpNoDelay;
                    if (new Integer((String)this.channelProperties.get(string)) == this.tcpNoDelay) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(REUSE_ADDR)) {
                    n4 = 2;
                    n5 = this.soReuseAddress;
                    if (new Integer((String)this.channelProperties.get(string)) == this.soReuseAddress) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(LINGER)) {
                    n4 = 0;
                    n5 = this.soLinger;
                    if (new Integer((String)this.channelProperties.get(string)) == this.soLinger) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(ACCEPT_THREAD)) {
                    n4 = 0;
                    n5 = this.acceptThread;
                    if (new Integer((String)this.channelProperties.get(string)) == this.acceptThread) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(DIRECT_BUFFS)) {
                    n4 = 2;
                    n5 = this.allocateBuffersDirect;
                    if (new Integer((String)this.channelProperties.get(string)) == this.allocateBuffersDirect) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(KEEP_ALIVE)) {
                    n4 = 2;
                    n5 = this.keepAlive;
                    if (new Integer((String)this.channelProperties.get(string)) == this.keepAlive) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(BLOCKING_CHANNEL)) {
                    n4 = 2;
                    n5 = this.blockingChannel;
                    if (new Integer((String)this.channelProperties.get(string)) == this.blockingChannel) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase("receiveBufferSize")) {
                    n4 = 0;
                    n5 = this.receiveBufferSize;
                    if (new Integer((String)this.channelProperties.get(string)) == this.receiveBufferSize) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase("sendBufferSize")) {
                    n4 = 0;
                    n5 = this.sendBufferSize;
                    if (new Integer((String)this.channelProperties.get(string)) == this.sendBufferSize) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase("threadPoolName")) {
                    n4 = 1;
                    string2 = this.threadPoolName;
                    if (((String)this.channelProperties.get(string)).equals(this.threadPoolName)) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase("inactivityTimeout")) {
                    n4 = 0;
                    n8 = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testInactivityTimeout(n8);
                    if (n != ValidateUtils.VALIDATE_OK || n8 == ValidateUtils.INACTIVITY_TIMEOUT_NO_TIMEOUT) continue;
                    n8 *= 1000;
                    continue;
                }
                if (string.equalsIgnoreCase("pureNonblocking")) {
                    object = (String)this.channelProperties.get(string);
                    if (Boolean.toString(!this.dispatchWorkToThreads).equalsIgnoreCase((String)object)) {
                        n = ValidateUtils.VALIDATE_OK;
                        continue;
                    }
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(COMM_OPTION)) {
                    n4 = 0;
                    n5 = this.commOption;
                    if (new Integer((String)this.channelProperties.get(string)) == this.commOption) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase("chainData") || string.equalsIgnoreCase(CHAIN_TYPE_KEY) || string.equalsIgnoreCase(ZAIO_RESOLVE_FOREIGN_HOSTNAMES_KEY) || string.equalsIgnoreCase(ZAIO_FREE_INITIAL_BUFFER_KEY)) continue;
                object = this.channelProperties.get(string);
                if (object instanceof String) {
                    Tr.warning(tc, "CONFIG_KEY_NOT_VALID", new Object[]{this.externalName, string, object});
                    continue;
                }
                Tr.warning(tc, "CONFIG_KEY_NOT_VALID", new Object[]{this.externalName, string, ""});
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = false;
                Tr.error(tc, "CONFIG_VALUE_NUMBER_EXCEPTION", new Object[]{this.externalName, string, this.channelProperties.get(string)});
            }
        }
        if (n == ValidateUtils.VALIDATE_ERROR) {
            bl2 = false;
            if (n4 == 0) {
                Tr.error(tc, "CONFIG_VALUE_NOT_VALID_INT", new Object[]{this.externalName, string, this.channelProperties.get(string), "" + n2, "" + n3});
            } else if (n4 == 2) {
                Tr.error(tc, "CONFIG_VALUE_NOT_VALID_BOOLEAN2", new Object[]{this.externalName, string, this.channelProperties.get(string)});
            } else if (n4 == 1) {
                if (this.channelProperties.get(string) == null) {
                    Tr.error(tc, "CONFIG_VALUE_NOT_VALID_NULL_STRING", new Object[]{this.externalName, string});
                } else {
                    Tr.error(tc, "CONFIG_VALUE_NOT_VALID_STRING", new Object[]{this.externalName, string});
                }
            }
            Tr.error(tc, "UPDATED_CONFIG_NOT_IMPLEMENTED", new Object[]{this.externalName});
        }
        if (n == ValidateUtils.VALIDATE_NOT_EQUAL) {
            bl2 = false;
            if (n4 == 0 || n4 == 2) {
                n6 = new Integer((String)this.channelProperties.get(string));
                Tr.error(tc, "NEW_CONFIG_VALUE_NOT_EQUAL", new Object[]{this.externalName, string, "" + n5, "" + n6});
            } else if (n4 == 1) {
                string3 = (String)this.channelProperties.get(string);
                Tr.error(tc, "NEW_CONFIG_VALUE_NOT_EQUAL", new Object[]{this.externalName, string, string2, string3});
            }
            Tr.error(tc, "UPDATED_CONFIG_NOT_IMPLEMENTED", new Object[]{this.externalName});
        }
        if (bl2) {
            this.maxOpenConnections = n7;
            this.inactivityTimeout = n8;
            this.addressExcludeList = stringArray;
            this.addressIncludeList = stringArray2;
            this.hostNameExcludeList = stringArray3;
            this.hostNameIncludeList = stringArray4;
        }
        return bl2;
    }

    private String[] convertToArray(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = null;
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n != n3) {
            n2 = string.indexOf(",", n);
            if (n2 > n) {
                string2 = string.substring(n, n2);
                string2 = string2.trim();
                arrayList.add(string2);
            } else if (n2 != n) {
                string2 = string.substring(n);
                string2 = string2.trim();
                arrayList.add(string2);
            }
            if (n2 == -1) break;
            n = n2 + 1;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected ChannelData getChannelData() {
        return this.channelData;
    }

    protected int getMaxOpenConnections() {
        return this.maxOpenConnections;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    protected int getListenBacklog() {
        return this.listenBacklog;
    }

    protected int getNewConnectionBufferSize() {
        return this.newConnectionBufferSize;
    }

    public int getAllocateBuffersDirect() {
        return this.allocateBuffersDirect;
    }

    protected int getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    protected int getSoReuseAddress() {
        return this.soReuseAddress;
    }

    protected int getKeepAlive() {
        return this.keepAlive;
    }

    protected int getBlockingChannel() {
        return this.blockingChannel;
    }

    public String getHostname() {
        if (this.hostname.equals("*")) {
            return null;
        }
        return this.hostname;
    }

    protected int getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    protected String getChannelId() {
        return "TCPChannel";
    }

    protected String[] getAddressExcludeList() {
        return this.addressExcludeList;
    }

    protected String[] getHostNameExcludeList() {
        return this.hostNameExcludeList;
    }

    protected String[] getAddressIncludeList() {
        return this.addressIncludeList;
    }

    protected String[] getHostNameIncludeList() {
        return this.hostNameIncludeList;
    }

    public int getPort() {
        return this.port;
    }

    protected boolean isNIOOnly() {
        return this.commOption == 0;
    }

    protected void outputConfigToTrace() {
        Tr.debug(tc, "Config parameters for TCP Channel: " + this.getChannelData().getExternalName());
        if (this.isInbound()) {
            Tr.debug(tc, "hostname: " + this.getHostname());
            Tr.debug(tc, "port: " + this.getPort());
            Tr.debug(tc, "maxOpenConnections: " + this.getMaxOpenConnections());
            Tr.debug(tc, "addressExcludeList: " + this.getAddressExcludeList());
            Tr.debug(tc, "hostNameExcludeList: " + this.getHostNameExcludeList());
            Tr.debug(tc, "addressIncludeList: " + this.getAddressIncludeList());
            Tr.debug(tc, "hostNameIncludeList: " + this.getHostNameIncludeList());
            Tr.debug(tc, "listenBacklog: " + this.getListenBacklog());
            Tr.debug(tc, "newConnectionBufferSize: " + this.getNewConnectionBufferSize());
        }
        Tr.debug(tc, "soReuseAddr: " + this.getSoReuseAddress());
        Tr.debug(tc, "inactivityTimeout: " + this.getInactivityTimeout());
        Tr.debug(tc, "threadPoolName: " + this.getThreadPoolName());
        Tr.debug(tc, "allocateBuffersDirect: " + this.getAllocateBuffersDirect());
        Tr.debug(tc, "tcpNoDelay: " + this.getTcpNoDelay());
        Tr.debug(tc, "receiveBufferSize: " + this.getReceiveBufferSize());
        Tr.debug(tc, "sendBufferSize: " + this.getSendBufferSize());
        Tr.debug(tc, "pureNonblocking: " + Boolean.toString(!this.isDispatchWorkToThreads()));
        Tr.debug(tc, "commOption: " + this.commOption);
        Tr.debug(tc, "blockingChannel: " + this.blockingChannel);
        Tr.debug(tc, "soLinger: " + this.getSoLinger());
    }

    protected String getFFDCDumpData(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer == null ? new StringBuffer() : stringBuffer;
        if (this.isInbound()) {
            stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("hostname", this.hostname, stringBuffer2);
            stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("port", String.valueOf(this.port), stringBuffer2);
            stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("maxOpenConnections", String.valueOf(this.maxOpenConnections), stringBuffer2);
            if (this.addressExcludeList != null) {
                stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("addressExcludeList", this.addressExcludeList.toString(), stringBuffer2);
            }
            if (this.hostNameExcludeList != null) {
                stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("hostNameExcludeList", this.hostNameExcludeList.toString(), stringBuffer2);
            }
            if (this.addressIncludeList != null) {
                stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("addressIncludeList", this.addressIncludeList.toString(), stringBuffer2);
            }
            if (this.hostNameIncludeList != null) {
                stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("hostNameIncludeList", this.hostNameIncludeList.toString(), stringBuffer2);
            }
            stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(BACKLOG, String.valueOf(this.listenBacklog), stringBuffer2);
            stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(NEW_BUFF_SIZE, String.valueOf(this.newConnectionBufferSize), stringBuffer2);
        }
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(REUSE_ADDR, String.valueOf(this.soReuseAddress), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("inactivityTimeout", String.valueOf(this.inactivityTimeout), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("threadPoolName", this.threadPoolName, stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(DIRECT_BUFFS, String.valueOf(this.allocateBuffersDirect), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(NO_DELAY, String.valueOf(this.tcpNoDelay), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("receiveBufferSize", String.valueOf(this.receiveBufferSize), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("sendBufferSize", String.valueOf(this.sendBufferSize), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(COMM_OPTION, String.valueOf(this.commOption), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(LINGER, String.valueOf(this.soLinger), stringBuffer2);
        return stringBuffer2.toString();
    }

    protected String getFFDCDumpData() {
        return this.getFFDCDumpData(null);
    }

    public boolean isInbound() {
        return this.inbound;
    }

    protected int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    protected int getSendBufferSize() {
        return this.sendBufferSize;
    }

    protected int getSoLinger() {
        return this.soLinger;
    }

    public int getDumpStatsInterval() {
        return this.dumpStatsInterval;
    }

    protected int getAcceptThread() {
        return this.acceptThread;
    }

    protected boolean isDispatchWorkToThreads() {
        return this.dispatchWorkToThreads;
    }
}

