/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ws.tcp.channel.impl.FilterList;
import com.ibm.wsspi.tcp.channel.TCPConfigConstants;

public class ValidateUtils
implements TCPConfigConstants {
    public static int VALIDATE_OK = 0;
    public static int VALIDATE_ERROR = 1;
    public static int VALIDATE_NOT_EQUAL = 2;
    private static int NO_OPTIONS = 0;
    public static int LINGER_MIN = -1;
    public static int LINGER_MAX = 3600;
    public static int ACCEPT_THREAD_MIN = 0;
    public static int ACCEPT_THREAD_MAX = 1;
    public static int NEW_BUFF_SIZE_MIN = 32;
    public static int NEW_BUFF_SIZE_MAX = 65536;
    public static int LISTEN_BACKLOG_MIN = 0;
    public static int LISTEN_BACKLOG_MAX = 512;
    public static int KEYS_PER_SELECTOR_MIN = 1;
    public static int KEYS_PER_SELECTOR_MAX = 20000;
    public static int CHANNEL_SELECTOR_IDLE_TIMEOUT_MIN = 0;
    public static int CHANNEL_SELECTOR_IDLE_TIMEOUT_MAX = 3600000;
    public static int CHANNEL_SELECTOR_WAIT_TO_TERMINATE_MIN = 0;
    public static int CHANNEL_SELECTOR_WAIT_TO_TERMINATE_MAX = 3600;
    public static int NUMBER_NONBLOCKING_ACCEPT_THREADS_MIN = 1;
    public static int NUMBER_NONBLOCKING_ACCEPT_THREADS_MAX = 100;
    public static int SELECTOR_WAKEUP_OPTION_MIN = 1;
    public static int SELECTOR_WAKEUP_OPTION_MAX = 3;
    public static int SELECTOR_WAKEUP_WHEN_NEEDED = 1;
    public static int SELECTOR_WAKEUP_NEVER = 2;
    public static int SELECTOR_WAKEUP_IF_NO_FORCE_QUEUE = 3;
    public static int MIN_SELECTOR_THREADS = 1;
    public static int MAX_SELECTOR_THREADS = 1000;
    public static int MIN_CONNECTION_THRESHOLD = 1;
    public static int MAX_CONNECTION_THRESHOLD = 5000;
    public static int INACTIVITY_TIMEOUT_NO_TIMEOUT = 0;
    public static int MIN_INBOUND_READ_SELECTORS_TO_START = 1;
    public static int MAX_INBOUND_READ_SELECTORS_TO_START = 1000;
    public static int BOOLEAN_FORMAT2_MIN = 0;
    public static int BOOLEAN_FORMAT2_MAX = 1;
    public static final int KEY_TYPE_INT = 0;
    public static final int KEY_TYPE_STRING = 1;
    public static final int KEY_TYPE_BOOLEAN2 = 2;
    public static final int KEY_TYPE_ACCESS_LIST = 3;
    public static final int COMM_OPTION_MIN = 0;
    public static final int COMM_OPTION_MAX = 1;
    public static final int DUMP_STATS_INTERVAL_MIN = 0;
    public static final int DUMP_STATS_INTERVAL_MAX = 3600;

    public static int testInt(int n, int n2, int n3, int n4) {
        if (n < n2 || n > n3) {
            return VALIDATE_ERROR;
        }
        return VALIDATE_OK;
    }

    public static int testStringAsInt(String string, int n, int n2, int n3) throws NumberFormatException {
        int n4;
        try {
            n4 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return VALIDATE_ERROR;
        }
        if (n4 < n || n4 > n2) {
            return VALIDATE_ERROR;
        }
        return VALIDATE_OK;
    }

    public static int testPort(int n) {
        return ValidateUtils.testInt(n, 0, 65535, NO_OPTIONS);
    }

    public static int testMaxConnections(int n) {
        return ValidateUtils.testInt(n, 1, 128000, NO_OPTIONS);
    }

    public static int testMaxConnections(String string) {
        return ValidateUtils.testStringAsInt(string, 1, 128000, NO_OPTIONS);
    }

    public static int testLinger(int n) {
        return ValidateUtils.testInt(n, LINGER_MIN, LINGER_MAX, NO_OPTIONS);
    }

    public static int testLinger(String string) {
        return ValidateUtils.testStringAsInt(string, LINGER_MIN, LINGER_MAX, NO_OPTIONS);
    }

    public static int testAcceptThread(int n) {
        return ValidateUtils.testInt(n, ACCEPT_THREAD_MIN, ACCEPT_THREAD_MAX, NO_OPTIONS);
    }

    public static int testAcceptThread(String string) {
        return ValidateUtils.testStringAsInt(string, ACCEPT_THREAD_MIN, ACCEPT_THREAD_MAX, NO_OPTIONS);
    }

    public static int testNewBuffSize(int n) {
        return ValidateUtils.testInt(n, NEW_BUFF_SIZE_MIN, NEW_BUFF_SIZE_MAX, NO_OPTIONS);
    }

    public static int testNewBuffSize(String string) {
        return ValidateUtils.testStringAsInt(string, NEW_BUFF_SIZE_MIN, NEW_BUFF_SIZE_MAX, NO_OPTIONS);
    }

    public static int testListenBacklog(int n) {
        return ValidateUtils.testInt(n, LISTEN_BACKLOG_MIN, LISTEN_BACKLOG_MAX, NO_OPTIONS);
    }

    public static int testListenBacklog(String string) {
        return ValidateUtils.testStringAsInt(string, LISTEN_BACKLOG_MIN, LISTEN_BACKLOG_MAX, NO_OPTIONS);
    }

    public static int testReceiveBufferSize(int n) {
        return ValidateUtils.testInt(n, 4, 0x1000000, NO_OPTIONS);
    }

    public static int testReceiveBufferSize(String string) {
        return ValidateUtils.testStringAsInt(string, 4, 0x1000000, NO_OPTIONS);
    }

    public static int testSendBufferSize(int n) {
        return ValidateUtils.testInt(n, 4, 0x1000000, NO_OPTIONS);
    }

    public static int testSendBufferSize(String string) {
        return ValidateUtils.testStringAsInt(string, 4, 0x1000000, NO_OPTIONS);
    }

    public static int testInactivityTimeout(int n) {
        return ValidateUtils.testInt(n, 0, 3600, NO_OPTIONS);
    }

    public static int testInactivityTimeout(String string) {
        return ValidateUtils.testStringAsInt(string, 0, 3600, NO_OPTIONS);
    }

    public static int testKeysPerSelector(int n) {
        return ValidateUtils.testInt(n, KEYS_PER_SELECTOR_MIN, KEYS_PER_SELECTOR_MAX, NO_OPTIONS);
    }

    public static int testKeysPerSelector(String string) {
        return ValidateUtils.testStringAsInt(string, KEYS_PER_SELECTOR_MIN, KEYS_PER_SELECTOR_MAX, NO_OPTIONS);
    }

    public static int testChannelSelectorIdleTimeout(int n) {
        return ValidateUtils.testInt(n, CHANNEL_SELECTOR_IDLE_TIMEOUT_MIN, CHANNEL_SELECTOR_IDLE_TIMEOUT_MAX, NO_OPTIONS);
    }

    public static int testChannelSelectorIdleTimeout(String string) {
        return ValidateUtils.testStringAsInt(string, CHANNEL_SELECTOR_IDLE_TIMEOUT_MIN, CHANNEL_SELECTOR_IDLE_TIMEOUT_MAX, NO_OPTIONS);
    }

    public static int testChannelSelectorWaitToTerminate(int n) {
        return ValidateUtils.testInt(n, CHANNEL_SELECTOR_WAIT_TO_TERMINATE_MIN, CHANNEL_SELECTOR_WAIT_TO_TERMINATE_MAX, NO_OPTIONS);
    }

    public static int testChannelSelectorWaitToTerminate(String string) {
        return ValidateUtils.testStringAsInt(string, CHANNEL_SELECTOR_WAIT_TO_TERMINATE_MIN, CHANNEL_SELECTOR_WAIT_TO_TERMINATE_MAX, NO_OPTIONS);
    }

    public static int testChannelSelectorWakeupOption(int n) {
        return ValidateUtils.testInt(n, SELECTOR_WAKEUP_OPTION_MIN, SELECTOR_WAKEUP_OPTION_MAX, NO_OPTIONS);
    }

    public static int testChannelSelectorWakeupOption(String string) {
        return ValidateUtils.testStringAsInt(string, SELECTOR_WAKEUP_OPTION_MIN, SELECTOR_WAKEUP_OPTION_MAX, NO_OPTIONS);
    }

    public static int testMaxSelectorThreads(int n) {
        return ValidateUtils.testInt(n, MIN_SELECTOR_THREADS, MAX_SELECTOR_THREADS, NO_OPTIONS);
    }

    public static int testMaxSelectorThreads(String string) {
        return ValidateUtils.testStringAsInt(string, MIN_SELECTOR_THREADS, MAX_SELECTOR_THREADS, NO_OPTIONS);
    }

    public static int testConnectionThreshold(int n) {
        return ValidateUtils.testInt(n, MIN_CONNECTION_THRESHOLD, MAX_CONNECTION_THRESHOLD, NO_OPTIONS);
    }

    public static int testConnectionThreshold(String string) {
        return ValidateUtils.testStringAsInt(string, MIN_CONNECTION_THRESHOLD, MAX_CONNECTION_THRESHOLD, NO_OPTIONS);
    }

    public static int testInboundReadSelectorsToStart(int n) {
        return ValidateUtils.testInt(n, MIN_INBOUND_READ_SELECTORS_TO_START, MAX_INBOUND_READ_SELECTORS_TO_START, NO_OPTIONS);
    }

    public static int testInboundReadSelectorsToStart(String string) {
        return ValidateUtils.testStringAsInt(string, MIN_INBOUND_READ_SELECTORS_TO_START, MAX_INBOUND_READ_SELECTORS_TO_START, NO_OPTIONS);
    }

    public static int testBooleanFormat2(String string) {
        return ValidateUtils.testStringAsInt(string, BOOLEAN_FORMAT2_MIN, BOOLEAN_FORMAT2_MAX, NO_OPTIONS);
    }

    public static int testBooleanFormat2(int n) {
        return ValidateUtils.testInt(n, BOOLEAN_FORMAT2_MIN, BOOLEAN_FORMAT2_MAX, NO_OPTIONS);
    }

    public static int testAuditLevel(String string) {
        if (string.equalsIgnoreCase("INFO")) {
            return VALIDATE_OK;
        }
        if (string.equalsIgnoreCase("FINE")) {
            return VALIDATE_OK;
        }
        return VALIDATE_ERROR;
    }

    public static int testCommOption(int n) {
        return ValidateUtils.testInt(n, 0, 1, NO_OPTIONS);
    }

    public static int testCommOption(String string) {
        return ValidateUtils.testStringAsInt(string, 0, 1, NO_OPTIONS);
    }

    public static int testDumpStatsInterval(int n) {
        return ValidateUtils.testInt(n, 0, 3600, NO_OPTIONS);
    }

    public static int testDumpStatsInterval(String string) {
        return ValidateUtils.testStringAsInt(string, 0, 3600, NO_OPTIONS);
    }

    public static int testIsStringIPAddressesValid(String[] stringArray) {
        FilterList filterList = new FilterList();
        try {
            if (stringArray != null) {
                filterList.buildData(stringArray, true);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return VALIDATE_ERROR;
        }
        return VALIDATE_OK;
    }
}

