/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.cache;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.SplashScreen;
import com.sun.javaws.cache.CachedApplication;
import com.sun.javaws.cache.DiskCache;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.JavawsHttpsCertStore;
import com.sun.javaws.xml.XMLable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class InstallCache {
    private static InstallCache _cache = null;
    private static DiskCache _diskcache = null;
    private static DiskCache _muffincache = null;
    private static final String LAST_ACCESSED_FILE_NAME = "lastAccessed";
    private static final String INDIRECT_EXTENSION = ".ind";
    private File baseDir = this.getCacheBaseDir();
    private boolean _cacheUpdateFlag = true;
    private HashMap _loadedProperties;
    private static final String REBOOT_NEEDED_KEY = "_default.rebootNeeded";
    private static final String FORCED_UPDATE_CHECK_KEY = "_default.forcedUpdateCheck";
    private static final String NATIVELIB_DIR_KEY = "_default.nativeLibDir";
    private static final String INSTALL_DIR_KEY = "_default.installDir";
    private static final String LAST_ACCESSED_KEY = "_default.lastAccessed";
    private static final String LAUNCH_COUNT_KEY = "_default.launchCount";
    private static final String ASK_INSTALL_KEY = "_default.askedInstall";
    private static final String LOCALLY_INSTALLED_KEY = "_default.locallyInstalled";
    private static final String INDIRECT_PATH_KEY = "_default.indirectPath";
    static /* synthetic */ Class class$com$sun$javaws$cache$InstallCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstallCache getCache() {
        if (_cache == null) {
            Class clazz = class$com$sun$javaws$cache$InstallCache == null ? (class$com$sun$javaws$cache$InstallCache = InstallCache.class$("com.sun.javaws.cache.InstallCache")) : class$com$sun$javaws$cache$InstallCache;
            synchronized (clazz) {
                if (_cache == null) {
                    _cache = new InstallCache();
                }
            }
        }
        return _cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean refreshCacheLocation() {
        if (Globals.TraceCache) {
            Debug.println("_cache.baseDir: " + InstallCache._cache.baseDir);
            Debug.println("_cache.getCacheBaseDir(): " + _cache.getCacheBaseDir());
        }
        if (!InstallCache._cache.baseDir.equals(_cache.getCacheBaseDir())) {
            Class clazz = class$com$sun$javaws$cache$InstallCache == null ? (class$com$sun$javaws$cache$InstallCache = InstallCache.class$("com.sun.javaws.cache.InstallCache")) : class$com$sun$javaws$cache$InstallCache;
            synchronized (clazz) {
                _cache = new InstallCache();
            }
            return true;
        }
        return false;
    }

    private InstallCache() {
        _diskcache = new DiskCache(this.baseDir);
        File file = this.getMuffinCacheBaseDir();
        _muffincache = new DiskCache(file);
        this._loadedProperties = new HashMap();
    }

    private File getMuffinCacheBaseDir() {
        String string = ConfigProperties.getInstance().getMuffinDir();
        File file = new File(string);
        if (Globals.TraceCache) {
            Debug.println("Cache Dir = " + file);
        }
        return file;
    }

    private File getCacheBaseDir() {
        String string = ConfigProperties.getInstance().getCacheDir();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (Globals.TraceCache) {
            Debug.println("Cache Dir = " + file);
        }
        return file;
    }

    public long getLastAccessed() {
        return _diskcache.getLastUpdate();
    }

    public static synchronized DiskCache getMuffinCache() {
        if (_muffincache == null) {
            InstallCache.getCache();
        }
        return _muffincache;
    }

    public static synchronized DiskCache getDiskCache() {
        if (_diskcache == null) {
            InstallCache.getCache();
        }
        return _diskcache;
    }

    public void remove() {
        Iterator iterator = _cache.getCachedApplications();
        if (iterator != null) {
            while (iterator.hasNext()) {
                CachedApplication cachedApplication = (CachedApplication)iterator.next();
                LaunchDesc launchDesc = cachedApplication.getLaunchDescriptor();
                LocalApplicationProperties localApplicationProperties = cachedApplication.getLocalApplicationProperties();
                if (launchDesc == null) continue;
                this.remove(localApplicationProperties, launchDesc);
            }
        }
        InstallCache.getDiskCache().uninstallCache();
        InstallCache.getMuffinCache().uninstallCache();
        JavawsHttpsCertStore.removeJavawsHttpsCert();
    }

    public void remove(LocalApplicationProperties localApplicationProperties, LaunchDesc launchDesc) {
        String string;
        URL uRL;
        int n;
        XMLable[] xMLableArray;
        InformationDesc informationDesc = launchDesc.getInformation();
        LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (localApplicationProperties.isLocallyInstalled() && localInstallHandler != null) {
            localInstallHandler.uninstall(launchDesc, localApplicationProperties);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
            }
        }
        SplashScreen.removeCustomSplash(launchDesc);
        if (informationDesc != null && (xMLableArray = informationDesc.getIcons()) != null) {
            for (n = 0; n < xMLableArray.length; ++n) {
                uRL = ((IconDesc)xMLableArray[n]).getLocation();
                string = ((IconDesc)xMLableArray[n]).getVersion();
                this.removeEntries('R', uRL, string);
            }
        }
        if (resourcesDesc != null && (xMLableArray = resourcesDesc.getEagerOrAllJarDescs(true)) != null) {
            for (n = xMLableArray.length - 1; n >= 0; --n) {
                uRL = ((JARDesc)xMLableArray[n]).getLocation();
                string = ((JARDesc)xMLableArray[n]).getVersion();
                this.removeEntries('R', uRL, string);
            }
        }
        if (localApplicationProperties != null && localApplicationProperties instanceof DefaultLocalApplicationProperties) {
            ((DefaultLocalApplicationProperties)localApplicationProperties).removeIndirectLaunchFile();
        }
        if (launchDesc.getCanonicalHome() != null) {
            this.removeEntries('A', launchDesc.getCanonicalHome(), null);
        }
    }

    private void removeEntries(char c, URL uRL, String string) {
        if (uRL == null) {
            return;
        }
        try {
            DiskCacheEntry[] diskCacheEntryArray = _diskcache.getCacheEntries(c, uRL, string, true);
            for (int i = 0; i < diskCacheEntryArray.length; ++i) {
                _diskcache.removeEntry(diskCacheEntryArray[i]);
            }
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
    }

    public File getCachedLaunchedFile(URL uRL) throws IOException {
        DiskCacheEntry diskCacheEntry = _diskcache.getCacheEntry('A', uRL, null);
        return diskCacheEntry == null ? null : diskCacheEntry.getFile();
    }

    public Iterator getCachedApplications() {
        final ArrayList arrayList = new ArrayList();
        try {
            _diskcache.visitDiskCache('A', new DiskCache.DiskCacheVisitor(){

                public void visitEntry(DiskCacheEntry diskCacheEntry) {
                    arrayList.add(new DefaultCachedApplication(diskCacheEntry));
                }
            });
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        return arrayList.iterator();
    }

    public LocalApplicationProperties getLocalApplicationProperties(String string, LaunchDesc launchDesc) {
        try {
            boolean bl;
            DiskCacheEntry diskCacheEntry = _diskcache.getCacheEntryFromFile(new File(string));
            boolean bl2 = bl = diskCacheEntry.getType() == 'A';
            if (diskCacheEntry != null) {
                return this.getLocalApplicationProperties(diskCacheEntry.getLocation(), diskCacheEntry.getVersionId(), launchDesc, bl);
            }
            return null;
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
            return null;
        }
    }

    public LocalApplicationProperties getLocalApplicationProperties(URL uRL, LaunchDesc launchDesc) {
        return this.getLocalApplicationProperties(uRL, null, launchDesc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalApplicationProperties getLocalApplicationProperties(URL uRL, String string, LaunchDesc launchDesc, boolean bl) {
        LocalApplicationProperties localApplicationProperties;
        if (uRL == null) {
            return null;
        }
        String string2 = uRL.toString().intern() + "?" + string;
        HashMap hashMap = this._loadedProperties;
        synchronized (hashMap) {
            localApplicationProperties = (LocalApplicationProperties)this._loadedProperties.get(string2);
            if (localApplicationProperties == null) {
                localApplicationProperties = new DefaultLocalApplicationProperties(uRL, string, launchDesc, bl);
                this._loadedProperties.put(string2, localApplicationProperties);
            } else {
                localApplicationProperties.refreshIfNecessary();
            }
        }
        return localApplicationProperties;
    }

    public LaunchDesc getLaunchDesc(URL uRL, String string) {
        try {
            DiskCacheEntry diskCacheEntry = _diskcache.getCacheEntry('A', uRL, string);
            if (diskCacheEntry != null) {
                try {
                    return LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        return null;
    }

    public String getNewExtensionInstallDirectory() throws IOException {
        String string = this.getCacheBaseDir().getAbsolutePath() + File.separator + ".ext";
        String string2 = null;
        int n = 0;
        do {
            File file;
            if (!(file = new File(string2 = string + File.separator + "E" + new Date().getTime() + File.separator)).mkdirs()) {
                string2 = null;
            }
            Thread.yield();
        } while (string2 == null && ++n < 50);
        if (string2 == null) {
            throw new IOException("Unable to create temp. dir for extension");
        }
        return string2;
    }

    private String createUniqueIndirectFile() throws IOException {
        String string = this.getCacheBaseDir().getAbsolutePath() + File.separator + "indirect";
        File file = new File(string);
        file.mkdirs();
        File file2 = File.createTempFile("indirect", INDIRECT_EXTENSION, file);
        return file2.getAbsolutePath();
    }

    private Properties getLocalApplicationPropertiesStorage(DefaultLocalApplicationProperties defaultLocalApplicationProperties) {
        Properties properties = new Properties();
        try {
            char c;
            byte[] byArray;
            URL uRL = defaultLocalApplicationProperties.getLocation();
            String string = defaultLocalApplicationProperties.getVersionId();
            if (uRL != null && (byArray = _diskcache.getEntryContent(c = defaultLocalApplicationProperties.isApplicationDescriptor() ? (char)'A' : 'E', 'L', uRL, string)) != null) {
                properties.load(new ByteArrayInputStream(byArray));
            }
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        return properties;
    }

    private void putLocalApplicationPropertiesStorage(DefaultLocalApplicationProperties defaultLocalApplicationProperties, Properties properties) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, "LAP");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byteArrayOutputStream.close();
        char c = defaultLocalApplicationProperties.isApplicationDescriptor() ? (char)'A' : 'E';
        _diskcache.storeAtomic(c, 'L', defaultLocalApplicationProperties.getLocation(), defaultLocalApplicationProperties.getVersionId(), byteArrayOutputStream.toByteArray());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DefaultLocalApplicationProperties
    implements LocalApplicationProperties {
        private LaunchDesc _descriptor;
        private Properties _properties;
        private URL _location;
        private String _versionId;
        private long _lastAccessed;
        private boolean _isApplicationDescriptor;
        private boolean _dirty;

        private DefaultLocalApplicationProperties(URL uRL, String string, LaunchDesc launchDesc, boolean bl) {
            this._descriptor = launchDesc;
            this._location = uRL;
            this._versionId = string;
            this._isApplicationDescriptor = bl;
            this._properties = InstallCache.this.getLocalApplicationPropertiesStorage(this);
        }

        public URL getLocation() {
            return this._location;
        }

        public String getVersionId() {
            return this._versionId;
        }

        public LaunchDesc getLaunchDescriptor() {
            return this._descriptor;
        }

        public void setLastAccessed(Date date) {
            this.put(InstallCache.LAST_ACCESSED_KEY, date.toString());
        }

        public Date getLastAccessed() {
            return this.getDate(InstallCache.LAST_ACCESSED_KEY);
        }

        public void incrementLaunchCount() {
            int n = this.getLaunchCount();
            this.put(InstallCache.LAUNCH_COUNT_KEY, Integer.toString(++n));
        }

        public int getLaunchCount() {
            return this.getInteger(InstallCache.LAUNCH_COUNT_KEY);
        }

        public void setAskedForInstall(boolean bl) {
            this.put(InstallCache.ASK_INSTALL_KEY, new Boolean(bl).toString());
        }

        public boolean getAskedForInstall() {
            return this.getBoolean(InstallCache.ASK_INSTALL_KEY);
        }

        public void setRebootNeeded(boolean bl) {
            this.put(InstallCache.REBOOT_NEEDED_KEY, new Boolean(bl).toString());
        }

        public boolean isRebootNeeded() {
            return this.getBoolean(InstallCache.REBOOT_NEEDED_KEY);
        }

        public void setLocallyInstalled(boolean bl) {
            this.put(InstallCache.LOCALLY_INSTALLED_KEY, new Boolean(bl).toString());
        }

        public boolean isLocallyInstalled() {
            return this.getBoolean(InstallCache.LOCALLY_INSTALLED_KEY);
        }

        public boolean forceUpdateCheck() {
            return this.getBoolean(InstallCache.FORCED_UPDATE_CHECK_KEY);
        }

        public void setForceUpdateCheck(boolean bl) {
            this.put(InstallCache.FORCED_UPDATE_CHECK_KEY, new Boolean(bl).toString());
        }

        public boolean isApplicationDescriptor() {
            return this._isApplicationDescriptor;
        }

        public boolean isExtensionDescriptor() {
            return !this._isApplicationDescriptor;
        }

        public String getNativeLibDirectory() {
            return this.get(InstallCache.NATIVELIB_DIR_KEY);
        }

        public String getInstallDirectory() {
            return this.get(InstallCache.INSTALL_DIR_KEY);
        }

        public void setNativeLibDirectory(String string) {
            this.put(InstallCache.NATIVELIB_DIR_KEY, string);
        }

        public void setInstallDirectory(String string) {
            this.put(InstallCache.INSTALL_DIR_KEY, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(String string, String string2) {
            DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
            synchronized (defaultLocalApplicationProperties) {
                if (string2 == null) {
                    this._properties.remove(string);
                } else {
                    this._properties.put(string, string2);
                }
                this._dirty = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String get(String string) {
            DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
            synchronized (defaultLocalApplicationProperties) {
                return (String)this._properties.get(string);
            }
        }

        public int getInteger(String string) {
            String string2 = this.get(string);
            if (string2 == null) {
                return 0;
            }
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            return n;
        }

        public boolean getBoolean(String string) {
            String string2 = this.get(string);
            if (string2 == null) {
                return false;
            }
            return Boolean.valueOf(string2);
        }

        public Date getDate(String string) {
            String string2 = this.get(string);
            if (string2 == null) {
                return null;
            }
            try {
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                return dateFormat.parse(string2);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        public synchronized void store() throws IOException {
            InstallCache.this.putLocalApplicationPropertiesStorage(this, this._properties);
            this._dirty = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doesNewVersionExist() {
            DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
            synchronized (defaultLocalApplicationProperties) {
                long l = _diskcache.getLastUpdate();
                if (l == 0L) {
                    return false;
                }
                if (l > this._lastAccessed) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshIfNecessary() {
            DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
            synchronized (defaultLocalApplicationProperties) {
                if (!this._dirty && this.doesNewVersionExist()) {
                    this.refresh();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() {
            DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
            synchronized (defaultLocalApplicationProperties) {
                Properties properties;
                this._properties = properties = InstallCache.this.getLocalApplicationPropertiesStorage(this);
                this._dirty = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getIndirectLauchFilePath(boolean bl) throws IOException {
            DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
            synchronized (defaultLocalApplicationProperties) {
                File file;
                String string = this.get(InstallCache.INDIRECT_PATH_KEY);
                if (string != null && (file = new File(string)).exists() && !file.isDirectory() && file.canRead()) {
                    return string;
                }
                if (bl) {
                    string = this.createIndirectLaunchFile();
                    return string;
                }
                this.put(InstallCache.INDIRECT_PATH_KEY, null);
            }
            return null;
        }

        private String createIndirectLaunchFile() throws IOException {
            DiskCacheEntry diskCacheEntry = _diskcache.getCacheEntry('A', this._location, null);
            if (diskCacheEntry == null || diskCacheEntry.isEmpty()) {
                throw new IOException("no launch descriptor path!");
            }
            for (int i = 0; i < 10; ++i) {
                try {
                    String string = InstallCache.this.createUniqueIndirectFile();
                    if (string == null) continue;
                    FileWriter fileWriter = new FileWriter(string);
                    fileWriter.write(diskCacheEntry.getFile().getAbsolutePath());
                    ((Writer)fileWriter).close();
                    this.put(InstallCache.INDIRECT_PATH_KEY, string);
                    try {
                        this.store();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return string;
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                }
            }
            throw new IOException("couldn't create indirect file");
        }

        private void removeIndirectLaunchFile() {
            this.refreshIfNecessary();
            try {
                String string = this.getIndirectLauchFilePath(false);
                if (string != null) {
                    new File(string).delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.put(InstallCache.INDIRECT_PATH_KEY, null);
            try {
                this.store();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class DefaultCachedApplication
    implements CachedApplication {
        private DiskCacheEntry _dce;
        private LaunchDesc _descriptor;
        private LocalApplicationProperties _lap;
        private int _state;

        DefaultCachedApplication(DiskCacheEntry diskCacheEntry) {
            this._dce = diskCacheEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LaunchDesc getLaunchDescriptor() {
            if ((this._state & 1) == 0) {
                DefaultCachedApplication defaultCachedApplication = this;
                synchronized (defaultCachedApplication) {
                    this.loadLaunchDescriptorIfNecessary();
                }
            }
            return this._descriptor;
        }

        public URL getCodebase() {
            return this._dce.getLocation();
        }

        public String getVersionId() {
            return this._dce.getVersionId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LocalApplicationProperties getLocalApplicationProperties() {
            if ((this._state & 2) == 0) {
                DefaultCachedApplication defaultCachedApplication = this;
                synchronized (defaultCachedApplication) {
                    this.loadLocalApplicationPropertiesIfNecessary();
                }
            }
            return this._lap;
        }

        private synchronized void loadLaunchDescriptorIfNecessary() {
            if ((this._state & 1) == 0) {
                this._state |= 1;
                try {
                    this._descriptor = LaunchDescFactory.buildDescriptor(this._dce.getFile());
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                }
                catch (BadFieldException badFieldException) {
                    Debug.ignoredException(badFieldException);
                }
                catch (MissingFieldException missingFieldException) {
                    Debug.ignoredException(missingFieldException);
                }
                catch (JNLParseException jNLParseException) {
                    Debug.ignoredException(jNLParseException);
                }
            }
        }

        private synchronized void loadLocalApplicationPropertiesIfNecessary() {
            if ((this._state & 2) == 0) {
                this.loadLaunchDescriptorIfNecessary();
                this._state |= 2;
                this._lap = InstallCache.this.getLocalApplicationProperties(this._dce.getLocation(), this.getLaunchDescriptor());
            }
        }
    }
}

