/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.Main;
import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.security.CertificateInfo;
import com.sun.javaws.security.CertificatePanel;
import com.sun.javaws.security.KeyStoreManager;
import com.sun.javaws.security.SunSecurityUtil;
import com.sun.javaws.ui.general.GeneralUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;

public class CertificateDialog {
    static boolean verifyCertificate(final Frame frame, final String string, final Certificate[] certificateArray, int n) {
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        switch (n) {
            case 1: {
                string2 = Resources.getString("certs.verify.application-type");
                bl2 = false;
                break;
            }
            case 2: {
                string2 = Resources.getString("certs.verify.applet-type");
                bl2 = false;
                break;
            }
            case 3: {
                string2 = Resources.getString("certs.verify.library-type");
                bl2 = true;
                break;
            }
            case 4: {
                string2 = Resources.getString("certs.verify.installer-type");
                bl2 = true;
            }
        }
        try {
            String string3;
            int n2;
            CertificateInfo certificateInfo;
            int n3 = -1;
            CertificateInfo certificateInfo2 = certificateInfo = CertificateInfo.getCertificateInfo(certificateArray[0]);
            for (n2 = 0; n2 < certificateArray.length; ++n2) {
                certificateInfo = CertificateInfo.getCertificateInfo(certificateArray[n2]);
                if (!KeyStoreManager.isCertificateTrusted(certificateArray[n2])) continue;
                n3 = n2;
                break;
            }
            SunSecurityUtil.checkTrustedChain(certificateArray);
            n2 = n3;
            String string4 = Resources.getString("certs.verify.unkown");
            String string5 = CertificateDialog.buildString(certificateInfo2.getSubjectName(), string4);
            String string6 = CertificateDialog.buildString(certificateInfo.getSubjectName(), string4);
            Date date = certificateInfo2.getExpirationDate();
            String string7 = Resources.getString("certs.verify.msg");
            int n4 = 0;
            if (n2 == -1) {
                string3 = Resources.getString("certs.verify.untrustedCert");
                n4 = 2;
            } else {
                string7 = string7 + Resources.getString("certs.verify.msg.trusted");
                string3 = Resources.getString("certs.verify.trustedCert");
                n4 = 0;
            }
            JTextPane jTextPane = GeneralUtilities.addBoldText(null, string7, new Object[]{string2, string, string5, string6});
            JTextPane jTextPane2 = GeneralUtilities.addBoldText(null, string3, new Object[]{string5, string5});
            String string8 = bl2 ? "certs.verify.okinst" : "certs.verify.ok";
            final JButton jButton = new JButton(Resources.getString(string8));
            jButton.setMnemonic(Resources.getVKCode(bl2 ? "certs.verify.okinstMnemonic" : "certs.verify.okMnemonic"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    while (component != null) {
                        if (!((component = component.getParent()) instanceof JOptionPane)) continue;
                        ((JOptionPane)component).setValue(jButton);
                        break;
                    }
                }
            });
            JButton jButton2 = new JButton(Resources.getString("certs.verify.details"));
            jButton2.setMnemonic(Resources.getVKCode("certs.verify.detailsMnemonic"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CertificateDialog.showDetails(string, frame, certificateArray, n2);
                }
            });
            Object[] objectArray = new Object[]{jButton, jButton2, Resources.getString("certs.verify.cancel")};
            int n5 = GeneralUtilities.showOptionDialog(frame, new Object[]{jTextPane, jTextPane2}, Resources.getString("certs.verify.title"), -1, 2, objectArray, objectArray[n4]);
            if (n5 != 0) {
                Main.systemExit(-1);
            }
        }
        catch (CertificateException certificateException) {
            if (Globals.TraceSecurity) {
                Debug.println("CertificateException: " + certificateException);
            }
            CertificateDialog.bogusCertificate(string, frame);
            return true;
        }
        return true;
    }

    private static void showDetails(String string, Frame frame, Certificate[] certificateArray, int n) {
        try {
            CertificateInfo[] certificateInfoArray = new CertificateInfo[certificateArray.length];
            for (int i = 0; i < certificateArray.length; ++i) {
                certificateInfoArray[i] = CertificateInfo.getCertificateInfo(certificateArray[i]);
            }
            CertificatePanel.showCertificateDialog(frame, certificateInfoArray, n);
        }
        catch (CertificateException certificateException) {
            if (Globals.TraceSecurity) {
                Debug.println("CertificateException: " + certificateException);
            }
            CertificateDialog.bogusCertificate(string, frame);
        }
    }

    private static void bogusCertificate(String string, Frame frame) {
        Object[] objectArray = new Object[]{Resources.getString("certs.verify.cancel")};
        int n = GeneralUtilities.showOptionDialog(frame, Resources.getString("certs.verify.unknownCert", string), Resources.getString("certs.verify.title"), -1, 2, objectArray, objectArray[0]);
        if (n == 0) {
            Main.systemExit(-1);
        }
    }

    private static String buildString(String string, String string2) {
        return string == null || string.length() == 0 ? string2 : string;
    }
}

