/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.Resources;
import com.sun.javaws.security.DeploymentCertificateInfo;
import com.sun.javaws.ui.general.GeneralUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import sun.misc.HexDumpEncoder;

public class DeploymentCertificateDialog {
    private Certificate[] certs = null;
    private int start = 0;
    private int end = 0;
    private Component parentComponent;
    JTree certChainTree = null;
    final JTable certInfoTable = new JTable();
    final JTextArea textArea = new JTextArea();
    Object[] msg;
    Object[] options;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public DeploymentCertificateDialog(Certificate[] certificateArray, int n, int n2) {
        this(null, certificateArray, n, n2);
    }

    public DeploymentCertificateDialog(Component component, Certificate[] certificateArray, int n, int n2) {
        this.certs = certificateArray;
        this.start = n;
        this.end = n2;
        this.parentComponent = component;
        UIManager.getBorder("TableHeader.cellBorder");
        UIManager.getBorder("Table.focusCellHighlightBorder");
        UIManager.getColor("Table.focusCellForeground");
        UIManager.getColor("Table.focusCellBackground");
        JTable jTable = new JTable();
        jTable.getDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = DeploymentCertificateDialog.class$("java.lang.String")) : class$java$lang$String);
        jTable.getDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = DeploymentCertificateDialog.class$("java.lang.Object")) : class$java$lang$Object);
        if (certificateArray.length > n && certificateArray[n] instanceof X509Certificate) {
            Border border = BorderFactory.createEtchedBorder();
            this.certChainTree = this.buildCertChainTree(certificateArray, n, n2);
            this.certChainTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)DeploymentCertificateDialog.this.certChainTree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode == null) {
                        return;
                    }
                    DeploymentCertificateInfo deploymentCertificateInfo = (DeploymentCertificateInfo)defaultMutableTreeNode.getUserObject();
                    DeploymentCertificateDialog.this.showCertificateInfo(deploymentCertificateInfo.getCertificate());
                }
            });
            this.showCertificateInfo((X509Certificate)certificateArray[n]);
            this.certInfoTable.setSelectionMode(0);
            ListSelectionModel listSelectionModel = this.certInfoTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = DeploymentCertificateDialog.this.certInfoTable.getSelectedRow();
                    if (n == -1) {
                        return;
                    }
                    String string = (String)DeploymentCertificateDialog.this.certInfoTable.getValueAt(n, 1);
                    DeploymentCertificateDialog.this.textArea.setText(string);
                    DeploymentCertificateDialog.this.textArea.repaint();
                }
            });
            this.textArea.setLineWrap(false);
            this.textArea.setEditable(false);
            this.textArea.setColumns(40);
            this.certInfoTable.setRowSelectionInterval(6, 6);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            Dimension dimension = this.certInfoTable.getPreferredScrollableViewportSize();
            dimension.setSize(dimension.getWidth(), 120.0);
            this.certInfoTable.setPreferredScrollableViewportSize(dimension);
            JScrollPane jScrollPane = new JScrollPane(this.certInfoTable);
            jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), jScrollPane.getBorder()));
            jPanel.add((Component)jScrollPane, "Center");
            jPanel.add((Component)new JScrollPane(this.textArea), "South");
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            dimension = this.certChainTree.getPreferredScrollableViewportSize();
            dimension.setSize(200.0, 100.0);
            jScrollPane = new JScrollPane(this.certChainTree);
            jScrollPane.setPreferredSize(dimension);
            jPanel2.add((Component)jScrollPane, "West");
            jPanel2.add((Component)jPanel, "East");
            this.msg = new Object[]{jPanel2};
            final JButton jButton = new JButton(DeploymentCertificateDialog.getMessage("cert_dialog.closeButton"));
            jButton.setMnemonic(Resources.getVKCode("cert_dialog.closeMnemonic"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    while (component != null) {
                        if (!((component = component.getParent()) instanceof JOptionPane)) continue;
                        ((JOptionPane)component).setValue(jButton);
                        break;
                    }
                }
            });
            this.options = new Object[]{jButton};
        }
    }

    public void DoModal() {
        GeneralUtilities.showOptionDialog(this.parentComponent, this.msg, DeploymentCertificateDialog.getMessage("cert_dialog.caption"), -1, -1, this.options, this.options[0], GeneralUtilities.getLockIcon());
    }

    private String formatDNString(String string) {
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\'') {
                boolean bl3 = bl2 = !bl2;
            }
            if (c == ',' && !bl2) {
                stringBuffer.append(",\n");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private JTree buildCertChainTree(Certificate[] certificateArray, int n, int n2) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = n; i < certificateArray.length && i < n2; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DeploymentCertificateInfo((X509Certificate)certificateArray[i]));
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = defaultMutableTreeNode3;
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
                continue;
            }
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
        }
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        return jTree;
    }

    private void showCertificateInfo(X509Certificate x509Certificate) {
        String string = "V" + x509Certificate.getVersion();
        String string2 = "[" + x509Certificate.getSerialNumber() + "]";
        String string3 = "[" + x509Certificate.getSigAlgName() + "]";
        String string4 = this.formatDNString(((Object)x509Certificate.getIssuerDN()).toString());
        String string5 = "[From: " + x509Certificate.getNotBefore() + ",\n To: " + x509Certificate.getNotAfter() + "]";
        String string6 = this.formatDNString(((Object)x509Certificate.getSubjectDN()).toString());
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string7 = hexDumpEncoder.encodeBuffer(x509Certificate.getSignature());
        Object[][] objectArray = new Object[][]{{DeploymentCertificateDialog.getMessage("cert_dialog.field.Version"), string}, {DeploymentCertificateDialog.getMessage("cert_dialog.field.SerialNumber"), string2}, {DeploymentCertificateDialog.getMessage("cert_dialog.field.SignatureAlg"), string3}, {DeploymentCertificateDialog.getMessage("cert_dialog.field.Issuer"), string4}, {DeploymentCertificateDialog.getMessage("cert_dialog.field.Validity"), string5}, {DeploymentCertificateDialog.getMessage("cert_dialog.field.Subject"), string6}, {DeploymentCertificateDialog.getMessage("cert_dialog.field.Signature"), string7}};
        Object[] objectArray2 = new String[]{DeploymentCertificateDialog.getMessage("cert_dialog.field"), DeploymentCertificateDialog.getMessage("cert_dialog.value")};
        this.certInfoTable.setModel(new DefaultTableModel(objectArray, objectArray2){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        this.certInfoTable.setRowSelectionInterval(6, 6);
        this.certInfoTable.repaint();
        this.textArea.repaint();
    }

    private static String getMessage(String string) {
        return Resources.getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

