/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.commandline.utils;

import com.ibm.ws.install.commandline.utils.resourcebundle.CLUResourceBundleUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class CommandLineUtils {
    private static final String S_DASH = "-";
    private static final String S_EMPTY = "";
    private static final int N_COMMAND_TYPE_INVALID = 0;
    private static final int N_COMMAND_TYPE_NO_DEFAULT_PROFILE = 10;
    private static final int N_COMMAND_TYPE_SPECIFIED_PROFILE_NOT_EXISTS = 20;
    private static final int N_COMMAND_TYPE_WASUSERSCRIPT_FILE_NOT_EXISTS = 30;
    private static final String S_PARAM_NO_DEFAULT_PROFILE = "-nodefaultprofile";
    private static final String S_PARAM_COMMAND_NAME = "-commandname";
    private static final String S_PARAM_SPECIFIED_PROFILE_NOT_EXISTS = "-specifiedprofilenotexists";
    private static final String S_PARAM_PROFILE_NAME = "-profilename";
    private static final String S_PARAM_WASUSERSCRIPT_FILE_NOT_EXISTS = "-wasuserscriptfilenotexists";
    private static final String S_PARAM_WASUSERSCRIPT = "-wasuserscript";
    private static final String[] AS_VALID_COMMANDS = new String[]{"-nodefaultprofile", "-specifiedprofilenotexists", "-wasuserscriptfilenotexists"};
    private static final String[] AS_VALID_INPUT_PARAMS = new String[]{"-nodefaultprofile", "-commandname", "-specifiedprofilenotexists", "-profilename", "-wasuserscriptfilenotexists", "-wasuserscript"};
    private static final int N_SUCCESS = 0;
    private static final int N_FAIL = -1;
    private static final String S_CORRECT_COMMAND_USAGE_MESSAGE_TEXT_KEY = "CommandLineUtils.correctCommandUsageMessageText";
    private static final String S_NO_DEFAULT_PROFILE_MESSAGE_TEXT_KEY = "CommandLineUtils.noDefaultProfileMessageText";
    private static final String S_SPECIFIED_PROFILE_NOT_EXISTS_MESSAGE_TEXT_KEY = "CommandLineUtils.specifiedProfileNotExistsMessageText";
    private static final String S_WASUSERSCRIPT_FILE_NOT_EXISTS_MESSAGE_TEXT_KEY = "CommandLineUtils.WASUserScriptFileNotExistsMessageText";
    private static HashMap m_hashmapInputParams = null;
    private static int m_nCommandType = 0;

    public static void main(String[] stringArray) {
        int n = CommandLineUtils.validateInputParameters(stringArray);
        if (n != 0) {
            CommandLineUtils.displayMessages(n);
            System.exit(-1);
        }
        CommandLineUtils.displayMessages(m_nCommandType);
        System.exit(0);
    }

    private static int validateInputParameters(String[] stringArray) {
        int n = CommandLineUtils.createParameterHashmap(stringArray);
        if (n != 0) {
            return n;
        }
        n = CommandLineUtils.validateCommandParameters();
        if (n != 0) {
            return n;
        }
        switch (m_nCommandType) {
            case 0: {
                return -1;
            }
            case 10: {
                return CommandLineUtils.validateNoDefaultProfileParams();
            }
            case 20: {
                return CommandLineUtils.validateSpecifiedProfileNotExistsParam();
            }
            case 30: {
                return CommandLineUtils.validateWASUserScriptFileNotExistsParam();
            }
        }
        return 0;
    }

    private static int createParameterHashmap(String[] stringArray) {
        if (stringArray.length == 0) {
            return -1;
        }
        m_hashmapInputParams = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(S_DASH)) {
                return -1;
            }
            if (i + 1 < stringArray.length && !stringArray[i + 1].startsWith(S_DASH)) {
                m_hashmapInputParams.put(stringArray[i].toLowerCase(), stringArray[i + 1]);
                ++i;
                continue;
            }
            m_hashmapInputParams.put(stringArray[i].toLowerCase(), null);
        }
        return 0;
    }

    private static int validateCommandParameters() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < AS_VALID_INPUT_PARAMS.length; ++i) {
            hashSet.add(AS_VALID_INPUT_PARAMS[i]);
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i = 0; i < AS_VALID_COMMANDS.length; ++i) {
            hashSet2.add(AS_VALID_COMMANDS[i]);
        }
        Iterator iterator = m_hashmapInputParams.keySet().iterator();
        while (iterator.hasNext()) {
            String string = ((String)iterator.next()).toLowerCase();
            if (!hashSet.contains(string)) {
                return -1;
            }
            if (!hashSet2.contains(string)) continue;
            if (m_nCommandType != 0) {
                return -1;
            }
            if (string.equals(S_PARAM_NO_DEFAULT_PROFILE)) {
                m_nCommandType = 10;
                continue;
            }
            if (string.equals(S_PARAM_SPECIFIED_PROFILE_NOT_EXISTS)) {
                m_nCommandType = 20;
                continue;
            }
            if (!string.equals(S_PARAM_WASUSERSCRIPT_FILE_NOT_EXISTS)) continue;
            m_nCommandType = 30;
        }
        return 0;
    }

    private static int validateNoDefaultProfileParams() {
        if (m_hashmapInputParams.containsKey(S_PARAM_NO_DEFAULT_PROFILE) && m_hashmapInputParams.get(S_PARAM_NO_DEFAULT_PROFILE) == null) {
            if (m_hashmapInputParams.containsKey(S_PARAM_PROFILE_NAME) || m_hashmapInputParams.containsKey(S_PARAM_WASUSERSCRIPT)) {
                return -1;
            }
            int n = CommandLineUtils.validateCommandName();
            if (n != 0) {
                return n;
            }
            m_nCommandType = 10;
            return 0;
        }
        return -1;
    }

    private static int validateCommandName() {
        String string;
        if (m_hashmapInputParams.containsKey(S_PARAM_COMMAND_NAME) && (string = (String)m_hashmapInputParams.get(S_PARAM_COMMAND_NAME)) != null && !string.equals(S_EMPTY)) {
            return 0;
        }
        return -1;
    }

    private static int validateSpecifiedProfileNotExistsParam() {
        if (m_hashmapInputParams.containsKey(S_PARAM_SPECIFIED_PROFILE_NOT_EXISTS) && m_hashmapInputParams.get(S_PARAM_SPECIFIED_PROFILE_NOT_EXISTS) == null) {
            if (m_hashmapInputParams.containsKey(S_PARAM_COMMAND_NAME) || m_hashmapInputParams.containsKey(S_PARAM_WASUSERSCRIPT)) {
                return -1;
            }
            int n = CommandLineUtils.validateProfileName();
            if (n != 0) {
                return n;
            }
            m_nCommandType = 20;
            return 0;
        }
        return -1;
    }

    private static int validateProfileName() {
        String string;
        if (m_hashmapInputParams.containsKey(S_PARAM_PROFILE_NAME) && (string = (String)m_hashmapInputParams.get(S_PARAM_PROFILE_NAME)) != null && !string.equals(S_EMPTY)) {
            return 0;
        }
        return -1;
    }

    private static int validateWASUserScriptFileNotExistsParam() {
        if (m_hashmapInputParams.containsKey(S_PARAM_WASUSERSCRIPT_FILE_NOT_EXISTS) && m_hashmapInputParams.get(S_PARAM_WASUSERSCRIPT_FILE_NOT_EXISTS) == null) {
            if (m_hashmapInputParams.containsKey(S_PARAM_COMMAND_NAME) || m_hashmapInputParams.containsKey(S_PARAM_PROFILE_NAME)) {
                return -1;
            }
            int n = CommandLineUtils.validateWASUserScript();
            if (n != 0) {
                return n;
            }
            m_nCommandType = 30;
            return 0;
        }
        return -1;
    }

    private static int validateWASUserScript() {
        String string;
        if (m_hashmapInputParams.containsKey(S_PARAM_WASUSERSCRIPT) && (string = (String)m_hashmapInputParams.get(S_PARAM_WASUSERSCRIPT)) != null && !string.equals(S_EMPTY)) {
            return 0;
        }
        return -1;
    }

    private static void displayMessages(int n) {
        switch (n) {
            case -1: {
                System.out.println(CLUResourceBundleUtils.getLocaleString(S_CORRECT_COMMAND_USAGE_MESSAGE_TEXT_KEY));
                break;
            }
            case 10: {
                System.out.println(CLUResourceBundleUtils.getLocaleString(S_NO_DEFAULT_PROFILE_MESSAGE_TEXT_KEY, (String)m_hashmapInputParams.get(S_PARAM_COMMAND_NAME)));
                break;
            }
            case 20: {
                System.out.println(CLUResourceBundleUtils.getLocaleString(S_SPECIFIED_PROFILE_NOT_EXISTS_MESSAGE_TEXT_KEY, (String)m_hashmapInputParams.get(S_PARAM_PROFILE_NAME)));
                break;
            }
            case 30: {
                System.out.println(CLUResourceBundleUtils.getLocaleString(S_WASUSERSCRIPT_FILE_NOT_EXISTS_MESSAGE_TEXT_KEY, (String)m_hashmapInputParams.get(S_PARAM_WASUSERSCRIPT)));
            }
        }
    }
}

