/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.InfoTypeAndValue;
import com.ibm.security.cmp.PKIFreeText;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.KeyIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Vector;

public final class PKIHeader
extends CMPDerObject {
    private BigInteger pvno;
    private GeneralName sender;
    private GeneralName recipient;
    private Date messageTime;
    private AlgorithmId protectionAlg;
    private KeyIdentifier senderKID;
    private KeyIdentifier recipKID;
    private byte[] transactionID;
    private byte[] senderNonce;
    private byte[] recipNonce;
    private PKIFreeText freeText;
    private InfoTypeAndValue[] generalInfo;
    private static final byte TAG_MESSAGE_TIME = 0;
    private static final byte TAG_PROTECTION_ALG = 1;
    private static final byte TAG_SENDER_KID = 2;
    private static final byte TAG_RECIP_KID = 3;
    private static final byte TAG_TRANSACTION_ID = 4;
    private static final byte TAG_SENDER_NONCE = 5;
    private static final byte TAG_RECIP_NONCE = 6;
    private static final byte TAG_FREE_TEXT = 7;
    private static final byte TAG_GENERAL_INFO = 8;

    public PKIHeader(BigInteger bigInteger, GeneralName generalName, GeneralName generalName2, Date date, AlgorithmId algorithmId, KeyIdentifier keyIdentifier, KeyIdentifier keyIdentifier2, byte[] byArray, byte[] byArray2, byte[] byArray3, PKIFreeText pKIFreeText, InfoTypeAndValue[] infoTypeAndValueArray) {
        if (bigInteger == null) {
            this.pvno = BigInteger.valueOf(2L);
        } else if (bigInteger.equals(BigInteger.valueOf(1L)) || bigInteger.equals(BigInteger.valueOf(2L))) {
            this.pvno = bigInteger;
        } else {
            throw new IllegalArgumentException("PKIHeader error, version not supported :" + bigInteger);
        }
        if (generalName == null) {
            throw new IllegalArgumentException("PKHeader error, sender not specified");
        }
        if (generalName2 == null) {
            throw new IllegalArgumentException("PKHeader error, recipient not specified");
        }
        this.sender = generalName;
        this.recipient = generalName2;
        this.messageTime = date;
        this.protectionAlg = algorithmId;
        this.senderKID = keyIdentifier;
        this.recipKID = keyIdentifier2;
        this.transactionID = byArray;
        this.senderNonce = byArray2;
        this.recipNonce = byArray3;
        this.freeText = pKIFreeText;
        this.generalInfo = infoTypeAndValueArray;
    }

    public PKIHeader(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new PKIHeader(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void decode(DerValue var1_1) throws IOException {
        block28: {
            block27: {
                var2_2 = null;
                if (var1_1.getTag() != 48) {
                    throw new IOException("PKIHeader parsing error, not a SEQUENCE");
                }
                this.pvno = null;
                this.sender = null;
                this.recipient = null;
                this.messageTime = null;
                this.protectionAlg = null;
                this.senderKID = null;
                this.recipKID = null;
                this.transactionID = null;
                this.senderNonce = null;
                this.recipNonce = null;
                this.freeText = null;
                this.generalInfo = null;
                if (var1_1.getData().available() == 0) {
                    throw new IOException("PKIHeader parsing error, not enough data");
                }
                this.pvno = var1_1.getData().getInteger();
                if (var1_1.getData().available() == 0) {
                    throw new IOException("PKIHeader parsing error, not enough data");
                }
                this.sender = new GeneralName(var1_1.getData().getDerValue());
                if (var1_1.getData().available() == 0) {
                    throw new IOException("PKIHeader parsing error, not enough data");
                }
                this.recipient = new GeneralName(var1_1.getData().getDerValue());
                if (var1_1.getData().available() == 0) {
                    return;
                }
                var2_2 = var1_1.getData().getDerValue();
                if (var2_2.isContextSpecific((byte)0) && var2_2.isConstructed()) {
                    this.messageTime = var2_2.getData().getGeneralizedTime();
                    if (var1_1.getData().available() == 0) {
                        return;
                    }
                    var2_2 = var1_1.getData().getDerValue();
                }
                if (var2_2.isContextSpecific((byte)1) && var2_2.isConstructed()) {
                    try {
                        this.protectionAlg = AlgorithmId.parse((DerValue)var2_2.getData().getDerValue());
                    }
                    catch (Exception v0) {
                        throw new IOException("PKIHeader parsing error, cannot parse protection algorithm");
                    }
                    if (var1_1.getData().available() == 0) {
                        return;
                    }
                    var2_2 = var1_1.getData().getDerValue();
                }
                if (var2_2.isContextSpecific((byte)2) && var2_2.isConstructed()) {
                    this.senderKID = new KeyIdentifier(var2_2.getData().getDerValue());
                    if (var1_1.getData().available() == 0) {
                        return;
                    }
                    var2_2 = var1_1.getData().getDerValue();
                }
                if (var2_2.isContextSpecific((byte)3) && var2_2.isConstructed()) {
                    this.recipKID = new KeyIdentifier(var2_2.getData().getDerValue());
                    if (var1_1.getData().available() == 0) {
                        return;
                    }
                    var2_2 = var1_1.getData().getDerValue();
                }
                if (var2_2.isContextSpecific((byte)4) && var2_2.isConstructed()) {
                    this.transactionID = var2_2.getData().getOctetString();
                    if (var1_1.getData().available() == 0) {
                        return;
                    }
                    var2_2 = var1_1.getData().getDerValue();
                }
                if (var2_2.isContextSpecific((byte)5) && var2_2.isConstructed()) {
                    this.senderNonce = var2_2.getData().getOctetString();
                    if (var1_1.getData().available() == 0) {
                        return;
                    }
                    var2_2 = var1_1.getData().getDerValue();
                }
                if (var2_2.isContextSpecific((byte)6) && var2_2.isConstructed()) {
                    this.recipNonce = var2_2.getData().getOctetString();
                    if (var1_1.getData().available() == 0) {
                        return;
                    }
                    var2_2 = var1_1.getData().getDerValue();
                }
                if (var2_2.isContextSpecific((byte)7) && var2_2.isConstructed()) {
                    this.freeText = new PKIFreeText(var2_2.getData().getDerValue().toByteArray());
                    if (var1_1.getData().available() == 0) {
                        return;
                    }
                    var2_2 = var1_1.getData().getDerValue();
                }
                if (!var2_2.isContextSpecific((byte)8) || !var2_2.isConstructed()) break block27;
                var3_3 = var2_2.getData().getDerValue();
                var4_4 = new Vector<InfoTypeAndValue>();
                if (var3_3.getTag() == 48) ** GOTO lbl81
                throw new IOException("PKIHeader parsing error, not a SEQUENCE OF InfoTypeAndValue");
lbl-1000:
                // 1 sources

                {
                    var5_5 = var3_3.getData().getDerValue();
                    var6_7 = new InfoTypeAndValue(var5_5.toByteArray());
                    var4_4.add(var6_7);
lbl81:
                    // 2 sources

                    ** while (var3_3.getData().available() != 0)
                }
lbl82:
                // 1 sources

                if (var4_4.size() > 0) {
                    this.generalInfo = new InfoTypeAndValue[var4_4.size()];
                    var5_6 = 0;
                    while (var5_6 < var4_4.size()) {
                        this.generalInfo[var5_6] = (InfoTypeAndValue)var4_4.elementAt(var5_6);
                        ++var5_6;
                    }
                }
                break block28;
            }
            throw new IOException("PKIHeader parsing error, extra data");
        }
        if (var1_1.getData().available() != 0) {
            throw new IOException("PKIHeader parsing error, extra data");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.pvno == null) {
            throw new IOException("PKIHeader encoding error, Version Number not specified");
        }
        derOutputStream2.putInteger(this.pvno);
        if (this.sender == null) {
            throw new IOException("PKIHeader encoding error, Sender Name not specified");
        }
        this.sender.encode(derOutputStream2);
        if (this.recipient == null) {
            throw new IOException("PKIHeader encoding error, Recipient Name not specified");
        }
        this.recipient.encode(derOutputStream2);
        if (this.messageTime != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putGeneralizedTime(this.messageTime);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream);
        }
        if (this.protectionAlg != null) {
            derOutputStream = new DerOutputStream();
            this.protectionAlg.encode(derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream);
        }
        if (this.senderKID != null) {
            derOutputStream = new DerOutputStream();
            this.senderKID.encode(derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream);
        }
        if (this.recipKID != null) {
            derOutputStream = new DerOutputStream();
            this.recipKID.encode(derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream);
        }
        if (this.transactionID != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.transactionID);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), derOutputStream);
        }
        if (this.senderNonce != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.senderNonce);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), derOutputStream);
        }
        if (this.recipNonce != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.recipNonce);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)6), derOutputStream);
        }
        if (this.freeText != null) {
            derOutputStream = new DerOutputStream();
            this.freeText.encode((OutputStream)derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)7), derOutputStream);
        }
        if (this.generalInfo != null) {
            derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream4 = new DerOutputStream();
            if (this.generalInfo != null && this.generalInfo.length != 0) {
                int n = 0;
                while (n < this.generalInfo.length) {
                    this.generalInfo[n].encode((OutputStream)derOutputStream4);
                    ++n;
                }
            }
            derOutputStream.write((byte)48, derOutputStream4);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)8), derOutputStream);
        }
        derOutputStream3.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public boolean equals(PKIHeader pKIHeader) {
        DerValue derValue;
        DerValue derValue2;
        if (pKIHeader == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            pKIHeader.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof PKIHeader) {
            return this.equals((PKIHeader)object);
        }
        return false;
    }

    public PKIFreeText getFreeText() {
        if (this.freeText == null) {
            return null;
        }
        return (PKIFreeText)this.freeText.clone();
    }

    public InfoTypeAndValue[] getGeneralInfo() {
        if (this.generalInfo == null) {
            return null;
        }
        return (InfoTypeAndValue[])this.generalInfo.clone();
    }

    public Date getMessageTime() {
        if (this.messageTime == null) {
            return null;
        }
        return new Date(this.messageTime.getTime());
    }

    public AlgorithmId getProtectionAlg() throws IOException {
        if (this.protectionAlg == null) {
            return null;
        }
        return new AlgorithmId(this.protectionAlg.getOID(), this.protectionAlg.getParameters());
    }

    public BigInteger getPvno() {
        return new BigInteger(this.pvno.toByteArray());
    }

    public KeyIdentifier getRecipKID() throws IOException {
        if (this.recipKID == null) {
            return null;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        this.recipKID.encode(derOutputStream);
        return new KeyIdentifier(new DerValue(derOutputStream.toByteArray()));
    }

    public byte[] getRecipNonce() {
        if (this.recipNonce == null) {
            return null;
        }
        return (byte[])this.recipNonce.clone();
    }

    public GeneralName getRecipient() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.recipient.encode(derOutputStream);
        return new GeneralName(new DerValue(derOutputStream.toByteArray()));
    }

    public GeneralName getSender() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.sender.encode(derOutputStream);
        return new GeneralName(new DerValue(derOutputStream.toByteArray()));
    }

    public KeyIdentifier getSenderKID() throws IOException {
        if (this.senderKID == null) {
            return null;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        this.senderKID.encode(derOutputStream);
        return new KeyIdentifier(new DerValue(derOutputStream.toByteArray()));
    }

    public byte[] getSenderNonce() {
        if (this.senderNonce == null) {
            return null;
        }
        return (byte[])this.senderNonce.clone();
    }

    public byte[] getTransactionID() {
        if (this.transactionID == null) {
            return null;
        }
        return (byte[])this.transactionID.clone();
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "PKIHeader:";
        string = String.valueOf(string) + "\r\n\tversion number: " + this.pvno.toString();
        string = String.valueOf(string) + "\r\n\tsender: " + this.sender.toString();
        string = String.valueOf(string) + "\r\n\trecipient: " + this.recipient.toString();
        if (this.messageTime != null) {
            string = String.valueOf(string) + "\r\n\tmessage time: " + this.messageTime.toString();
        }
        if (this.protectionAlg != null) {
            try {
                string = this.protectionAlg.equals(new AlgorithmId(AlgorithmId.RC2CBC_oid, null)) ? String.valueOf(string) + "\r\n\tprotection algorith: found but without salt" : String.valueOf(string) + "\r\n\tprotection algorithm: " + this.protectionAlg.toString();
            }
            catch (IOException iOException) {}
        }
        if (this.senderKID != null) {
            string = String.valueOf(string) + "\r\n\tsender key protection: " + this.senderKID.toString();
        }
        if (this.recipKID != null) {
            string = String.valueOf(string) + "\r\n\trecipient key protection: " + this.recipKID.toString();
        }
        if (this.transactionID != null) {
            string = String.valueOf(string) + "\r\n\ttransaction identifier: " + new String(this.transactionID);
        }
        if (this.senderNonce != null) {
            string = String.valueOf(string) + "\r\n\tsender nonce: " + new String(this.senderNonce);
        }
        if (this.recipNonce != null) {
            string = String.valueOf(string) + "\r\n\trecipient nonce: " + new String(this.recipNonce);
        }
        if (this.freeText != null) {
            string = String.valueOf(string) + "\r\n\tfree text: " + this.freeText.toString();
        }
        if (this.generalInfo == null || this.generalInfo.length == 0) {
            string = String.valueOf(string) + "\r\n\tNo general info";
        } else {
            int n = 0;
            while (n < this.generalInfo.length) {
                string = String.valueOf(string) + "\r\n\tGeneral info[" + n + "]";
                string = String.valueOf(string) + this.generalInfo[n].toString();
                ++n;
            }
        }
        return string;
    }
}

