/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtc.orb.map;

import com.ibm.jtc.orb.map.MapFactory;
import com.ibm.jtc.orb.map.ObjectWrapper;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class MapFactories {
    public static final MapFactory HASH = Hash.INSTANCE;
    public static final MapFactory WEAK = Weak.INSTANCE;
    public static final MapFactory IDEN = Identity.INSTANCE;

    private MapFactories() {
    }

    private static final class WeakWrapper
    implements ObjectWrapper {
        public static final WeakWrapper INSTANCE = new WeakWrapper();

        private WeakWrapper() {
        }

        public final Object wrap(Object object) {
            return null == object ? null : new WeakReference<Object>(object);
        }

        public final Object unwrap(Object object) {
            return null == object ? null : ((WeakReference)object).get();
        }
    }

    private static final class NoopWrapper
    implements ObjectWrapper {
        public static final NoopWrapper INSTANCE = new NoopWrapper();

        private NoopWrapper() {
        }

        public final Object wrap(Object object) {
            return object;
        }

        public final Object unwrap(Object object) {
            return object;
        }
    }

    private static final class Identity
    implements MapFactory {
        public static final Identity INSTANCE = new Identity();

        private Identity() {
        }

        public Map create() {
            return new IdentityHashMap();
        }

        public ObjectWrapper getKeyWrapper() {
            return NoopWrapper.INSTANCE;
        }
    }

    private static final class Weak
    implements MapFactory {
        public static final Weak INSTANCE = new Weak();

        private Weak() {
        }

        public Map create() {
            return new WeakHashMap();
        }

        public ObjectWrapper getKeyWrapper() {
            return WeakWrapper.INSTANCE;
        }
    }

    private static final class Hash
    implements MapFactory {
        public static final Hash INSTANCE = new Hash();

        private Hash() {
        }

        public Map create() {
            return new HashMap();
        }

        public ObjectWrapper getKeyWrapper() {
            return NoopWrapper.INSTANCE;
        }
    }
}

