/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionKey;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.ChannelTransportConnection;
import com.ibm.rmi.channel.giop.GIOPChannelConfig;
import com.ibm.rmi.channel.giop.GIOPConnection;
import com.ibm.rmi.channel.giop.GIOPConnectionTable;
import com.ibm.rmi.channel.giop.MessageReader;
import com.ibm.rmi.iiop.Connection;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.OutboundProtocolLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;

public class GIOPClientLink
extends OutboundProtocolLink {
    static final String CLASS = GIOPClientLink.class.getName();
    private GIOPConnection giopConn = null;
    private GIOPChannelConfig giopConfig;
    private GIOPChannelPlugin giopPlugin;
    private Connection conn;
    private GIOPConnectionKey key;
    private GIOPConnectionTable connTable;
    private boolean firstConnection;

    public GIOPClientLink(VirtualConnection virtualConnection, GIOPChannelConfig gIOPChannelConfig) {
        this.init(virtualConnection);
        this.giopConfig = gIOPChannelConfig;
    }

    protected void postConnectProcessing(VirtualConnection virtualConnection) {
        TCPConnectionContext tCPConnectionContext = (TCPConnectionContext)this.getDeviceLink().getChannelAccessor();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "postConnectProcessing:87", " local " + tCPConnectionContext.getLocalAddress().getHostName() + ":" + tCPConnectionContext.getLocalPort() + " remote " + tCPConnectionContext.getRemoteAddress().getHostName() + ":" + tCPConnectionContext.getRemotePort());
        }
        try {
            this.giopPlugin = this.giopConfig.getGIOPChannelPlugin();
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, (Object)this, "postConnectProcessing:103", exception);
        }
        ChannelTransportConnection channelTransportConnection = new ChannelTransportConnection(this.giopConfig.getOrb());
        this.giopConn = new GIOPConnection(virtualConnection, (ConnectionLink)this, this.conn, channelTransportConnection, this.giopConfig, this.giopPlugin, tCPConnectionContext);
        channelTransportConnection.setConnectionContext(this.giopConn);
        this.conn.setContext(channelTransportConnection, this.giopConn, this.key.getGIOPConnectionProfile());
        this.key.addConnection(this.giopConn);
        MessageReader messageReader = (MessageReader)this.giopConn.getReadInterface();
        try {
            messageReader.retrieveDataLater(12);
        }
        catch (IOException iOException) {
            ORBRas.orbTrcLogger.exception(4104L, (Object)this, "postConnectProcessing:128", (Exception)iOException);
            this.giopConn.closeConnection(iOException);
        }
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (Trc.enabled()) {
            Trc.info(exception.getMessage(), CLASS, "close:141");
        }
        this.giopConn.waitForPermissionToClose(exception);
        this.getDeviceLink().close(virtualConnection, exception);
    }

    public void destroy(Exception exception) {
    }

    public Object getChannelAccessor() {
        GIOPConnection gIOPConnection = this.giopConn;
        if (!this.firstConnection) {
            Exception exception = new Exception("cached GIOPConnection found");
            this.getDeviceLink().close(this.vc, exception);
        }
        return gIOPConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object object) throws Exception {
        this.key = (GIOPConnectionKey)object;
        GIOPConnectionTable gIOPConnectionTable = this.connTable = this.giopConfig.getConnectionTable();
        synchronized (gIOPConnectionTable) {
            this.conn = this.connTable.getConnection(this.key);
            if (this.conn != null) {
                this.firstConnection = false;
                this.conn.checkEstablished();
                this.giopConn = (GIOPConnection)this.conn.getGiopConnCtx();
            } else {
                this.firstConnection = true;
                this.conn = new Connection(this.giopConfig.getOrb(), this.giopConfig.getGIOPImpl(), false);
                this.connTable.addConnection(this.key, this.conn);
                try {
                    super.connect((Object)this.key);
                }
                catch (Exception exception) {
                    this.connTable.removeConnection(this.conn);
                    throw exception;
                }
            }
        }
    }
}

