/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.orb.CallLink;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

abstract class RequestDataStore {
    private final Map dataMap = new HashMap();
    private final Map callLinkMap = new HashMap();
    private final Key skeletonKey = new Key(0);
    private final Object lock = this.skeletonKey;
    private IOException closeConnectionException = null;

    RequestDataStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeRequestData(int n, Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.dataMap.put(new Key(n), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object retrieveRequestData(int n) {
        if (this.closeConnectionException != null) {
            return this.closeConnectionException;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.dataMap.get(this.skeletonKey.toFit(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object clearRequestData(int n) {
        Object object = this.lock;
        synchronized (object) {
            return this.dataMap.remove(this.skeletonKey.toFit(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean noRequestData() {
        Object object = this.lock;
        synchronized (object) {
            return this.dataMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeCallLink(int n, CallLink callLink) {
        Object object = this.lock;
        synchronized (object) {
            this.callLinkMap.put(new Key(n), callLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeCallLink(int n, CallLink callLink, long l) {
        Object object = this.lock;
        synchronized (object) {
            this.callLinkMap.put(new Key(n, l), callLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallLink retrieveCallLink(int n) {
        Object object = this.lock;
        synchronized (object) {
            return (CallLink)this.callLinkMap.get(this.skeletonKey.toFit(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object[] getCallLinkKeySet() {
        Object object = this.lock;
        synchronized (object) {
            return this.callLinkMap.keySet().toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallLink clearCallLink(int n) {
        Object object = this.lock;
        synchronized (object) {
            return (CallLink)this.callLinkMap.remove(this.skeletonKey.toFit(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean noCallLink() {
        Object object = this.lock;
        synchronized (object) {
            return this.callLinkMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeException(int n, IOException iOException) {
        Object object = this.lock;
        synchronized (object) {
            this.dataMap.put(new Key(n), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IOException retrieveException(int n) {
        if (this.closeConnectionException != null) {
            return this.closeConnectionException;
        }
        Object object = this.lock;
        synchronized (object) {
            Object v = this.dataMap.get(this.skeletonKey.toFit(n));
            if (v instanceof IOException) {
                return (IOException)v;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallLink clearCallLinkIfWaiting(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            Object v = this.dataMap.get(object);
            if (v == null) {
                return (CallLink)this.callLinkMap.remove(object);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallLink clearCallLinkIfTimeout(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            long l = ((Key)object).getEndTime();
            if (l == 0L || l - System.currentTimeMillis() > 0L) {
                return null;
            }
            return (CallLink)this.callLinkMap.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getIdForKey(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            return ((Key)object).getId();
        }
    }

    public final void markCloseConnection(IOException iOException) {
        this.closeConnectionException = iOException;
    }

    private static final class Key {
        private int val;
        private long endTime;

        Key(int n) {
            this.val = n;
        }

        Key(int n, long l) {
            this(n);
            this.endTime = l;
        }

        Key toFit(int n) {
            this.val = n;
            return this;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.val == key.val;
            }
            return false;
        }

        public int hashCode() {
            return this.val;
        }

        private int getId() {
            return this.val;
        }

        private long getEndTime() {
            return this.endTime;
        }
    }
}

