/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.orb;

import com.ibm.CORBA.channel.IIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.orb.CallLink;
import com.ibm.CORBA.channel.orb.ORBConfigConstants;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.GIOPImpl;
import com.ibm.rmi.iiop.GIOPMessageContextBase;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.ORB;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import java.util.Map;

public class ORBChannelHelper
implements ORBConfigConstants {
    private static final String CLASS = ORBChannelHelper.class.getName();
    public static String ORB = "ORB";
    public static String ORBConnection = "ORBConnection";
    private Map orbProperty;
    private ORB orb;
    private GIOPImpl giopImpl;
    private IIOPChannelPlugin channelPlugin;

    protected ORBChannelHelper(Map map) {
        this.orbProperty = map;
    }

    protected int getTimeout(int n) {
        return n == 0 ? -1 : n;
    }

    protected ORB getOrb() {
        if (this.orb == null) {
            this.orb = (ORB)this.orbProperty.get(ORB);
        }
        return this.orb;
    }

    protected GIOPImpl getGIOPImpl() {
        if (this.giopImpl == null) {
            this.giopImpl = (GIOPImpl)this.getOrb().getServerGIOP();
        }
        return this.giopImpl;
    }

    protected IIOPChannelPlugin getIIOPChannelPlugin() {
        if (this.channelPlugin == null) {
            this.channelPlugin = (IIOPChannelPlugin)this.getOrb().getPlugin(IIOPChannelPlugin.class.getName());
        }
        return this.channelPlugin;
    }

    protected void processCall(Connection connection, GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext, CallLink callLink, int n) throws Exception {
        if (Trc.enabled()) {
            Trc.begin2("connCtx=", gIOPConnectionContext, "msgCtx=", gIOPMessageContext, CLASS, "processCall:124");
            Trc.info("got connection ", connection, CLASS, "processCall:125");
        }
        GIOPMessageContextBase gIOPMessageContextBase = (GIOPMessageContextBase)gIOPMessageContext;
        WsByteBuffer[] wsByteBufferArray = gIOPMessageContextBase.getMessageBody();
        Message message = (Message)gIOPMessageContext.getMessage();
        IIOPInputStream iIOPInputStream = connection.getStreamObject(wsByteBufferArray == null ? null : WsByteBufferUtils.asByteArray((WsByteBuffer[])gIOPMessageContextBase.getMessageBody()), message.getBodyOffset(), message);
        iIOPInputStream.setGIOPConnectionContext(gIOPConnectionContext);
        try {
            iIOPInputStream.setCodeBaseRefBytes(gIOPMessageContext.getSendingContextBytes());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        connection.processInput(iIOPInputStream);
    }
}

