/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.CORBA.ras.Trc;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;

public class IIOPAddrImpl
implements ObjectURL.IIOPAddr {
    private static final String CLASS = "IIOPAddrImpl";
    int port = 2809;
    private boolean usingDefaultPort = true;
    byte major = 1;
    byte minor = 0;
    String host = null;
    private static final String protToken = "iiop";
    private static final Pattern IIOP_ADDRESS_PARTS = Pattern.compile("(?:([^@]*)@)?(.*?)(?::([^]:]*))?");
    private static final Pattern HOST_SYNTAX = Pattern.compile("([^@:]*|\\[[^]\\[]+\\])");

    public IIOPAddrImpl(String string) {
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("empty iiop_addr", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        Matcher matcher = IIOP_ADDRESS_PARTS.matcher(string);
        matcher.matches();
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        if (Trc.enabled()) {
            Trc.info("Parsed IIOP Address '", string, "' into: Version='", string2, "', Host='", string3, "', Port='", string4, CLASS, "IIOPAddrImpl:113");
        }
        if (HOST_SYNTAX.matcher(string3).matches()) {
            if (string2 != null) {
                this.setVersion(string2);
            }
            this.setHost(string3);
            if (string4 != null) {
                this.setPort(string4);
            }
        } else {
            throw new BAD_PARAM("bad host '" + string3 + "'", 1330446345, CompletionStatus.COMPLETED_NO);
        }
    }

    public IIOPAddrImpl(String string, int n, byte by, byte by2) {
        this.setHost(string);
        this.setPort(n);
        this.setVersion(by, by2);
    }

    private void setVersion(String string) {
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("empty version", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        int n = string.indexOf(46);
        if (n <= 0 || n + 1 >= string.length()) {
            throw new BAD_PARAM("bad iiop version " + string, 1330446345, CompletionStatus.COMPLETED_NO);
        }
        try {
            this.setVersion(Byte.parseByte(string.substring(0, n)), Byte.parseByte(string.substring(n + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new BAD_PARAM(numberFormatException.getMessage() + " in " + string, 1330446345, CompletionStatus.COMPLETED_NO);
        }
    }

    private void setVersion(byte by, byte by2) {
        if (by != 1 || by2 > 2) {
            throw new BAD_PARAM("invalid GIOP version " + by + "." + by2, 1330446345, CompletionStatus.COMPLETED_NO);
        }
        this.major = by;
        this.minor = by2;
    }

    private void setPort(String string) {
        if (string != null && string.length() > 0) {
            try {
                this.setPort(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BAD_PARAM(numberFormatException.getMessage() + " in " + string, 1330446345, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    private void setPort(int n) {
        if (n < 0) {
            throw new BAD_PARAM("port cannot be negative", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        this.port = n;
        this.usingDefaultPort = false;
    }

    private void setHost(String string) {
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("empty host", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        this.host = string;
    }

    public String toString() {
        return this.getProtToken() + ":" + this.getProtAddr();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public String getProtToken() {
        return protToken;
    }

    public String getProtAddr() {
        return this.major + "." + this.minor + "@" + this.host + ":" + this.port;
    }

    protected boolean usingDefaultPort() {
        return this.usingDefaultPort;
    }
}

