/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.UserKey;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.corba.Element;
import com.ibm.rmi.corba.ObjectManagerInterface;
import com.ibm.rmi.corba.UserKeyImpl;
import com.ibm.rmi.util.Utility;

public final class TransientObjectManager
implements ObjectManagerInterface {
    private static final int INIT_SIZE = 8;
    private int maxSize;
    private Element[] elementArray;
    private Element freeList;

    public synchronized UserKey storeServant(Object object) {
        if (this.freeList == null) {
            this.grow();
        }
        Element element = this.freeList;
        this.freeList = (Element)this.freeList.servant;
        UserKeyImpl userKeyImpl = new UserKeyImpl(element.store(object));
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "storeServant:62", object.getClass().getName(), (Object)((Object)userKeyImpl).toString());
        }
        return userKeyImpl;
    }

    public synchronized Object lookupServant(UserKey userKey) {
        byte[] byArray = userKey.getBytes();
        int n = Utility.bytesToInt(byArray, 0);
        int n2 = Utility.bytesToInt(byArray, 4);
        if (n < 0 || n + 1 > this.maxSize) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "lookupServant:81", "key " + ((Object)userKey).toString() + " is out of range: index is " + n + " but valid range is 0-" + (this.maxSize - 1));
            }
            return null;
        }
        if (this.elementArray[n].counter == n2 && this.elementArray[n].valid) {
            return this.elementArray[n].servant;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "lookupServant:95", "stale key " + ((Object)userKey).toString());
        }
        return null;
    }

    public synchronized void deleteServant(UserKey userKey) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "deleteServant:107", ((Object)userKey).toString());
        }
        byte[] byArray = userKey.getBytes();
        int n = Utility.bytesToInt(byArray, 0);
        int n2 = Utility.bytesToInt(byArray, 4);
        if (n < 0 || n + 1 > this.maxSize) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "deleteServant:118", "key " + ((Object)userKey).toString() + " is out of range: index is " + n + " but valid range is 0-" + (this.maxSize - 1));
            }
            return;
        }
        if (this.elementArray[n].counter == n2 && this.elementArray[n].valid) {
            this.freeList = this.elementArray[n].delete(this.freeList);
            return;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "deleteServant:136", "stale key " + ((Object)userKey).toString());
        }
    }

    public synchronized UserKey getKey(Object object) {
        for (int i = 0; i < this.maxSize; ++i) {
            if (!this.elementArray[i].valid || this.elementArray[i].servant != object) continue;
            return new UserKeyImpl(this.elementArray[i].toBytes());
        }
        return null;
    }

    public Object preinvoke(Object object, String string) {
        return null;
    }

    public void postinvoke(Object object) {
    }

    private void grow() {
        int n = this.maxSize;
        if (n == 0) {
            this.maxSize = 8;
            this.elementArray = new Element[8];
        } else {
            this.maxSize *= 2;
            Element[] elementArray = this.elementArray;
            this.elementArray = new Element[this.maxSize];
            System.arraycopy(elementArray, 0, this.elementArray, 0, n);
        }
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, this.freeList);
        for (int i = this.maxSize - 2; i >= n; --i) {
            this.elementArray[i] = new Element(i, this.elementArray[i + 1]);
        }
        this.freeList = this.elementArray[n];
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "grow:187", "grew from " + n + " to " + this.maxSize);
        }
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < this.maxSize; ++i) {
            if (!this.elementArray[i].valid) continue;
            ++n;
            stringBuffer.append(this.elementArray[i] + " ");
        }
        return "Using " + n + " of " + this.maxSize + ":" + stringBuffer.toString();
    }
}

