/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.Delegate;
import com.ibm.CORBA.iiop.DynamicStub;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.PartnerVersion;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.map.DataValueListEntry;
import com.ibm.jtc.orb.map.Value;
import com.ibm.jtc.orb.map.WeakDataValueListEntry;
import com.ibm.org.omg.CORBA.ValueDefPackage.FullValueDescription;
import com.ibm.org.omg.CORBA._ObjectStub;
import com.ibm.org.omg.SendingContext.CodeBase;
import com.ibm.rmi.IOR;
import com.ibm.rmi.Profile;
import com.ibm.rmi.SubcontractRegistry;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.corba.PrincipalImpl;
import com.ibm.rmi.corba.TypeCodeImpl;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.iiop.CancelRequestException;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.FVDCodeBaseDelegate;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.TcsToCharConverter;
import com.ibm.rmi.io.FastIndirectionException;
import com.ibm.rmi.io.ValueHandlerImpl;
import com.ibm.rmi.io.ValueHandlerPool;
import com.ibm.rmi.util.ClassInfo;
import com.ibm.rmi.util.GIOPVersion;
import com.ibm.rmi.util.Interop;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Store;
import com.ibm.rmi.util.TreeStore;
import com.ibm.rmi.util.Utility;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.rmi.CORBA.Tie;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnySeqHolder;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DataInputStream;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.DynamicImplementation;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.UShortSeqHolder;
import org.omg.CORBA.WCharSeqHolder;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA.portable.ValueInputStream;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.PortableServer.Servant;
import org.omg.stub.java.rmi._Remote_Stub;

public class CDRInputStream
extends com.ibm.CORBA.iiop.CDRInputStream
implements DataInputStream,
ValueInputStream,
PartnerVersion {
    private static final String CLASS = CDRInputStream.class.getName();
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String kReadMethod = "read";
    private static final int maxBlockLength = 0x7FFFFF00;
    public final Interop interop;
    protected boolean littleEndian;
    protected int index;
    protected int size;
    protected int offset;
    protected byte[] buf;
    protected org.omg.CORBA.ORB orb;
    protected int tcsChar = 0;
    protected int tcsWChar = 0;
    protected TcsToCharConverter tcsCConverter = null;
    protected TcsToCharConverter tcsWConverter = null;
    public static final Serializable PENDING_READ = new PendingReadMarker();
    private Map valueCache = new HashMap();
    private static Set missStubCache = Collections.synchronizedSet(new HashSet());
    private Store typeStore = new TreeStore();
    private Store repositoryIdStore = new TreeStore();
    private Store codebaseStore = new TreeStore();
    private com.ibm.CORBA.iiop.IOR codeBaseServerIOR = null;
    private WsByteBuffer[] codeBaseServerIORBytes = null;
    private FVDCodeBaseDelegate cbDelegate = null;
    protected long blockLength = 0x7FFFFF00L;
    private int end_flag = 0;
    private int valueIndirection = 0;
    private int stringIndirection = 0;
    private boolean isChunked = false;
    private boolean prevIsChunked = false;
    private boolean customStreamEnd = false;
    private int customStreamLevel = 0;
    private Stack customStreamStack = null;
    private int oldSUID = -1;
    private ValueHandlerImpl valueHandler = null;
    private Connection connection = null;
    public static final byte CON_TYPE_UNSPECIFIED = 0;
    public static final byte CON_TYPE_CLIENT = 1;
    public static final byte CON_TYPE_SERVER = 2;
    private byte connectionType = 0;
    private byte GIOPMajor = 1;
    private byte GIOPMinor = (byte)2;
    private boolean preGIOP12_CDR = false;
    private short partnerMajor = (short)-1;
    private short partnerMinor = (short)-1;
    private short partnerExtended = (short)-1;
    private byte streamFormatVersion = 0;
    protected boolean fragmentable = false;
    private CodeBase runTimeCodeBase = null;
    private String repositoryIDString = null;
    private Class valueClass = null;
    private ClassLoader streamClassLoader = null;
    private ClassNotFoundException classNotFound = null;
    protected int start = 0;
    private static Class[] intArgsClass = new Class[]{org.omg.CORBA.portable.Delegate.class};
    private static final Class[] argTypes = new Class[]{org.omg.CORBA.portable.InputStream.class};
    private static String _id = "IDL:omg.org/CORBA/DataInputStream:1.0";
    private static String[] _ids = new String[]{_id};
    protected boolean haveCheckedOldNestingDepths;
    protected boolean useOldNestingDepths;
    private static final long serialVersionUID = 0L;

    public CDRInputStream() {
        this.interop = Interop.NO_IBM_ORB;
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n) {
        this(oRB, byArray, n, false);
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, Connection connection) {
        this(oRB, byArray, n, false);
        this.connection = connection;
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, boolean bl) {
        this.orb = oRB;
        this.littleEndian = bl;
        this.size = n;
        this.buf = byArray;
        this.offset = 0;
        if (oRB instanceof com.ibm.rmi.ORB) {
            this.interop = ((com.ibm.rmi.ORB)oRB).getInterop(this);
            ValueHandlerImpl.THREAD_LOCAL_PV.set(this);
        } else {
            this.interop = Interop.NO_IBM_ORB;
        }
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, int n2, int n3) {
        this(oRB, byArray, n, false, n2, n3);
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, boolean bl, int n2, int n3) {
        this(oRB, byArray, n, bl);
        this.setCodeSets(n2, n3);
    }

    public CDRInputStream(CDRInputStream cDRInputStream) {
        this.littleEndian = cDRInputStream.littleEndian;
        this.index = cDRInputStream.index;
        this.size = cDRInputStream.size;
        this.buf = cDRInputStream.buf;
        this.orb = cDRInputStream.orb;
        this.connection = cDRInputStream.connection;
        this.offset = cDRInputStream.offset;
        this.start = cDRInputStream.start;
        this.setGIOPVersion(cDRInputStream.GIOPMajor, cDRInputStream.GIOPMinor, cDRInputStream.fragmentable);
        this.setCodeSets(cDRInputStream.tcsChar, cDRInputStream.tcsWChar);
        this.interop = cDRInputStream.interop;
    }

    public CDRInputStream(CDROutputStream cDROutputStream, byte[] byArray, int n) {
        this(cDROutputStream.orb(), byArray, n, cDROutputStream.littleEndian(), cDROutputStream.getCharCodeSet(), cDROutputStream.getWCharCodeSet());
        this.setGIOPVersions(cDROutputStream.getGIOPMajor(), cDROutputStream.getGIOPMinor(), cDROutputStream.getPartnerMajor(), cDROutputStream.getPartnerMinor(), cDROutputStream.getPartnerExtended());
        this.setStreamFormatVersion(cDROutputStream.getStreamFormatVersion());
    }

    public CDRInputStream(CDRInputStream cDRInputStream, int n) {
        this(cDRInputStream.getORB(), cDRInputStream.buf, cDRInputStream.mark() + n);
        if (cDRInputStream.index + n <= cDRInputStream.size) {
            this.index = this.start = cDRInputStream.index;
            this.offset = cDRInputStream.get_offset();
            cDRInputStream.setOffset(cDRInputStream.mark() + n);
        } else {
            this.littleEndian = cDRInputStream.littleEndian;
            this.buf = new byte[n];
            cDRInputStream.read_octet_array(this.buf, 0, n);
            this.start = 0;
            this.index = 0;
            this.size = n;
            this.offset = cDRInputStream.get_offset() - n;
        }
        this.typeStore = cDRInputStream.getTypeStore();
        this.setGIOPVersion(cDRInputStream.GIOPMajor, cDRInputStream.GIOPMinor, cDRInputStream.fragmentable);
    }

    public void setGIOPVersions(byte by, byte by2, short s, short s2, short s3) {
        this.partnerMajor = s;
        this.partnerMinor = s2;
        this.partnerExtended = s3;
        this.setGIOPVersion(by, by2, false);
    }

    public void setGIOPVersion(byte by, byte by2) {
        this.setGIOPVersion(by, by2, false);
    }

    public void setGIOPVersion(byte by, byte by2, boolean bl) {
        this.GIOPMajor = by;
        this.GIOPMinor = by2;
        if (by == 1 && by2 <= 1) {
            this.preGIOP12_CDR = true;
            this.fragmentable = false;
        } else {
            this.preGIOP12_CDR = false;
            this.fragmentable = bl;
        }
    }

    public void setStreamFormatVersion(byte by) {
        this.streamFormatVersion = by;
    }

    public void setConnectionType(byte by) {
        this.connectionType = by;
    }

    private void raiseWCharMarshal(String string) {
        switch (this.connectionType) {
            case 1: {
                throw new MARSHAL(string, 1330446342, CompletionStatus.COMPLETED_NO);
            }
            case 2: {
                throw new MARSHAL(string, 1330446341, CompletionStatus.COMPLETED_NO);
            }
            case 0: {
                throw new MARSHAL(string, 1229125870, CompletionStatus.COMPLETED_NO);
            }
        }
        ORBRas.orbTrcLogger.trace(4104L, this, "raiseWCharMarshal:574", "Invalid connectionType encountered: " + Integer.toString(this.connectionType));
    }

    public byte getGIOPMajor() {
        return this.GIOPMajor;
    }

    public byte getGIOPMinor() {
        return this.GIOPMinor;
    }

    public short getPartnerMajor() {
        if (this.partnerMajor == -1) {
            Connection connection = this.getConnection();
            this.partnerMajor = connection != null ? connection.getPartnerMajor() : (short)0;
        }
        return this.partnerMajor;
    }

    public short getPartnerMinor() {
        if (this.partnerMinor == -1) {
            Connection connection = this.getConnection();
            this.partnerMinor = connection != null ? connection.getPartnerMinor() : (short)0;
        }
        return this.partnerMinor;
    }

    public short getPartnerExtended() {
        if (this.partnerExtended == -1) {
            Connection connection = this.getConnection();
            this.partnerExtended = connection != null ? connection.getPartnerExtended() : (short)0;
        }
        return this.partnerExtended;
    }

    public byte getStreamFormatVersion() {
        Connection connection;
        if (this.streamFormatVersion == 0 && (connection = this.getConnection()) != null) {
            this.streamFormatVersion = connection.getStreamFormatVersion();
        }
        return this.streamFormatVersion;
    }

    public void setCodeBaseRef(com.ibm.CORBA.iiop.IOR iOR) {
        this.codeBaseServerIOR = iOR;
    }

    public void setCodeBaseRefBytes(WsByteBuffer[] wsByteBufferArray) {
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.setCodeBaseRefBytes(wsByteBufferArray);
        } else {
            this.codeBaseServerIORBytes = wsByteBufferArray;
        }
    }

    private com.ibm.CORBA.iiop.IOR getCodeBaseRef() {
        if (this.codeBaseServerIOR == null && this.codeBaseServerIORBytes != null) {
            byte[] byArray = WsByteBufferUtils.asByteArray((WsByteBuffer[])this.codeBaseServerIORBytes);
            CDRInputStream cDRInputStream = new CDRInputStream(this.orb, byArray, byArray.length);
            cDRInputStream.consumeEndian();
            IOR iOR = new IOR((ORB)this.orb);
            iOR.read((org.omg.CORBA.portable.InputStream)cDRInputStream);
            if (Trc.enabled()) {
                Trc.info(iOR.stringify(), CLASS, "getCodeBaseRef:675");
            }
            this.setCodeBaseRef(iOR);
        }
        return this.codeBaseServerIOR;
    }

    public void setCodeSets(int n, int n2) {
        this.tcsChar = n;
        this.tcsWChar = n2;
        this.tcsCConverter = null;
        this.tcsWConverter = null;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.streamClassLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.streamClassLoader;
    }

    public int getCharCodeSet() {
        return this.tcsChar;
    }

    public int getWCharCodeSet() {
        return this.tcsWChar;
    }

    public org.omg.CORBA.ORB getORB() {
        return this.orb;
    }

    protected IOR getIOR() {
        return new IOR((com.ibm.rmi.ORB)this.orb);
    }

    public void addTypeAtPosition(TypeCodeImpl typeCodeImpl, int n) {
        this.typeStore.add(n, (java.lang.Object)typeCodeImpl);
    }

    public TypeCodeImpl getTypeAtPosition(int n) {
        try {
            return (TypeCodeImpl)((java.lang.Object)this.typeStore.get(n));
        }
        catch (Store.NoSuchElementException noSuchElementException) {
            Trc.ffdc(noSuchElementException, CLASS, "getTypeAtPosition:727");
            return null;
        }
    }

    private Store getTypeStore() {
        return this.typeStore;
    }

    public boolean wasCreatedFrom(CDROutputStream cDROutputStream) {
        return cDROutputStream != null && cDROutputStream.getBuffer() == this.buf;
    }

    public com.ibm.CORBA.iiop.CDRInputStream dup() {
        return new CDRInputStream(this);
    }

    public final int alignAndCheck(int n, int n2) {
        int n3;
        boolean bl;
        int n4 = n;
        if (this.customStreamEnd) {
            throw new MARSHAL("No more custom marshaled data", 1330446344, CompletionStatus.COMPLETED_MAYBE);
        }
        int n5 = n2;
        boolean bl2 = bl = this.blockLength < 0x7FFFFF00L;
        if (this.blockLength == (long)this.index) {
            this.blockLength = 0x7FFFFF00L;
            this.start_block();
        }
        if (n > 1 && (n3 = this.index - this.start & n - 1) != 0) {
            n3 = n - n3;
            this.index += n3;
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.customStreamLevel != 0) {
            if (this.blockLength < 0x7FFFFF00L) {
                if ((long)(this.index + n4) > this.blockLength) {
                    throw new MARSHAL("Not enough custom marshaled data in chunk", 1330446344, CompletionStatus.COMPLETED_MAYBE);
                }
            } else if (bl && this.customStreamLevel <= this.end_flag) {
                throw new MARSHAL("Not enough custom marshaled data in enclosure", 1330446344, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        if (this.index + n4 > this.size) {
            try {
                if (this.fragmentable) {
                    n3 = this.index;
                    this.getNextBuffer();
                    if (this.blockLength != 0x7FFFFF00L) {
                        this.blockLength = this.blockLength - (long)n3 + (long)this.index;
                    }
                } else {
                    this.grow(n, n2);
                }
            }
            catch (MARSHAL mARSHAL) {
                throw new MARSHAL("No available data: " + mARSHAL.getMessage(), 1330446344, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        if (this.index + n2 > this.size) {
            n5 = this.size - this.index;
        }
        return (n5 - n5 % n4) / n4;
    }

    public void getNextBuffer() {
        throw new MARSHAL("InputStream fragmentation error", 1229125819, CompletionStatus.COMPLETED_NO);
    }

    protected void grow(int n, int n2) {
        throw new MARSHAL("Read beyond end of input stream", 1229125858, CompletionStatus.COMPLETED_NO);
    }

    public void setOffset(int n) {
        this.index = n;
    }

    public final void consumeEndian() {
        this.littleEndian = this.read_boolean();
    }

    public final double read_longdouble() {
        throw new NO_IMPLEMENT("long double not implemented (2) - no such type in java", 1229124491, CompletionStatus.COMPLETED_MAYBE);
    }

    public final boolean read_boolean() {
        boolean bl = this.read_octet() != 0;
        return bl;
    }

    public final char read_char() {
        this.alignAndCheck(1, 1);
        byte[] byArray = new byte[]{this.buf[this.index++]};
        TcsToCharConverter tcsToCharConverter = this.getTcsCConverter();
        char[] cArray = tcsToCharConverter.convertFromByte(byArray);
        return cArray[0];
    }

    public final char read_wchar() {
        int n;
        if (!GIOPVersion.getGIOPVersion(this.getGIOPMajor(), this.getGIOPMinor()).allowReceivingWideCharacters(this.orb)) {
            this.raiseWCharMarshal("wchar not supported in GIOP 1.0");
        }
        TcsToCharConverter tcsToCharConverter = this.getTcsWConverter();
        boolean bl = tcsToCharConverter.needToSwap(this.littleEndian);
        if (this.preGIOP12_CDR) {
            n = 2;
            this.alignAndCheck(2, 2);
        } else {
            n = this.read_octet();
        }
        if (n > tcsToCharConverter.getMaxBytesPerChar()) {
            throw new MARSHAL("wchar length " + n + " exceeds expected max " + tcsToCharConverter.getMaxBytesPerChar() + " octets per char", 1229125824, CompletionStatus.COMPLETED_NO);
        }
        char[] cArray = new char[n / 2];
        for (int i = 0; i < cArray.length; ++i) {
            int n2 = this.read_octet() & 0xFF;
            int n3 = this.read_octet() & 0xFF;
            cArray[i] = bl ? (char)(n3 << 8 | n2) : (char)(n2 << 8 | n3);
        }
        char[] cArray2 = tcsToCharConverter.convertFromChar(cArray, this.littleEndian);
        return cArray2[0];
    }

    public final byte read_octet() {
        this.alignAndCheck(1, 1);
        byte by = this.buf[this.index++];
        if (this.blockLength == (long)this.index) {
            this.blockLength = 0x7FFFFF00L;
            this.start_block();
        }
        return by;
    }

    public final void ignoreReserved() {
        block7: {
            try {
                switch (this.available()) {
                    case 0: {
                        this.alignAndCheck(2, 2);
                        this.index += 2;
                        this.alignAndCheck(1, 1);
                        ++this.index;
                        return;
                    }
                    case 1: {
                        ++this.index;
                        this.alignAndCheck(2, 2);
                        this.index += 2;
                        return;
                    }
                    case 2: {
                        this.index += 2;
                        this.alignAndCheck(1, 1);
                        ++this.index;
                        return;
                    }
                }
                this.index += 3;
            }
            catch (IOException iOException) {
                if (!Trc.enabled()) break block7;
                Trc.warn(iOException, CLASS, "ignoreReserved:988");
            }
        }
    }

    public final short read_short() {
        int n;
        int n2;
        this.alignAndCheck(2, 2);
        if (this.littleEndian) {
            n2 = this.buf[this.index++] << 0 & 0xFF;
            n = this.buf[this.index++] << 8 & 0xFF00;
        } else {
            n = this.buf[this.index++] << 8 & 0xFF00;
            n2 = this.buf[this.index++] << 0 & 0xFF;
        }
        return (short)(n | n2);
    }

    public final short read_ushort() {
        return this.read_short();
    }

    public final int read_long() {
        int n;
        int n2;
        int n3;
        int n4;
        this.alignAndCheck(4, 4);
        if (this.littleEndian) {
            n4 = this.buf[this.index++] & 0xFF;
            n3 = this.buf[this.index++] & 0xFF;
            n2 = this.buf[this.index++] & 0xFF;
            n = this.buf[this.index++] & 0xFF;
        } else {
            n = this.buf[this.index++] & 0xFF;
            n2 = this.buf[this.index++] & 0xFF;
            n3 = this.buf[this.index++] & 0xFF;
            n4 = this.buf[this.index++] & 0xFF;
        }
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public final int read_ulong() {
        return this.read_long();
    }

    public final long read_longlong() {
        long l;
        long l2;
        this.alignAndCheck(8, 8);
        if (this.littleEndian) {
            l2 = (long)this.read_long() & 0xFFFFFFFFL;
            l = (long)this.read_long() << 32;
        } else {
            l = (long)this.read_long() << 32;
            l2 = (long)this.read_long() & 0xFFFFFFFFL;
        }
        return l | l2;
    }

    public final long read_ulonglong() {
        return this.read_longlong();
    }

    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    private final byte[] readBytesForString(boolean bl) {
        int n;
        int n2 = this.read_long();
        if (bl) {
            if (n2 == -1) {
                return null;
            }
            this.stringIndirection = this.get_offset() - 4;
        }
        if (n2 == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[--n2];
        for (int i = 0; i < n2; i += n) {
            n = this.alignAndCheck(1, n2 - i);
            System.arraycopy(this.buf, this.index, byArray, i, n);
            this.index += n;
        }
        this.read_octet();
        return byArray;
    }

    protected final String readRepIdOrIndirection() {
        String string;
        byte[] byArray = this.readBytesForString(true);
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        if (this.interop.useAlternativeRepIDEncoding.inUse()) {
            TcsToCharConverter tcsToCharConverter = this.getTcsCConverter();
            string = new String(tcsToCharConverter.convertFromByte(byArray));
            string = RepositoryId.escape(string);
        } else {
            TcsToCharConverter tcsToCharConverter = TcsToCharConverter.getConverter(65537);
            string = new String(tcsToCharConverter.convertFromByte(byArray));
        }
        return string;
    }

    protected final String readStringOrIndirection(boolean bl) {
        byte[] byArray = this.readBytesForString(bl);
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        TcsToCharConverter tcsToCharConverter = this.getTcsCConverter();
        return new String(tcsToCharConverter.convertFromByte(byArray));
    }

    public final String read_string() {
        return this.readStringOrIndirection(false);
    }

    public SystemException readSystemException() {
        SystemException systemException = Utility.readSystemException((org.omg.CORBA.portable.InputStream)this);
        return systemException;
    }

    public String peekUserExceptionId() {
        int n = this.mark();
        String string = this.read_string();
        this.reset(n);
        return string;
    }

    public final String read_wstring() {
        int n;
        int n2;
        if (!GIOPVersion.getGIOPVersion(this.getGIOPMajor(), this.getGIOPMinor()).allowReceivingWideCharacters(this.orb)) {
            this.raiseWCharMarshal("wstring not supported in GIOP 1.0");
        }
        if (this.preGIOP12_CDR) {
            n2 = this.read_long();
            if (n2 == 0) {
                return "";
            }
            n = --n2 * 2;
        } else {
            n = this.read_long();
            if (n == 0) {
                return "";
            }
            n2 = n / 2;
        }
        char[] cArray = new char[n2];
        TcsToCharConverter tcsToCharConverter = this.getTcsWConverter();
        boolean bl = tcsToCharConverter.needToSwap(this.littleEndian);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            int n6;
            int n7;
            n3 = this.alignAndCheck(2, (n2 - n4) * 2);
            if (bl) {
                for (n7 = 0; n7 < n3; ++n7) {
                    n6 = this.buf[this.index++] & 0xFF;
                    n5 = this.buf[this.index++] & 0xFF;
                    cArray[n4++] = (char)((n5 << 8) + (n6 << 0));
                }
                continue;
            }
            for (n7 = 0; n7 < n3; ++n7) {
                n5 = this.buf[this.index++] & 0xFF;
                n6 = this.buf[this.index++] & 0xFF;
                cArray[n4++] = (char)((n5 << 8) + (n6 << 0));
            }
        }
        if (this.preGIOP12_CDR) {
            this.read_short();
        }
        return new String(tcsToCharConverter.convertFromChar(cArray, this.littleEndian));
    }

    public final void read_octet_array(byte[] byArray, int n, int n2) {
        int n3;
        if (byArray == null) {
            throw new BAD_PARAM("NULL_PARAM (17) - Null encountered reading octet array", 1229124113, CompletionStatus.COMPLETED_NO);
        }
        for (int i = n; i < n2 + n; i += n3) {
            int n4 = n2 + n - i;
            n3 = this.alignAndCheck(1, n4);
            System.arraycopy(this.buf, this.index, byArray, i, n3);
            this.index += n3;
        }
    }

    public Principal read_Principal() {
        int n = this.read_long();
        byte[] byArray = new byte[n];
        this.read_octet_array(byArray, 0, n);
        PrincipalImpl principalImpl = new PrincipalImpl();
        principalImpl.name(byArray);
        return principalImpl;
    }

    public TypeCode read_TypeCode() {
        TypeCodeImpl typeCodeImpl = TypeCodeImpl.readTypeCode(this, null);
        return typeCodeImpl;
    }

    public Any read_any() {
        Any any = this.orb.create_any();
        TypeCodeImpl typeCodeImpl = TypeCodeImpl.readTypeCode(this, null);
        any.read_value((org.omg.CORBA.portable.InputStream)this, (TypeCode)typeCodeImpl);
        return any;
    }

    public java.lang.Object fast_readAnyOpt() {
        TypeCodeImpl typeCodeImpl = TypeCodeImpl.readTypeCode(this, null);
        int n = typeCodeImpl.kind().value();
        if (n == 29) {
            return this.fast_read_value();
        }
        if (n == 30) {
            return this.fast_read_value();
        }
        if (n == 14) {
            return this.read_Object();
        }
        if (n == 32) {
            return this.fast_read_abstract_interface();
        }
        throw new MARSHAL("Unexpected type in any", 1229125810, CompletionStatus.COMPLETED_NO);
    }

    public java.lang.Object readAnyOpt() {
        TypeCodeImpl typeCodeImpl = TypeCodeImpl.readTypeCode(this, null);
        int n = typeCodeImpl.kind().value();
        if (n == 29) {
            return this.read_value();
        }
        if (n == 30) {
            return this.read_value();
        }
        if (n == 14) {
            return this.read_Object();
        }
        if (n == 32) {
            return this.read_abstract_interface();
        }
        throw new MARSHAL("Unexpected type " + n + " in any", 1229125804, CompletionStatus.COMPLETED_NO);
    }

    public Object read_Object() {
        return this.read_Object(null);
    }

    public Object read_Object(Class clazz) {
        IOR iOR = this.getIOR();
        iOR.read((org.omg.CORBA.portable.InputStream)this);
        if (clazz != null && !ObjectImpl.class.isAssignableFrom(clazz)) {
            if (DynamicStub.class.isAssignableFrom(clazz)) {
                clazz = clazz.getInterfaces()[0];
            }
            String string = iOR.getCodebase();
            String string2 = iOR.getTypeId();
            Object object = InterfaceClassToStubClassInfoCache.createNewObjRef(clazz, iOR, string, string2, this);
            return (Object)PortableRemoteObject.narrow((java.lang.Object)object, clazz);
        }
        return this.newObjRef(iOR, clazz, null);
    }

    public Object newObjRef(IOR iOR, Class clazz, Class clazz2) {
        SubcontractRegistry subcontractRegistry;
        if (iOR.is_nil()) {
            return null;
        }
        Profile profile = (Profile)iOR.getProfile();
        ObjectKey objectKey = profile.getObjectKeyObject();
        if (this.orb instanceof ORB && (subcontractRegistry = ((ORB)this.orb).lookupLocalObject(clazz, clazz2, iOR, objectKey)) != null) {
            return this.loadLocalStub((Object)subcontractRegistry, clazz, clazz2, iOR);
        }
        subcontractRegistry = (SubcontractRegistry)((com.ibm.rmi.ORB)this.orb).getSubcontractRegistry();
        ClientSubcontract clientSubcontract = subcontractRegistry.getClientSubcontract(iOR);
        return this.loadStub(iOR, clazz, (org.omg.CORBA.portable.Delegate)clientSubcontract, clazz2);
    }

    protected Object loadLocalStub(Object object, Class clazz, Class clazz2, com.ibm.CORBA.iiop.IOR iOR) {
        Object object2;
        java.lang.Object object3;
        if (!(object instanceof InvokeHandler || object instanceof DynamicImplementation || object instanceof Servant)) {
            if (object.getClass() == clazz || ClassInfo.isCompatible(object.getClass(), clazz2, this.streamClassLoader)) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "loadLocalStub:1422", "returning compatible stub:" + object.getClass().getName() + ", CL:" + object.getClass().getClassLoader());
                }
                return object;
            }
            object3 = (Delegate)((ObjectImpl)object)._get_delegate();
            object = (Object)((Delegate)((java.lang.Object)object3)).getCorbaServant();
        }
        if ((object2 = Utility.loadStub((java.lang.Object)object, clazz, clazz2, (String)(object3 = iOR.getCodebase()), false)) != null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exit(4100L, this, "loadLocalStub:1448", (java.lang.Object)("returning stub:" + object2.getClass().getName() + ", CL:" + object2.getClass().getClassLoader()));
            }
            return object2;
        }
        if (object instanceof Tie) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exit(4100L, this, "loadLocalStub:1457", (java.lang.Object)"failed to load stub, throwing MARSHAL");
            }
            throw new MARSHAL("Read Object Exception (2)", 1229125828, CompletionStatus.COMPLETED_NO);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "loadLocalStub:1473", (java.lang.Object)("failed to load stub, returning IDL servant:" + object.getClass()));
        }
        return object;
    }

    protected ObjectImpl loadStub(IOR iOR, Class clazz, org.omg.CORBA.portable.Delegate delegate, Class clazz2) {
        if (clazz != null) {
            try {
                return CDRInputStream.newStub(clazz, delegate);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                if (throwable instanceof ClassNotFoundException) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8208L, CLASS, "loadStub:1498", throwable.toString());
                    }
                } else if (throwable instanceof Exception) {
                    ORBRas.orbTrcLogger.exception(4104L, CLASS, "loadStub:1503", (Exception)throwable);
                } else {
                    ORBRas.orbTrcLogger.trace(4104L, CLASS, "loadStub:1507", throwable.toString(), (java.lang.Object)throwable);
                }
            }
        } else {
            String string = iOR.getTypeId();
            if (!missStubCache.contains(string) && string.length() > 0) {
                try {
                    String string2 = iOR.getCodebase();
                    Class clazz3 = Utility.loadStubClass(string, string2, clazz2, this.streamClassLoader);
                    return CDRInputStream.newStub(clazz3, delegate);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    if (throwable instanceof ClassNotFoundException) {
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(8208L, CLASS, "loadStub:1530", throwable.toString());
                        }
                    } else if (throwable instanceof Exception) {
                        ORBRas.orbTrcLogger.exception(4104L, CLASS, "loadStub:1534", (Exception)throwable);
                    } else {
                        ORBRas.orbTrcLogger.trace(4104L, CLASS, "loadStub:1538", throwable.toString(), (java.lang.Object)throwable);
                    }
                    missStubCache.add(string);
                }
            }
            java.lang.Object object = string.startsWith("RMI:") ? new _Remote_Stub() : new _ObjectStub();
            object._set_delegate(delegate);
            return object;
        }
        throw new MARSHAL("READ_OBJECT_EXCEPTION (1) for stub class " + clazz, 1229125827, CompletionStatus.COMPLETED_NO);
    }

    protected static ObjectImpl newStub(Class clazz, org.omg.CORBA.portable.Delegate delegate) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (Remote.class.isAssignableFrom(clazz)) {
            ObjectImpl objectImpl = (ObjectImpl)clazz.newInstance();
            objectImpl._set_delegate(delegate);
            return objectImpl;
        }
        try {
            ObjectImpl objectImpl = (ObjectImpl)clazz.newInstance();
            objectImpl._set_delegate(delegate);
            return objectImpl;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, CLASS, "newStub:1602", throwable.toString());
            }
            java.lang.Object[] objectArray = new java.lang.Object[]{delegate};
            Constructor constructor = clazz.getConstructor(intArgsClass);
            return (ObjectImpl)constructor.newInstance(objectArray);
        }
    }

    public java.lang.Object read_abstract_interface() {
        return this.read_abstract_interface(null);
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        boolean bl = this.read_boolean();
        if (bl) {
            return this.read_Object(clazz);
        }
        return this.read_value();
    }

    public Serializable read_value() {
        Serializable serializable = this.fast_read_value();
        if (serializable != PENDING_READ) {
            return serializable;
        }
        int n = this.valueIndirection;
        boolean bl = this.prevIsChunked;
        boolean bl2 = false;
        if (this.valueHandler == null) {
            bl2 = true;
            this.valueHandler = ValueHandlerPool.getValueHandler();
        }
        try {
            serializable = this.valueHandler.readValue((org.omg.CORBA.portable.InputStream)this, this.valueIndirection, this.valueClass, this.repositoryIDString, null);
        }
        catch (CancelRequestException cancelRequestException) {
            throw cancelRequestException;
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            Trc.ffdc((Exception)((java.lang.Object)nO_IMPLEMENT), CLASS, "read_value:1650");
            if (this.classNotFound != null) {
                nO_IMPLEMENT.initCause((Throwable)this.classNotFound);
                this.classNotFound = null;
            }
            throw nO_IMPLEMENT;
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "read_value:1657");
            MARSHAL mARSHAL = new MARSHAL("Unable to read value from underlying bridge : " + exception.getMessage(), 1229125782, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)exception);
            throw mARSHAL;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Trc.ffdc(outOfMemoryError.toString(), CLASS, "read_value:1665");
            NO_MEMORY nO_MEMORY = new NO_MEMORY("Unable to read value from underlying bridge : " + outOfMemoryError.getMessage(), 1229126017, CompletionStatus.COMPLETED_NO);
            nO_MEMORY.initCause((Throwable)outOfMemoryError);
            throw nO_MEMORY;
        }
        catch (Error error) {
            Trc.ffdc(error.toString(), CLASS, "read_value:1673");
            MARSHAL mARSHAL = new MARSHAL("Unable to read value from underlying bridge : " + error.getMessage(), 1229125783, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)error);
            throw mARSHAL;
        }
        finally {
            if (bl2) {
                ValueHandlerPool.returnValueHandler(this.valueHandler);
                this.valueHandler = null;
            }
        }
        this.valueIndirection = n;
        this.addToValueCache(serializable);
        this.post_fast_read_value(bl);
        return serializable;
    }

    public Serializable fast_read_value() {
        int n = this.readValueTag();
        if (n == 0) {
            return null;
        }
        int n2 = this.get_offset();
        if (n == -1) {
            return this.readIndirection(n2);
        }
        this.valueIndirection = n2 -= 4;
        this.prevIsChunked = this.isChunked;
        boolean bl = this.isChunked;
        this.isChunked = RepositoryId.isChunkedEncoding(n);
        java.lang.Object object = null;
        String string = null;
        if (RepositoryId.isCodeBasePresent(n)) {
            string = this.read_codebase_URL();
        }
        switch (RepositoryId.getTypeInfo(n)) {
            case 0: {
                this.repositoryIDString = RepositoryId.createForAnyType(null);
                break;
            }
            case 2: {
                this.repositoryIDString = this.read_repositoryId();
                break;
            }
            case 6: {
                this.repositoryIDString = this.read_repositoryIds();
                break;
            }
            default: {
                throw new MARSHAL("Undefined type information value in value_tag 0x" + Integer.toHexString(n), 1229125789, CompletionStatus.COMPLETED_NO);
            }
        }
        this.start_block();
        if (this.useOldNestingDepths()) {
            --this.end_flag;
        } else if (this.isChunked) {
            --this.end_flag;
        }
        if (this.repositoryIDString.equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
            object = this.read_wstring();
        } else if (this.repositoryIDString.equals(RepositoryId.kClassDescValueRepID)) {
            object = this.readClass(n2);
        } else {
            RepositoryId repositoryId;
            block24: {
                repositoryId = RepositoryId.get(this.repositoryIDString);
                if (repositoryId.isProxy()) {
                    try {
                        this.valueClass = this.loadProxyClass(this.repositoryIDString);
                    }
                    catch (Exception exception) {
                        if (Trc.enabled()) {
                            Trc.warn(exception, CLASS, "fast_read_value:1765");
                        }
                        this.valueClass = null;
                        if (exception instanceof ClassNotFoundException) {
                            this.classNotFound = (ClassNotFoundException)exception;
                        }
                        break block24;
                    }
                }
                try {
                    this.valueClass = repositoryId.getClassFromType(string, this.streamClassLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.valueClass = null;
                    this.classNotFound = classNotFoundException;
                    if (!Trc.enabled()) break block24;
                    Trc.warn(classNotFoundException, CLASS, "fast_read_value:1789");
                }
            }
            if (this.valueClass != null && IDLEntity.class.isAssignableFrom(this.valueClass) || repositoryId.isIDLType()) {
                object = this.readIDLValue(n2, this.repositoryIDString, this.valueClass, string);
                this.classNotFound = null;
            } else {
                return PENDING_READ;
            }
        }
        this.addToValueCache(object);
        this.post_fast_read_value2(bl);
        return (Serializable)object;
    }

    public void addToValueCache(java.lang.Object object) {
        this.addToValueCache(this.valueIndirection, object);
    }

    public void addToValueCache(int n, java.lang.Object object) {
        if (null != object) {
            this.valueCache.put(n, object);
        }
    }

    public boolean getOldSUID() {
        if (this.oldSUID == -1) {
            short s;
            short s2 = this.getPartnerMajor();
            this.oldSUID = PartnerVersionUtil.useOldSUID(s2, s = this.getPartnerMinor()) ? 1 : 0;
        }
        return this.oldSUID == 1;
    }

    public boolean getPrevIsChunked() {
        return this.prevIsChunked;
    }

    public int getValueIndirection() {
        return this.valueIndirection;
    }

    public void setValueIndirection(int n) {
        this.valueIndirection = n;
    }

    public String getRepositoryIDString() {
        return this.repositoryIDString;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public void post_fast_read_value(boolean bl) {
        try {
            if (this.isChunked) {
                this.skipToEndOfValue();
            }
            this.end_block();
            this.readEndTag();
            this.isChunked = bl;
            this.start_block();
        }
        catch (MARSHAL mARSHAL) {
            if (mARSHAL.minor == 1330446344) {
                if (Trc.enabled()) {
                    Trc.info("End of stream after object is fully read :", mARSHAL.getMessage(), CLASS, "fast_read_value:1905");
                }
            }
            throw mARSHAL;
        }
    }

    public void post_fast_read_value2(boolean bl) {
        this.end_block();
        this.readEndTag();
        this.isChunked = bl;
        this.start_block();
    }

    public java.lang.Object fast_read_abstract_interface() {
        return this.fast_read_abstract_interface(null);
    }

    public java.lang.Object fast_read_abstract_interface(Class clazz) {
        boolean bl = this.read_boolean();
        if (bl) {
            return this.read_Object(clazz);
        }
        return this.fast_read_value();
    }

    public Serializable fast_read_value(Class clazz) {
        int n = this.readValueTag();
        if (n == 0) {
            return null;
        }
        int n2 = this.get_offset();
        if (n == -1) {
            return this.readIndirection(n2);
        }
        this.valueIndirection = n2 -= 4;
        String string = null;
        if (clazz != null) {
            string = RepositoryId.createForAnyType(clazz, false, this);
        }
        this.prevIsChunked = this.isChunked;
        boolean bl = this.isChunked;
        this.isChunked = RepositoryId.isChunkedEncoding(n);
        java.lang.Object object = null;
        String string2 = null;
        if (RepositoryId.isCodeBasePresent(n)) {
            string2 = this.read_codebase_URL();
        }
        switch (RepositoryId.getTypeInfo(n)) {
            case 0: {
                if (clazz != null) {
                    this.repositoryIDString = string;
                    break;
                }
                throw new MARSHAL("Missing repId in RMI valuetype encoding", 1229125784, CompletionStatus.COMPLETED_NO);
            }
            case 2: {
                this.repositoryIDString = this.read_repositoryId();
                break;
            }
            case 6: {
                this.repositoryIDString = this.read_repositoryIds();
                break;
            }
            default: {
                throw new MARSHAL("Undefined type information value in value_tag", 1229125785, CompletionStatus.COMPLETED_NO);
            }
        }
        this.start_block();
        if (this.useOldNestingDepths()) {
            --this.end_flag;
        } else if (this.isChunked) {
            --this.end_flag;
        }
        if (this.repositoryIDString.equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
            object = this.read_wstring();
        } else if (this.repositoryIDString.equals(RepositoryId.kClassDescValueRepID)) {
            object = this.readClass(n2);
        } else {
            block29: {
                RepositoryId repositoryId = RepositoryId.get(this.repositoryIDString);
                this.valueClass = clazz;
                if (repositoryId.isProxy()) {
                    try {
                        this.valueClass = this.loadProxyClass(this.repositoryIDString);
                    }
                    catch (Exception exception) {
                        this.valueClass = null;
                        if (exception instanceof ClassNotFoundException) {
                            this.classNotFound = (ClassNotFoundException)exception;
                        }
                        if (Trc.enabled()) {
                            Trc.info(exception, CLASS, "fast_read_value:2047");
                        }
                        break block29;
                    }
                }
                if (this.valueClass == null && repositoryId.isIDLType()) {
                    object = this.readFactoryValue(n2, this.repositoryIDString, this.valueClass, string2);
                } else if (this.valueClass == null || !string.equals(this.repositoryIDString)) {
                    try {
                        this.valueClass = repositoryId.getClassFromType(this.valueClass, string2, this.streamClassLoader, this);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.classNotFound = classNotFoundException;
                        if (!Trc.enabled()) break block29;
                        Trc.info(classNotFoundException, CLASS, "fast_read_value:2071");
                    }
                }
            }
            if (this.valueClass != null && IDLEntity.class.isAssignableFrom(this.valueClass)) {
                object = this.readIDLValue(n2, this.repositoryIDString, this.valueClass, string2);
                this.classNotFound = null;
            } else {
                return PENDING_READ;
            }
        }
        this.addToValueCache(object);
        this.post_fast_read_value2(bl);
        return (Serializable)object;
    }

    private void skipToEndOfValue() {
        int n;
        if (this.blockLength != 0x7FFFFF00L) {
            this.skipToEndOfChunk();
        }
        while (true) {
            n = this.mark();
            int n2 = this.read_long();
            if (n2 < 0 && n2 >= this.end_flag) break;
            if (n2 < this.end_flag) continue;
            if (n2 >= 0x7FFFFF00) {
                if (RepositoryId.isCodeBasePresent(n2)) {
                    this.read_codebase_URL();
                }
                switch (RepositoryId.getTypeInfo(n2)) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        this.read_repositoryId();
                        break;
                    }
                    case 6: {
                        this.read_repositoryIds();
                        break;
                    }
                    default: {
                        throw new MARSHAL("Undefined type information value in value_tag 0x" + Integer.toHexString(n2));
                    }
                }
                this.start_block();
                this.skipToEndOfChunk();
                continue;
            }
            this.reset(n);
            this.start_block();
            this.skipToEndOfChunk();
        }
        this.reset(n);
    }

    private void skipToEndOfChunk() {
        int n = (int)(this.blockLength - (long)this.index);
        if (n <= 0) {
            return;
        }
        if (n < this.size - this.index) {
            this.index += n;
        } else {
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; i += n2) {
                n2 = this.size - this.index;
                n3 = n - i;
                n2 = n2 > n3 ? n3 : this.alignAndCheck(1, n3);
                this.index += n2;
            }
        }
    }

    public Serializable read_value(Class clazz) {
        Serializable serializable;
        if (Trc.enabled()) {
            Trc.begin1(clazz, CLASS, "read_value:2173");
        }
        if ((serializable = this.fast_read_value(clazz)) == PENDING_READ) {
            int n = this.valueIndirection;
            boolean bl = this.prevIsChunked;
            boolean bl2 = false;
            if (this.valueHandler == null) {
                bl2 = true;
                this.valueHandler = ValueHandlerPool.getValueHandler();
            }
            try {
                serializable = this.valueHandler.readValue((org.omg.CORBA.portable.InputStream)this, n, this.valueClass, this.repositoryIDString, null);
            }
            catch (CancelRequestException cancelRequestException) {
                throw cancelRequestException;
            }
            catch (NO_IMPLEMENT nO_IMPLEMENT) {
                Trc.ffdc((Exception)((java.lang.Object)nO_IMPLEMENT), CLASS, "read_value:2196");
                if (this.classNotFound != null) {
                    nO_IMPLEMENT.initCause((Throwable)this.classNotFound);
                    this.classNotFound = null;
                }
                throw nO_IMPLEMENT;
            }
            catch (Exception exception) {
                Trc.ffdc(exception, CLASS, "read_value:2203");
                MARSHAL mARSHAL = new MARSHAL("Unable to read value from underlying bridge : " + exception.getMessage(), 1229125786, CompletionStatus.COMPLETED_NO);
                mARSHAL.initCause((Throwable)exception);
                throw mARSHAL;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Trc.ffdc(outOfMemoryError.toString(), CLASS, "read_value:2211");
                NO_MEMORY nO_MEMORY = new NO_MEMORY("Unable to read value from underlying bridge : " + outOfMemoryError.getMessage(), 1229126018, CompletionStatus.COMPLETED_NO);
                nO_MEMORY.initCause((Throwable)outOfMemoryError);
                throw nO_MEMORY;
            }
            catch (Error error) {
                Trc.ffdc(error.toString(), CLASS, "read_value:2219");
                MARSHAL mARSHAL = new MARSHAL("Unable to read value from underlying bridge : " + error.getMessage(), 1229125787, CompletionStatus.COMPLETED_NO);
                mARSHAL.initCause((Throwable)error);
                throw error;
            }
            finally {
                if (bl2) {
                    ValueHandlerPool.returnValueHandler(this.valueHandler);
                    this.valueHandler = null;
                }
            }
            this.valueIndirection = n;
            this.addToValueCache(serializable);
            this.post_fast_read_value(bl);
        }
        if (serializable != null && clazz != null && !clazz.isAssignableFrom(serializable.getClass())) {
            String string = "returning " + serializable.getClass().getName() + ", CL:" + serializable.getClass().getClassLoader() + " is not assignable to:" + clazz.getName() + ", CL:" + clazz.getClassLoader();
            Trc.ffdc(string, CLASS, "read_value:2248");
        }
        if (Trc.enabled()) {
            Trc.complete(serializable == null ? null : serializable.getClass().getName(), CLASS, "read_value:2254");
        }
        return serializable;
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        int n;
        int n2 = this.readValueTag();
        if (n2 == 0) {
            return null;
        }
        int n3 = this.get_offset();
        if (n2 == -1) {
            return this.readIndirection(n3);
        }
        this.valueIndirection = n3 -= 4;
        boolean bl = this.isChunked;
        this.isChunked = RepositoryId.isChunkedEncoding(n2);
        Serializable serializable = null;
        String string = null;
        if (RepositoryId.isCodeBasePresent(n2)) {
            string = this.read_codebase_URL();
        }
        if ((n = RepositoryId.getTypeInfo(n2)) != 0) {
            String string2 = null;
            switch (n) {
                case 2: {
                    string2 = this.read_repositoryId();
                    break;
                }
                case 6: {
                    string2 = this.read_repositoryIds();
                    break;
                }
                default: {
                    throw new MARSHAL("Undefined type information value in value_tag 0x" + Integer.toHexString(n2), 1229125788, CompletionStatus.COMPLETED_NO);
                }
            }
            if (!string2.equals(boxedValueHelper.get_id())) {
                boxedValueHelper = Utility.getHelper(null, string, string2);
            }
        }
        this.start_block();
        if (this.useOldNestingDepths()) {
            --this.end_flag;
        } else if (this.isChunked) {
            --this.end_flag;
        }
        serializable = boxedValueHelper.read_value((org.omg.CORBA.portable.InputStream)this);
        this.addToValueCache(serializable);
        this.post_fast_read_value2(bl);
        return serializable;
    }

    public Serializable read_value(Serializable serializable) {
        this.addToValueCache(serializable);
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._read((org.omg.CORBA.portable.InputStream)this);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).unmarshal((DataInputStream)this);
        }
        return serializable;
    }

    public Serializable read_value(String string) {
        int n;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "read_value:2356", (java.lang.Object)string);
        }
        if ((n = this.readValueTag()) == 0) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exit(4100L, this, "read_value:2364", (java.lang.Object)string);
            }
            return null;
        }
        int n2 = this.get_offset();
        if (n == -1) {
            Serializable serializable = this.readIndirection(n2);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exit(4100L, this, "read_value:2374", (java.lang.Object)string);
            }
            return serializable;
        }
        this.valueIndirection = n2 -= 4;
        boolean bl = this.isChunked;
        this.isChunked = RepositoryId.isChunkedEncoding(n);
        java.lang.Object object = null;
        String string2 = null;
        if (RepositoryId.isCodeBasePresent(n)) {
            string2 = this.read_codebase_URL();
        }
        String string3 = null;
        switch (RepositoryId.getTypeInfo(n)) {
            case 0: {
                string3 = string;
                break;
            }
            case 2: {
                string3 = this.read_repositoryId();
                break;
            }
            case 6: {
                string3 = this.read_repositoryIds();
                break;
            }
            default: {
                throw new MARSHAL("Undefined type information value in value_tag0x" + Integer.toHexString(n), 1229125781, CompletionStatus.COMPLETED_NO);
            }
        }
        this.start_block();
        if (this.useOldNestingDepths()) {
            --this.end_flag;
        } else if (this.isChunked) {
            --this.end_flag;
        }
        object = this.readFactoryValue(n2, string3, null, string2);
        this.addToValueCache(object);
        this.post_fast_read_value2(bl);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "read_value:2430", (java.lang.Object)string);
        }
        return (Serializable)object;
    }

    private Class readClass(int n) {
        Class clazz = Utility.readClassValue(this);
        this.valueIndirection = n;
        return clazz;
    }

    private java.lang.Object readFactoryValue(int n, String string, Class clazz, String string2) {
        ValueFactory valueFactory = Utility.getFactory(clazz, string2, this.orb, string);
        Serializable serializable = valueFactory.read_value((InputStream)this);
        this.valueIndirection = n;
        return serializable;
    }

    private java.lang.Object readBoxedIDLEntity(Class clazz, String string) {
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            final Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string, classLoader, clazz, classLoader);
            Method method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws NoSuchMethodException {
                    return clazz2.getMethod(CDRInputStream.kReadMethod, argTypes);
                }
            });
            java.lang.Object[] objectArray = new java.lang.Object[]{this};
            return method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trc.ffdc(classNotFoundException, CLASS, "readBoxedIDLEntity:2482");
            MARSHAL mARSHAL = new MARSHAL(classNotFoundException.getMessage(), 1229125790, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)classNotFoundException);
            throw mARSHAL;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            Trc.ffdc(exception, CLASS, "readBoxedIDLEntity:2490");
            MARSHAL mARSHAL = new MARSHAL(exception.getMessage(), 1229125791, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)exception);
            throw mARSHAL;
        }
        catch (IllegalAccessException illegalAccessException) {
            Trc.ffdc(illegalAccessException, CLASS, "readBoxedIDLEntity:2497");
            MARSHAL mARSHAL = new MARSHAL(illegalAccessException.getMessage(), 1229125792, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)illegalAccessException);
            throw mARSHAL;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof Exception) {
                Trc.ffdc((Exception)throwable, CLASS, "readBoxedIDLEntity:2508");
            } else if (Trc.enabled()) {
                Trc.warn(throwable.getMessage(), CLASS, "readBoxedIDLEntity:2511");
            }
            MARSHAL mARSHAL = new MARSHAL("InvocationTargetException:" + throwable.getMessage(), 1229125793, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause(throwable);
            throw mARSHAL;
        }
    }

    private java.lang.Object readIDLValue(int n, String string, Class clazz, String string2) {
        if (clazz == null) {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(null, string2, string);
            return boxedValueHelper.read_value((org.omg.CORBA.portable.InputStream)this);
        }
        if (StreamableValue.class.isAssignableFrom(clazz) || CustomValue.class.isAssignableFrom(clazz)) {
            return this.readFactoryValue(n, string, clazz, string2);
        }
        if (ValueBase.class.isAssignableFrom(clazz)) {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(clazz, string2, string);
            return boxedValueHelper.read_value((org.omg.CORBA.portable.InputStream)this);
        }
        return this.readBoxedIDLEntity(clazz, string2);
    }

    private Serializable readIndirection(int n) {
        Serializable serializable = (Serializable)this.valueCache.get(n += this.read_long());
        if (null == serializable) {
            throw new FastIndirectionException(n);
        }
        return serializable;
    }

    private void readEndTag() {
        if (this.isChunked) {
            int n = this.mark();
            int n2 = this.read_long();
            if (n2 != this.end_flag) {
                this.reset(n);
            }
            if (!this.useOldNestingDepths()) {
                ++this.end_flag;
            }
        }
        if (this.useOldNestingDepths()) {
            ++this.end_flag;
        }
    }

    public int get_offset() {
        return this.index - this.start + this.offset;
    }

    public void start_value() {
        int n = this.readValueTag();
        if (n == 0) {
            this.customStreamEnd = true;
        } else {
            if (!RepositoryId.isChunkedEncoding(n) || RepositoryId.getTypeInfo(n) != 2 || RepositoryId.isCodeBasePresent(n)) {
                throw new MARSHAL("Invalid start_value valuetag: " + Integer.toHexString(n), 1229125867, CompletionStatus.COMPLETED_MAYBE);
            }
            if (!this.isChunked) {
                throw new MARSHAL("start_value called outside of chunked encoding", 1229125868, CompletionStatus.COMPLETED_MAYBE);
            }
            this.read_repositoryId();
            this.start_block();
            --this.end_flag;
            if (this.customStreamStack == null) {
                this.customStreamStack = new Stack();
            }
            this.customStreamStack.push(new Integer(this.customStreamLevel));
            this.customStreamLevel = this.end_flag;
        }
    }

    public void end_value() {
        if (this.customStreamEnd) {
            this.customStreamEnd = false;
        } else {
            this.customStreamLevel = (Integer)this.customStreamStack.pop();
            this.skipToEndOfValue();
            this.end_block();
            this.readEndTag();
            this.start_block();
        }
    }

    private void start_block() {
        if (!this.isChunked) {
            return;
        }
        this.blockLength = 0x7FFFFF00L;
        this.blockLength = this.read_long();
        if (this.blockLength > 0L && this.blockLength < 0x7FFFFF00L) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "start_block:2651", "start block index_hex " + Integer.toHexString(this.get_offset()) + " blocklength_hex " + Long.toHexString(this.blockLength));
            }
            this.blockLength += (long)this.index;
        } else {
            this.blockLength = 0x7FFFFF00L;
            this.index -= 4;
        }
    }

    private void end_block() {
        if (this.blockLength != 0x7FFFFF00L) {
            if (this.blockLength == (long)this.index) {
                this.blockLength = 0x7FFFFF00L;
            } else {
                throw new MARSHAL("Incorrect chunk length " + this.blockLength + " at offset " + this.index, 1229125854, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public int readValueTag() {
        int n = this.read_long();
        if (n != -1 && ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "readValueTag:2684", "read value tag " + Integer.toHexString(n) + " index_hex " + Integer.toHexString(this.get_offset() - 4));
        }
        return n;
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    private Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        if (this instanceof IIOPInputStream) {
            this.connection = ((IIOPInputStream)this).getConnection();
        }
        return this.connection;
    }

    public CodeBase getFVDCodeBase() {
        block5: {
            if (this.cbDelegate == null) {
                Connection connection = this.getConnection();
                try {
                    this.codeBaseServerIOR = connection != null ? connection.getCodeBaseRef() : this.getCodeBaseRef();
                    if (this.codeBaseServerIOR != null) {
                        this.cbDelegate = connection != null ? (FVDCodeBaseDelegate)connection.getFVDCodeBase() : FVDCodeBaseDelegate.createFVDCodeBaseDelegate(this.orb, this.codeBaseServerIOR);
                        break block5;
                    }
                    if (this.runTimeCodeBase != null) {
                        return this.runTimeCodeBase;
                    }
                    this.runTimeCodeBase = (CodeBase)this.valueHandler.getRunTimeCodeBase();
                    return this.runTimeCodeBase;
                }
                catch (ClassCastException classCastException) {
                    ORBRas.orbTrcLogger.exception(4104L, CLASS, "getFVDCodeBase:2751", (Exception)classCastException);
                    return null;
                }
            }
        }
        return this.cbDelegate;
    }

    private int getTcsC() {
        if (this.tcsChar != 0) {
            return this.tcsChar;
        }
        Connection connection = this.getConnection();
        this.tcsChar = connection != null ? connection.getCharCodeSet() : 65537;
        return this.tcsChar;
    }

    private int getTcsW() {
        if (this.tcsWChar != 0) {
            return this.tcsWChar;
        }
        Connection connection = this.getConnection();
        if (connection != null) {
            this.tcsWChar = connection.getWCharCodeSet();
            if (this.tcsWChar == 0 && ((ORB)this.orb).getWCharDefault() != 0) {
                this.tcsWChar = ((ORB)this.orb).getWCharDefault();
            }
        } else {
            if (this.orb instanceof ORB) {
                this.tcsWChar = ((ORB)this.orb).getWCharDefault();
            }
            if (this.tcsWChar == 0) {
                this.tcsWChar = 65792;
            }
        }
        if (this.tcsWChar == 0 && PartnerVersionUtil.noWCharCodeset(this.getPartnerMajor(), this.getPartnerMinor())) {
            this.tcsWChar = 65792;
        }
        return this.tcsWChar;
    }

    private TcsToCharConverter getTcsCConverter() {
        if (this.tcsCConverter == null) {
            int n = this.getTcsC();
            if (n == 0) {
                n = 65537;
            }
            this.tcsCConverter = TcsToCharConverter.getConverter(n);
            if (!this.tcsCConverter.isByteOriented()) {
                throw new INTERNAL("non-byte-oriented char code set " + n + " specified", 1229125043, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.tcsCConverter;
    }

    private TcsToCharConverter getTcsWConverter() {
        if (this.tcsWConverter == null) {
            int n = this.getTcsW();
            if (n == 0) {
                throw new BAD_PARAM("wchar transmission code not set in service context - Tcs wchar", 1330446359, CompletionStatus.COMPLETED_NO);
            }
            this.tcsWConverter = TcsToCharConverter.getConverter(n);
            if (this.tcsWConverter.isByteOriented()) {
                throw new INTERNAL("byte-oriented wchar code set " + n + " specified", 1229125045, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.tcsWConverter;
    }

    public final void read_boolean_array(boolean[] blArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            blArray[i + n] = this.read_boolean();
        }
    }

    public final void read_char_array(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[i + n] = this.read_char();
        }
    }

    public final void read_wchar_array(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[i + n] = this.read_wchar();
        }
    }

    public final void read_short_array(short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            sArray[i + n] = this.read_short();
        }
    }

    public final void read_ushort_array(short[] sArray, int n, int n2) {
        this.read_short_array(sArray, n, n2);
    }

    public final void read_long_array(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[i + n] = this.read_long();
        }
    }

    public final void read_ulong_array(int[] nArray, int n, int n2) {
        this.read_long_array(nArray, n, n2);
    }

    public final void read_longlong_array(long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            lArray[i + n] = this.read_longlong();
        }
    }

    public final void read_ulonglong_array(long[] lArray, int n, int n2) {
        this.read_longlong_array(lArray, n, n2);
    }

    public final void read_float_array(float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[i + n] = this.read_float();
        }
    }

    public final void read_double_array(double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            dArray[i + n] = this.read_double();
        }
    }

    public final void read_any_array(Any[] anyArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            anyArray[i + n] = this.read_any();
        }
    }

    public final void rewind() {
        this.offset += this.index;
        this.index = this.start;
    }

    public final boolean isAtEnd() {
        return this.index == this.size;
    }

    public int available() throws IOException {
        return this.size - this.index;
    }

    public int mark() {
        return this.index;
    }

    public void reset(int n) {
        this.index = n;
    }

    private Class loadProxyClass(String string) throws ClassNotFoundException, IOException {
        boolean bl = false;
        if (this.valueHandler == null) {
            bl = true;
            this.valueHandler = ValueHandlerPool.getValueHandler();
        }
        CodeBase codeBase = this.getFVDCodeBase();
        if (bl) {
            ValueHandlerPool.returnValueHandler(this.valueHandler);
            this.valueHandler = null;
        }
        if (codeBase == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, CLASS, "loadProxyClass:2959", "No sending context");
            }
            throw new IOException("No sending context");
        }
        FullValueDescription fullValueDescription = codeBase.meta(string);
        Class[] classArray = null;
        if (fullValueDescription.supported_interfaces != null) {
            classArray = new Class[fullValueDescription.supported_interfaces.length];
            for (int i = 0; i < fullValueDescription.supported_interfaces.length; ++i) {
                RepositoryId repositoryId = RepositoryId.get(fullValueDescription.supported_interfaces[i]);
                classArray[i] = this.streamClassLoader != null ? repositoryId.getClassFromType(null, this.streamClassLoader) : repositoryId.getClassFromType();
            }
            Class<?> clazz = null;
            clazz = this.streamClassLoader != null ? Proxy.getProxyClass(this.streamClassLoader, classArray) : Proxy.getProxyClass(Thread.currentThread().getContextClassLoader(), classArray);
            return clazz;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, CLASS, "loadProxyClass:2993", "No Interfaces available for the class");
        }
        return null;
    }

    private String read_repositoryIds() {
        int n = this.read_long();
        if (n == -1) {
            int n2 = this.get_offset() + this.read_long();
            try {
                return (String)this.repositoryIdStore.get(n2);
            }
            catch (Store.NoSuchElementException noSuchElementException) {
                throw new MARSHAL("Unable to locate array of repository IDs from indirection " + n2, 1229125794, CompletionStatus.COMPLETED_NO);
            }
        }
        int n3 = this.get_offset() - 4;
        String string = this.read_repositoryId();
        this.repositoryIdStore.add(n3, string);
        for (int i = 1; i < n; ++i) {
            this.read_repositoryId();
        }
        return string;
    }

    private final String read_repositoryId() {
        String string = this.readRepIdOrIndirection();
        if (string == null) {
            int n = this.get_offset() + this.read_long();
            try {
                return (String)this.repositoryIdStore.get(n);
            }
            catch (Store.NoSuchElementException noSuchElementException) {
                throw new MARSHAL("RepID indirection @ " + (this.index - this.start), 1229125795, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        this.repositoryIdStore.add(this.stringIndirection, string);
        return string;
    }

    private final String read_codebase_URL() {
        String string = this.readStringOrIndirection(true);
        if (string == null) {
            int n = this.get_offset() + this.read_long();
            try {
                return (String)this.codebaseStore.get(n);
            }
            catch (Store.NoSuchElementException noSuchElementException) {
                throw new MARSHAL("Codebase indirection @ " + (this.index - this.start), 1229125796, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        this.codebaseStore.add(this.stringIndirection, string);
        return string;
    }

    public java.lang.Object read_Abstract() {
        return this.read_abstract_interface();
    }

    public Serializable read_Value() {
        return this.read_value();
    }

    public void read_any_array(AnySeqHolder anySeqHolder, int n, int n2) {
        this.read_any_array(anySeqHolder.value, n, n2);
    }

    public void read_boolean_array(BooleanSeqHolder booleanSeqHolder, int n, int n2) {
        this.read_boolean_array(booleanSeqHolder.value, n, n2);
    }

    public void read_char_array(CharSeqHolder charSeqHolder, int n, int n2) {
        this.read_char_array(charSeqHolder.value, n, n2);
    }

    public void read_wchar_array(WCharSeqHolder wCharSeqHolder, int n, int n2) {
        this.read_wchar_array(wCharSeqHolder.value, n, n2);
    }

    public void read_octet_array(OctetSeqHolder octetSeqHolder, int n, int n2) {
        this.read_octet_array(octetSeqHolder.value, n, n2);
    }

    public void read_short_array(ShortSeqHolder shortSeqHolder, int n, int n2) {
        this.read_short_array(shortSeqHolder.value, n, n2);
    }

    public void read_ushort_array(UShortSeqHolder uShortSeqHolder, int n, int n2) {
        this.read_ushort_array(uShortSeqHolder.value, n, n2);
    }

    public void read_long_array(LongSeqHolder longSeqHolder, int n, int n2) {
        this.read_long_array(longSeqHolder.value, n, n2);
    }

    public void read_ulong_array(ULongSeqHolder uLongSeqHolder, int n, int n2) {
        this.read_ulong_array(uLongSeqHolder.value, n, n2);
    }

    public void read_ulonglong_array(ULongLongSeqHolder uLongLongSeqHolder, int n, int n2) {
        this.read_ulonglong_array(uLongLongSeqHolder.value, n, n2);
    }

    public void read_longlong_array(LongLongSeqHolder longLongSeqHolder, int n, int n2) {
        this.read_longlong_array(longLongSeqHolder.value, n, n2);
    }

    public void read_float_array(FloatSeqHolder floatSeqHolder, int n, int n2) {
        this.read_float_array(floatSeqHolder.value, n, n2);
    }

    public void read_double_array(DoubleSeqHolder doubleSeqHolder, int n, int n2) {
        this.read_double_array(doubleSeqHolder.value, n, n2);
    }

    public String[] _truncatable_ids() {
        return _ids;
    }

    public void printBuffer() {
        for (int i = 0; i < this.size; i += 16) {
            int n = 0;
            for (int j = 0; j < 16; ++j) {
                String string;
                int n2;
                if (i + j >= this.size) {
                    n2 = 0;
                } else {
                    n2 = this.buf[i + j];
                    ++n;
                }
                if (n2 < 0) {
                    n2 = 256 + n2;
                }
                if ((string = Integer.toHexString(n2)).length() == 1) {
                    string = "0" + string;
                }
                System.out.print(string + " ");
            }
            System.out.println(new String(this.buf, i, n));
        }
    }

    protected boolean useOldNestingDepths() {
        if (!this.haveCheckedOldNestingDepths) {
            short s = this.getPartnerMajor();
            short s2 = this.getPartnerMinor();
            this.useOldNestingDepths = PartnerVersionUtil.useOldNestingDepths(s, s2);
            this.haveCheckedOldNestingDepths = true;
        }
        return this.useOldNestingDepths;
    }

    public int getSize() {
        return this.size - this.index;
    }

    public void close() throws IOException {
        this.typeStore = null;
        this.tcsCConverter = null;
        this.tcsWConverter = null;
        this.valueCache = null;
        this.buf = null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NotSerializableException notSerializableException = new NotSerializableException(this.getClass().getName());
        Trc.ffdc(notSerializableException, CLASS, "writeObject:3201");
        throw notSerializableException;
    }

    private static final class PendingReadMarker
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private PendingReadMarker() {
        }
    }

    private static final class InterfaceClassToStubClassInfoCache {
        private static final Map map = new WeakHashMap();
        private static final ReferenceQueue queue = new ReferenceQueue();

        private InterfaceClassToStubClassInfoCache() {
        }

        private static void processQueue() {
            Value value = (Value)((java.lang.Object)queue.poll());
            while (value != null) {
                value.remove(map, ((Reference)value.getKey()).get());
                value = (Value)((java.lang.Object)queue.poll());
            }
        }

        static synchronized Object createNewObjRef(Class clazz, IOR iOR, String string, String string2, CDRInputStream cDRInputStream) {
            Class<?> clazz2;
            ClassInfo classInfo;
            DataValueListEntry dataValueListEntry;
            ClassLoader classLoader = cDRInputStream.streamClassLoader;
            DataValueListEntry dataValueListEntry2 = (DataValueListEntry)map.get(clazz);
            ClassInfo classInfo2 = null;
            for (dataValueListEntry = dataValueListEntry2; dataValueListEntry != null; dataValueListEntry = dataValueListEntry.getNext()) {
                classInfo = (ClassInfo)dataValueListEntry.getData();
                if (!classInfo.matches(null, string, string2, classLoader)) continue;
                classInfo2 = classInfo;
                break;
            }
            classInfo = null;
            if (classInfo2 != null && (clazz2 = classInfo2.getActualClass()) != null) {
                classInfo = cDRInputStream.newObjRef(iOR, clazz2, clazz);
            }
            InterfaceClassToStubClassInfoCache.processQueue();
            if (classInfo == null && (classInfo = cDRInputStream.newObjRef(iOR, null, clazz)) != null) {
                clazz2 = classInfo.getClass();
                classInfo2 = new ClassInfo(clazz2, null, string, string2, classLoader);
                Reference reference = null == dataValueListEntry2 ? new WeakReference<Class>(clazz) : (Reference)dataValueListEntry2.getKey();
                Class<?> clazz3 = clazz2;
                DataValueListEntry dataValueListEntry3 = (DataValueListEntry)map.get(clazz);
                dataValueListEntry = new WeakDataValueListEntry(reference, classInfo2, dataValueListEntry3, clazz3, queue);
                map.put(clazz, dataValueListEntry);
            }
            return classInfo;
        }
    }
}

