/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.iiop.CharToTcsAscii;
import com.ibm.rmi.iiop.CharToTcsLatin1;
import com.ibm.rmi.iiop.CharToTcsUnicode;
import com.ibm.rmi.iiop.CodeSetMapping;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import sun.io.CharToByteConverter;

public class CharToTcsConverter {
    protected boolean byteOriented;
    protected int osfId;
    protected CharToByteConverter sunConverter;

    public CharToTcsConverter(int n) {
        this.osfId = n;
        this.byteOriented = true;
        this.sunConverter = null;
    }

    public boolean isByteOriented() {
        return this.byteOriented;
    }

    public byte[] convertToByte(char[] cArray) {
        if (this.sunConverter == null) {
            this.getSunConverter();
        }
        try {
            int n = cArray.length * this.sunConverter.getMaxBytesPerChar();
            byte[] byArray = new byte[n];
            int n2 = 0;
            this.sunConverter.reset();
            n2 += this.sunConverter.convert(cArray, 0, cArray.length, byArray, 0, n);
            if ((n2 += this.sunConverter.flush(byArray, this.sunConverter.nextByteIndex(), n)) < n) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                return byArray2;
            }
            return byArray;
        }
        catch (CharConversionException charConversionException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "convertToByte:115", (Exception)charConversionException);
            throw new DATA_CONVERSION("character not mapped to negotiated transimission code set (7)", 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    public char[] convertToChar(char[] cArray, boolean bl) {
        return null;
    }

    private synchronized void getSunConverter() {
        if (this.sunConverter == null) {
            final String string = CodeSetMapping.mapToJavaEncoding(this.osfId);
            this.sunConverter = (CharToByteConverter)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return CharToByteConverter.getConverter((String)string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        ORBRas.orbTrcLogger.exception(4104L, this, "getSunConverter:146", (Exception)unsupportedEncodingException);
                        throw new DATA_CONVERSION("no character converter", 1229125848, CompletionStatus.COMPLETED_NO);
                    }
                }
            });
            this.sunConverter.setSubstitutionMode(false);
        }
    }

    public static CharToTcsConverter getConverter(int n) {
        CharToTcsConverter charToTcsConverter;
        switch (n) {
            case 65537: 
            case 65568: {
                charToTcsConverter = new CharToTcsLatin1(n);
                break;
            }
            case 65551: 
            case 268567780: {
                charToTcsConverter = new CharToTcsAscii(n, '\u007f');
                break;
            }
            case 65792: 
            case 65801: {
                charToTcsConverter = new CharToTcsUnicode(n);
                break;
            }
            default: {
                charToTcsConverter = new CharToTcsConverter(n);
            }
        }
        return charToTcsConverter;
    }

    protected int getMaxBytesPerChar() {
        if (this.sunConverter == null) {
            this.getSunConverter();
        }
        return this.sunConverter.getMaxBytesPerChar();
    }

    public boolean needToSwap(boolean bl) {
        return bl && this.osfId != 65801;
    }
}

