/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.iiop.CharToTcsConverter;
import com.ibm.rmi.iiop.CodeSetMapping;
import com.ibm.rmi.iiop.TcsToCharAscii;
import com.ibm.rmi.iiop.TcsToCharLatin1;
import com.ibm.rmi.iiop.TcsToCharUnicode;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.MARSHAL;
import sun.io.ByteToCharConverter;
import sun.io.MalformedInputException;

public class TcsToCharConverter {
    protected boolean byteOriented;
    protected int osfId;
    protected ByteToCharConverter sunConverter;
    protected int maxBytesPerChar = -1;

    public TcsToCharConverter(int n) {
        this.osfId = n;
        this.byteOriented = true;
        this.sunConverter = null;
    }

    public boolean isByteOriented() {
        return this.byteOriented;
    }

    public char[] convertFromByte(byte[] byArray) {
        if (this.sunConverter == null) {
            this.getSunConverter();
        }
        try {
            int n = byArray.length * this.sunConverter.getMaxCharsPerByte();
            char[] cArray = new char[n];
            int n2 = 0;
            this.sunConverter.reset();
            n2 += this.sunConverter.convert(byArray, 0, byArray.length, cArray, 0, n);
            if ((n2 += this.sunConverter.flush(cArray, this.sunConverter.nextCharIndex(), n)) < n) {
                char[] cArray2 = new char[n2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                return cArray2;
            }
            return cArray;
        }
        catch (MalformedInputException malformedInputException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "convertFromByte:116", (Exception)((Object)malformedInputException));
            throw new MARSHAL("character malformed", 1229125849, CompletionStatus.COMPLETED_NO);
        }
        catch (CharConversionException charConversionException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "convertFromByte:123", (Exception)charConversionException);
            throw new DATA_CONVERSION("character not mapped to negotiated transimission code set (7)", 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    public char[] convertFromChar(char[] cArray, boolean bl) {
        return null;
    }

    private synchronized void getSunConverter() {
        if (this.sunConverter == null) {
            final String string = CodeSetMapping.mapToJavaEncoding(this.osfId);
            this.sunConverter = (ByteToCharConverter)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return ByteToCharConverter.getConverter((String)string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        ORBRas.orbTrcLogger.exception(4104L, this, "getSunConverter:153", (Exception)unsupportedEncodingException);
                        throw new DATA_CONVERSION("no character converter", 1229125847, CompletionStatus.COMPLETED_NO);
                    }
                }
            });
            this.sunConverter.setSubstitutionMode(false);
        }
    }

    public static TcsToCharConverter getConverter(int n) {
        TcsToCharConverter tcsToCharConverter;
        switch (n) {
            case 65537: 
            case 65568: {
                tcsToCharConverter = new TcsToCharLatin1(n);
                break;
            }
            case 65551: 
            case 268567780: {
                tcsToCharConverter = new TcsToCharAscii(n, '\u007f');
                break;
            }
            case 65792: 
            case 65801: {
                tcsToCharConverter = new TcsToCharUnicode(n);
                break;
            }
            default: {
                tcsToCharConverter = new TcsToCharConverter(n);
            }
        }
        return tcsToCharConverter;
    }

    protected int getMaxBytesPerChar() {
        if (this.maxBytesPerChar == -1) {
            CharToTcsConverter charToTcsConverter = CharToTcsConverter.getConverter(this.osfId);
            this.maxBytesPerChar = charToTcsConverter.getMaxBytesPerChar();
        }
        return this.maxBytesPerChar;
    }

    public boolean needToSwap(boolean bl) {
        return bl && this.osfId != 65801;
    }
}

