/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.iiop.IOOutputStream;
import com.ibm.CORBA.iiop.PartnerVersion;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.ObjectStreamField;
import com.ibm.rmi.io.OutputStreamHook;
import com.ibm.rmi.io.ReflectField;
import com.ibm.rmi.io.ValueHandlerImpl;
import com.ibm.rmi.util.Interop;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Utility;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.ValueOutputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import sun.util.calendar.ZoneInfo;

public class IIOPOutputStream
extends OutputStreamHook
implements IOOutputStream {
    public static boolean usePortableInterface = false;
    private static final int ENCLOSE_NONE = 0;
    private static final int ENCLOSE_START = 1;
    private static final int ENCLOSE_END = 2;
    private final Object[] writeObjectArglist = new Object[]{this};
    private final PendingWriteStack pendingWriteStack = new PendingWriteStack();
    private OutputStream orbStream;
    private CDROutputStream orbStream2;
    private ValueOutputStream vStream;
    private PartnerVersion pv = PartnerVersion.UNKNOWN;
    private byte formatVersion = 1;
    private Object currentObject = null;
    private ObjectStreamClass currentClassDesc = null;
    private int index = -1;
    private boolean writeObjectStart = false;
    private int currentEnclose = 0;
    private Interop interop = Interop.NO_IBM_ORB;

    public final void setOrbStream(OutputStream outputStream) {
        this.orbStream = outputStream;
        PartnerVersion partnerVersion = this.pv = outputStream instanceof PartnerVersion ? (PartnerVersion)outputStream : PartnerVersion.UNKNOWN;
        if (outputStream instanceof CDROutputStream) {
            this.orbStream2 = (CDROutputStream)outputStream;
            this.vStream = (ValueOutputStream)outputStream;
            this.interop = this.orbStream2.interop;
        } else if (outputStream instanceof ValueOutputStream) {
            this.vStream = (ValueOutputStream)outputStream;
        }
        if (usePortableInterface) {
            this.orbStream2 = null;
            this.pv = PartnerVersion.UNKNOWN;
        }
    }

    public final void setFormatVersion(byte by) {
        this.formatVersion = by;
        if (by > 2) {
            throw new BAD_PARAM("Requested stream format not supported", 1330446375, CompletionStatus.COMPLETED_MAYBE);
        }
        if (by > 1 && this.vStream == null) {
            throw new BAD_PARAM("ORB stream does not support format version", 1330446376, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public final void writeObjectDelegate(Object object) throws IOException {
        this.startEnclosure();
        int n = this.currentEnclose;
        this.currentEnclose = 0;
        if (this.orbStream2 == null) {
            Util.writeAbstractObject((org.omg.CORBA.portable.OutputStream)this.orbStream, (Object)object);
        } else {
            Object object2 = this.orbStream2.fast_write_abstract_interface(object = Utility.autoConnect(object, this.orbStream.orb(), false));
            if (object2 == CDROutputStream.PENDING_WRITE) {
                if (!this.pendingWriteStack.isEmpty()) {
                    this.pendingWriteStack.addRecursionBreak();
                }
                boolean bl = this.orbStream2.getPrevMustChunk();
                object = this.orbStream2.getCurrentObject();
                this.simpleWriteObjectLoop(object);
                this.orbStream2.post_fast_write_value(bl);
            }
        }
        this.currentEnclose = n;
    }

    public final void writeObjectOverride(Object object) throws IOException {
        this.writeObjectDelegate(object);
    }

    private Object writeArray(Object object, Class clazz) throws IOException {
        if (clazz.isPrimitive()) {
            this.writePrimArray(object, clazz);
            return null;
        }
        Object[] objectArray = (Object[])object;
        int n = objectArray.length;
        this.orbStream.write_ulong(n);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz, this.pv.getPartnerMajor(), this.pv.getPartnerMinor());
        return this.writeArray(objectArray, objectStreamClass, 0);
    }

    private Object writeArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) {
        if (objectStreamClass.isValueType(this.orbStream2)) {
            return this.writeValueArray(objectArray, objectStreamClass, n);
        }
        if (objectStreamClass.isRemoteInterface()) {
            return this.writeRemoteInterfaceArray(objectArray, n);
        }
        if (objectStreamClass.isAny()) {
            return this.writeObjectArray(objectArray, objectStreamClass, n);
        }
        if (objectStreamClass.isAbstractInterface(this.orbStream2)) {
            return this.writeAbstractInterfaceArray(objectArray, objectStreamClass, n);
        }
        throw new MARSHAL("Unknown array type " + objectStreamClass.forClass().getName(), 1229125817, CompletionStatus.COMPLETED_NO);
    }

    private Object writeValueArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) {
        for (int i = n; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if ((object = this.writeValueType(object)) != CDROutputStream.PENDING_WRITE) continue;
            boolean bl = this.orbStream2.getPrevMustChunk();
            this.pendingWriteStack.addResumeArray(objectArray, objectStreamClass, i, bl);
            object = this.orbStream2.getCurrentObject();
            return object;
        }
        return null;
    }

    private Object writeAbstractInterfaceArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) {
        for (int i = n; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Object object2 = this.writeAbstractInterface(object);
            if (object2 != CDROutputStream.PENDING_WRITE) continue;
            boolean bl = this.orbStream2.getPrevMustChunk();
            this.pendingWriteStack.addResumeArray(objectArray, objectStreamClass, i, bl);
            object = this.orbStream2.getCurrentObject();
            return object;
        }
        return null;
    }

    private Object writeRemoteInterfaceArray(Object[] objectArray, int n) {
        for (int i = n; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Util.writeRemoteObject((org.omg.CORBA.portable.OutputStream)this.orbStream, (Object)object);
        }
        return null;
    }

    private Object writeObjectArray(Object[] objectArray, ObjectStreamClass objectStreamClass, int n) {
        for (int i = n; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (this.orbStream2 == null) {
                Util.writeAny((org.omg.CORBA.portable.OutputStream)this.orbStream, (Object)object);
                continue;
            }
            Object object2 = this.orbStream2.fast_writeAnyOpt(object);
            if (object2 != CDROutputStream.PENDING_WRITE) continue;
            boolean bl = this.orbStream2.getPrevMustChunk();
            this.pendingWriteStack.addResumeArray(objectArray, objectStreamClass, i, bl);
            object = this.orbStream2.getCurrentObject();
            return object;
        }
        return null;
    }

    private void writePrimArray(Object object, Class clazz) {
        if (clazz == Integer.TYPE) {
            int[] nArray = (int[])object;
            int n = nArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_long_array(nArray, 0, n);
        } else if (clazz == Byte.TYPE) {
            byte[] byArray = (byte[])object;
            int n = byArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_octet_array(byArray, 0, n);
        } else if (clazz == Boolean.TYPE) {
            boolean[] blArray = (boolean[])object;
            int n = blArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_boolean_array(blArray, 0, n);
        } else if (clazz == Long.TYPE) {
            long[] lArray = (long[])object;
            int n = lArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_longlong_array(lArray, 0, n);
        } else if (clazz == Float.TYPE) {
            float[] fArray = (float[])object;
            int n = fArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_float_array(fArray, 0, n);
        } else if (clazz == Double.TYPE) {
            double[] dArray = (double[])object;
            int n = dArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_double_array(dArray, 0, n);
        } else if (clazz == Short.TYPE) {
            short[] sArray = (short[])object;
            int n = sArray.length;
            this.orbStream.write_ulong(n);
            this.orbStream.write_short_array(sArray, 0, n);
        } else {
            if (clazz != Character.TYPE) {
                throw new MARSHAL("Invalid primitive type : " + object.getClass().getName(), 1229125812, CompletionStatus.COMPLETED_NO);
            }
            char[] cArray = (char[])object;
            int n = cArray.length;
            this.orbStream.write_ulong(n);
            if (PartnerVersionUtil.useOldChar(this.pv.getPartnerMajor(), this.pv.getPartnerMinor())) {
                this.orbStream.write_char_array(cArray, 0, n);
            } else {
                this.orbStream.write_wchar_array(cArray, 0, n);
            }
        }
    }

    private void writeExternalizable(Object object) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "writeExternalizable:394", object.getClass());
        }
        int n = this.currentEnclose;
        this.currentEnclose = 0;
        this.writeByte(this.formatVersion);
        Externalizable externalizable = (Externalizable)object;
        externalizable.writeExternal(this);
        this.currentEnclose = n;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "writeExternalizable:409", object.getClass());
        }
    }

    private Object simpleWriteObjectInternal(Object object) throws IOException {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return this.writeArray(object, clazz.getComponentType());
        }
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz, this.pv.getPartnerMajor(), this.pv.getPartnerMinor());
        if (objectStreamClass == null) {
            throw new NotSerializableException(clazz.getName());
        }
        if (objectStreamClass.isExternalizable()) {
            this.writeExternalizable(object);
            return null;
        }
        if (objectStreamClass.isSerializable()) {
            return this.writeSerializable(object, objectStreamClass);
        }
        throw new NotSerializableException(clazz.getName());
    }

    private void simpleWriteObjectLoop(Object object) throws IOException {
        while (true) {
            if (object == null) {
                PendingWrite pendingWrite = this.pendingWriteStack.getNextPendingWrite();
                if (pendingWrite == null || pendingWrite.isRecursionBreak()) {
                    return;
                }
                object = this.continueSimpleWriteObject(pendingWrite);
                continue;
            }
            object = this.simpleWriteObjectInternal(object);
        }
    }

    private Object continueSimpleWriteObject(PendingWrite pendingWrite) throws IOException {
        Object object = pendingWrite.obj;
        ObjectStreamClass objectStreamClass = pendingWrite.classDesc;
        if (pendingWrite.isSubclass()) {
            return this.outputObject(object, objectStreamClass);
        }
        if (pendingWrite.isBeginFields()) {
            return this.outputClassFields(object, objectStreamClass, 0);
        }
        this.orbStream2.post_fast_write_value(pendingWrite.mustChunk);
        if (pendingWrite.isResumeFields()) {
            int n = pendingWrite.index;
            return this.outputClassFields(object, objectStreamClass, ++n);
        }
        if (pendingWrite.isResumeArray()) {
            Object[] objectArray = (Object[])object;
            int n = pendingWrite.index;
            return this.writeArray(objectArray, objectStreamClass, ++n);
        }
        throw new MARSHAL("Unknown PendingWrite type", 1229125827, CompletionStatus.COMPLETED_NO);
    }

    public final void simpleWriteObject(Object object) {
        try {
            if (object instanceof String) {
                this.orbStream.write_wstring((String)object);
                return;
            }
            if (object instanceof Class) {
                Utility.writeClassValue(this.orbStream, (Class)object);
                return;
            }
            if (!this.pendingWriteStack.isEmpty()) {
                this.pendingWriteStack.addRecursionBreak();
            }
            this.simpleWriteObjectLoop(object);
        }
        catch (IOException iOException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "simpleWriteObject:524", (Exception)iOException);
            throw new MARSHAL(iOException.getMessage(), 1229125806, CompletionStatus.COMPLETED_NO);
        }
    }

    public final void defaultWriteObjectDelegate() throws IOException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultWriteObjectDelegate");
        }
        int n = this.currentEnclose;
        this.currentEnclose = 0;
        if (this.writeObjectStart) {
            this.orbStream.write_boolean(true);
            this.writeObjectStart = false;
        }
        if (this.orbStream2 == null) {
            this.outputClassFields(this.currentObject, this.currentClassDesc, 0);
        } else {
            if (!this.pendingWriteStack.isEmpty()) {
                this.pendingWriteStack.addRecursionBreak();
            }
            this.pendingWriteStack.addBeginFields(this.currentObject, this.currentClassDesc);
            this.simpleWriteObjectLoop(null);
        }
        this.currentEnclose = n;
    }

    public final boolean enableReplaceObjectDelegate(boolean bl) {
        return false;
    }

    protected final void annotateClass(Class clazz) throws IOException {
        throw new IOException("Method annotateClass not supported");
    }

    public final void close() throws IOException {
    }

    protected final void drain() throws IOException {
    }

    public final void flush() throws IOException {
        try {
            this.orbStream.flush();
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "flush:603", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    protected final Object replaceObject(Object object) throws IOException {
        throw new IOException("Method replaceObject not supported");
    }

    public final void reset() throws IOException {
        throw new IOException("Method reset not supported");
    }

    public final void write(byte[] byArray) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "write (byte[]):626", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_octet_array(byArray, n, n2);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "write (byte[], int, int):641", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void write(int n) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_octet((byte)(n & 0xFF));
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "write (int):656", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeBoolean(boolean bl) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_boolean(bl);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeBoolean:670", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeByte(int n) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_octet((byte)n);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeByte:685", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeBytes(String string) throws IOException {
        try {
            byte[] byArray;
            this.startEnclosure();
            if (this.interop.omg4591.inUse()) {
                byArray = new byte[string.length()];
                for (int i = 0; i != byArray.length; ++i) {
                    byArray[i] = (byte)string.charAt(i);
                }
            } else {
                byArray = string.getBytes();
            }
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeBytes:715", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeChar(int n) throws IOException {
        try {
            this.startEnclosure();
            if (this.interop.omg4591.inUse()) {
                byte[] byArray = new byte[]{(byte)(n >> 8), (byte)n};
                this.orbStream.write_octet_array(byArray, 0, 2);
            } else {
                this.orbStream.write_wchar((char)n);
            }
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeChar:739", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeChars(String string) throws IOException {
        try {
            this.startEnclosure();
            if (this.interop.omg4591.inUse()) {
                int n = string.length();
                byte[] byArray = new byte[n * 2];
                int n2 = 0;
                for (int i = 0; i != n; ++i) {
                    char c = string.charAt(i);
                    byArray[n2++] = (byte)(c >> 8);
                    byArray[n2++] = (byte)c;
                }
                this.orbStream.write_octet_array(byArray, 0, byArray.length);
            } else {
                char[] cArray = string.toCharArray();
                this.orbStream.write_wchar_array(cArray, 0, cArray.length);
            }
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeChars:769", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeDouble(double d) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_double(d);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeDouble:784", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeFloat(float f) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_float(f);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeFloat:799", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeInt(int n) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_long(n);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeInt:814", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeLong(long l) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_longlong(l);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeLong:829", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeShort(int n) throws IOException {
        try {
            this.startEnclosure();
            this.orbStream.write_short((short)n);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeShort:844", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    protected final void writeStreamHeader() throws IOException {
    }

    public final void writeUTF(String string) throws IOException {
        try {
            this.startEnclosure();
            if (PartnerVersionUtil.sendJavaCharAsIDLChar(this.pv.getPartnerMajor(), this.pv.getPartnerMinor())) {
                this.orbStream.write_string(string);
            } else {
                this.orbStream.write_wstring(string);
            }
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeUTF:869", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    private void invokeObjectWriter(ObjectStreamClass objectStreamClass, Object object) throws IOException {
        short s;
        short s2;
        if (objectStreamClass.getName().equals("java.util.Calendar") && this.orbStream != null && PartnerVersionUtil.needAnOldCalendar(s2 = this.pv.getPartnerMajor(), s = this.pv.getPartnerMinor())) {
            Calendar calendar = (Calendar)object;
            TimeZone timeZone = calendar.getTimeZone();
            if (timeZone instanceof ZoneInfo) {
                SimpleTimeZone simpleTimeZone = ((ZoneInfo)timeZone).getLastRuleInstance();
                if (simpleTimeZone == null) {
                    simpleTimeZone = new SimpleTimeZone(timeZone.getRawOffset(), timeZone.getID());
                }
                calendar.setTimeZone(simpleTimeZone);
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "invokeObjectWriter:919", "WARNING: IBM partner version major=" + s2 + " and minor=" + s + ": Only default fields of java.util.Calendar were written");
            }
            this.defaultWriteObjectDelegate();
            return;
        }
        try {
            this.writeByte(this.formatVersion);
            this.writeObjectStart = true;
            if (this.orbStream2 != null) {
                this.index = this.orbStream2.get_offset();
            }
            if (this.formatVersion >= 2) {
                this.currentEnclose = 1;
            }
            objectStreamClass.writeObjectMethod.invoke(object, this.writeObjectArglist);
            if (this.currentEnclose != 0) {
                this.endEnclosure();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "invokeObjectWriter:952", (Exception)invocationTargetException);
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("invokeObjectWriter internal error");
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "invokeObjectWriter:965", (Exception)illegalAccessException);
        }
    }

    private Object outputObject(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        if (objectStreamClass.hasWriteObject()) {
            this.currentClassDesc = objectStreamClass;
            this.currentObject = object;
            this.currentEnclose = 0;
            this.invokeObjectWriter(objectStreamClass, object);
            return null;
        }
        return this.outputClassFields(object, objectStreamClass, 0);
    }

    private Object outputClassFields(Object object, ObjectStreamClass objectStreamClass, int n) throws InvalidClassException {
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFieldsNoCopy();
        for (int i = n; i < objectStreamFieldArray.length; ++i) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            if (objectStreamField.isPrimitive()) {
                this.writePrimField(object, objectStreamField);
                continue;
            }
            Object object2 = this.getObjectField(object, objectStreamField);
            Object object3 = this.writeObjectField(object2, objectStreamField);
            if (object3 != CDROutputStream.PENDING_WRITE) continue;
            boolean bl = this.orbStream2.getPrevMustChunk();
            this.pendingWriteStack.addResumeFields(object, objectStreamClass, i, bl);
            object2 = this.orbStream2.getCurrentObject();
            return object2;
        }
        return null;
    }

    private Object writeSerializable(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        ObjectStreamClass objectStreamClass2 = objectStreamClass;
        for (objectStreamClass = objectStreamClass.getSuperclass(); objectStreamClass != null && objectStreamClass.isSerializable(); objectStreamClass = objectStreamClass.getSuperclass()) {
            this.pendingWriteStack.addSubclass(object, objectStreamClass2);
            objectStreamClass2 = objectStreamClass;
        }
        return this.outputObject(object, objectStreamClass2);
    }

    private Object getObjectField(Object object, ObjectStreamField objectStreamField) throws InvalidClassException {
        ReflectField reflectField = objectStreamField.getReflectField();
        if (reflectField == null) {
            throw new InvalidClassException(objectStreamField.getClazz().getName(), "Nonexistent field " + objectStreamField.getName());
        }
        Object object2 = null;
        try {
            object2 = reflectField.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "getObjectField:1050", (Exception)illegalAccessException);
            throw new InvalidClassException(objectStreamField.getClazz().getName(), "IllegalAccessException " + objectStreamField.getName());
        }
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object writeObjectField(Object object, ObjectStreamField objectStreamField) {
        ObjectStreamClass objectStreamClass = objectStreamField.getObjectStreamClass();
        if (objectStreamClass.isValueType(this.orbStream2)) {
            return this.writeValueType(object);
        }
        if (objectStreamClass.isRemoteInterface()) {
            Util.writeRemoteObject((org.omg.CORBA.portable.OutputStream)this.orbStream, (Object)object);
            return object;
        } else {
            if (objectStreamClass.isAbstractInterface(this.orbStream2)) {
                return this.writeAbstractInterface(object);
            }
            if (!objectStreamClass.isAny()) throw new MARSHAL("Unknown field type " + objectStreamClass.forClass().getName(), 1229125816, CompletionStatus.COMPLETED_NO);
            if (this.orbStream2 != null) return this.orbStream2.fast_writeAnyOpt(object);
            Util.writeAny((org.omg.CORBA.portable.OutputStream)this.orbStream, (Object)object);
        }
        return object;
    }

    private Object writeAbstractInterface(Object object) {
        block3: {
            if (this.orbStream2 == null) {
                Util.writeAbstractObject((org.omg.CORBA.portable.OutputStream)this.orbStream, (Object)object);
                return object;
            }
            try {
                object = Utility.autoConnect(object, this.orbStream.orb(), false);
            }
            catch (INV_OBJREF iNV_OBJREF) {
                if (!ORBRas.isTrcLogging) break block3;
                ORBRas.orbTrcLogger.trace(4112L, this, "writeAbstractInterface:1105", iNV_OBJREF.toString());
            }
        }
        return this.orbStream2.fast_write_abstract_interface(object);
    }

    private Object writeValueType(Object object) {
        try {
            if (this.orbStream2 == null) {
                this.orbStream.write_value((Serializable)object);
                return object;
            }
            return this.orbStream2.fast_write_value((Serializable)object);
        }
        catch (ClassCastException classCastException) {
            if (object instanceof Serializable) {
                throw classCastException;
            }
            ORBRas.orbTrcLogger.exception(4104L, this, "writeValueType:1126", (Exception)classCastException);
            Utility.throwNotSerializableForCorba(object.getClass().getName());
            return object;
        }
    }

    private void writePrimPutField(Object object, ObjectStreamField objectStreamField) {
        switch (objectStreamField.getTypeCode()) {
            case 'B': {
                byte by = object != null ? (Byte)object : (byte)0;
                this.orbStream.write_octet(by);
                break;
            }
            case 'C': {
                char c = object != null ? ((Character)object).charValue() : (char)'\u0000';
                this.orbStream.write_wchar(c);
                break;
            }
            case 'F': {
                float f = object != null ? ((Float)object).floatValue() : 0.0f;
                this.orbStream.write_float(f);
                break;
            }
            case 'D': {
                double d = object != null ? (Double)object : 0.0;
                this.orbStream.write_double(d);
                break;
            }
            case 'I': {
                int n = object != null ? (Integer)object : 0;
                this.orbStream.write_long(n);
                break;
            }
            case 'J': {
                long l = object != null ? (Long)object : 0L;
                this.orbStream.write_longlong(l);
                break;
            }
            case 'S': {
                short s = object != null ? (Short)object : (short)0;
                this.orbStream.write_short(s);
                break;
            }
            case 'Z': {
                boolean bl = object != null ? (Boolean)object : false;
                this.orbStream.write_boolean(bl);
                break;
            }
            default: {
                throw new IllegalArgumentException("field is not a primitive");
            }
        }
    }

    private void writePrimField(Object object, ObjectStreamField objectStreamField) throws InvalidClassException {
        ReflectField reflectField = objectStreamField.getReflectField();
        if (reflectField == null) {
            throw new InvalidClassException(objectStreamField.getClazz().getName(), "Nonexistent field " + objectStreamField.getName());
        }
        try {
            switch (objectStreamField.getTypeCode()) {
                case 'I': {
                    int n = reflectField.getInt(object);
                    this.orbStream.write_long(n);
                    break;
                }
                case 'Z': {
                    boolean bl = reflectField.getBoolean(object);
                    this.orbStream.write_boolean(bl);
                    break;
                }
                case 'B': {
                    byte by = reflectField.getByte(object);
                    this.orbStream.write_octet(by);
                    break;
                }
                case 'J': {
                    long l = reflectField.getLong(object);
                    this.orbStream.write_longlong(l);
                    break;
                }
                case 'F': {
                    float f = reflectField.getFloat(object);
                    this.orbStream.write_float(f);
                    break;
                }
                case 'S': {
                    short s = reflectField.getShort(object);
                    this.orbStream.write_short(s);
                    break;
                }
                case 'C': {
                    char c = reflectField.getChar(object);
                    this.orbStream.write_wchar(c);
                    break;
                }
                case 'D': {
                    double d = reflectField.getDouble(object);
                    this.orbStream.write_double(d);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("field is not a primitive");
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "writePrimField:1237", (Exception)illegalAccessException);
            throw new InvalidClassException(objectStreamField.getClazz().getName(), "IllegalAccessException " + objectStreamField.getName());
        }
    }

    protected void putClassFields(HashMap hashMap) throws IOException {
        int n = this.currentEnclose;
        this.currentEnclose = 0;
        if (this.writeObjectStart) {
            this.orbStream.write_boolean(true);
            this.writeObjectStart = false;
        }
        ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
        for (int i = 0; i < objectStreamFieldArray.length; ++i) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            String string = objectStreamField.getName();
            Object object = hashMap.get(string);
            if (objectStreamField.isPrimitive()) {
                this.writePrimPutField(object, objectStreamField);
                continue;
            }
            Object object2 = this.writeObjectField(object, objectStreamField);
            if (object2 != CDROutputStream.PENDING_WRITE) continue;
            object = this.orbStream2.getCurrentObject();
            if (!this.pendingWriteStack.isEmpty()) {
                this.pendingWriteStack.addRecursionBreak();
            }
            boolean bl = this.orbStream2.getPrevMustChunk();
            object = this.orbStream2.getCurrentObject();
            this.simpleWriteObjectLoop(object);
            this.orbStream2.post_fast_write_value(bl);
        }
        this.currentEnclose = n;
    }

    protected void clearStream() {
        this.pendingWriteStack.reset();
        this.orbStream = null;
        this.orbStream2 = null;
        this.pv = PartnerVersion.UNKNOWN;
        ValueHandlerImpl.THREAD_LOCAL_PV.remove();
        this.vStream = null;
        this.formatVersion = 1;
        this.currentObject = null;
        this.currentClassDesc = null;
        this.index = -1;
        this.writeObjectStart = false;
        this.currentEnclose = 0;
        this.interop = Interop.NO_IBM_ORB;
    }

    private void startEnclosure() {
        if (this.writeObjectStart) {
            this.orbStream.write_boolean(false);
            this.writeObjectStart = false;
        }
        if (this.currentEnclose == 1) {
            String string = RepositoryId.createForCustomJavaType(this.currentClassDesc.forClass(), this.pv);
            this.vStream.start_value(string);
            this.currentEnclose = 2;
        }
    }

    private void endEnclosure() {
        if (this.writeObjectStart) {
            this.orbStream.write_boolean(false);
            this.writeObjectStart = false;
        }
        if (this.currentEnclose == 2) {
            this.vStream.end_value();
        } else if (this.currentEnclose == 1) {
            this.orbStream.write_long(0);
        }
    }

    private class PendingWrite {
        protected static final byte RECURSION_BREAK = 0;
        protected static final byte SUBCLASS = 1;
        protected static final byte BEGIN_FIELDS = 2;
        protected static final byte RESUME_FIELDS = 3;
        protected static final byte RESUME_ARRAY = 4;
        protected byte type;
        protected Object obj;
        protected ObjectStreamClass classDesc;
        protected int index;
        protected boolean mustChunk;

        private PendingWrite() {
        }

        protected boolean isRecursionBreak() {
            return this.type == 0;
        }

        protected boolean isSubclass() {
            return this.type == 1;
        }

        protected boolean isBeginFields() {
            return this.type == 2;
        }

        protected boolean isResumeFields() {
            return this.type == 3;
        }

        protected boolean isResumeArray() {
            return this.type == 4;
        }

        protected void reset() {
            this.obj = null;
            this.classDesc = null;
        }
    }

    private class PendingWriteStack {
        private static final int INIT_SIZE = 8;
        private PendingWrite[] pendingWrites = new PendingWrite[8];
        private int size = 0;
        private int maxDepth = 0;

        private PendingWriteStack() {
        }

        protected void reset() {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "reset:1362", "max recursion was " + this.maxDepth);
            }
            for (int i = 0; i < this.maxDepth; ++i) {
                if (this.pendingWrites[i] == null) continue;
                this.pendingWrites[i].reset();
            }
            if (this.maxDepth > 8) {
                PendingWrite[] pendingWriteArray = this.pendingWrites;
                this.pendingWrites = new PendingWrite[8];
                System.arraycopy(pendingWriteArray, 0, this.pendingWrites, 0, 8);
            }
            this.size = 0;
            this.maxDepth = 0;
        }

        protected boolean isEmpty() {
            return this.size == 0;
        }

        protected void addRecursionBreak() {
            PendingWrite pendingWrite = this.createPendingWrite();
            pendingWrite.reset();
            pendingWrite.type = 0;
        }

        protected void addSubclass(Object object, ObjectStreamClass objectStreamClass) {
            PendingWrite pendingWrite = this.createPendingWrite();
            pendingWrite.type = 1;
            pendingWrite.obj = object;
            pendingWrite.classDesc = objectStreamClass;
        }

        protected void addBeginFields(Object object, ObjectStreamClass objectStreamClass) {
            PendingWrite pendingWrite = this.createPendingWrite();
            pendingWrite.type = (byte)2;
            pendingWrite.obj = object;
            pendingWrite.classDesc = objectStreamClass;
        }

        protected void addResumeFields(Object object, ObjectStreamClass objectStreamClass, int n, boolean bl) {
            PendingWrite pendingWrite = this.createPendingWrite();
            pendingWrite.type = (byte)3;
            pendingWrite.obj = object;
            pendingWrite.classDesc = objectStreamClass;
            pendingWrite.index = n;
            pendingWrite.mustChunk = bl;
        }

        protected void addResumeArray(Object object, ObjectStreamClass objectStreamClass, int n, boolean bl) {
            PendingWrite pendingWrite = this.createPendingWrite();
            pendingWrite.type = (byte)4;
            pendingWrite.obj = object;
            pendingWrite.classDesc = objectStreamClass;
            pendingWrite.index = n;
            pendingWrite.mustChunk = bl;
        }

        private PendingWrite createPendingWrite() {
            PendingWrite pendingWrite;
            if (this.size == this.pendingWrites.length) {
                int n = this.pendingWrites.length;
                int n2 = Math.min(n * 2, n + 50);
                PendingWrite[] pendingWriteArray = this.pendingWrites;
                this.pendingWrites = new PendingWrite[n2];
                System.arraycopy(pendingWriteArray, 0, this.pendingWrites, 0, n);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "createPendingWrite:1459", "grew from " + n + " to " + n2);
                }
            }
            if ((pendingWrite = this.pendingWrites[this.size]) == null) {
                this.pendingWrites[this.size] = pendingWrite = new PendingWrite();
            }
            ++this.size;
            if (this.size > this.maxDepth) {
                this.maxDepth = this.size;
            }
            return pendingWrite;
        }

        protected PendingWrite getNextPendingWrite() {
            if (this.size == 0) {
                return null;
            }
            return this.pendingWrites[--this.size];
        }
    }
}

