/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.transport;

import com.ibm.CORBA.iiop.Delegate;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.TransportBase;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.CORBA.transport.TransportConnectionBase;
import com.ibm.rmi.transport.ConnectionKeyImpl;
import com.ibm.rmi.transport.ListenerThread;
import com.ibm.rmi.transport.TCPTransportConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class TCPTransport
extends TransportBase {
    private ORB orb;
    private ConnectionTable connTable;
    private ORBForTransports tOrb;
    private Profile serverProfile = null;
    private int acceptTimeout = 0;
    private Set listeners;

    public void init(ORB oRB) {
        this.orb = oRB;
        this.connTable = ORB.createConnectionTable(oRB, this);
        this.tOrb = oRB.getORBForTransports();
        this.listeners = new HashSet(1);
        try {
            this.acceptTimeout = Integer.parseInt(oRB.getProperty("com.ibm.CORBA.AcceptTimeout"));
            if (this.acceptTimeout < 0 || this.acceptTimeout > 5000) {
                this.acceptTimeout = 5000;
            }
        }
        catch (Exception exception) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, this, "init:99", exception.toString());
            }
            this.acceptTimeout = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORBConnection getConnection(Profile profile, String string, Delegate delegate) {
        ORBConnection oRBConnection;
        String string2 = profile.getHost();
        int n = profile.getPort();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "getConnection:117", (Object)("host=" + string2 + ", port=" + n + ", operation=" + string));
        }
        ConnectionKeyImpl connectionKeyImpl = new ConnectionKeyImpl(string2, n);
        Object object = this.connTable;
        synchronized (object) {
            oRBConnection = this.connTable.getConnection(connectionKeyImpl);
            if (oRBConnection != null) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exit(4100L, this, "getConnection:130", (Object)oRBConnection);
                }
                return oRBConnection;
            }
            oRBConnection = this.tOrb.createORBConnection();
            this.connTable.addConnection(connectionKeyImpl, oRBConnection);
        }
        object = new TCPTransportConnection(this.tOrb, this.connTable, connectionKeyImpl, oRBConnection, this.orb.getReaderPool(), profile);
        ((TransportConnectionBase)object).connect();
        this.connTable.checkConnectionTable();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "getConnection:158", (Object)oRBConnection);
        }
        return oRBConnection;
    }

    public void createListener(int n) {
        this.startListening(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startListening(int n) {
        ServerSocket serverSocket;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "startListening:178", (Object)("port=" + n));
        }
        final ConnectionTable connectionTable = this.connTable;
        try {
            int n2 = this.orb.getSocketQueueDepth();
            serverSocket = n2 > 0 ? new ServerSocket(n, n2) : new ServerSocket(n);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "startListening:192", "new socket=" + serverSocket);
            }
            final String string = "P=" + ORB.orbLoadTime + ":" + "O=" + this.orb.thisInstanceNumber + ":" + "port=" + serverSocket.getLocalPort();
            final boolean bl = this.orb.getServerKeepAlive();
            Thread thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread thread = TCPTransport.this.createListenerThread(connectionTable, serverSocket, TCPTransport.this.acceptTimeout, bl, string);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            thread.start();
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.add(thread);
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "startListening:219", "new listener=" + thread);
            }
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "startListening:225", exception);
            INTERNAL iNTERNAL = new INTERNAL(exception.toString(), 1229124996, CompletionStatus.COMPLETED_NO);
            iNTERNAL.initCause((Throwable)exception);
            throw iNTERNAL;
        }
        return serverSocket.getLocalPort();
    }

    public void initTransports() {
        int n = this.orb.getListenerPort();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "initTransports:247", "listenerPort = " + n);
        }
        int n2 = this.startListening(n);
        this.serverProfile = ORB.createProfile(this.orb, this.orb.getORBServerHost(), n2);
    }

    public Profile getIIOPProfile() {
        return this.serverProfile;
    }

    public TransportConnection createTransportConnection(Socket socket, Thread thread) {
        return new TCPTransportConnection(this.connTable, socket, this.orb.getReaderPool(), this.tOrb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Set set = this.listeners;
        synchronized (set) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((ListenerThread)iterator.next()).setShutdownPending(true);
            }
        }
    }

    ConnectionTable getConnectionTable() {
        return this.connTable;
    }
}

