/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.rmi.util.AbstractMapLite;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class MPHashMap
extends AbstractMapLite {
    private final Map[] maps;
    private final Key[] lookupKeys;
    private final boolean useIdentityHashCode;
    private static final Comparator identityComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return System.identityHashCode(object) - System.identityHashCode(object2);
        }
    };

    private MPHashMap(int n, boolean bl) {
        this.useIdentityHashCode = bl;
        this.maps = new Map[n | 1];
        this.lookupKeys = new Key[n | 1];
    }

    protected MPHashMap(boolean bl, int n) {
        this(n, bl);
        for (int i = 0; i < this.maps.length; ++i) {
            this.maps[i] = new HashMap();
            this.lookupKeys[i] = this.createKey();
        }
    }

    protected MPHashMap(boolean bl, int n, int n2) {
        this(n, bl);
        for (int i = 0; i < this.maps.length; ++i) {
            this.maps[i] = new HashMap(n2);
            this.lookupKeys[i] = this.createKey();
        }
    }

    protected MPHashMap(boolean bl, int n, int n2, float f) {
        this(n, bl);
        for (int i = 0; i < this.maps.length; ++i) {
            this.maps[i] = new HashMap(n2, f);
            this.lookupKeys[i] = this.createKey();
        }
    }

    public MPHashMap(int n) {
        this(false, n);
    }

    public MPHashMap(int n, int n2) {
        this(false, n, n2);
    }

    public MPHashMap(int n, int n2, float f) {
        this(false, n, n2, f);
    }

    private final int getIndexForHash(int n) {
        return (n & Integer.MAX_VALUE) % this.maps.length;
    }

    private int hash(Object object) {
        int n = 0;
        if (this.useIdentityHashCode) {
            n = System.identityHashCode(object);
        } else if (object != null) {
            n = object.hashCode();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean syncEquals(Iterator iterator, Map map) {
        Object e;
        Object e2 = e = iterator.next();
        synchronized (e2) {
            if (iterator.hasNext()) {
                return this.syncEquals(iterator, map);
            }
            if (this.size() != map.size()) {
                return false;
            }
            for (int i = 0; i < this.maps.length; ++i) {
                for (Map.Entry entry : this.maps[i].entrySet()) {
                    if (map.get(entry.getKey()) == entry.getValue()) continue;
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void syncPutAll(Iterator iterator, MPHashMap mPHashMap) {
        Object e;
        Object e2 = e = iterator.next();
        synchronized (e2) {
            if (iterator.hasNext()) {
                this.syncPutAll(iterator, mPHashMap);
            } else {
                for (int i = 0; i < mPHashMap.maps.length; ++i) {
                    this.putAll(mPHashMap.maps[i]);
                }
            }
        }
    }

    private void printObject(Object object, PrintWriter printWriter) {
        printWriter.print(object.getClass().getName());
        printWriter.print("@");
        printWriter.print(System.identityHashCode(object));
    }

    private void printEntry(Map.Entry entry, PrintWriter printWriter) {
        printWriter.print("\t");
        this.printObject(((Key)entry.getKey()).getRealKey(), printWriter);
        printWriter.print(" -> ");
        this.printObject(entry.getValue(), printWriter);
        printWriter.println();
    }

    protected Key createKey() {
        return new Key();
    }

    protected Key createKey(Object object, int n) {
        return new Key(object, n);
    }

    public final Object getLockObject(Object object) {
        return this.maps[this.getIndexForHash(this.hash(object))];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (int i = 0; i < this.maps.length; ++i) {
            Map map = this.maps[i];
            synchronized (map) {
                Iterator iterator = this.maps[i].entrySet().iterator();
                if (!iterator.hasNext()) {
                    printWriter.println("\tEmpty.");
                }
                while (iterator.hasNext()) {
                    this.printEntry(iterator.next(), printWriter);
                }
                continue;
            }
        }
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        for (int i = 0; i < this.maps.length; ++i) {
            Map map = this.maps[i];
            synchronized (map) {
                this.maps[i].clear();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsKey(Object object) {
        Map map;
        int n = this.hash(object);
        int n2 = this.getIndexForHash(n);
        Map map2 = map = this.maps[n2];
        synchronized (map2) {
            Key key = this.lookupKeys[n2];
            key.set(object, n);
            boolean bl = map.containsKey(key);
            key.reset();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsValue(Object object) {
        for (int i = 0; i < this.maps.length; ++i) {
            Map map = this.maps[i];
            synchronized (map) {
                if (this.maps[i].containsValue(object)) {
                    return true;
                }
                continue;
            }
        }
        return false;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            TreeSet<Map> treeSet = new TreeSet<Map>(identityComparator);
            treeSet.addAll(Arrays.asList(this.maps));
            if (map instanceof MPHashMap) {
                treeSet.addAll(Arrays.asList(((MPHashMap)map).maps));
            }
            return this.syncEquals(treeSet.iterator(), map);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get(Object object) {
        Map map;
        int n = this.hash(object);
        int n2 = this.getIndexForHash(n);
        Map map2 = map = this.maps[n2];
        synchronized (map2) {
            Key key = this.lookupKeys[n2];
            key.set(object, n);
            Object v = map.get(key);
            key.reset();
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        int n = 0;
        for (int i = 0; i < this.maps.length; ++i) {
            Map map = this.maps[i];
            synchronized (map) {
                n += ((Object)this.maps[i]).hashCode();
                continue;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEmpty() {
        for (int i = 0; i < this.maps.length; ++i) {
            Map map = this.maps[i];
            synchronized (map) {
                if (!this.maps[i].isEmpty()) {
                    return false;
                }
                continue;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object put(Object object, Object object2) {
        Map map;
        int n = this.hash(object);
        Key key = this.createKey(object, n);
        Map map2 = map = this.maps[this.getIndexForHash(n)];
        synchronized (map2) {
            return map.put(key, object2);
        }
    }

    public final void putAll(Map map) {
        if (map instanceof MPHashMap) {
            MPHashMap mPHashMap = (MPHashMap)map;
            TreeSet<Map> treeSet = new TreeSet<Map>(identityComparator);
            treeSet.addAll(Arrays.asList(this.maps));
            treeSet.addAll(Arrays.asList(mPHashMap.maps));
            this.syncPutAll(treeSet.iterator(), mPHashMap);
        } else {
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object remove(Object object) {
        Map map;
        int n = this.hash(object);
        int n2 = this.getIndexForHash(n);
        Map map2 = map = this.maps[n2];
        synchronized (map2) {
            Key key = this.lookupKeys[n2];
            key.set(object, n);
            Object v = map.remove(key);
            key.reset();
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int n = 0;
        for (int i = 0; i < this.maps.length; ++i) {
            Map map = this.maps[i];
            synchronized (map) {
                n += this.maps[i].size();
                continue;
            }
        }
        return n;
    }

    protected static class Key {
        private Object realKey;
        private int hash;

        Key() {
            this(null, 0);
        }

        Key(Object object, int n) {
            this.set(object, n);
        }

        public boolean equals(Object object) {
            return object instanceof Key && this.realKey.equals(((Key)object).realKey);
        }

        public final int hashCode() {
            return this.hash;
        }

        final Object getRealKey() {
            return this.realKey;
        }

        final void set(Object object, int n) {
            this.realKey = object;
            this.hash = n;
        }

        final void reset() {
            this.realKey = null;
            this.hash = 0;
        }
    }
}

