/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.iiop.IDLMapper;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;

public class MethodNames
implements IDLMapper {
    private static Map mnCache = new HashMap();
    private Map nameMap;

    public static synchronized MethodNames createMapper(Class clazz) {
        MethodNames methodNames = (MethodNames)mnCache.get(clazz);
        if (methodNames == null) {
            methodNames = new MethodNames(clazz);
            mnCache.put(clazz, methodNames);
        }
        return methodNames;
    }

    public MethodNames(Class clazz) {
        this.nameMap = this.init(clazz);
    }

    public String mapMethod(Method method) {
        return (String)this.nameMap.get(method);
    }

    private Map init(Class clazz) {
        int n;
        Method[] methodArray = clazz.getMethods();
        java.lang.Object[] objectArray = new Entry[methodArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = new Entry(methodArray[i]);
        }
        Arrays.sort(objectArray);
        HashMap hashMap = new HashMap();
        for (int i = 0; i < objectArray.length; ++i) {
            ((Entry)objectArray[i]).checkProperty(hashMap);
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (n = 0; n < objectArray.length; ++n) {
            ((Entry)objectArray[n]).checkOverloaded(hashSet, hashSet2);
        }
        for (n = 0; n < objectArray.length; ++n) {
            ((Entry)objectArray[n]).checkAttrClash(hashSet, hashSet2);
        }
        hashSet.clear();
        HashSet hashSet3 = new HashSet();
        HashSet hashSet4 = new HashSet();
        for (int i = 0; i < objectArray.length; ++i) {
            ((Entry)objectArray[i]).checkCaseDifference(hashSet, hashSet3, hashSet4);
        }
        String string = clazz.getName();
        StringBuffer stringBuffer = new StringBuffer(string.substring(string.lastIndexOf(46) + 1));
        this.mangleInvalidChars(stringBuffer, false);
        String string2 = stringBuffer.toString();
        HashMap<Method, String> hashMap2 = new HashMap<Method, String>();
        for (int i = 0; i < objectArray.length; ++i) {
            java.lang.Object object = objectArray[i];
            StringBuffer stringBuffer2 = new StringBuffer(((Entry)object).name);
            if (hashSet4.contains(((Entry)object).upperName)) {
                this.mangleCaseDiffs(stringBuffer2);
            }
            if (!((Entry)object).isAttribute) {
                if (hashSet2.contains(((Entry)object).name)) {
                    this.mangleOverloads(stringBuffer2, ((Entry)object).method.getParameterTypes());
                }
            } else {
                this.mangleProperty(stringBuffer2, ((Entry)object).isNameClash, ((Entry)object).isSetter);
            }
            this.mangleInvalidChars(stringBuffer2, ((Entry)object).isAttribute);
            String string3 = stringBuffer2.toString();
            if (string3.equalsIgnoreCase(string2)) {
                stringBuffer2.append('_');
                string3 = stringBuffer2.toString();
            }
            hashMap2.put(((Entry)object).method, string3);
        }
        return hashMap2;
    }

    private void mangleCaseDiffs(StringBuffer stringBuffer) {
        boolean bl = false;
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isUpperCase(stringBuffer.charAt(i))) continue;
            stringBuffer.append("_");
            stringBuffer.append(i);
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("_");
        }
    }

    private void mangleOverloads(StringBuffer stringBuffer, Class[] classArray) {
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append("__");
            stringBuffer.append(this.mapJavaType(classArray[i]).replace('.', '_'));
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("__");
        }
    }

    private void mangleProperty(StringBuffer stringBuffer, boolean bl, boolean bl2) {
        if (bl2) {
            stringBuffer.insert(0, "_set_");
        } else {
            stringBuffer.insert(0, "_get_");
        }
        if (bl) {
            stringBuffer.append("__");
        }
    }

    private void mangleInvalidChars(StringBuffer stringBuffer, boolean bl) {
        int n = stringBuffer.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(n2);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') {
                ++n2;
                continue;
            }
            stringBuffer.replace(n2, n2 + 1, this.getEscapeChar(c));
            n2 += 5;
        }
        if (!bl && stringBuffer.charAt(0) == '_') {
            stringBuffer.insert(0, 'J');
        }
    }

    private String getEscapeChar(char c) {
        StringBuffer stringBuffer = new StringBuffer("U0000");
        String string = Integer.toHexString(c);
        int n = string.length();
        for (int i = 4; i > 0 && n > 0; --i) {
            stringBuffer.setCharAt(i, Character.toUpperCase(string.charAt(--n)));
        }
        return stringBuffer.toString();
    }

    private String mapJavaType(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            int n = 0;
            while (clazz.isArray()) {
                ++n;
                clazz = clazz.getComponentType();
            }
            String string2 = this.mapJavaType(clazz);
            String string3 = "";
            int n2 = string2.lastIndexOf(46);
            if (n2 != -1) {
                string3 = string2.substring(0, n2 + 1);
                string2 = string2.substring(n2 + 1);
            }
            string = "org.omg.boxedRMI." + string3 + "seq" + n + "_" + string2;
        } else {
            string = IDLEntity.class.isAssignableFrom(clazz) && !Object.class.isAssignableFrom(clazz) ? "org.omg.boxedIDL." + this.mapBaseJavaType(clazz) : this.mapBaseJavaType(clazz);
        }
        return string;
    }

    private String mapBaseJavaType(Class clazz) {
        String string = null;
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                string = "boolean";
            } else if (clazz == Byte.TYPE) {
                string = "octet";
            } else if (clazz == Character.TYPE) {
                string = "wchar";
            } else if (clazz == Short.TYPE) {
                string = "short";
            } else if (clazz == Integer.TYPE) {
                string = "long";
            } else if (clazz == Long.TYPE) {
                string = "long_long";
            } else if (clazz == Float.TYPE) {
                string = "float";
            } else if (clazz == Double.TYPE) {
                string = "double";
            }
        } else {
            string = clazz == String.class ? "CORBA.WStringValue" : (clazz == Class.class ? "javax.rmi.CORBA.ClassDesc" : (clazz == Object.class ? "Object" : clazz.getName()));
        }
        return string;
    }

    static class Entry
    implements Comparable {
        Method method;
        String name;
        String upperName;
        boolean isAttribute;
        boolean isSetter;
        boolean isNameClash;

        Entry(Method method) {
            this.method = method;
            this.name = method.getName();
        }

        public int compareTo(java.lang.Object object) {
            return this.name.compareTo(((Entry)object).name);
        }

        void checkProperty(Map map) {
            if (this.name.startsWith("get") && this.method.getReturnType() != Void.TYPE || this.name.startsWith("is") && this.method.getReturnType() == Boolean.TYPE) {
                if (this.name.equals("get") || this.name.equals("is")) {
                    return;
                }
                if (this.method.getParameterTypes().length > 0) {
                    return;
                }
                Class<?>[] classArray = this.method.getExceptionTypes();
                for (int i = 0; i < classArray.length; ++i) {
                    if (RuntimeException.class.isAssignableFrom(classArray[i]) || RemoteException.class.isAssignableFrom(classArray[i])) continue;
                    return;
                }
                String string = this.name.substring(this.name.startsWith("is") ? 2 : 3);
                Entry entry = (Entry)map.get(string);
                if (entry != null) {
                    if (entry.method.getReturnType() == Boolean.TYPE) {
                        entry.isAttribute = false;
                        entry.name = entry.method.getName();
                    } else {
                        return;
                    }
                }
                map.put(string, this);
                this.name = string;
                this.isAttribute = true;
                this.isSetter = false;
            } else if (this.name.startsWith("set") && this.method.getReturnType() == Void.TYPE) {
                if (this.name.equals("set")) {
                    return;
                }
                Class<?>[] classArray = this.method.getParameterTypes();
                if (classArray.length != 1) {
                    return;
                }
                Class<?>[] classArray2 = this.method.getExceptionTypes();
                for (int i = 0; i < classArray2.length; ++i) {
                    if (RuntimeException.class.isAssignableFrom(classArray2[i]) || RemoteException.class.isAssignableFrom(classArray2[i])) continue;
                    return;
                }
                String string = this.name.substring(3);
                Entry entry = (Entry)map.get(string);
                if (entry == null || entry.method.getReturnType() != classArray[0]) {
                    return;
                }
                this.name = string;
                this.isAttribute = true;
                this.isSetter = true;
            }
        }

        void checkOverloaded(Set set, Set set2) {
            if (!this.isAttribute && !set.add(this.name)) {
                set2.add(this.name);
            }
        }

        void checkAttrClash(Set set, Set set2) {
            if (this.isAttribute) {
                StringBuffer stringBuffer = new StringBuffer(this.name);
                if (stringBuffer.length() == 1 || Character.isLowerCase(stringBuffer.charAt(1))) {
                    stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
                }
                this.name = stringBuffer.toString();
                if (set.contains(this.name) && !set2.contains(this.name)) {
                    this.isNameClash = true;
                }
            }
        }

        void checkCaseDifference(Set set, Set set2, Set set3) {
            this.upperName = this.name.toUpperCase();
            if (set.add(this.name) && !set2.add(this.upperName)) {
                set3.add(this.upperName);
            }
        }
    }
}

