/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.config;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.logic.Logic;
import com.ibm.keymanager.util.SmudgedBytes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ConfigImpl
extends Config {
    private static final String WINCONFFILE;
    private static final String IXCONFFILE;
    private static KMSDebug debug;
    private static String className;
    private static ConfigImpl configInstance;
    private static Hashtable configInMemory;
    private static Properties p;
    private static FileInputStream fis;
    private static FileOutputStream fos;
    private static String configFile;
    private static String[] z;

    public void init() throws KeyManagerException {
        debug = KMSDebug.getInstance();
        debug.entry(z[2], className, z[3]);
        String string = System.getProperty(z[8]);
        debug.trace(z[2], className, z[3], string);
        if (string.toUpperCase().indexOf(z[10]) != -1) {
            debug.trace(z[2], className, z[3], z[11]);
            ConfigImpl.load(WINCONFFILE);
        } else if (string.toUpperCase().indexOf("X") != -1) {
            debug.trace(z[2], className, z[3], string + z[9]);
            ConfigImpl.load(IXCONFFILE);
        } else {
            debug.trace(z[2], className, z[3], string + z[9]);
            ConfigImpl.load(IXCONFFILE);
        }
        debug.exit(z[2], className, z[3]);
    }

    public void init(String string) throws KeyManagerException {
        debug = KMSDebug.getInstance();
        debug.entry(z[2], className, z[3]);
        if (string != null) {
            ConfigImpl.load(string);
        } else {
            this.init();
        }
        debug.exit(z[2], className, z[3]);
    }

    public static void load(String string) throws KeyManagerException {
        debug.entry(z[2], className, z[12]);
        String string2 = null;
        if (string == null) {
            String string3 = System.getProperty(z[8]);
            if (string3.toUpperCase().indexOf(z[10]) != -1) {
                string2 = WINCONFFILE;
                debug.trace(z[2], className, z[3], z[11]);
            } else if (string3.toUpperCase().indexOf("X") != -1) {
                string2 = IXCONFFILE;
                debug.trace(z[2], className, z[3], string3 + z[9]);
            }
            configFile = string2;
        } else {
            configFile = string;
        }
        try {
            debug.trace(z[2], className, z[12], configFile);
            fis = new FileInputStream(configFile);
            p.clear();
            p.load(fis);
            fis.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(iOException);
        }
        ConfigImpl.buildConfig(p);
        debug.exit(z[2], className, z[12]);
    }

    public void add(String string, Object object) throws KeyManagerException {
        debug.entry(z[2], className, z[25]);
        try {
            if (string.toLowerCase().indexOf(z[0]) == 0) {
                debug.trace(z[2], className, z[25], string + z[22] + object);
            }
            configInMemory.put(string, object);
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyManagerException(nullPointerException);
        }
        debug.exit(z[2], className, z[25]);
    }

    public void delete(String string) throws KeyManagerException {
        debug.entry(z[2], className, z[1]);
        try {
            if (string.toLowerCase().indexOf(z[0]) == 0) {
                debug.trace(z[2], className, z[1], string);
            }
            configInMemory.remove(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyManagerException(nullPointerException);
        }
        debug.exit(z[2], className, z[1]);
    }

    public void replace(String string, Object object) throws KeyManagerException {
        debug.entry(z[2], className, z[33]);
        try {
            if (string.toLowerCase().indexOf(z[0]) == 0) {
                debug.trace(z[2], className, z[33], string + z[22] + object);
                debug.trace(z[2], className, z[33], string + z[32] + configInMemory.get(string));
            }
            configInMemory.remove(string);
            configInMemory.put(string, object);
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyManagerException(nullPointerException);
        }
        debug.exit(z[2], className, z[33]);
    }

    public void reload() throws KeyManagerException {
        debug.entry(z[2], className, z[7]);
        try {
            debug.trace(z[2], className, z[7], configFile);
            fis = new FileInputStream(configFile);
            p.clear();
            p.load(fis);
            fis.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(iOException);
        }
        configInMemory.clear();
        ConfigImpl.buildConfig(p);
        debug.exit(z[2], className, z[7]);
    }

    public Hashtable get() {
        debug.entry(z[2], className, z[6]);
        Hashtable hashtable = new Hashtable(configInMemory.size());
        Enumeration enumeration = configInMemory.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            hashtable.put(k2, configInMemory.get(k2));
        }
        debug.exit(z[2], className, z[6]);
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(String string) throws KeyManagerException {
        debug.entry(z[2], className, z[6]);
        if (string == null) {
            return null;
        }
        Object var2_2 = null;
        try {
            if (string.equals(z[26])) {
                String string2 = (String)configInMemory.get(z[27]);
                if (string2 == null) {
                    return null;
                }
                byte[] byArray = Logic.hexStringToByteArray(string2);
                return SmudgedBytes.getClearTextPWstring(byArray);
            }
            if (string.equals(z[28])) {
                String string3 = (String)configInMemory.get(z[30]);
                if (string3 == null) {
                    return null;
                }
                byte[] byArray = Logic.hexStringToByteArray(string3);
                return SmudgedBytes.getClearTextPWstring(byArray);
            }
            if (string.equals(z[29])) {
                String string4 = (String)configInMemory.get(z[31]);
                if (string4 == null) {
                    return null;
                }
                byte[] byArray = Logic.hexStringToByteArray(string4);
                return SmudgedBytes.getClearTextPWstring(byArray);
            }
            var2_2 = configInMemory.get(string);
            if (string.toLowerCase().indexOf(z[0]) == -1) {
                debug.trace(z[2], className, z[6], string + z[22] + var2_2);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyManagerException(nullPointerException);
        }
        debug.exit(z[2], className, z[6]);
        if (!(var2_2 instanceof String)) return var2_2;
        return ((String)var2_2).trim();
    }

    public void shutdown() throws KeyManagerException {
        debug.entry(z[2], className, z[20]);
        this.sync();
        debug.exit(z[2], className, z[20]);
    }

    public void sync() throws KeyManagerException {
        debug = KMSDebug.getInstance();
        debug.entry(z[2], className, z[5]);
        try {
            ConfigImpl.write();
        }
        catch (Exception exception) {
            throw new KeyManagerException(exception);
        }
        debug.exit(z[2], className, z[5]);
    }

    public void sync(Hashtable hashtable) throws KeyManagerException {
        debug.entry(z[2], className, z[5]);
        configInMemory.clear();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            configInMemory.put(k2, hashtable.get(k2));
        }
        try {
            ConfigImpl.write();
        }
        catch (Exception exception) {
            throw new KeyManagerException(exception.getMessage());
        }
        debug.exit(z[2], className, z[5]);
    }

    private static void buildConfig(Properties properties) {
        debug.entry(z[2], className, z[13]);
        Enumeration<?> enumeration = p.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            string2 = p.getProperty(string);
            int n2 = string2.toString().length();
            if (n2 >= 1) {
                if (string.toLowerCase().indexOf(z[0]) == 0) {
                    debug.trace(z[2], className, z[13], z[14] + string + z[15] + string2);
                }
                configInMemory.put(string, string2);
                continue;
            }
            if (configInMemory.get(string) != null) continue;
            if (string.toLowerCase().indexOf(z[0]) == 0) {
                debug.trace(z[2], className, z[13], z[16] + string);
            }
            configInMemory.put(string, p.getProperty(string));
        }
        debug.exit(z[2], className, z[13]);
    }

    private static void mergeConfig(Properties properties) {
        debug.entry(z[2], className, z[19]);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            string2 = properties.getProperty(string);
            int n2 = string2.toString().length();
            if (n2 >= 1) {
                configInMemory.put(string, string2);
                if (string.toLowerCase().indexOf(z[0]) != 0) continue;
                debug.trace(z[2], className, z[19], z[14] + string + z[15] + string2);
                continue;
            }
            if (configInMemory.get(string) != null) continue;
            debug.trace(z[2], className, z[19], z[16] + string);
            configInMemory.put(string, p.getProperty(string));
        }
        debug.exit(z[2], className, z[19]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void write() throws Exception {
        String string = configFile;
        debug.entry(z[2], className, z[17]);
        String string2 = configFile;
        synchronized (string2) {
            File file;
            debug.trace(z[2], className, z[17], string);
            File file2 = new File(string);
            File file3 = new File(string + z[23]);
            if (!file3.exists()) {
                try {
                    file3.createNewFile();
                }
                catch (IOException iOException) {
                    file = file3.getAbsoluteFile().getParentFile();
                    if (!file.exists()) {
                        if (!file.mkdirs()) {
                            throw new KeyManagerException(z[24] + string + z[21]);
                        }
                    } else {
                        throw (KeyManagerException)new KeyManagerException().initCause(iOException);
                    }
                    try {
                        file3.createNewFile();
                    }
                    catch (IOException iOException2) {
                        throw (KeyManagerException)new KeyManagerException().initCause(iOException2);
                    }
                }
            }
            fos = new FileOutputStream(file3);
            Enumeration enumeration = configInMemory.keys();
            file = null;
            while (enumeration.hasMoreElements()) {
                file = enumeration.nextElement();
                String string3 = file + z[22] + configInMemory.get(file) + "\n";
                if (string3.toLowerCase().indexOf(z[0]) == 0) {
                    debug.trace(z[2], className, z[17], "" + string3);
                }
                if (configInMemory.get(file) == null) continue;
                fos.write(string3.getBytes());
                fos.flush();
            }
            fos.close();
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
        }
        debug.exit(z[2], className, z[17]);
    }

    public void write(String string) throws KeyManagerException {
        debug.entry(z[2], className, z[17]);
        try {
            String string2 = configFile;
            configFile = string;
            ConfigImpl.write();
            configFile = string2;
        }
        catch (Exception exception) {
            throw new KeyManagerException(exception);
        }
        debug.exit(z[2], className, z[17]);
    }

    public void merge(File file) throws KeyManagerException {
        Hashtable hashtable = new Hashtable(25);
        debug.entry(z[2], className, z[4]);
        if (file == null) {
            return;
        }
        try {
            p = new Properties();
            fis = new FileInputStream(file);
            p.load(fis);
            ConfigImpl.mergeConfig(p);
            fis.close();
        }
        catch (IOException iOException) {
            throw new KeyManagerException(iOException);
        }
        debug.exit(z[2], className, z[4]);
    }

    public void load(File file) throws KeyManagerException {
        debug.entry(z[2], className, z[12]);
        if (file == null) {
            return;
        }
        try {
            debug.trace(z[2], className, z[12], file.getName());
            p = new Properties();
            fis = new FileInputStream(file);
            p.load(fis);
            ConfigImpl.buildConfig(p);
            fis.close();
        }
        catch (IOException iOException) {
            throw new KeyManagerException(iOException);
        }
        debug.exit(z[2], className, z[12]);
    }

    public Enumeration list() {
        debug.entry(z[2], className, z[18]);
        debug.exit(z[2], className, z[18]);
        return configInMemory.keys();
    }

    static {
        String[] stringArray = new String[34];
        Object var0 = null;
        IXCONFFILE = ConfigImpl.z(ConfigImpl.z("\u00143kEKR>v\u001e/^%VP\nZ;~C7^.mT\u0016\u0014\u0017~H)Z2zV\u0001I\u001ft_\u0002R;5A\u0016T,~C\u0010R9h"));
        var0 = null;
        WINCONFFILE = ConfigImpl.z(ConfigImpl.z("xf4a\u0016T;iP\t\u001b\u001ar]\u0001HsRs)\u0014\u0017~H)Z2zV\u0001I\u000f~C\u0012^.4z\u0001B\u0011z_\u0005\\9ir\u000bU:rVJK.tA\u0001I(rT\u0017"));
        var0 = null;
        stringArray[0] = ConfigImpl.z(ConfigImpl.z("K=hB\u0013T.\u007f"));
        var0 = null;
        stringArray[1] = ConfigImpl.z(ConfigImpl.z("_9wT\u0010^"));
        var0 = null;
        stringArray[2] = ConfigImpl.z(ConfigImpl.z("X3uW\r\\"));
        var0 = null;
        stringArray[3] = ConfigImpl.z(ConfigImpl.z("R2rE"));
        var0 = null;
        stringArray[4] = ConfigImpl.z(ConfigImpl.z("V9iV\u0001"));
        var0 = null;
        stringArray[5] = ConfigImpl.z(ConfigImpl.z("H%uR"));
        var0 = null;
        stringArray[6] = ConfigImpl.z(ConfigImpl.z("\\9o"));
        var0 = null;
        stringArray[7] = ConfigImpl.z(ConfigImpl.z("I9w^\u0005_"));
        var0 = null;
        stringArray[8] = ConfigImpl.z(ConfigImpl.z("T/5_\u0005V9"));
        var0 = null;
        stringArray[9] = ConfigImpl.z(ConfigImpl.z("\u001b\u0015O\u0011-h}"));
        var0 = null;
        stringArray[10] = ConfigImpl.z(ConfigImpl.z("l\u0015U"));
        var0 = null;
        stringArray[11] = ConfigImpl.z(ConfigImpl.z("l\u0015Uu+l\u000f;x0\u001b\u0015H\u0010"));
        var0 = null;
        stringArray[12] = ConfigImpl.z(ConfigImpl.z("W3zU"));
        var0 = null;
        stringArray[13] = ConfigImpl.z(ConfigImpl.z("Y)r]\u0000x3uW\r\\"));
        var0 = null;
        stringArray[14] = ConfigImpl.z(ConfigImpl.z("N,\u007fP\u0010R2|\u0011"));
        var0 = null;
        stringArray[15] = ConfigImpl.z(ConfigImpl.z("\u001b(t\u0011"));
        var0 = null;
        stringArray[16] = ConfigImpl.z(ConfigImpl.z("m\u001dWd!\u001b\u0012N}(\u0001|"));
        var0 = null;
        stringArray[17] = ConfigImpl.z(ConfigImpl.z("L.rE\u0001"));
        var0 = null;
        stringArray[18] = ConfigImpl.z(ConfigImpl.z("W5hE"));
        var0 = null;
        stringArray[19] = ConfigImpl.z(ConfigImpl.z("V9iV\u0001x3uW\r\\"));
        var0 = null;
        stringArray[20] = ConfigImpl.z(ConfigImpl.z("H4nE\u0000T+u"));
        var0 = null;
        stringArray[21] = ConfigImpl.z(ConfigImpl.z("\u001b?z_DU3o\u0011\u0006^|xC\u0001Z(~U"));
        var0 = null;
        stringArray[22] = ConfigImpl.z(ConfigImpl.z("\u001ba;"));
        var0 = null;
        stringArray[23] = ConfigImpl.z(ConfigImpl.z("\u0015>zR\u000fN,"));
        var0 = null;
        stringArray[24] = ConfigImpl.z(ConfigImpl.z("x3uW\r\\)iP\u0010R3u\u0011\"R0~\u0011"));
        var0 = null;
        stringArray[25] = ConfigImpl.z(ConfigImpl.z("Z8\u007f"));
        var0 = null;
        stringArray[26] = ConfigImpl.z(ConfigImpl.z("X3uW\r\\rpT\u001dH(tC\u0001\u0015,zB\u0017L3iU"));
        var0 = null;
        stringArray[27] = ConfigImpl.z(ConfigImpl.z("X3uW\r\\rpT\u001dH(tC\u0001\u0015,zB\u0017L3iUJT>}D\u0017X=oT\u0000"));
        var0 = null;
        stringArray[28] = ConfigImpl.z(ConfigImpl.z("z8vX\n\u0015/h]JP9bB\u0010T.~\u001f\u0014Z/hF\u000bI8"));
        var0 = null;
        stringArray[29] = ConfigImpl.z(ConfigImpl.z("o.z_\u0017K3iE(R/oT\n^.5B\u0017WrpT\u001dH(tC\u0001\u0015,zB\u0017L3iU"));
        var0 = null;
        stringArray[30] = ConfigImpl.z(ConfigImpl.z("z8vX\n\u0015/h]JP9bB\u0010T.~\u001f\u0014Z/hF\u000bI85^\u0006])hR\u0005O9\u007f"));
        var0 = null;
        stringArray[31] = ConfigImpl.z(ConfigImpl.z("o.z_\u0017K3iE(R/oT\n^.5B\u0017WrpT\u001dH(tC\u0001\u0015,zB\u0017L3iUJT>}D\u0017X=oT\u0000"));
        var0 = null;
        stringArray[32] = ConfigImpl.z(ConfigImpl.z("\u001b\u000bZbD"));
        var0 = null;
        stringArray[33] = ConfigImpl.z(ConfigImpl.z("I9k]\u0005X9"));
        z = stringArray;
        debug = null;
        var0 = null;
        className = ConfigImpl.z(ConfigImpl.z("X3v\u001f\rY15Z\u0001B1z_\u0003^.5R\u000bU:rVJx3uW\r\\\u0015vA\b"));
        configInstance = new ConfigImpl();
        configInMemory = new Hashtable(25);
        p = new Properties();
        fis = null;
        fos = null;
        configFile = null;
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x64);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 59;
                            break;
                        }
                        case 1: {
                            n7 = 92;
                            break;
                        }
                        case 2: {
                            n7 = 27;
                            break;
                        }
                        case 3: {
                            n7 = 49;
                            break;
                        }
                        default: {
                            n7 = 100;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }
}

