/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.help.IFilterableResource;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class FilterData {
    private Map criteria;
    HttpServletRequest request = null;
    private HttpSession session;
    private boolean cookiEnabled = true;
    private static final String DISABLE_FILTER = "disableFilter";
    public static final String CRITERIA = "criteria";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    public static final String ON = "on";
    private static final String HIDDEN = "hidden";
    private static final String OFF = "off";

    private FilterData(HttpSession session) {
        this.session = session;
        this.criteria = (Map)session.getAttribute("allCriterias");
    }

    public FilterData(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        Enumeration e;
        this.session = session;
        this.request = request;
        this.criteria = HelpPlugin.getFilterManager().getCriterias(UrlUtil.getLocale(request, response));
        Map map = this.criteria = this.criteria == null ? new HashMap(0) : this.criteria;
        if (session.getAttribute("filterTag") == null || session.getAttribute("allCriterias") != this.criteria) {
            session.setAttribute(CRITERIA, (Object)FilterData.cloneMap(this.criteria));
            session.setAttribute("allCriterias", (Object)this.criteria);
            session.setAttribute("filterTag", (Object)"filterTag");
        }
        if ((e = request.getParameterNames()).hasMoreElements()) {
            String disableFilter = request.getParameter(DISABLE_FILTER);
            if (FALSE.equals(disableFilter)) {
                String[] criterias = request.getParameterValues(CRITERIA);
                if (criterias == null) {
                    session.removeAttribute(CRITERIA);
                    return;
                }
                int criteriaAmount = criterias.length;
                HashMap<String, ArrayList<String>> criteria = new HashMap<String, ArrayList<String>>(criteriaAmount * 2);
                int i = 0;
                while (i < criteriaAmount) {
                    int index = criterias[i].indexOf(95);
                    String name = criterias[i].substring(0, index);
                    String value = criterias[i].substring(index + 1);
                    ArrayList<String> temp = (ArrayList<String>)criteria.get(name);
                    if (temp == null) {
                        temp = new ArrayList<String>(3);
                    }
                    temp.add(value);
                    criteria.put(name, temp);
                    ++i;
                }
                session.setAttribute(CRITERIA, criteria);
            } else if (TRUE.equals(disableFilter)) {
                session.removeAttribute(CRITERIA);
            }
        }
    }

    public Map getCriteria() {
        return this.criteria;
    }

    public boolean isSelected(String key, String value) {
        List temp;
        boolean selected = false;
        Map filter = (Map)this.session.getAttribute(CRITERIA);
        if (filter != null && (temp = (List)filter.get(key)) != null && temp.contains(value)) {
            selected = true;
        }
        return selected;
    }

    public boolean isSelected(String key) {
        boolean selected = false;
        Map filter = (Map)this.session.getAttribute(CRITERIA);
        if (filter != null) {
            List temp = (List)filter.get(key);
            selected = temp != null ? temp.containsAll((List)this.criteria.get(key)) : false;
        }
        return selected;
    }

    public boolean isPartSelected(String key) {
        List temp;
        boolean selected = false;
        Map filter = (Map)this.session.getAttribute(CRITERIA);
        if (filter != null && (temp = (List)filter.get(key)) != null && temp.size() > 0 && temp.size() < ((List)this.criteria.get(key)).size()) {
            selected = true;
        }
        return selected;
    }

    public boolean isFilterOn() {
        boolean isOn = false;
        try {
            Object temp;
            isOn = this.criteria != null ? !this.criteria.equals(temp = this.session.getAttribute(CRITERIA)) : false;
        }
        catch (Exception exception) {
            isOn = false;
        }
        return isOn;
    }

    public String getButtonState() {
        if (this.cookiEnabled && this.isFilterEnabled()) {
            return this.isFilterOn() ? ON : OFF;
        }
        return HIDDEN;
    }

    public boolean isFilterEnabled() {
        return HelpBasePlugin.getDefault().getPluginPreferences().getBoolean("filterEnable");
    }

    public String getButtonToolTip() {
        return this.isFilterOn() ? "filteropen" : "filterclose";
    }

    public static boolean isCriteriaFilterEnabled(HttpSession session) {
        return new FilterData(session).isFilterOn();
    }

    private static boolean filter(HashMap userFilter, HashMap topic) {
        boolean filter = false;
        if (userFilter != null) {
            if (!userFilter.keySet().containsAll(topic.keySet())) {
                return false;
            }
            Iterator keys = userFilter.keySet().iterator();
            while (keys.hasNext()) {
                filter = false;
                String key = (String)keys.next();
                Iterator values = ((List)userFilter.get(key)).iterator();
                List criterias = (List)topic.get(key);
                if (criterias != null) {
                    while (values.hasNext()) {
                        if (!criterias.contains(values.next())) continue;
                        filter = true;
                        break;
                    }
                } else {
                    filter = true;
                }
                if (!filter) break;
            }
        }
        return filter;
    }

    public static boolean filter(HttpSession session, IFilterableResource topic) {
        if (!FilterData.isCriteriaFilterEnabled(session)) {
            return true;
        }
        if (topic.getCriteria().keySet().isEmpty()) {
            return true;
        }
        return FilterData.filter((HashMap)session.getAttribute(CRITERIA), topic.getCriteria());
    }

    public static boolean filter(HttpSession session, HashMap topic) {
        if (!FilterData.isCriteriaFilterEnabled(session)) {
            return true;
        }
        if (topic == null || topic.keySet().isEmpty()) {
            return true;
        }
        return FilterData.filter((HashMap)session.getAttribute(CRITERIA), topic);
    }

    public boolean isFilterAvailable() {
        return this.criteria.size() > 0;
    }

    public static Map cloneMap(Map map) {
        HashMap temp = new HashMap(map.keySet().size() * 2);
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            temp.put(key, FilterData.copy((List)map.get(key)));
        }
        return temp;
    }

    private static List copy(List s) {
        int len = s.size();
        ArrayList<String> r = new ArrayList<String>(len);
        int i = 0;
        while (i < len) {
            r.add((String)s.get(i));
            ++i;
        }
        return r;
    }

    public boolean isCookiEnabled() {
        return this.cookiEnabled;
    }

    public void setCookiEnabled(boolean cookiEnabled) {
        this.cookiEnabled = cookiEnabled;
    }

    public boolean isOtherBrowserEnabled() {
        boolean enable = true;
        if (UrlUtil.isSafari(this.request) && "120".compareTo(UrlUtil.getSafariVersion(this.request)) <= 0) {
            enable = HelpBasePlugin.getDefault().getPluginPreferences().getBoolean("safariEnable");
        }
        return enable;
    }
}

