/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.index.IIndex;
import org.eclipse.help.internal.index.IIndexEntry;
import org.eclipse.help.internal.index.IIndexTopic;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class IndexData
extends ActivitiesData {
    private IIndex index;
    int entryIndex;
    Writer out;
    String indent;
    StringWriter funcOut;

    public IndexData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.loadIndex();
    }

    private void loadIndex() {
        this.index = HelpPlugin.getIndexManager().getIndex(this.getLocale());
    }

    public void generateHrefs(Writer out) throws IOException {
        out.write(this.funcOut.toString());
    }

    public void generateIndex(Writer out, String indent) throws IOException {
        this.out = out;
        this.entryIndex = 0;
        this.indent = indent;
        this.funcOut = new StringWriter();
        Iterator iter = this.index.getEntries().values().iterator();
        while (iter.hasNext()) {
            IIndexEntry entry = (IIndexEntry)iter.next();
            this.generateIndexEntry(entry, 0);
        }
    }

    private void generateIndexEntry(IIndexEntry entry, int depth) throws IOException {
        int rootEntryIndex = this.entryIndex;
        List topics = entry.getTopics();
        int size = topics.size();
        String label = entry.getKeyword();
        if (size == 1) {
            IIndexTopic topic = (IIndexTopic)topics.get(0);
            String href = UrlUtil.getHelpURL(topic.getHref());
            this.funcOut.write("case " + this.entryIndex + ": openTopic(\"" + href + "\"); break;\n");
        } else if (size == 0) {
            this.funcOut.write("case " + this.entryIndex + ": openTopic(\" indexNoTopic.jsp \"); break;\n");
        }
        String path = URLEncoder.encode(label, "UTF-8");
        this.out.write("<option value=\"" + rootEntryIndex + "\" id=\"" + path + "\">");
        int i = 0;
        while (i < depth) {
            this.out.write(this.indent);
            ++i;
        }
        this.out.write(String.valueOf(UrlUtil.htmlEncode(label)) + "</option>\n");
        ++this.entryIndex;
        Iterator iter = entry.getEntries().values().iterator();
        if (iter.hasNext()) {
            do {
                IIndexEntry childEntry = (IIndexEntry)iter.next();
                this.generateSubIndexEntry(childEntry, depth + 1, path, rootEntryIndex);
            } while (iter.hasNext());
        }
    }

    private void generateSubIndexEntry(IIndexEntry entry, int depth, String encodedPath, int rootEntryIndex) throws IOException {
        List topics = entry.getTopics();
        int size = topics.size();
        String label = entry.getKeyword();
        if (size == 1) {
            IIndexTopic topic = (IIndexTopic)topics.get(0);
            String href = UrlUtil.getHelpURL(topic.getHref());
            this.funcOut.write("case " + this.entryIndex + ": openTopic(\"" + href + "\"); break;\n");
        } else if (size == 0) {
            this.funcOut.write("case " + this.entryIndex + ": openTopic(\" indexNoTopic.jsp \"); break;\n");
        }
        String path = String.valueOf(encodedPath) + "," + URLEncoder.encode(label, "UTF-8");
        this.out.write("<option value=\"" + rootEntryIndex + "\" id=\"" + path + "\">");
        int i = 0;
        while (i < depth) {
            this.out.write(this.indent);
            ++i;
        }
        this.out.write(String.valueOf(UrlUtil.htmlEncode(label)) + "</option>\n");
        ++this.entryIndex;
        Iterator iter = entry.getEntries().values().iterator();
        if (iter.hasNext()) {
            do {
                IIndexEntry childEntry = (IIndexEntry)iter.next();
                this.generateSubIndexEntry(childEntry, depth + 1, path, rootEntryIndex);
            } while (iter.hasNext());
        }
    }

    public IIndexEntry getIndexEntry(String[] path) {
        Map entries = this.index.getEntries();
        IIndexEntry result = null;
        int i = 0;
        while (i < path.length) {
            try {
                result = (IIndexEntry)entries.get(URLDecoder.decode(path[i], "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            if (result == null) {
                return null;
            }
            entries = result.getEntries();
            ++i;
        }
        return result;
    }
}

