/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.IFilterableResource;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.INavigationElement;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.model.ITopicElement;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.FilterData;
import org.eclipse.help.internal.webapp.data.PrintType;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class PrintData
extends ActivitiesData {
    private boolean initialized = false;
    private boolean confirmed;
    String direction;
    private PrintType printType;
    private INavigationElement root;
    private String tocId = null;
    private int tocIdInt;
    private String topicId = null;
    private int[] rootPath = null;
    private int topicsGenerated = 0;
    private int topicsRequested = 0;

    public PrintData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.printType = PrintType.valueOf(request.getParameter("printType"));
        if (this.printType != null && this.initPrintPath()) {
            if (PrintType.SINGLE_TOPIC_PRINT.equals(this.printType)) {
                this.topicsRequested = 1;
            } else if (PrintType.SUB_TOPICS_PRINT.equals(this.printType)) {
                this.topicsRequested(this.root);
            }
            boolean isRTL = UrlUtil.isRTL(request, response);
            this.direction = isRTL ? "rtl" : "ltr";
            String confirmString = request.getParameter("confirmed");
            this.confirmed = confirmString != null && "true".equals(confirmString);
            this.initialized = true;
        }
    }

    private boolean initPrintPath() {
        int i;
        String id = this.request.getParameter("linkId");
        if (id == null || "".equals(id)) {
            return false;
        }
        int underline = id.indexOf("_");
        if (underline == -1) {
            underline = id.length();
        }
        this.tocId = id.substring(1, underline);
        this.topicId = underline < id.length() ? id.substring(underline + 1) : "";
        boolean parameterOK = true;
        try {
            this.tocIdInt = Integer.parseInt(this.tocId);
        }
        catch (NumberFormatException numberFormatException) {
            parameterOK = false;
        }
        if (parameterOK && this.topicId != null && this.topicId.length() > 0) {
            String[] paths = this.topicId.split("_", -1);
            this.rootPath = new int[paths.length];
            i = 0;
            while (i < paths.length) {
                try {
                    this.rootPath[i] = Integer.parseInt(paths[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    parameterOK = false;
                    break;
                }
                ++i;
            }
        }
        if (parameterOK) {
            ITocElement[] tocs = HelpPlugin.getTocManager().getTocs(this.getLocale());
            if (tocs != null && tocs.length > this.tocIdInt) {
                this.root = tocs[this.tocIdInt];
            } else {
                parameterOK = false;
                this.rootPath = null;
            }
            if (this.rootPath != null && this.rootPath.length > 0) {
                i = 0;
                while (i < this.rootPath.length) {
                    ITopicElement[] topics = this.getEnabledSubtopics(this.root);
                    if (this.rootPath[i] < 0 || this.rootPath[i] >= topics.length) {
                        parameterOK = false;
                        break;
                    }
                    this.root = topics[this.rootPath[i]];
                    ++i;
                }
            }
        }
        return parameterOK;
    }

    public void generateBreak(int topicPrinted) throws IOException {
        ServletOutputStream out = this.getResponse().getOutputStream();
        out.write(new String("<a name=\"ppt_" + topicPrinted + "\">").getBytes("UTF-8"));
        out.write(new String("<div class=\"breaker\"></div>").getBytes("UTF-8"));
        out.flush();
    }

    public void generateImageFile(String url) throws IOException {
        ServletOutputStream out = this.getResponse().getOutputStream();
        out.write(new String("<html>\n").getBytes("UTF-8"));
        out.write(new String("<body>\n").getBytes("UTF-8"));
        out.write(new String("<div dir=\"" + this.direction + "\">\n").getBytes("UTF-8"));
        out.write(new String("<img src=\"" + url + "\">\n").getBytes("UTF-8"));
        out.write(new String("</div>").getBytes("UTF-8"));
        out.write(new String("</body>\n").getBytes("UTF-8"));
        out.write(new String("</html>\n").getBytes("UTF-8"));
        out.flush();
    }

    public void generateTitle(INavigationElement elem, boolean supported) throws IOException {
        ServletOutputStream out = this.getResponse().getOutputStream();
        out.write(new String("<html>\n").getBytes("UTF-8"));
        out.write(new String("<body>\n").getBytes("UTF-8"));
        out.write(new String("<div dir=\"" + this.direction + "\">").getBytes("UTF-8"));
        out.write(new String("<h2>").getBytes("UTF-8"));
        if (elem instanceof ITocElement) {
            out.write(((ITocElement)elem).getLabel().getBytes("UTF-8"));
        } else if (elem instanceof ITopicElement) {
            out.write(UrlUtil.htmlEncode(((ITopicElement)elem).getLabel()).getBytes("UTF-8"));
        }
        out.write(new String("</h2>\n").getBytes("UTF-8"));
        if (!supported) {
            out.write(new String("<p>" + ServletResources.getString("print_not_support", this.request) + "</p>").getBytes("UTF-8"));
        }
        out.write(new String("</div>\n").getBytes("UTF-8"));
        out.write(new String("</body>\n").getBytes("UTF-8"));
        out.write(new String("</html>\n").getBytes("UTF-8"));
        out.flush();
    }

    public void generateToc() throws IOException {
        this.topicsGenerated = 0;
        HttpServletResponse resp = this.getResponse();
        resp.setContentType("text/html");
        ServletOutputStream out = resp.getOutputStream();
        out.write(new String("<html>\n").getBytes("UTF-8"));
        out.write(new String("<head>\n").getBytes("UTF-8"));
        out.write(new String("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>\n").getBytes("UTF-8"));
        out.write(new String("<title>").getBytes("UTF-8"));
        if (this.root instanceof ITocElement) {
            out.write(((ITocElement)this.root).getLabel().getBytes("UTF-8"));
        } else if (this.root instanceof ITopicElement) {
            out.write(UrlUtil.htmlEncode(((ITopicElement)this.root).getLabel()).getBytes("UTF-8"));
        }
        out.write(new String("</title>\n").getBytes("UTF-8"));
        out.write(new String("<link rel=\"stylesheet\" media=\"print\" href=\"advanced/print.css\" type=\"text/css\" />\n").getBytes("UTF-8"));
        out.write(new String("</head>\n").getBytes("UTF-8"));
        out.write(new String("<body>\n").getBytes("UTF-8"));
        out.write(new String("<H1 align='center'>" + ServletResources.getString("TableOfContents", this.getRequest()) + "</H1>").getBytes("UTF-8"));
        if (this.topicsGenerated < this.topicsRequested) {
            ITopicElement[] topics;
            ++this.topicsGenerated;
            out.write(new String("<p>&nbsp;</p>").getBytes("UTF-8"));
            out.write(new String("<ul dir=\"" + this.direction + "\">\n").getBytes("UTF-8"));
            out.write(new String("<li><b><a href=\"#ppt_" + this.topicsGenerated + "\">").getBytes("UTF-8"));
            if (this.root instanceof ITocElement) {
                out.write(((ITocElement)this.root).getLabel().getBytes("UTF-8"));
            } else if (this.root instanceof ITopicElement) {
                out.write(UrlUtil.htmlEncode(((ITopicElement)this.root).getLabel()).getBytes("UTF-8"));
            }
            out.write(new String("</a></b></li>\n").getBytes("UTF-8"));
            if (PrintType.SUB_TOPICS_PRINT.equals(this.printType) && (topics = this.getEnabledSubtopics(this.root)).length > 0) {
                out.write(new String("<ul class='expanded'>\n").getBytes("UTF-8"));
                int i = 0;
                while (i < topics.length) {
                    this.generateTopic(topics[i], (OutputStream)out);
                    ++i;
                }
                out.write(new String("</ul>\n").getBytes("UTF-8"));
            }
            out.write(new String("</ul>\n").getBytes("UTF-8"));
            out.write(new String("<p>&nbsp;</p>").getBytes("UTF-8"));
        }
        out.write(new String("</body>\n").getBytes("UTF-8"));
        out.write(new String("</html>\n").getBytes("UTF-8"));
        out.flush();
    }

    private void generateTopic(ITopicElement topic, OutputStream out) throws IOException {
        boolean hasNodes;
        ITopicElement[] topics;
        if (!FilterData.filter(this.request.getSession(), (IFilterableResource)topic)) {
            return;
        }
        if ((topic.getHref() == null || topic.getHref().length() == 0) && (topics = this.getFilteredSubtopics((INavigationElement)topic)).length == 0) {
            return;
        }
        if (this.topicsGenerated >= this.topicsRequested) {
            return;
        }
        ++this.topicsGenerated;
        topics = this.getEnabledSubtopics((INavigationElement)topic);
        boolean bl = hasNodes = topics.length > 0;
        if (hasNodes) {
            out.write(new String("<li><a href=\"#ppt_" + this.topicsGenerated + "\">").getBytes("UTF-8"));
            out.write(UrlUtil.htmlEncode(topic.getLabel()).getBytes("UTF-8"));
            out.write(new String("</a>\n").getBytes("UTF-8"));
            out.write(new String("<ul>\n").getBytes("UTF-8"));
            int i = 0;
            while (i < topics.length) {
                this.generateTopic(topics[i], out);
                ++i;
            }
            out.write(new String("</ul>\n").getBytes("UTF-8"));
        } else {
            out.write(new String("<li><a href=\"#ppt_" + this.topicsGenerated + "\">").getBytes("UTF-8"));
            out.write(UrlUtil.htmlEncode(topic.getLabel()).getBytes("UTF-8"));
            out.write(new String("</a>\n").getBytes("UTF-8"));
        }
        out.write(new String("</li>\n").getBytes("UTF-8"));
    }

    private List getEnabledSubtopicList(INavigationElement navigationElement) {
        List children = navigationElement.getChildren();
        ArrayList<INavigationElement> childTopics = new ArrayList<INavigationElement>(children.size());
        Iterator childrenIt = children.iterator();
        while (childrenIt.hasNext()) {
            INavigationElement c = (INavigationElement)childrenIt.next();
            if (c instanceof ITopicElement) {
                if ((((ITopicElement)c).getHref() == null || ((ITopicElement)c).getHref().length() <= 0) && this.getEnabledSubtopicList(c).size() <= 0) continue;
                childTopics.add(c);
                continue;
            }
            childTopics.addAll(this.getEnabledSubtopicList(c));
        }
        return childTopics;
    }

    public ITopicElement[] getEnabledSubtopics(INavigationElement navigationElement) {
        List topics = this.getEnabledSubtopicList(navigationElement);
        return topics.toArray(new ITopicElement[topics.size()]);
    }

    public PrintType getPrintType() {
        return this.printType;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public INavigationElement getRootElement() {
        return this.root;
    }

    public String getTocId() {
        return this.tocId;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public int getTopicsRequested() {
        return this.topicsRequested;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setTopicsRequested(int topicsRequested) {
        this.topicsRequested = topicsRequested;
    }

    private void topicsRequested(INavigationElement elem) {
        boolean hasNodes;
        ++this.topicsRequested;
        ITopicElement[] topics = this.getEnabledSubtopics(elem);
        boolean bl = hasNodes = topics.length > 0;
        if (hasNodes) {
            int i = 0;
            while (i < topics.length) {
                this.topicsRequested((INavigationElement)topics[i]);
                ++i;
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private ITopicElement[] getFilteredSubtopics(INavigationElement navigationElement) {
        List topics = this.getFilteredSubtopicList(navigationElement);
        return topics.toArray(new ITopicElement[topics.size()]);
    }

    private List getFilteredSubtopicList(INavigationElement navigationElement) {
        List children = navigationElement.getChildren();
        ArrayList<INavigationElement> childTopics = new ArrayList<INavigationElement>(children.size());
        Iterator childrenIt = children.iterator();
        while (childrenIt.hasNext()) {
            INavigationElement c = (INavigationElement)childrenIt.next();
            if (c instanceof ITopicElement) {
                if ((((ITopicElement)c).getHref() == null || ((ITopicElement)c).getHref().length() <= 0) && this.getFilteredSubtopicList(c).size() <= 0 || !FilterData.filter(this.request.getSession(), (IFilterableResource)((ITopicElement)c))) continue;
                childTopics.add(c);
                break;
            }
            childTopics.addAll(this.getFilteredSubtopicList(c));
        }
        return childTopics;
    }
}

