/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchProgressMonitor;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.FilterData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.TocData;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.WebappWorkingSetManager;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;

public class SearchData
extends ActivitiesData {
    private WebappWorkingSetManager wsmgr;
    private boolean percentageDisplay = false;
    private final String PERCENTAGE_DISPLAY = "percentageDisplay";
    private String topicHref;
    private String selectedTopicId = "";
    private String searchWord;
    private String group = "none";
    private String detail;
    private Iterator groupTypes;
    private String quickSearchTopicID;
    private String quickSearchTopicHref;
    private String workingSetName;
    SearchHit[] hits;
    private int indexCompletion = 100;
    private QueryTooComplexException queryException = null;
    private HashMap results;

    public SearchData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.setPercentageDisplay();
        this.wsmgr = new WebappWorkingSetManager(request, response, this.getLocale());
        this.topicHref = request.getParameter("topic");
        if (this.topicHref != null && this.topicHref.length() == 0) {
            this.topicHref = null;
        }
        this.searchWord = request.getParameter("searchWord");
        Map criterias = HelpPlugin.getFilterManager().getCriterias(this.getLocale());
        this.groupTypes = criterias != null ? HelpPlugin.getFilterManager().getCriterias(this.getLocale()).keySet().iterator() : new ArrayList(0).iterator();
        if (this.isQuickSearchRequest()) {
            this.quickSearchTopicID = request.getParameter("quickSearchTopicID");
            if (this.searchWord != null) {
                request.getSession().setAttribute("quickSearchWord", (Object)this.searchWord);
            }
        }
        if (this.isSearchRequest() && !this.isScopeRequest()) {
            this.loadSearchResults();
            if (this.queryException != null) {
                return;
            }
            if (!this.isProgressRequest()) {
                int i = 0;
                while (i < this.hits.length) {
                    if (this.hits[i].getHref().equals(this.topicHref)) {
                        this.selectedTopicId = "a" + i;
                        break;
                    }
                    ++i;
                }
            }
        }
        this.group = request.getParameter("group");
        if (this.group != null) {
            this.groupSearchResults();
        }
        this.detail = request.getParameter("detail");
    }

    public boolean isSearchRequest() {
        return this.request.getParameter("searchWord") != null;
    }

    public boolean isQuickSearchRequest() {
        return this.isSingleTopicSearch() || this.isSubTopicSearch();
    }

    public boolean isSingleTopicSearch() {
        return this.request.getParameter("singleTopicSearch") != null;
    }

    public boolean isSubTopicSearch() {
        return this.request.getParameter("subTopicsSearch") != null;
    }

    public String getQuickSearchTopicID() {
        if (this.quickSearchTopicID == null) {
            return "";
        }
        return this.quickSearchTopicID;
    }

    public boolean isProgressRequest() {
        return this.hits == null && this.indexCompletion != 100;
    }

    public boolean isScopeRequest() {
        return this.request.getParameter("workingSet") != null;
    }

    public int getResultsCount() {
        return this.hits.length;
    }

    public String getSelectedTopicId() {
        return this.selectedTopicId;
    }

    public String getTopicHref(int i) {
        return UrlUtil.getHelpURL(this.hits[i].getHref());
    }

    public String getTopicSummury(int i) {
        return UrlUtil.htmlEncode(this.hits[i].getSummary());
    }

    public String getTopicLabel(int i) {
        return UrlUtil.htmlEncode(this.hits[i].getLabel());
    }

    public String getTopicScore(int i) {
        try {
            float score = this.hits[i].getScore();
            NumberFormat percentFormat = NumberFormat.getPercentInstance(UrlUtil.getLocaleObj(this.request, this.response));
            return percentFormat.format(score);
        }
        catch (NumberFormatException numberFormatException) {
            return String.valueOf(this.hits[i].getScore());
        }
    }

    public String getTopicScore(SearchHit hit) {
        try {
            float score = hit.getScore();
            NumberFormat percentFormat = NumberFormat.getPercentInstance(UrlUtil.getLocaleObj(this.request, this.response));
            return percentFormat.format(score);
        }
        catch (NumberFormatException numberFormatException) {
            return String.valueOf(hit.getScore());
        }
    }

    public String getTopicTocLabel(int i) {
        if (this.hits[i].getToc() != null) {
            return UrlUtil.htmlEncode(this.hits[i].getToc().getLabel());
        }
        return "";
    }

    public boolean isEnabled(int i) {
        String href = this.hits[i].getHref();
        return HelpBasePlugin.getActivitySupport().isEnabledTopic(href, this.getLocale());
    }

    public boolean isFiltered(int i) {
        try {
            if (!this.isSubTopicSearch()) {
                return false;
            }
            return !FilterData.filter(this.request.getSession(), this.hits[i].getCriteria());
        }
        catch (Exception exception) {
            return true;
        }
    }

    public String getIndexedPercentage() {
        return String.valueOf(this.indexCompletion);
    }

    public String getSearchWord() {
        if (this.searchWord == null) {
            return "";
        }
        return this.searchWord;
    }

    public String getQuickSearchWord() {
        if (this.request.getSession().getAttribute("quickSearchWord") == null) {
            return "";
        }
        return this.request.getSession().getAttribute("quickSearchWord").toString();
    }

    public String[] getSelectedTocs() {
        String[] books = this.request.getParameterValues("scope");
        if (books == null) {
            TocData tocData = new TocData(this.context, this.request, this.response);
            books = new String[tocData.getTocCount()];
            int i = 0;
            while (i < books.length) {
                books[i] = tocData.getTocHref(i);
                ++i;
            }
        }
        return books;
    }

    public boolean isTocSelected(int toc) {
        TocData tocData = new TocData(this.context, this.request, this.response);
        String href = tocData.getTocHref(toc);
        String[] books = this.request.getParameterValues("scope");
        if (books == null) {
            return false;
        }
        int i = 0;
        while (i < books.length) {
            if (books[i].equals(href)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getScope() {
        if (this.workingSetName != null) {
            return this.workingSetName;
        }
        if (this.isScopeRequest()) {
            this.workingSetName = this.request.getParameter("workingSet");
        } else if (this.isSearchRequest()) {
            this.workingSetName = this.request.getParameter("scope");
            if (this.workingSetName == null) {
                this.workingSetName = this.request.getParameter("workingSet");
            }
        } else {
            this.workingSetName = this.getWorkingSets() == null || this.getWorkingSets().length == 0 ? ServletResources.getString("All", this.request) : this.wsmgr.getCurrentWorkingSet();
        }
        if (this.workingSetName == null || this.workingSetName.length() == 0 || this.getMode() == 1 && this.wsmgr.getWorkingSet(this.workingSetName) == null) {
            this.workingSetName = ServletResources.getString("All", this.request);
        }
        return this.workingSetName;
    }

    public void saveScope() {
        String workingSet = this.request.getParameter("scope");
        String lastWS = this.wsmgr.getCurrentWorkingSet();
        if (workingSet != null && !workingSet.equals(lastWS)) {
            this.wsmgr.setCurrentWorkingSet(workingSet);
        } else if (workingSet == null && lastWS != null && lastWS.length() > 0) {
            this.wsmgr.setCurrentWorkingSet("");
        }
    }

    private void loadSearchResults() {
        try {
            SearchProgressMonitor pm = SearchProgressMonitor.getProgressMonitor((String)this.getLocale());
            if (pm.isDone()) {
                this.indexCompletion = 100;
                SearchResults results = this.createHitCollector();
                BaseHelpSystem.getSearchManager().search(this.createSearchQuery(), (ISearchHitCollector)results, (IProgressMonitor)pm);
                this.hits = results.getSearchHits();
                if (this.hits == null) {
                    HelpWebappPlugin.logWarning("No search results returned.  Help index is in use.");
                } else {
                    if (this.isSubTopicSearch()) {
                        this.initCriteria();
                    }
                    this.filterResults();
                }
                return;
            }
            this.indexCompletion = pm.getPercentage();
            if (this.indexCompletion >= 100) {
                this.indexCompletion = 99;
            }
            return;
        }
        catch (QueryTooComplexException qe) {
            this.queryException = qe;
        }
        catch (Exception exception) {
            this.indexCompletion = 0;
        }
    }

    private ISearchQuery createSearchQuery() {
        String fieldSearchStr = this.request.getParameter("fieldSearch");
        boolean fieldSearch = fieldSearchStr != null ? new Boolean(fieldSearchStr) : false;
        return new SearchQuery(this.searchWord, fieldSearch, new ArrayList(), this.getLocale());
    }

    private SearchResults createHitCollector() {
        int maxHits = 500;
        String maxHitsStr = this.request.getParameter("maxHits");
        if (maxHitsStr != null) {
            try {
                int clientmaxHits = Integer.parseInt(maxHitsStr);
                if (clientmaxHits > 0 && clientmaxHits < 500) {
                    maxHits = clientmaxHits;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.isQuickSearchRequest()) {
            WorkingSet[] workingSets = this.createQuickWorkingSetByID(this.quickSearchTopicID);
            if (this.isSingleTopicSearch()) {
                return new SearchResults(workingSets, maxHits, this.getLocale(), this.quickSearchTopicHref);
            }
            return new SearchResults(workingSets, maxHits, this.getLocale());
        }
        WorkingSet[] workingSets = this.request.getParameterValues("scopedSearch") == null ? this.getWorkingSets() : this.createTempWorkingSets();
        return new SearchResults(workingSets, maxHits, this.getLocale());
    }

    private WorkingSet[] createQuickWorkingSetByID(String quickSearchTopicID) {
        ArrayList<Object> adaptableHelpResource = new ArrayList<Object>(1);
        if (quickSearchTopicID != null) {
            AdaptableHelpResource topic = null;
            ITocElement[] tocs = HelpPlugin.getTocManager().getTocs(this.getLocale());
            int tocid = Integer.parseInt(quickSearchTopicID.substring(1, 2));
            ITocElement toc = tocs[tocid];
            AdaptableToc adaptableToc = this.wsmgr.getAdaptableToc(toc.getHref());
            if (quickSearchTopicID.charAt(0) == 'b') {
                this.quickSearchTopicHref = adaptableToc.getTopic(null).getHref();
                adaptableHelpResource.add(adaptableToc);
            } else if (quickSearchTopicID.charAt(0) == 't') {
                String[] paths = quickSearchTopicID.split("_");
                int[] indexes = new int[paths.length - 1];
                boolean indexOK = true;
                int i = 0;
                while (i < indexes.length) {
                    try {
                        indexes[i] = Integer.parseInt(paths[i + 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        indexOK = false;
                        break;
                    }
                    ++i;
                }
                if (indexOK) {
                    AdaptableHelpResource[] topics = adaptableToc.getChildren();
                    int p = 0;
                    while (p < indexes.length) {
                        topic = topics[indexes[p]];
                        topics = topic.getChildren();
                        ++p;
                    }
                    this.quickSearchTopicHref = topic.getHref();
                    adaptableHelpResource.add(topic);
                }
            } else {
                return null;
            }
        }
        WorkingSet[] workingSets = new WorkingSet[]{new WorkingSet("QuickSearch", adaptableHelpResource)};
        return workingSets;
    }

    private WorkingSet[] getWorkingSets() {
        String[] scopes = this.request.getParameterValues("scope");
        if (scopes == null) {
            return null;
        }
        ArrayList<WorkingSet> workingSetCol = new ArrayList<WorkingSet>(scopes.length);
        int s = 0;
        while (s < scopes.length) {
            WorkingSet ws = this.wsmgr.getWorkingSet(scopes[s]);
            if (ws != null) {
                workingSetCol.add(ws);
            }
            ++s;
        }
        if (workingSetCol.size() == 0) {
            return null;
        }
        return workingSetCol.toArray(new WorkingSet[workingSetCol.size()]);
    }

    private WorkingSet[] createTempWorkingSets() {
        String[] scopes = this.request.getParameterValues("scope");
        if (scopes == null) {
            return new WorkingSet[0];
        }
        if (scopes.length == HelpPlugin.getTocManager().getTocs(this.getLocale()).length) {
            return null;
        }
        ArrayList<AdaptableToc> tocs = new ArrayList<AdaptableToc>(scopes.length);
        int s = 0;
        while (s < scopes.length) {
            AdaptableToc toc = this.wsmgr.getAdaptableToc(scopes[s]);
            if (toc != null) {
                tocs.add(toc);
            }
            ++s;
        }
        AdaptableToc[] adaptableTocs = tocs.toArray(new AdaptableToc[tocs.size()]);
        WorkingSet[] workingSets = new WorkingSet[]{this.wsmgr.createWorkingSet("temp", (AdaptableHelpResource[])adaptableTocs)};
        return workingSets;
    }

    public String getQueryExceptionMessage() {
        if (this.queryException == null) {
            return null;
        }
        return ServletResources.getString("searchTooComplex", this.request);
    }

    public boolean isPercentageDisplay() {
        return this.percentageDisplay;
    }

    public void setPercentageDisplay() {
        this.percentageDisplay = HelpBasePlugin.getDefault().getPluginPreferences().getBoolean("percentageDisplay");
    }

    private void groupSearchResults() {
        this.initCriteria();
        String Uncategorized = ServletResources.getString("Uncategorized", this.request);
        int len = this.hits.length;
        this.results = new HashMap();
        int i = 0;
        while (i < len) {
            List criteriaValues = (List)this.hits[i].getCriteria().get(this.group);
            if (criteriaValues != null) {
                Iterator values = criteriaValues.iterator();
                while (values.hasNext()) {
                    String value = (String)values.next();
                    ArrayList<SearchHit> hitsGroup = (ArrayList<SearchHit>)this.results.get(value);
                    if (hitsGroup == null) {
                        hitsGroup = new ArrayList<SearchHit>();
                    }
                    hitsGroup.add(this.hits[i]);
                    this.results.put(value, hitsGroup);
                }
            } else {
                ArrayList<SearchHit> hitsGroup = (ArrayList<SearchHit>)this.results.get(Uncategorized);
                if (hitsGroup == null) {
                    hitsGroup = new ArrayList<SearchHit>();
                }
                hitsGroup.add(this.hits[i]);
                this.results.put(Uncategorized, hitsGroup);
            }
            ++i;
        }
    }

    private void initCriteria() {
        int len = this.hits.length;
        int i = 0;
        while (i < len) {
            IToc toc = this.hits[i].getToc();
            String href = this.hits[i].getHref().substring(0, this.hits[i].getHref().indexOf("?"));
            HashMap criteria = null;
            if (toc != null) {
                ITopic temp = toc.getTopic(href);
                if (temp != null) {
                    criteria = temp.getCriteria();
                } else {
                    criteria = new HashMap(0);
                    HelpWebappPlugin.logError("invalid topic href", new NullPointerException());
                }
            } else {
                criteria = new HashMap(0);
            }
            this.hits[i].setCriteria(criteria);
            ++i;
        }
    }

    public HashMap getResults() {
        if (this.isSubTopicSearch()) {
            this.initCriteria();
        }
        return this.results;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDetail() {
        return this.detail;
    }

    public Iterator getGroupTypes() {
        return this.groupTypes;
    }

    public void filterResults() {
        ArrayList<SearchHit> tempResults = new ArrayList<SearchHit>();
        int len = this.hits.length;
        int i = 0;
        while (i < len) {
            if (FilterData.filter(this.request.getSession(), this.hits[i].getCriteria())) {
                tempResults.add(this.hits[i]);
            }
            ++i;
        }
        int resultLength = tempResults.size();
        this.hits = new SearchHit[resultLength];
        int i2 = 0;
        while (i2 < resultLength) {
            this.hits[i2] = (SearchHit)tempResults.get(i2);
            ++i2;
        }
    }

    public boolean isFilterEnabled() {
        return HelpBasePlugin.getDefault().getPluginPreferences().getBoolean("filterEnable");
    }
}

