/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.FilterData;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.ToolbarButton;

public class ToolbarData
extends RequestData {
    ToolbarButton[] buttons;
    private String contentToolbarTitle;

    public ToolbarData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.contentToolbarTitle = request.getParameter("contentToolbarTitle");
        this.loadButtons();
    }

    private void loadButtons() {
        String[] names = this.request.getParameterValues("name");
        String[] tooltips = this.request.getParameterValues("tooltip");
        String[] images = this.request.getParameterValues("image");
        String[] actions = this.request.getParameterValues("action");
        String[] states = this.request.getParameterValues("state");
        if (names == null || tooltips == null || images == null || actions == null || states == null || names.length != tooltips.length || names.length != images.length || names.length != actions.length || names.length != states.length) {
            this.buttons = new ToolbarButton[0];
            return;
        }
        ArrayList<ToolbarButton> buttonList = new ArrayList<ToolbarButton>();
        int i = 0;
        while (i < names.length) {
            if (!states[i].startsWith("hid")) {
                if ("".equals(names[i])) {
                    buttonList.add(new ToolbarButton());
                } else {
                    buttonList.add(new ToolbarButton(names[i], ServletResources.getString(tooltips[i], this.request), String.valueOf(this.preferences.getImagesDirectory()) + "/" + images[i], actions[i], "on".equalsIgnoreCase(states[i])));
                }
            }
            ++i;
        }
        if ((this.isIE() || this.isMozilla() && "1.2.1".compareTo(this.getMozillaVersion()) <= 0 || this.isSafari() && "120".compareTo(this.getSafariVersion()) <= 0) && !"print".equals(this.request.getParameter("toolbar"))) {
            buttonList.add(new ToolbarButton("maximize_restore", this.getMaximizeTooltip(), String.valueOf(this.preferences.getImagesDirectory()) + "/" + "maximize.gif", "restore_maximize", false));
        }
        this.buttons = buttonList.toArray(new ToolbarButton[buttonList.size()]);
    }

    public ToolbarButton[] getButtons() {
        return this.buttons;
    }

    public String getName() {
        if (this.request.getParameter("view") == null) {
            return "";
        }
        return this.request.getParameter("view");
    }

    public String getTitle() {
        if (this.request.getParameter("view") == null) {
            return "";
        }
        if ("toc".equalsIgnoreCase(this.request.getParameter("view"))) {
            return String.valueOf(ServletResources.getString(this.request.getParameter("view"), this.request)) + this.getMessage();
        }
        return ServletResources.getString(this.request.getParameter("view"), this.request);
    }

    public String getContentToolbarTitle() {
        return this.contentToolbarTitle;
    }

    public String getScript() {
        return this.request.getParameter("script");
    }

    public String getMaximizeImage() {
        return String.valueOf(this.preferences.getImagesDirectory()) + "/e_maximize.gif";
    }

    public String getRestoreImage() {
        return String.valueOf(this.preferences.getImagesDirectory()) + "/e_restore.gif";
    }

    public String getMaximizeTooltip() {
        return ServletResources.getString("maximize", this.request);
    }

    public String getRestoreTooltip() {
        return ServletResources.getString("restore", this.request);
    }

    private String getMessage() {
        StringBuffer message = new StringBuffer(20);
        message.append("&nbsp;");
        try {
            int i = 0;
            while (i < this.buttons.length) {
                if ("filter".equalsIgnoreCase(this.buttons[i].getName()) && this.buttons[i].isOn()) {
                    message.append("&nbsp;").append(this.buttons[i].getTooltip()).append(" : ");
                    HashMap userCriteria = (HashMap)this.request.getSession().getAttribute("criteria");
                    HashMap allCriterias = (HashMap)this.request.getSession().getAttribute("allCriterias");
                    if (allCriterias == null || allCriterias.isEmpty()) break;
                    if (userCriteria == null || userCriteria.isEmpty()) {
                        message.append(ServletResources.getString((String)allCriterias.keySet().iterator().next(), this.request)).append("...");
                        break;
                    }
                    HashMap allCriteriaCopy = (HashMap)FilterData.cloneMap(allCriterias);
                    Iterator keys = allCriterias.keySet().iterator();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        Object values = userCriteria.get(key);
                        if (values == null) continue;
                        ((List)allCriteriaCopy.get(key)).removeAll((List)values);
                    }
                    boolean firstTime = true;
                    Object[] ckeys = allCriteriaCopy.keySet().toArray();
                    int j = 0;
                    while (j < ckeys.length) {
                        String key = (String)ckeys[j];
                        if (((List)allCriteriaCopy.get(key)).size() > 0) {
                            if (firstTime) {
                                message.append(ServletResources.getString(key, this.request));
                                firstTime = false;
                            } else {
                                message.append("...");
                                break;
                            }
                        }
                        allCriteriaCopy.remove(key);
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            HelpWebappPlugin.logError("error in get filter message", e);
            message.append("Filter on");
        }
        return message.toString();
    }
}

