/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.Messages;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.configurator.UpdateURLDecoder;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.standalone.DisableCommand;
import org.eclipse.update.standalone.InstallCommand;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateBookData
extends ActivitiesData {
    private IConfiguredSite localSite;
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private String remoteSite;
    private int numOfsites;
    private String strDescription = null;
    private String lblVersion = null;
    private String[] selectedItems = null;
    private String[] selectedUpdates = null;
    private IFeatureReference[] remoteFeatures = null;
    private IFeatureReference[] localFeatures = null;
    private int finished = 0;
    protected String status = null;
    private int amount = 0;
    HttpSession session = null;
    HttpServletResponse response = null;
    HttpServletRequest request = null;
    protected boolean error = false;
    IFeatureReference currentFeature = null;
    private boolean canceled = false;
    public static int lock = 0;
    private FeatureStatus findingStatus = new FeatureStatus();

    public UpdateBookData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.session = request.getSession();
        this.response = response;
        this.request = request;
        try {
            this.initBundle();
            this.localSite = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites()[0];
            this.setNumOfsites();
            this.remoteSite = this.getSites();
        }
        catch (Exception e) {
            HelpWebappPlugin.logError("UpdateBookData init problem", e);
        }
    }

    private void initBundle() {
        this.strDescription = ServletResources.getString("featureDescription", this.request);
        this.lblVersion = ServletResources.getString("lblVersion", this.request);
    }

    private IFeatureReference[] filterFeatures(IFeatureReference[] inputFeatures) {
        return inputFeatures;
    }

    private List getExistFeatures(IFeatureReference[] localFeatures, IFeatureReference[] remoteFeatures) {
        boolean isMatch = false;
        ArrayList<IFeatureReference> filteredResult = new ArrayList<IFeatureReference>(localFeatures.length);
        try {
            int idx = 0;
            while (idx < remoteFeatures.length) {
                int j = 0;
                while (j < localFeatures.length) {
                    if (localFeatures[j].getVersionedIdentifier().getIdentifier().equals(remoteFeatures[idx].getVersionedIdentifier().getIdentifier())) {
                        isMatch = true;
                        if (!remoteFeatures[idx].getVersionedIdentifier().getVersion().isGreaterThan(localFeatures[j].getVersionedIdentifier().getVersion())) {
                            isMatch = false;
                            break;
                        }
                    }
                    ++j;
                }
                if (isMatch) {
                    filteredResult.add(remoteFeatures[idx]);
                }
                isMatch = false;
                ++idx;
            }
            return filteredResult;
        }
        catch (Exception e) {
            HelpWebappPlugin.logError("Error occur when get exist features", e);
            return filteredResult;
        }
    }

    private List getNewFeatures(IFeatureReference[] localFeatures, IFeatureReference[] remoteFeatures) {
        ArrayList<IFeatureReference> filteredResult = new ArrayList<IFeatureReference>(remoteFeatures.length);
        if (localFeatures.length == 0) {
            int i = 0;
            while (i < remoteFeatures.length) {
                filteredResult.add(remoteFeatures[i]);
                ++i;
            }
        } else {
            try {
                int idx = 0;
                while (idx < remoteFeatures.length) {
                    boolean noneExist = true;
                    int j = 0;
                    while (j < localFeatures.length) {
                        if (localFeatures[j].getVersionedIdentifier().getIdentifier().toString().equals(remoteFeatures[idx].getVersionedIdentifier().getIdentifier().toString())) {
                            noneExist = false;
                            break;
                        }
                        ++j;
                    }
                    if (noneExist) {
                        filteredResult.add(remoteFeatures[idx]);
                    }
                    ++idx;
                }
            }
            catch (Exception e) {
                HelpWebappPlugin.logError("Error occur when get new features", e);
                return null;
            }
        }
        return filteredResult;
    }

    public String getExistingDocs() {
        try {
            String label = null;
            this.localFeatures = this.filterFeatures(this.localSite.getFeatureReferences());
            StringBuffer strControl = new StringBuffer(300);
            String packageTip = ServletResources.getString("package_tip", this.request);
            String showDesc = ServletResources.getString("showdescription", this.request);
            if (this.localFeatures.length == 0) {
                return ServletResources.getString("noLocalFeature", this.request);
            }
            int f = 0;
            while (f < this.localFeatures.length) {
                label = this.localFeatures[f].getFeature((IProgressMonitor)new NullProgressMonitor()).getLabel();
                strControl.append("<li><img src='images/plus.gif' onClick='' class='collapsed' alt='").append(showDesc).append("' title='").append(showDesc).append("'><img src='images/point.gif' alt=''><img src='images/package.jpg' alt='");
                strControl.append(packageTip);
                strControl.append("' title='").append(packageTip).append("'><a id='" + f + "' href='javascript://needmodel' onkeydown=\"keyDownHandler(event.keyCode, this.parentNode.firstChild)\"'>");
                if (label == null || label == "") {
                    strControl.append(this.localFeatures[f].getVersionedIdentifier().getIdentifier());
                } else {
                    strControl.append(label);
                }
                label = null;
                strControl.append(" ").append(this.lblVersion).append(" ");
                strControl.append(this.localFeatures[f].getVersionedIdentifier().getVersion().toString()).append("</a>").append('\n');
                strControl.append("<ul class='collapsed'>");
                strControl.append("<li><img src='images/treeshow.gif' alt='").append(this.strDescription).append("' title='").append(this.strDescription).append("'><b>");
                strControl.append(this.strDescription);
                strControl.append(" </b>");
                strControl.append(this.localFeatures[f].getFeature((IProgressMonitor)new NullProgressMonitor()).getDescription().getAnnotation()).append("</li>");
                strControl.append("</ul></li>\n");
                ++f;
            }
            return strControl.toString();
        }
        catch (Exception ex) {
            HelpWebappPlugin.logError("Error occur when get exist docs", ex);
            return ServletResources.getString("listLocalFeatureError", this.request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareRemoteFeatures() throws IOException, CoreException {
        UpdateBookData updateBookData = this;
        synchronized (updateBookData) {
            if (this.remoteFeatures == null) {
                URL remoteUrl = new URL(UpdateURLDecoder.decode((String)this.remoteSite, (String)"UTF-8"));
                ISite remote = SiteManager.getSite((URL)remoteUrl, (IProgressMonitor)new NullProgressMonitor());
                this.remoteFeatures = this.filterFeatures((IFeatureReference[])remote.getFeatureReferences());
                if (this.remoteFeatures != null) {
                    int len = this.remoteFeatures.length;
                    this.findingStatus.setTotal(len);
                    int i = 0;
                    while (i < len) {
                        this.remoteFeatures[i].getFeature((IProgressMonitor)new FeatureMonitor());
                        this.findingStatus.setName(this.remoteFeatures[i].getName());
                        ++i;
                    }
                }
                this.session.setAttribute("remoteFeatures", (Object)this.remoteFeatures);
            } else {
                this.session.setAttribute("remoteFeatures", (Object)this.remoteFeatures);
            }
        }
    }

    public String generateNewFeaturesCb() throws IOException {
        try {
            URL remoteUrl = new URL(UpdateURLDecoder.decode((String)this.remoteSite, (String)"UTF-8"));
            if (this.remoteFeatures == null) {
                ISite remote = SiteManager.getSite((URL)remoteUrl, (IProgressMonitor)new NullProgressMonitor());
                this.remoteFeatures = this.filterFeatures((IFeatureReference[])remote.getFeatureReferences());
                this.session.setAttribute("remoteFeatures", (Object)this.remoteFeatures);
            }
            IFeatureReference[] localFeatures = this.filterFeatures(this.localSite.getFeatureReferences());
            List newFeatures = this.getNewFeatures(localFeatures, this.remoteFeatures);
            StringBuffer strControl = new StringBuffer(300);
            String label = null;
            if (newFeatures == null || newFeatures.size() == 0) {
                return "&nbsp;&nbsp;&nbsp;" + ServletResources.getString("noIntall", this.request);
            }
            String showDesc = ServletResources.getString("showdescription", this.request);
            String packageTip = ServletResources.getString("package_tip", this.request);
            Iterator features = newFeatures.iterator();
            while (features.hasNext()) {
                IFeatureReference feature = (IFeatureReference)features.next();
                label = feature.getFeature((IProgressMonitor)new NullProgressMonitor()).getLabel();
                strControl.append("<li><input onClick=\"isValid();\" type=\"checkbox\" onkeydown=\"keyDownHandler(event.keyCode, this.nextSibling)\" name=\"update_new\"");
                strControl.append(" id=\"");
                strControl.append(feature.getVersionedIdentifier().toString());
                strControl.append("\"");
                strControl.append(" value=\"");
                strControl.append(feature.getVersionedIdentifier().getIdentifier());
                strControl.append(" ");
                strControl.append(feature.getVersionedIdentifier().getVersion().toString());
                strControl.append("\"><img src='images/plus.gif' onClick='' class='collapsed' alt='").append(showDesc).append("' title='").append(showDesc).append("'><img src='images/point.gif' alt=''><img src='images/package.jpg' alt='");
                strControl.append(packageTip);
                strControl.append("' title='").append(packageTip).append("')>");
                strControl.append("<label for='");
                strControl.append(feature.getVersionedIdentifier().toString());
                strControl.append("'>");
                if (label == null || label == "") {
                    strControl.append(feature.getVersionedIdentifier().getIdentifier());
                } else {
                    strControl.append(label);
                }
                label = null;
                strControl.append(" ").append(this.lblVersion).append(" ");
                strControl.append(feature.getVersionedIdentifier().getVersion().toString());
                strControl.append("</label>\n");
                strControl.append("<ul class='collapsed'>");
                strControl.append("<li><img src='images/treeshow.gif' alt='").append(this.strDescription).append("' title='").append(this.strDescription).append("'><b>");
                strControl.append(this.strDescription);
                strControl.append(" </b>");
                strControl.append(feature.getFeature((IProgressMonitor)new NullProgressMonitor()).getDescription().getAnnotation()).append("</li>");
                strControl.append("</ul></li>");
            }
            return strControl.toString();
        }
        catch (Exception e) {
            HelpWebappPlugin.logError("Control genetate problem in get new features from server", e);
            this.response.sendRedirect("updateSite.jsp?code=conTimeout");
            return "";
        }
    }

    public String generateExistFeaturesCb() throws IOException {
        try {
            URL remoteUrl = new URL(UpdateURLDecoder.decode((String)this.remoteSite, (String)"UTF-8"));
            if (this.remoteFeatures == null) {
                ISite remote = SiteManager.getSite((URL)remoteUrl, (IProgressMonitor)new NullProgressMonitor());
                this.remoteFeatures = this.filterFeatures((IFeatureReference[])remote.getFeatureReferences());
                this.session.setAttribute("remoteFeatures", (Object)this.remoteFeatures);
            }
            this.localFeatures = this.filterFeatures(this.localSite.getFeatureReferences());
            List existFeatures = this.getExistFeatures(this.localFeatures, this.remoteFeatures);
            StringBuffer strControl = new StringBuffer(300);
            String label = null;
            if (existFeatures == null || existFeatures.size() == 0) {
                return "&nbsp;&nbsp;&nbsp;" + ServletResources.getString("noUpdate", this.request);
            }
            String showDesc = ServletResources.getString("showdescription", this.request);
            String packageTip = ServletResources.getString("package_tip", this.request);
            Iterator features = existFeatures.iterator();
            while (features.hasNext()) {
                IFeatureReference feature = (IFeatureReference)features.next();
                label = feature.getFeature((IProgressMonitor)new NullProgressMonitor()).getLabel();
                strControl.append("<li>");
                strControl.append("<input onClick=\"isValid();\" type=\"checkbox\" onkeydown=\"keyDownHandler(event.keyCode, this.nextSibling)\" name=\"update_exist\"");
                strControl.append(" id=\"");
                strControl.append(feature.getVersionedIdentifier().toString());
                strControl.append("\"");
                strControl.append(" value=\"");
                strControl.append(feature.getVersionedIdentifier().getIdentifier());
                strControl.append(" ");
                strControl.append(feature.getVersionedIdentifier().getVersion().toString());
                strControl.append("\"><img src='images/plus.gif' onClick='' class='collapsed' alt='").append(showDesc).append("' title='").append(showDesc).append("'><img src='images/point.gif' alt=''><img src='images/package.jpg' alt='");
                strControl.append(packageTip);
                strControl.append("' title='").append(packageTip).append("'>");
                strControl.append("<label for='");
                strControl.append(feature.getVersionedIdentifier().toString());
                strControl.append("'>");
                if (label == null || label == "") {
                    strControl.append(feature.getVersionedIdentifier().getIdentifier());
                } else {
                    strControl.append(label);
                }
                label = null;
                strControl.append(" ").append(this.lblVersion).append(" ");
                strControl.append(feature.getVersionedIdentifier().getVersion().toString());
                strControl.append("</label>");
                strControl.append("<ul class='collapsed'>");
                strControl.append("<li><img src='images/treeshow.gif' alt='").append(this.strDescription).append("' title='").append(this.strDescription).append("'><b>");
                strControl.append(this.strDescription);
                strControl.append(" </b>");
                strControl.append(feature.getFeature((IProgressMonitor)new NullProgressMonitor()).getDescription().getAnnotation()).append("</li>");
                strControl.append("</ul></li>");
            }
            return strControl.toString();
        }
        catch (Exception e) {
            HelpWebappPlugin.logError("Control genetate problem in get new features list from server", e);
            this.response.sendRedirect("updateSite.jsp?code=conTimeout");
            return "";
        }
    }

    public IConfiguredSite getLocalSite() {
        return this.localSite;
    }

    public String getRemoteSite() {
        return this.remoteSite;
    }

    public List getUniqueFeatures(String[] input) {
        ArrayList<String> tempList = new ArrayList<String>();
        String[] splitted = null;
        int idx = 0;
        while (idx < input.length) {
            splitted = input[idx].split(" ");
            if (!tempList.contains(splitted[0])) {
                tempList.add(splitted[0]);
            }
            ++idx;
        }
        return tempList;
    }

    public List getFeatureVersions(String feature, String[] featuresWithVersion) throws Exception {
        ArrayList<String> tempList = new ArrayList<String>();
        String[] splitted = null;
        int idx = 0;
        while (idx < featuresWithVersion.length) {
            splitted = featuresWithVersion[idx].split(" ");
            if (splitted[0].equals(feature)) {
                tempList.add(splitted[1]);
            }
            ++idx;
        }
        return tempList;
    }

    public boolean installItem(String id, String version) {
        try {
            this.currentFeature = this.getCurrentFeature(id, version);
            String localPath = this.localSite.getSite().getURL().getPath();
            InstallCommand dc = new InstallCommand(id, version, this.remoteSite, localPath, "false");
            PluginMonitor monitor = new PluginMonitor();
            monitor.setCanceled(this.canceled);
            this.session.setAttribute("monitor", (Object)monitor);
            if (!dc.run((IProgressMonitor)monitor)) {
                this.error = true;
                return false;
            }
        }
        catch (Exception e) {
            HelpWebappPlugin.logError("installation problem", e);
        }
        return true;
    }

    private IFeatureReference getCurrentFeature(String id, String version) {
        try {
            IFeatureReference currentFeature = null;
            this.remoteFeatures = (IFeatureReference[])this.session.getAttribute("remoteFeatures");
            int i = 0;
            while (i < this.remoteFeatures.length) {
                if (this.remoteFeatures[i].getVersionedIdentifier().getIdentifier().equalsIgnoreCase(id) && this.remoteFeatures[i].getVersionedIdentifier().getVersion().equals((Object)new PluginVersionIdentifier(version))) {
                    currentFeature = this.remoteFeatures[i];
                    break;
                }
                ++i;
            }
            return currentFeature;
        }
        catch (Exception e) {
            HelpWebappPlugin.logError("error when get local features", e);
            return null;
        }
    }

    public boolean isFinished() {
        return this.finished == 1;
    }

    public String getStatus() {
        return this.status;
    }

    public void uninstallItem(String id, String version) {
        try {
            String localPath = this.localSite.toString().substring(6);
            DisableCommand dc = new DisableCommand(id, version, localPath, "false");
            dc.run();
        }
        catch (Exception e) {
            HelpWebappPlugin.logError("uninstallation problem", e);
            return;
        }
    }

    public boolean updateItem(String feature, List versions) {
        try {
            IFeature[] features = UpdateBookData.searchSite(feature, this.localSite, false);
            int idx = 0;
            while (idx < features.length) {
                this.localSite.unconfigure(features[idx]);
                ++idx;
            }
            Iterator vIt = versions.iterator();
            while (vIt.hasNext()) {
                if (this.installItem(feature, (String)vIt.next())) continue;
                return false;
            }
        }
        catch (Exception e) {
            HelpWebappPlugin.logError("installation problem", e);
            return false;
        }
        return true;
    }

    public static IFeature[] searchSite(String featureId, IConfiguredSite site, boolean onlyConfigured) throws CoreException {
        Object[] references = null;
        references = onlyConfigured ? site.getConfiguredFeatures() : site.getSite().getFeatureReferences();
        Vector<IFeature> result = new Vector<IFeature>();
        int i = 0;
        while (i < references.length) {
            IFeature feature = references[i].getFeature(null);
            String id = feature.getVersionedIdentifier().getIdentifier();
            if (featureId.equals(id)) {
                result.add(feature);
            }
            ++i;
        }
        return result.toArray(new IFeature[result.size()]);
    }

    public String printSuccessDownloads(String[] featuresWithVersion) {
        StringBuffer strResult = new StringBuffer(300);
        String showDes = ServletResources.getString("showdescription", this.request);
        String packageTip = ServletResources.getString("package_tip", this.request);
        IFeatureReference[] localFeatures = this.filterFeatures(this.localSite.getFeatureReferences());
        String label = null;
        try {
            int idx = 0;
            while (idx < featuresWithVersion.length) {
                String[] splitted = featuresWithVersion[idx].split(" ");
                int j = 0;
                while (j < localFeatures.length) {
                    if (localFeatures[j].getVersionedIdentifier().getIdentifier().equals(splitted[0]) && localFeatures[j].getVersionedIdentifier().getVersion().toString().equals(splitted[1])) {
                        label = localFeatures[j].getFeature((IProgressMonitor)new NullProgressMonitor()).getLabel();
                        strResult.append("<li>");
                        strResult.append("<img src='images/plus.gif' onClick='' class='collapsed' alt='").append(showDes).append("' title='").append(showDes).append("'><img src='images/point.gif' alt=''><img src='images/package.jpg' alt='");
                        strResult.append(packageTip);
                        strResult.append("' title= '").append(packageTip).append("'><a id='" + j + "' href='javascript://needmodel'  onkeydown=\"keyDownHandler(event.keyCode, this.parentNode.firstChild)\">");
                        if (label == null || label == "") {
                            strResult.append(localFeatures[j].getVersionedIdentifier().getIdentifier());
                        } else {
                            strResult.append(label);
                        }
                        label = null;
                        strResult.append(" ").append(this.lblVersion).append(" ");
                        strResult.append(localFeatures[j].getVersionedIdentifier().getVersion().toString()).append("</a>").append("\n");
                        strResult.append("<ul class='collapsed'>\n");
                        strResult.append("<li><img src='images/treeshow.gif' alt='").append(this.strDescription).append("' title='").append(this.strDescription).append("'><b>");
                        strResult.append(this.strDescription);
                        strResult.append(" </b>");
                        strResult.append(localFeatures[j].getFeature((IProgressMonitor)new NullProgressMonitor()).getDescription().getAnnotation()).append("</li>\n");
                        strResult.append("</ul></li>\n");
                    }
                    ++j;
                }
                ++idx;
            }
            return strResult.toString();
        }
        catch (Exception e) {
            HelpWebappPlugin.logError("Control generation problem", e);
            return ServletResources.getString("listDownloadFeatureError", this.request);
        }
    }

    public String getSites() throws IOException {
        try {
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            Document doc = parser.parse("./" + this.getPluginLocation() + "bookmarks.xml");
            Element root = doc.getDocumentElement();
            NodeList list = root.getChildNodes();
            int nodesAmount = list.getLength();
            int idx = 0;
            while (idx < nodesAmount) {
                Node node = list.item(idx);
                if (node.getNodeType() == 1) {
                    NamedNodeMap map = list.item(idx).getAttributes();
                    return map.getNamedItem("url").getNodeValue();
                }
                ++idx;
            }
            return null;
        }
        catch (Exception e) {
            HelpWebappPlugin.logError("site load problem", e);
            return null;
        }
    }

    public boolean testSite() {
        try {
            URL ul = new URL(this.remoteSite);
            URLConnection uc = ul.openConnection();
            uc.connect();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getNumOfsites() {
        return this.numOfsites;
    }

    public void setNumOfsites() {
        try {
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            Document doc = parser.parse("./" + this.getPluginLocation() + "bookmarks.xml");
            Element root = doc.getDocumentElement();
            NodeList list = root.getChildNodes();
            this.numOfsites = list.getLength();
        }
        catch (Exception exception) {
            this.numOfsites = 1;
        }
    }

    public void applyChange() {
        OperationsManager.applyChangesNow();
    }

    public String getPluginLocation() {
        try {
            HelpWebappPlugin temp = HelpWebappPlugin.getDefault();
            Bundle teb = temp.getBundle();
            String fullStr = teb.getLocation();
            return fullStr.substring(fullStr.indexOf("@") + 1);
        }
        catch (Exception exception) {
            return "plugins/org.eclipse.help.webapp_3.1.0/";
        }
    }

    public void prepare(HttpSession session) {
        session.setAttribute("finding", (Object)"true");
        new Preparer(this, session).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean finishUpdate(HttpSession session) {
        DocumentBuilderFactory documentBuilderFactory = UpdateBookData.documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            if (lock != 0) {
                return false;
            }
            lock = 1;
        }
        new Downloader(this, session).start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void doUpdate(HttpSession session) {
        try {
            try {
                UpdateBookData updateBookData = this;
                synchronized (updateBookData) {
                    block19: {
                        if (session.getAttribute("update_new") == null) {
                            this.selectedUpdates = (String[])session.getAttribute("update_exist");
                            this.finished -= this.selectedUpdates.length;
                            ++this.finished;
                            List filteredUpdates = this.getUniqueFeatures(this.selectedUpdates);
                            Iterator updates = filteredUpdates.iterator();
                            while (true) {
                                if (!updates.hasNext()) {
                                    this.applyChange();
                                    break block19;
                                }
                                String update = (String)updates.next();
                                if (this.updateItem(update, this.getFeatureVersions(update, this.selectedUpdates))) continue;
                                this.error = true;
                            }
                        }
                        if (session.getAttribute("update_exist") == null) {
                            this.selectedItems = (String[])session.getAttribute("update_new");
                            this.finished -= this.selectedItems.length;
                            ++this.finished;
                            int idx = 0;
                            while (true) {
                                if (idx >= this.selectedItems.length) {
                                    this.applyChange();
                                    break block19;
                                }
                                String[] strItem = this.selectedItems[idx].split(" ");
                                if (!this.installItem(strItem[0], strItem[1])) {
                                    this.error = true;
                                }
                                ++idx;
                            }
                        }
                        this.selectedItems = (String[])session.getAttribute("update_new");
                        this.selectedUpdates = (String[])session.getAttribute("update_exist");
                        this.finished -= this.selectedUpdates.length;
                        this.finished -= this.selectedItems.length;
                        ++this.finished;
                        int idx = 0;
                        while (true) {
                            if (idx >= this.selectedItems.length) break;
                            String[] strItem = this.selectedItems[idx].split(" ");
                            if (!this.installItem(strItem[0], strItem[1])) {
                                this.error = true;
                            }
                            ++idx;
                        }
                        List filteredUpdates = this.getUniqueFeatures(this.selectedUpdates);
                        Iterator updates = filteredUpdates.iterator();
                        while (true) {
                            if (!updates.hasNext()) {
                                this.applyChange();
                                break;
                            }
                            String update = (String)updates.next();
                            if (this.updateItem(update, this.getFeatureVersions(update, this.selectedUpdates))) continue;
                            this.error = true;
                        }
                    }
                    this.canceled = false;
                    session.removeAttribute("filterTag");
                }
            }
            catch (Exception e) {
                HelpWebappPlugin.logError("error in install", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_15 = null;
            lock = 0;
            throw throwable;
        }
        {
            Object var7_16 = null;
            lock = 0;
            return;
        }
    }

    public String[] getSelectedItems() {
        return this.selectedItems;
    }

    public String[] getSelectedUpdates() {
        return this.selectedUpdates;
    }

    public static void initSession(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        if (request.getParameterValues("update_new") == null && request.getParameterValues("update_exist") == null) {
            try {
                response.sendRedirect("updateComplete.jsp?status=completeNoneUpdate");
            }
            catch (IOException ioe) {
                HelpWebappPlugin.logError("error when redirect to error page", ioe);
            }
        } else if (request.getParameterValues("update_new") == null) {
            String[] selectedUpdates = request.getParameterValues("update_exist");
            session.setAttribute("update_exist", (Object)selectedUpdates);
        } else if (request.getParameterValues("update_exist") == null) {
            String[] selectedItems = request.getParameterValues("update_new");
            session.setAttribute("update_new", (Object)selectedItems);
        } else {
            String[] selectedUpdates = request.getParameterValues("update_exist");
            String[] selectedItems = request.getParameterValues("update_new");
            session.setAttribute("update_new", (Object)selectedItems);
            session.setAttribute("update_exist", (Object)selectedUpdates);
        }
    }

    public int getFinished() {
        return this.finished;
    }

    public int getAmount() {
        if (this.amount == 0) {
            if (this.selectedItems == null) {
                this.selectedItems = (String[])this.session.getAttribute("update_new");
            }
            if (this.selectedUpdates == null) {
                this.selectedUpdates = (String[])this.session.getAttribute("update_exist");
            }
            if (this.selectedItems != null) {
                this.amount += this.selectedItems.length;
            }
            if (this.selectedUpdates != null) {
                this.amount += this.selectedUpdates.length;
            }
        }
        return this.amount;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void cancelInstall() {
        this.canceled = true;
        PluginMonitor monitor = (PluginMonitor)((Object)this.session.getAttribute("monitor"));
        if (monitor != null) {
            monitor.setCanceled(this.canceled);
        }
        this.cleanSession();
    }

    public static HttpSession getSession() {
        return (HttpSession)HelpWebappPlugin.getDefault().getManagerSession();
    }

    public static void setSession(HttpSession session) {
        HelpWebappPlugin.getDefault().setManagerSession(session);
    }

    public IFeatureReference[] getRemoteFeatures() {
        return this.remoteFeatures;
    }

    public void initData(HttpServletResponse response, HttpServletRequest request) {
        this.response = response;
        this.request = request;
    }

    public FeatureStatus getFindingStatus() {
        return this.findingStatus;
    }

    public void cleanSession() {
        this.session.removeAttribute("currentpage");
        this.session.removeAttribute("findingdata");
        this.session.removeAttribute("process");
        this.session.removeAttribute("amountgif");
        this.session.removeAttribute("update_new");
        this.session.removeAttribute("update_exist");
        this.session.removeAttribute("errorinprepare");
        this.session.removeAttribute("remoteFeatures");
    }

    public static String getLog() {
        String s = "";
        try {
            s = System.getProperty("osgi.logfile");
        }
        catch (Exception exception) {
            s = "eclipse/workspace/.metadata/.log";
        }
        return s;
    }

    public class PluginMonitor
    extends NullProgressMonitor {
        private String download = Messages.FeatureContentProvider_Downloading.substring(0, Messages.FeatureContentProvider_Downloading.length() - 1);
        private String bytes = Messages.InstallMonitor_DownloadSizeLong;
        private String firstSp = "";
        private String secondSp = "";
        private char bracket = this.bytes.charAt(0);
        private int totalwork = 0;
        private int currentwork = 0;
        private int workload = 0;

        PluginMonitor() {
            this.firstSp = this.bytes.substring(this.bytes.indexOf(125) + 1, this.bytes.lastIndexOf(123));
            this.secondSp = this.bytes.substring(this.bytes.lastIndexOf(125) + 1, this.bytes.length() - 1);
            try {
                this.totalwork = UpdateBookData.this.currentFeature.getFeature((IProgressMonitor)new NullProgressMonitor()).getPluginEntryCount();
            }
            catch (Exception e) {
                HelpWebappPlugin.logError("error when count plugins of feature", e);
            }
        }

        public void beginTask(String name, int totalWork) {
            this.workload = 100 / UpdateBookData.this.getAmount();
        }

        public void subTask(String name) {
            UpdateBookData.this.status = name;
            try {
                if (name.indexOf(this.firstSp) != -1) {
                    int totalK;
                    String current = name.substring(name.indexOf(this.bracket) + 1, name.indexOf(this.firstSp));
                    String total = name.substring(name.indexOf(this.firstSp) + this.firstSp.length(), name.lastIndexOf(this.secondSp));
                    int currentK = Integer.parseInt(current);
                    if (currentK != (totalK = Integer.parseInt(total))) {
                        int gifamount = (UpdateBookData.this.getAmount() + UpdateBookData.this.finished - 1) * this.workload + this.workload * (this.currentwork - 1) / this.totalwork;
                        UpdateBookData.this.session.setAttribute("amountgif", (Object)new Integer(gifamount += this.workload / this.totalwork * currentK / totalK));
                    }
                }
            }
            catch (Exception exception) {}
        }

        public void done() {
            UpdateBookData updateBookData = UpdateBookData.this;
            updateBookData.finished = updateBookData.finished + 1;
            int gifamount = 100 * (UpdateBookData.this.getAmount() + UpdateBookData.this.finished - 1) / UpdateBookData.this.getAmount();
            UpdateBookData.this.session.setAttribute("amountgif", (Object)new Integer(gifamount));
        }

        public void setTaskName(String name) {
            UpdateBookData.this.status = name;
            if (name.indexOf(this.download) != -1) {
                int gifamount = (UpdateBookData.this.getAmount() + UpdateBookData.this.finished - 1) * this.workload + this.workload * this.currentwork / this.totalwork;
                UpdateBookData.this.session.setAttribute("amountgif", (Object)new Integer(gifamount));
                ++this.currentwork;
            }
        }
    }

    public class FeatureMonitor
    extends NullProgressMonitor {
        FeatureMonitor() {
        }

        public void beginTask(String name, int totalWork) {
            UpdateBookData.this.findingStatus.setCurrent(UpdateBookData.this.findingStatus.getCurrent() + 1);
        }
    }

    private class Downloader
    extends Thread {
        UpdateBookData data = null;
        HttpSession session = null;

        Downloader(UpdateBookData data, HttpSession session) {
            this.data = data;
            this.session = session;
        }

        public void run() {
            this.data.doUpdate(this.session);
        }
    }

    private class Preparer
    extends Thread {
        UpdateBookData data = null;
        HttpSession session = null;

        Preparer(UpdateBookData data, HttpSession session) {
            this.data = data;
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                UpdateBookData updateBookData = this.data;
                synchronized (updateBookData) {
                    this.data.prepareRemoteFeatures();
                }
            }
            catch (Exception e) {
                this.session.setAttribute("errorinprepare", (Object)"true");
                HelpWebappPlugin.logError("error when finding updates", e);
            }
        }
    }

    public class FeatureStatus {
        private int total = 0;
        private int current = 0;
        private String name = "";

        public int getCurrent() {
            return this.current;
        }

        public void setCurrent(int current) {
            this.current = current;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }
    }
}

