/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.util.TString;

public class UrlUtil {
    private static final String[] invalidXML = new String[]{"&", ">", "<", "\""};
    private static final String[] escapedXML = new String[]{"&amp;", "&gt;", "&lt;", "&quot;"};
    static final Pattern safariPatern = Pattern.compile("Safari/(\\d+)(?:\\.|\\s|$)", 2);
    private static String defaultLocale;
    private static Collection locales;
    private static final int INFOCENTER_DIRECTION_BY_LOCALE = 1;
    private static final int INFOCENTER_DIRECTION_LTR = 2;
    private static final int INFOCENTER_DIRECTION_RTL = 3;
    private static int infocenterDirection;

    static {
        infocenterDirection = 1;
    }

    public static String JavaScriptEncode(String str) {
        char[] wordChars = new char[str.length()];
        str.getChars(0, str.length(), wordChars, 0);
        StringBuffer jsEncoded = new StringBuffer();
        int j = 0;
        while (j < wordChars.length) {
            char unicode = wordChars[j];
            if ('A' <= unicode && unicode <= 'Z' || 'a' <= unicode && unicode <= 'z') {
                jsEncoded.append(wordChars[j]);
            } else {
                String charInHex = Integer.toString(unicode, 16).toUpperCase();
                switch (charInHex.length()) {
                    case 1: {
                        jsEncoded.append("\\u000").append(charInHex);
                        break;
                    }
                    case 2: {
                        jsEncoded.append("\\u00").append(charInHex);
                        break;
                    }
                    case 3: {
                        jsEncoded.append("\\u0").append(charInHex);
                        break;
                    }
                    default: {
                        jsEncoded.append("\\u").append(charInHex);
                    }
                }
            }
            ++j;
        }
        return jsEncoded.toString();
    }

    public static String htmlEncode(String str) {
        int i = 0;
        while (i < invalidXML.length) {
            str = TString.change((String)str, (String)invalidXML[i], (String)escapedXML[i]);
            ++i;
        }
        return str;
    }

    public static boolean isLocalRequest(HttpServletRequest request) {
        String reqIP = request.getRemoteAddr();
        if ("127.0.0.1".equals(reqIP)) {
            return true;
        }
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            InetAddress[] addr = InetAddress.getAllByName(hostname);
            int i = 0;
            while (i < addr.length) {
                if (addr[i].getHostAddress().equals(reqIP)) {
                    return true;
                }
                ++i;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public static String getHelpURL(String url) {
        if (url == null || url.length() == 0) {
            url = "about:blank";
        } else if (!url.startsWith("http:/") && !url.startsWith("https:/")) {
            url = url.startsWith("file:/") || url.startsWith("jar:file:/") ? "../topic/" + url : "../topic" + url;
        }
        return url;
    }

    public static String getPrintFileURL(String url) {
        if ((url = UrlUtil.getHelpURL(url)).startsWith("../")) {
            url = url.substring(3);
        }
        return url;
    }

    public static String getPrintBaseURL(String url) {
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        url = "topic/" + url.substring(0, url.lastIndexOf("/") + 1);
        return url;
    }

    public static boolean isBot(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        return (agent = agent.toLowerCase(Locale.ENGLISH)).indexOf("bot") >= 0 || agent.indexOf("crawl") >= 0 || request.getParameter("bot") != null;
    }

    public static boolean isGecko(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        return (agent = agent.toLowerCase(Locale.ENGLISH)).indexOf("gecko/") >= 0;
    }

    public static boolean isIE(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        if ((agent = agent.toLowerCase(Locale.ENGLISH)).startsWith("bobby/")) {
            return true;
        }
        return agent.indexOf("msie") >= 0;
    }

    public static String getIEVersion(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return "0";
        }
        if ((agent = agent.toLowerCase(Locale.ENGLISH)).startsWith("bobby/")) {
            return "5.5";
        }
        int start = agent.indexOf("msie ") + "msie ".length();
        if (start < "msie ".length() || start >= agent.length()) {
            return "0";
        }
        int end = agent.indexOf(";", start);
        if (end <= start) {
            return "0";
        }
        return agent.substring(start, end);
    }

    public static boolean isKonqueror(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        return (agent = agent.toLowerCase(Locale.ENGLISH)).indexOf("konqueror") >= 0;
    }

    public static boolean isMozilla(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        return (agent = agent.toLowerCase(Locale.ENGLISH)).indexOf("mozilla/5") >= 0;
    }

    public static String getMozillaVersion(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return "0";
        }
        if ((agent = agent.toLowerCase(Locale.ENGLISH)).indexOf("mozilla/5") < 0) {
            return "0";
        }
        int start = agent.indexOf("rv:") + "rv:".length();
        if (start < "rv:".length() || start >= agent.length()) {
            return "0";
        }
        int end = agent.indexOf(")", start);
        if (end <= start) {
            return "0";
        }
        return agent.substring(start, end);
    }

    public static boolean isOpera(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        return (agent = agent.toLowerCase(Locale.ENGLISH)).indexOf("opera") >= 0;
    }

    public static boolean isSafari(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        return (agent = agent.toLowerCase(Locale.ENGLISH)).indexOf("safari/") >= 0;
    }

    public static String getSafariVersion(HttpServletRequest request) {
        String version = "0";
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            return version;
        }
        Matcher m = safariPatern.matcher(agent = agent.toLowerCase(Locale.ENGLISH));
        boolean matched = m.find();
        if (matched) {
            version = m.group(1);
            while (version.length() < 3) {
                version = "0" + version;
            }
        }
        return version;
    }

    public static Locale getLocaleObj(HttpServletRequest request, HttpServletResponse response) {
        String localeStr = UrlUtil.getLocale(request, response);
        return UrlUtil.getLocale(localeStr);
    }

    public static Locale getLocale(String localeStr) {
        if (localeStr.length() >= 5) {
            return new Locale(localeStr.substring(0, 2), localeStr.substring(3, 5));
        }
        if (localeStr.length() >= 2) {
            return new Locale(localeStr.substring(0, 2), "");
        }
        return Locale.getDefault();
    }

    public static String getLocale(HttpServletRequest request, HttpServletResponse response) {
        if (defaultLocale == null) {
            UrlUtil.initializeNL();
        }
        if (BaseHelpSystem.getMode() != 1 || request == null) {
            return defaultLocale;
        }
        String forcedLocale = UrlUtil.getForcedLocale(request, response);
        if (forcedLocale != null) {
            String ll;
            if (locales == null) {
                return forcedLocale;
            }
            if (locales.contains(forcedLocale)) {
                return forcedLocale;
            }
            if (forcedLocale.length() > 2 && locales.contains(ll = forcedLocale.substring(0, 2))) {
                return ll;
            }
        }
        if (locales == null) {
            return request.getLocale().toString();
        }
        Enumeration e = request.getLocales();
        while (e.hasMoreElements()) {
            String ll;
            String ll_CC;
            String locale = ((Locale)e.nextElement()).toString();
            if (locale.length() >= 5 && locales.contains(ll_CC = locale.substring(0, 5))) {
                return ll_CC;
            }
            if (locale.length() < 2 || !locales.contains(ll = locale.substring(0, 2))) continue;
            return ll;
        }
        return defaultLocale;
    }

    private static String getForcedLocale(HttpServletRequest request, HttpServletResponse response) {
        String forcedLocale = request.getParameter("lang");
        if (forcedLocale != null) {
            if (response != null) {
                Cookie cookieTest = new Cookie("lang", forcedLocale);
                response.addCookie(cookieTest);
            }
        } else {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                int c = 0;
                while (c < cookies.length) {
                    if ("lang".equals(cookies[c].getName())) {
                        forcedLocale = cookies[c].getValue();
                        break;
                    }
                    ++c;
                }
            }
        }
        if (forcedLocale != null) {
            if (forcedLocale.length() >= 5) {
                forcedLocale = String.valueOf(forcedLocale.substring(0, 2)) + "_" + forcedLocale.substring(3, 5);
            } else if (forcedLocale.length() >= 2) {
                forcedLocale = forcedLocale.substring(0, 2);
            }
        }
        return forcedLocale;
    }

    private static synchronized void initializeNL() {
        if (defaultLocale != null) {
            return;
        }
        UrlUtil.initializeLocales();
        if (BaseHelpSystem.getMode() == 1) {
            UrlUtil.initializeIcDirection();
        }
    }

    private static void initializeLocales() {
        defaultLocale = Platform.getNL();
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault().toString();
        }
        if (BaseHelpSystem.getMode() != 1) {
            return;
        }
        ArrayList<String> infocenterLocales = null;
        String[] args = Platform.getCommandLineArgs();
        boolean localeOption = false;
        int i = 0;
        while (i < args.length) {
            if ("-locales".equalsIgnoreCase(args[i])) {
                localeOption = true;
                infocenterLocales = new ArrayList<String>();
            } else if (args[i].startsWith("-")) {
                localeOption = false;
            } else if (localeOption) {
                infocenterLocales.add(args[i]);
            }
            ++i;
        }
        if (infocenterLocales == null) {
            StringTokenizer tokenizer = new StringTokenizer(HelpBasePlugin.getDefault().getPluginPreferences().getString("locales"), " ,\t");
            while (tokenizer.hasMoreTokens()) {
                if (infocenterLocales == null) {
                    infocenterLocales = new ArrayList();
                }
                infocenterLocales.add(tokenizer.nextToken());
            }
        }
        if (infocenterLocales != null) {
            locales = new HashSet(10, 0.4f);
            Iterator it = infocenterLocales.iterator();
            while (it.hasNext()) {
                String locale = (String)it.next();
                if (locale.length() >= 5) {
                    locales.add(String.valueOf(locale.substring(0, 2).toLowerCase(Locale.ENGLISH)) + "_" + locale.substring(3, 5).toUpperCase(Locale.ENGLISH));
                    continue;
                }
                if (locale.length() < 2) continue;
                locales.add(locale.substring(0, 2).toLowerCase(Locale.ENGLISH));
            }
        }
    }

    private static void initializeIcDirection() {
        String orientation = System.getProperty("eclipse.orientation");
        if ("rtl".equals(orientation)) {
            infocenterDirection = 3;
            return;
        }
        if ("ltr".equals(orientation)) {
            infocenterDirection = 2;
            return;
        }
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if ("-dir".equalsIgnoreCase(args[i])) {
                if (i + 1 < args.length && "rtl".equalsIgnoreCase(args[i + 1])) {
                    infocenterDirection = 3;
                    return;
                }
                infocenterDirection = 2;
                return;
            }
            ++i;
        }
    }

    public static boolean isRTL(HttpServletRequest request, HttpServletResponse response) {
        if (BaseHelpSystem.getMode() != 1) {
            return BaseHelpSystem.isRTL();
        }
        if (infocenterDirection == 3) {
            return true;
        }
        if (infocenterDirection == 2) {
            return false;
        }
        String locale = UrlUtil.getLocale(request, response);
        return locale.startsWith("ar") || locale.startsWith("fa") || locale.startsWith("he") || locale.startsWith("iw") | locale.startsWith("ur");
    }

    public static boolean isHighlight(HttpServletRequest request, HttpServletResponse response) {
        String isHighlightStr = request.getParameter("ishighlight");
        if (isHighlightStr != null) {
            if (response != null) {
                Cookie cookieHL = new Cookie("ishighlight", isHighlightStr);
                response.addCookie(cookieHL);
            }
        } else {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                int c = 0;
                while (c < cookies.length) {
                    if ("ishighlight".equals(cookies[c].getName())) {
                        isHighlightStr = cookies[c].getValue();
                        break;
                    }
                    ++c;
                }
            }
        }
        if (isHighlightStr == null) {
            return true;
        }
        boolean isHighlight = Boolean.valueOf(isHighlightStr) != false || request.getParameter("singleTopicSearch") != null;
        return isHighlight;
    }
}

