/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import com.ibm.watson.commons.html.wrapper.RobustHTMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.help.internal.webapp.servlet.ContentFile;

public class HTMLParser {
    public static boolean transferContent(InputStream inputStream, OutputStream out, String baseURL) throws IOException {
        int n;
        int k;
        int len = inputStream.available();
        byte[] b = new byte[len];
        for (n = 0; (k = inputStream.read(b, n, len - n)) >= 0 && n != len; n += k) {
        }
        if (n != len) {
            return false;
        }
        ContentFile contentFile = new ContentFile(new String(b, "UTF-8"));
        List chunks = RobustHTMLParser.parse((String)contentFile.getContent());
        StringBuffer output = new StringBuffer();
        int pieceNumber = chunks.size();
        int i = 0;
        while (i < pieceNumber) {
            RobustHTMLParser.Chunk chunk = (RobustHTMLParser.Chunk)chunks.get(i);
            if (!(chunk instanceof RobustHTMLParser.CommentTag || chunk instanceof RobustHTMLParser.Tag && "script".equals(((RobustHTMLParser.Tag)chunk).getTag()))) {
                if (chunk instanceof RobustHTMLParser.OpenTag && !HTMLParser.filterOpenTag((RobustHTMLParser.OpenTag)chunk, baseURL, contentFile)) {
                    return false;
                }
                output.append(chunk.toString());
            }
            ++i;
        }
        out.write(output.toString().getBytes("UTF-8"));
        return true;
    }

    private static boolean filterOpenTag(RobustHTMLParser.OpenTag tag, String baseURL, ContentFile contentFile) {
        String tagName = tag.getTag();
        if ("html".equals(tagName)) {
            String rtl = (String)tag.getParams().get("dir");
            if (rtl != null) {
                contentFile.setRTL(rtl.equalsIgnoreCase("RTL"));
                tag.getParams().remove("dir");
            }
        } else if ("body".equals(tagName)) {
            tag.getParams().remove("onload");
            if (tag.getParams().get("dir") == null) {
                Map params = tag.getParams();
                params.put("dir", contentFile.isRTL() ? "rtl" : "ltr");
                tag.setParams(params);
            }
        } else {
            String value;
            if ("frameset".equals(tagName)) {
                return false;
            }
            if ("img".equals(tagName)) {
                Map params = tag.getParams();
                String url = (String)params.get("src");
                if (url != null && url.indexOf(":") == -1) {
                    params.put("src", String.valueOf(baseURL) + url);
                }
            } else if ("a".equals(tagName) || "link".equals(tagName)) {
                Map params = tag.getParams();
                String url = (String)params.get("href");
                if (url != null && url.indexOf(":") == -1) {
                    params.put("href", String.valueOf(baseURL) + url);
                }
            } else if ("meta".equals(tagName) && (value = (String)tag.getParams().get("http-equiv")) != null && "refresh".equals(value)) {
                return false;
            }
        }
        return true;
    }
}

