/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.IFilterableResource;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.model.INavigationElement;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.model.ITopicElement;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.FilterData;
import org.eclipse.help.internal.webapp.data.PrintData;
import org.eclipse.help.internal.webapp.data.PrintType;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.EclipseConnector;

public class PrintServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Object lock = new Object();
    private static final int defaultMaxConnections = 50;
    private static final int defaultMaxTopics = 100;
    private static Set images;
    private static int allowedMaxConnections;
    private static int allowedMaxTopics;
    private EclipseConnector connector;

    public void init() throws ServletException {
        Preferences pref = HelpBasePlugin.getDefault().getPluginPreferences();
        String imageFormats = pref.getString("image");
        String[] formats = imageFormats.split("_");
        images = new HashSet(formats.length);
        int i = 0;
        while (i < formats.length) {
            images.add(formats[i]);
            ++i;
        }
        String maxConnections = pref.getString("maxConnections");
        if (maxConnections != null && "".equals(maxConnections.trim())) {
            allowedMaxConnections = 50;
        } else {
            try {
                allowedMaxConnections = Integer.parseInt(maxConnections);
            }
            catch (NumberFormatException e) {
                HelpWebappPlugin.logError("Init maxConnections error. Set to default.", e);
                allowedMaxConnections = 50;
            }
        }
        String maxTopics = pref.getString("maxTopics");
        if (maxTopics != null && "".equals(maxTopics.trim())) {
            allowedMaxTopics = 100;
        } else {
            try {
                allowedMaxTopics = Integer.parseInt(maxTopics);
            }
            catch (NumberFormatException e) {
                HelpWebappPlugin.logError("Init maxTopics error. Set to default.", e);
                allowedMaxTopics = 100;
            }
        }
        try {
            this.connector = new EclipseConnector(this.getServletContext());
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        this.process(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object object = lock;
        synchronized (object) {
            if (allowedMaxConnections <= 0) {
                RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/advanced/printError.jsp");
                req.setAttribute("msg", (Object)"noConnection");
                rd.forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            --allowedMaxConnections;
        }
        PrintData data = new PrintData(this.getServletContext(), req, resp);
        if (data == null || !data.isInitialized()) {
            Object rd = lock;
            synchronized (rd) {
                ++allowedMaxConnections;
                lock.notifyAll();
            }
            rd = this.getServletContext().getRequestDispatcher("/advanced/printError.jsp");
            req.setAttribute("msg", (Object)"illegalParameter");
            rd.forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (data.getTopicsRequested() > allowedMaxTopics && !data.isConfirmed()) {
            Object rd = lock;
            synchronized (rd) {
                ++allowedMaxConnections;
                lock.notifyAll();
            }
            rd = this.getServletContext().getRequestDispatcher("/advanced/printConfirm.jsp");
            req.setAttribute("topicsRequested", (Object)String.valueOf(data.getTopicsRequested()));
            req.setAttribute("allowedMaxTopics", (Object)String.valueOf(allowedMaxTopics));
            rd.forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (data.getTopicsRequested() > allowedMaxTopics) {
            data.setTopicsRequested(allowedMaxTopics);
        }
        try {
            INavigationElement root;
            data.generateToc();
            if (this.connector != null && (root = data.getRootElement()) != null) {
                if (PrintType.SINGLE_TOPIC_PRINT.equals(data.getPrintType()) && allowedMaxTopics > 0) {
                    if (root instanceof ITocElement) {
                        this.printContent(root, ((ITocElement)root).getTopic(null).getHref(), data, 1);
                    } else if (root instanceof ITopicElement) {
                        this.printContent(root, ((ITopicElement)root).getHref(), data, 1);
                    }
                } else if (PrintType.SUB_TOPICS_PRINT.equals(data.getPrintType())) {
                    int topicPrinted = 0;
                    if (root instanceof ITocElement) {
                        this.printToc((ITocElement)root, data, topicPrinted);
                    } else if (root instanceof ITopicElement) {
                        this.printTopics((ITopicElement)root, data, topicPrinted);
                    }
                }
            }
        }
        catch (IOException iOException) {
            Object root = lock;
            synchronized (root) {
                ++allowedMaxConnections;
                lock.notifyAll();
            }
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/advanced/printError.jsp");
            req.setAttribute("msg", (Object)"ioException");
            rd.forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        catch (Exception exception) {
            HelpWebappPlugin.logWarning("Print is terminated by an exception.");
        }
        Object object2 = lock;
        synchronized (object2) {
            ++allowedMaxConnections;
            lock.notifyAll();
        }
    }

    private int printToc(ITocElement toc, PrintData data, int topicPrinted) throws IOException {
        if (topicPrinted < allowedMaxTopics) {
            boolean hasNodes;
            this.printContent((INavigationElement)toc, toc.getTopic(null).getHref(), data, ++topicPrinted);
            ITopicElement[] topics = data.getEnabledSubtopics((INavigationElement)toc);
            boolean bl = hasNodes = topics.length > 0;
            if (hasNodes) {
                int i = 0;
                while (i < topics.length) {
                    topicPrinted = this.printTopics(topics[i], data, topicPrinted);
                    ++i;
                }
            }
        }
        return topicPrinted;
    }

    private int printTopics(ITopicElement elem, PrintData data, int topicPrinted) throws IOException {
        ITopicElement[] topics;
        if (!FilterData.filter(data.getRequest().getSession(), (IFilterableResource)elem)) {
            return topicPrinted;
        }
        if ((elem.getHref() == null || elem.getHref().length() == 0) && (topics = this.getFilteredSubtopics((INavigationElement)elem, data)).length == 0) {
            return topicPrinted;
        }
        if (topicPrinted < allowedMaxTopics) {
            boolean hasNodes;
            this.printContent((INavigationElement)elem, elem.getHref(), data, ++topicPrinted);
            topics = data.getEnabledSubtopics((INavigationElement)elem);
            boolean bl = hasNodes = topics.length > 0;
            if (hasNodes) {
                int i = 0;
                while (i < topics.length) {
                    topicPrinted = this.printTopics(topics[i], data, topicPrinted);
                    ++i;
                }
            }
        }
        return topicPrinted;
    }

    private void printContent(INavigationElement elem, String url, PrintData data, int topicPrinted) throws IOException {
        data.generateBreak(topicPrinted);
        if (url == null || "".equals(url)) {
            data.generateTitle(elem, true);
        } else if (url.startsWith("http:/") || url.startsWith("https:/")) {
            data.generateTitle(elem, false);
        } else {
            int pos = url.indexOf("#");
            if (pos > 0) {
                url = url.substring(0, pos);
            }
            if ((pos = url.indexOf("?")) > 0) {
                url = url.substring(0, pos);
            }
            boolean supported = false;
            String extension = url.substring(url.lastIndexOf(".") + 1, url.length()).toLowerCase(Locale.ENGLISH);
            if (extension != null) {
                if ("htm".equals(extension) || "html".equals(extension)) {
                    supported = this.connector.transfer(data.getRequest(), data.getResponse(), url);
                } else if (images.contains(extension)) {
                    data.generateImageFile(UrlUtil.getPrintFileURL(url));
                    supported = true;
                }
            }
            if (!supported) {
                data.generateTitle(elem, supported);
            }
        }
    }

    private ITopicElement[] getFilteredSubtopics(INavigationElement navigationElement, PrintData data) {
        List topics = this.getFilteredSubtopicList(navigationElement, data);
        return topics.toArray(new ITopicElement[topics.size()]);
    }

    private List getFilteredSubtopicList(INavigationElement navigationElement, PrintData data) {
        List children = navigationElement.getChildren();
        ArrayList<INavigationElement> childTopics = new ArrayList<INavigationElement>(children.size());
        Iterator childrenIt = children.iterator();
        while (childrenIt.hasNext()) {
            INavigationElement c = (INavigationElement)childrenIt.next();
            if (c instanceof ITopicElement) {
                if ((((ITopicElement)c).getHref() == null || ((ITopicElement)c).getHref().length() <= 0) && this.getFilteredSubtopicList(c, data).size() <= 0 || !FilterData.filter(data.getRequest().getSession(), (IFilterableResource)((ITopicElement)c))) continue;
                childTopics.add(c);
                break;
            }
            childTopics.addAll(this.getFilteredSubtopicList(c, data));
        }
        return childTopics;
    }
}

