/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth;

import com.ibm.security.auth.PolicyParser;
import com.ibm.security.auth.PrincipalComparator;
import com.ibm.security.util.Debug;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.security.auth.Subject;

class SubjectCodeSource
extends CodeSource
implements Serializable {
    private static final long serialVersionUID = 6138559213707284907L;
    private static final ResourceBundle rb = (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return ResourceBundle.getBundle("com.ibm.security.util.AuthResources");
        }
    });
    private Subject subject;
    private LinkedList principals;
    private static final Class[] PARAMS = new Class[]{String.class};
    private static final Debug debug = Debug.getInstance("auth", "\t[Auth Access]");
    private ClassLoader sysClassLoader;

    SubjectCodeSource(Subject subject, LinkedList linkedList, URL uRL, Certificate[] certificateArray) {
        super(uRL, certificateArray);
        this.subject = subject;
        this.principals = linkedList == null ? new LinkedList() : new LinkedList(linkedList);
        this.sysClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    LinkedList getPrincipals() {
        return this.principals;
    }

    Subject getSubject() {
        return this.subject;
    }

    public boolean implies(CodeSource codeSource) {
        LinkedList<PolicyParser.PrincipalEntry> linkedList = null;
        if (codeSource == null || !(codeSource instanceof SubjectCodeSource) || !super.implies(codeSource)) {
            if (debug != null) {
                debug.println("\tSubjectCodeSource.implies: FAILURE 1");
            }
            return false;
        }
        SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
        if (this.principals == null) {
            if (debug != null) {
                debug.println("\tSubjectCodeSource.implies: PASS 1");
            }
            return true;
        }
        if (subjectCodeSource.getSubject() == null || subjectCodeSource.getSubject().getPrincipals().size() == 0) {
            if (debug != null) {
                debug.println("\tSubjectCodeSource.implies: FAILURE 2");
            }
            return false;
        }
        ListIterator listIterator = this.principals.listIterator(0);
        while (listIterator.hasNext()) {
            Object object;
            Object object2;
            PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)listIterator.next();
            try {
                Class<?> clazz = Class.forName(principalEntry.principalClass, true, this.sysClassLoader);
                object2 = clazz.getConstructor(PARAMS);
                object = (PrincipalComparator)((Constructor)object2).newInstance(principalEntry.principalName);
                if (!object.implies(subjectCodeSource.getSubject())) {
                    if (debug != null) {
                        debug.println("\tSubjectCodeSource.implies: FAILURE 3");
                    }
                    return false;
                }
                if (debug != null) {
                    debug.println("\tSubjectCodeSource.implies: PASS 2");
                }
                return true;
            }
            catch (Exception exception) {
                if (linkedList == null) {
                    if (subjectCodeSource.getSubject() == null) {
                        if (debug != null) {
                            debug.println("\tSubjectCodeSource.implies: FAILURE 4");
                        }
                        return false;
                    }
                    object2 = subjectCodeSource.getSubject().getPrincipals().iterator();
                    linkedList = new LinkedList<PolicyParser.PrincipalEntry>();
                    while (object2.hasNext()) {
                        object = (Principal)object2.next();
                        PolicyParser.PrincipalEntry principalEntry2 = new PolicyParser.PrincipalEntry(object.getClass().getName(), object.getName());
                        linkedList.add(principalEntry2);
                    }
                }
                if (this.subjectListImpliesPrincipalEntry(linkedList, principalEntry)) continue;
                if (debug != null) {
                    debug.println("\tSubjectCodeSource.implies: FAILURE 5");
                }
                return false;
            }
        }
        if (debug != null) {
            debug.println("\tSubjectCodeSource.implies: PASS 3");
        }
        return true;
    }

    private boolean subjectListImpliesPrincipalEntry(LinkedList linkedList, PolicyParser.PrincipalEntry principalEntry) {
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            PolicyParser.PrincipalEntry principalEntry2 = (PolicyParser.PrincipalEntry)listIterator.next();
            if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !principalEntry.principalClass.equals(principalEntry2.principalClass) || !principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME") && !principalEntry.principalName.equals(principalEntry2.principalName)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SubjectCodeSource)) {
            return false;
        }
        SubjectCodeSource subjectCodeSource = (SubjectCodeSource)object;
        try {
            if (this.getSubject() != subjectCodeSource.getSubject()) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        if (this.principals == null && subjectCodeSource.principals != null || this.principals != null && subjectCodeSource.principals == null) {
            return false;
        }
        return this.principals == null || subjectCodeSource.principals == null || this.principals.containsAll(subjectCodeSource.principals) && subjectCodeSource.principals.containsAll(this.principals);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        Object object;
        String string = super.toString();
        if (this.getSubject() != null) {
            if (debug != null) {
                object = this.getSubject();
                string = string + "\n" + AccessController.doPrivileged(new PrivilegedAction((Subject)object){
                    final /* synthetic */ Subject val$finalSubject;
                    {
                        this.val$finalSubject = subject;
                    }

                    public Object run() {
                        return this.val$finalSubject.toString();
                    }
                });
            } else {
                string = string + "\n" + this.getSubject().toString();
            }
        }
        if (this.principals != null) {
            object = this.principals.listIterator();
            while (object.hasNext()) {
                PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)object.next();
                string = string + rb.getString("\n") + principalEntry.principalClass + " " + principalEntry.principalName;
            }
        }
        return string;
    }
}

