/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.bootstrap;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.ProviderException;

abstract class DigestBase
extends MessageDigestSpi
implements Cloneable {
    private final byte[] oneByte = new byte[1];
    private final String algorithm;
    private final int digestLength;
    private final int blockSize;
    private final byte[] buffer;
    private int bufOfs;
    long bytesProcessed;
    static final byte[] padding = new byte[136];

    DigestBase(String string, int n, int n2) {
        this.algorithm = string;
        this.digestLength = n;
        this.blockSize = n2;
        this.buffer = new byte[n2];
    }

    DigestBase(DigestBase digestBase) {
        this.algorithm = digestBase.algorithm;
        this.digestLength = digestBase.digestLength;
        this.blockSize = digestBase.blockSize;
        this.buffer = (byte[])digestBase.buffer.clone();
        this.bufOfs = digestBase.bufOfs;
        this.bytesProcessed = digestBase.bytesProcessed;
    }

    protected final int engineGetDigestLength() {
        return this.digestLength;
    }

    protected final void engineUpdate(byte by) {
        this.oneByte[0] = by;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    protected final void engineUpdate(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (this.bytesProcessed < 0L) {
            this.engineReset();
        }
        this.bytesProcessed += (long)n2;
        if (this.bufOfs != 0) {
            int n3 = Math.min(n2, this.blockSize - this.bufOfs);
            System.arraycopy(byArray, n, this.buffer, this.bufOfs, n3);
            this.bufOfs += n3;
            n += n3;
            n2 -= n3;
            if (this.bufOfs >= this.blockSize) {
                this.implCompress(this.buffer, 0);
                this.bufOfs = 0;
            }
        }
        while (n2 >= this.blockSize) {
            this.implCompress(byArray, n);
            n2 -= this.blockSize;
            n += this.blockSize;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, 0, n2);
            this.bufOfs = n2;
        }
    }

    protected final void engineReset() {
        if (this.bytesProcessed == 0L) {
            return;
        }
        this.implReset();
        this.bufOfs = 0;
        this.bytesProcessed = 0L;
    }

    protected final byte[] engineDigest() {
        byte[] byArray = new byte[this.digestLength];
        try {
            this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            throw (ProviderException)new ProviderException("Internal error").initCause(digestException);
        }
        return byArray;
    }

    protected final int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < this.digestLength) {
            throw new DigestException("Length must be at least " + this.digestLength + " for " + this.algorithm + "digests");
        }
        if (n + n2 > byArray.length) {
            throw new DigestException("Buffer too short to store digest");
        }
        if (this.bytesProcessed < 0L) {
            this.engineReset();
        }
        this.implDigest(byArray, n);
        this.bytesProcessed = -1L;
        return this.digestLength;
    }

    abstract void implCompress(byte[] var1, int var2);

    abstract void implDigest(byte[] var1, int var2);

    abstract void implReset();

    public abstract Object clone();

    static void b2iLittle(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
            nArray[n2++] = n4;
            n += 4;
            n3 -= 4;
        }
    }

    static void i2bLittle(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = nArray[n++];
            byArray[n2++] = (byte)n4;
            byArray[n2++] = (byte)(n4 >> 8);
            byArray[n2++] = (byte)(n4 >> 16);
            byArray[n2++] = (byte)(n4 >> 24);
            n3 -= 4;
        }
    }

    static void b2iBig(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = byArray[n + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | byArray[n] << 24;
            nArray[n2++] = n4;
            n += 4;
            n3 -= 4;
        }
    }

    static void i2bBig(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = nArray[n++];
            byArray[n2++] = (byte)(n4 >> 24);
            byArray[n2++] = (byte)(n4 >> 16);
            byArray[n2++] = (byte)(n4 >> 8);
            byArray[n2++] = (byte)n4;
            n3 -= 4;
        }
    }

    static void b2lBig(byte[] byArray, int n, long[] lArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = byArray[n + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | byArray[n] << 24;
            int n5 = byArray[(n += 4) + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | byArray[n] << 24;
            lArray[n2++] = (long)n4 << 32 | (long)n5 & 0xFFFFFFFFL;
            n += 4;
            n3 -= 8;
        }
    }

    static void l2bBig(long[] lArray, int n, byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            long l = lArray[n++];
            byArray[n2++] = (byte)(l >> 56);
            byArray[n2++] = (byte)(l >> 48);
            byArray[n2++] = (byte)(l >> 40);
            byArray[n2++] = (byte)(l >> 32);
            byArray[n2++] = (byte)(l >> 24);
            byArray[n2++] = (byte)(l >> 16);
            byArray[n2++] = (byte)(l >> 8);
            byArray[n2++] = (byte)l;
            n3 -= 8;
        }
    }

    static {
        DigestBase.padding[0] = -128;
    }
}

