/*
 * Decompiled with CFR 0.152.
 */
package sun.security.timestamp;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;

public class TimestampToken {
    private int version;
    private ObjectIdentifier policy;
    private BigInteger serialNumber;
    private AlgorithmId hashAlgorithm;
    private byte[] hashedMessage;
    private Date genTime;

    public TimestampToken(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IOException("No timestamp token info");
        }
        this.parse(byArray);
    }

    public Date getDate() {
        return this.genTime;
    }

    private void parse(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.getTag() != 48) {
            throw new IOException("Bad encoding for timestamp token info");
        }
        DerInputStream derInputStream = derValue.getData();
        this.version = derInputStream.getInteger().intValue();
        this.policy = derInputStream.getOID();
        DerValue derValue2 = derInputStream.getDerValue();
        DerInputStream derInputStream2 = derValue2.getData();
        this.hashAlgorithm = AlgorithmId.parse((DerValue)derInputStream2.getDerValue());
        this.hashedMessage = derInputStream2.getOctetString();
        this.serialNumber = derInputStream.getBigInteger();
        this.genTime = derInputStream.getGeneralizedTime();
        if (derInputStream.available() > 0) {
            // empty if block
        }
    }
}

