/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import sun.security.tools.FocusTextField;
import sun.security.tools.PolicyTool;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindow;

class FileMenuListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;

    FileMenuListener(PolicyTool policyTool, ToolWindow toolWindow) {
        this.tool = policyTool;
        this.tw = toolWindow;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (PolicyTool.collator.compare(actionEvent.getActionCommand(), ToolWindow.QUIT) == 0) {
            ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Save Changes"), this.tool, this.tw, this.tw, true);
            toolDialog.displayUserSave(1);
        } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), ToolWindow.NEW_POLICY_FILE) == 0) {
            ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Save Changes"), this.tool, this.tw, this.tw, true);
            toolDialog.displayUserSave(2);
        } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), ToolWindow.OPEN_POLICY_FILE) == 0) {
            ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Save Changes"), this.tool, this.tw, this.tw, true);
            toolDialog.displayUserSave(3);
        } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), ToolWindow.SAVE_POLICY_FILE) == 0) {
            String string = ((FocusTextField)this.tw.getContentPane().getComponent(1)).getText();
            if (string == null || string.length() == 0) {
                ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Save As"), this.tool, this.tw, this.tw, true);
                toolDialog.displaySaveAsDialog(0);
            } else {
                try {
                    this.tool.savePolicy(string);
                    MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Policy successfully written to filename"));
                    Object[] objectArray = new Object[]{string};
                    this.tw.displayStatusDialog(this.tw, messageFormat.format(objectArray));
                }
                catch (Exception exception) {
                    MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Save to filename failed. View Warning Log for details."));
                    Object[] objectArray = new Object[]{string};
                    this.tw.displayErrorDialog(this.tw, messageFormat.format(objectArray));
                    messageFormat = new MessageFormat(PolicyTool.rb.getString("Warning: Save to filename failed due to unexpected exception: "));
                    this.tool.warnings.addElement(messageFormat.format(objectArray) + exception.getMessage());
                }
            }
        } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), ToolWindow.SAVE_AS_POLICY_FILE) == 0) {
            ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Save As"), this.tool, this.tw, this.tw, true);
            toolDialog.displaySaveAsDialog(0);
        } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), ToolWindow.VIEW_WARNINGS) == 0) {
            this.tw.displayWarningLog(this.tw);
        }
    }
}

