/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyImpl;

public class KerberosKey
implements SecretKey,
Destroyable {
    public static final long serialVersionUID = -4625402278148246993L;
    private KerberosPrincipal principal;
    private int versionNum;
    private KeyImpl key;
    private transient boolean destroyed = false;

    public KerberosKey(KerberosPrincipal principal, byte[] keyBytes, int keyType, int versionNum) {
        this.principal = principal;
        this.versionNum = versionNum;
        this.key = new KeyImpl(keyBytes, keyType);
    }

    public KerberosKey(KerberosPrincipal principal, char[] password, String algorithm) {
        this.principal = principal;
        this.key = new KeyImpl(principal, password, algorithm);
    }

    public final KerberosPrincipal getPrincipal() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.principal;
    }

    public final int getVersionNumber() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.versionNum;
    }

    public final int getKeyType() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getKeyType();
    }

    public final String getAlgorithm() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getAlgorithm();
    }

    public final String getFormat() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getFormat();
    }

    public final byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getEncoded();
    }

    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.key.destroy();
            this.principal = null;
            this.destroyed = true;
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public String toString() {
        return "Kerberos Principal " + this.principal.toString() + "Key Version " + this.versionNum + "key " + this.key.toString();
    }
}

