/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import com.ibm.jvm.Constants;
import com.ibm.misc.BASE64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import sun.security.util.Debug;
import sun.security.util.ManifestDigester;
import sun.security.util.SignatureFile;

public class JarSigner {
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.tools.JarSignerResources");
    private static final Collator collator = Collator.getInstance();
    static final String VERSION = "1.0";
    static final int IN_KEYSTORE = 1;
    static final int IN_SCOPE = 2;
    X509Certificate[] certChain;
    PrivateKey privateKey;
    KeyStore store = null;
    IdentityScope scope;
    private static final Debug jarDebug;
    String keystore;
    String jarfile;
    String alias;
    char[] storepass;
    String storetype;
    Vector providers = null;
    char[] keypass;
    String sigfile;
    String signedjar;
    boolean verify = false;
    boolean verbose = false;
    boolean showcerts = false;
    boolean debug = false;
    boolean signManifest = true;
    boolean externalSF = true;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
    private byte[] buffer = new byte[8192];
    Hashtable storeHash = new Hashtable();

    public static void main(String[] stringArray) throws Exception {
        JarSigner jarSigner = new JarSigner();
        jarSigner.run(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(String[] stringArray) {
        block15: {
            try {
                block14: {
                    try {
                        this.parseArgs(stringArray);
                        if (this.providers != null) {
                            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                            Enumeration enumeration = this.providers.elements();
                            while (enumeration.hasMoreElements()) {
                                String string = (String)enumeration.nextElement();
                                Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                                Object obj = clazz.newInstance();
                                if (!(obj instanceof Provider)) {
                                    MessageFormat messageFormat = new MessageFormat(rb.getString("provName not a provider"));
                                    Object[] objectArray = new Object[]{string};
                                    this.error(messageFormat.format(objectArray));
                                }
                                Security.addProvider((Provider)obj);
                            }
                        }
                        if (this.verify) {
                            block13: {
                                try {
                                    this.loadKeyStore(this.keystore, false);
                                    this.scope = IdentityScope.getSystemScope();
                                }
                                catch (Exception exception) {
                                    if (this.keystore == null && this.storepass == null) break block13;
                                    this.error(rb.getString("unable to load keystore"), exception);
                                }
                            }
                            this.verifyJar(this.jarfile);
                            break block14;
                        }
                        this.loadKeyStore(this.keystore, true);
                        this.getAliasInfo(this.alias);
                        this.signJar(this.jarfile, this.alias);
                    }
                    catch (Exception exception) {
                        this.error(rb.getString("unexpected exception"), exception);
                        Object var10_12 = null;
                        if (this.keypass != null) {
                            Arrays.fill(this.keypass, ' ');
                            this.keypass = null;
                        }
                        if (this.storepass == null) return;
                        Arrays.fill(this.storepass, ' ');
                        this.storepass = null;
                        return;
                    }
                }
                Object var10_11 = null;
                if (this.keypass == null) break block15;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (this.keypass != null) {
                    Arrays.fill(this.keypass, ' ');
                    this.keypass = null;
                }
                if (this.storepass == null) throw throwable;
                Arrays.fill(this.storepass, ' ');
                this.storepass = null;
                throw throwable;
            }
            Arrays.fill(this.keypass, ' ');
            this.keypass = null;
        }
        if (this.storepass == null) return;
        Arrays.fill(this.storepass, ' ');
        this.storepass = null;
    }

    void parseArgs(String[] stringArray) {
        int n = 0;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            String string = stringArray[n];
            if (collator.compare(string, "-keystore") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.keystore = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-storepass") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.storepass = stringArray[n].toCharArray();
                continue;
            }
            if (collator.compare(string, "-storetype") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.storetype = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-provider") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                if (this.providers == null) {
                    this.providers = new Vector(3);
                }
                this.providers.add(stringArray[n]);
                continue;
            }
            if (collator.compare(string, "-debug") == 0) {
                this.debug = true;
                continue;
            }
            if (collator.compare(string, "-keypass") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.keypass = stringArray[n].toCharArray();
                continue;
            }
            if (collator.compare(string, "-sigfile") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.sigfile = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-signedjar") == 0) {
                if (++n == stringArray.length) {
                    this.usage();
                }
                this.signedjar = stringArray[n];
                continue;
            }
            if (collator.compare(string, "-sectionsonly") == 0) {
                this.signManifest = false;
                continue;
            }
            if (collator.compare(string, "-internalsf") == 0) {
                this.externalSF = false;
                continue;
            }
            if (collator.compare(string, "-verify") == 0) {
                this.verify = true;
                continue;
            }
            if (collator.compare(string, "-verbose") == 0) {
                this.verbose = true;
                continue;
            }
            if (collator.compare(string, "-certs") == 0) {
                this.showcerts = true;
                continue;
            }
            if (collator.compare(string, "-h") == 0 || collator.compare(string, "-help") == 0) {
                this.usage();
                continue;
            }
            System.err.println(rb.getString("Illegal option: ") + string);
            this.usage();
        }
        if (n == stringArray.length) {
            this.usage();
        }
        this.jarfile = stringArray[n++];
        if (!this.verify) {
            if (n == stringArray.length) {
                this.usage();
            }
            this.alias = stringArray[n++];
        }
    }

    void usage() {
        System.out.println(rb.getString("Usage: jarsigner [options] jar-file alias"));
        System.out.println(rb.getString("       jarsigner -verify [options] jar-file"));
        System.out.println();
        System.out.println(rb.getString("  [-keystore <url>]           keystore location"));
        System.out.println();
        System.out.println(rb.getString("  [-storepass <password>]     password for keystore integrity"));
        System.out.println();
        System.out.println(rb.getString("  [-storetype <type>]         keystore type"));
        System.out.println();
        System.out.println(rb.getString("  [-keypass <password>]       password for private key (if different)"));
        System.out.println();
        System.out.println(rb.getString("  [-sigfile <file>]           name of .SF/.DSA file"));
        System.out.println();
        System.out.println(rb.getString("  [-signedjar <file>]         name of signed JAR file"));
        System.out.println();
        System.out.println(rb.getString("  [-verify]                   verify a signed JAR file"));
        System.out.println();
        System.out.println(rb.getString("  [-verbose]                  verbose output when signing/verifying"));
        System.out.println();
        System.out.println(rb.getString("  [-certs]                    display certificates when verbose and verifying"));
        System.out.println();
        System.out.println(rb.getString("  [-internalsf]               include the .SF file inside the signature block"));
        System.out.println();
        System.out.println(rb.getString("  [-sectionsonly]             don't compute hash of entire manifest"));
        System.out.println();
        System.out.println(rb.getString("  [-provider]                 name of cryptographic service provider's master class file"));
        System.out.println(rb.getString("  ..."));
        System.out.println();
        System.exit(1);
    }

    void verifyJar(String string) throws Exception {
        Object object;
        Cloneable cloneable;
        boolean bl = false;
        boolean bl2 = false;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(string, true);
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable to open jar file: ") + string, iOException);
        }
        Vector<Cloneable> vector = new Vector<Cloneable>();
        byte[] byArray = new byte[8192];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            int n;
            cloneable = enumeration.nextElement();
            vector.addElement(cloneable);
            object = jarFile.getInputStream((ZipEntry)cloneable);
            while ((n = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
            }
            ((InputStream)object).close();
        }
        jarFile.close();
        cloneable = jarFile.getManifest();
        if (cloneable != null) {
            if (this.verbose) {
                System.out.println();
            }
            object = vector.elements();
            while (object.hasMoreElements()) {
                int n;
                JarEntry jarEntry = (JarEntry)object.nextElement();
                String string2 = jarEntry.getName();
                Certificate[] certificateArray = jarEntry.getCertificates();
                boolean bl3 = certificateArray != null && certificateArray.length > 0;
                bl |= bl3;
                bl2 |= !bl3 && !string2.startsWith("META-INF/");
                if (!this.verbose) continue;
                int n2 = this.inKeyStore(certificateArray);
                boolean bl4 = (n2 & 1) != 0;
                boolean bl5 = (n2 & 2) != 0;
                boolean bl6 = ((Manifest)cloneable).getAttributes(string2) != null || ((Manifest)cloneable).getAttributes("./" + string2) != null || ((Manifest)cloneable).getAttributes("/" + string2) != null;
                System.out.print((bl3 ? rb.getString("s") : rb.getString(" ")) + (bl6 ? rb.getString("m") : rb.getString(" ")) + (bl4 ? rb.getString("k") : rb.getString(" ")) + (bl5 ? rb.getString("i") : rb.getString(" ")) + rb.getString("  "));
                StringBuffer stringBuffer = new StringBuffer();
                String string3 = Long.toString(jarEntry.getSize());
                for (n = 6 - string3.length(); n > 0; --n) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(string3).append(' ').append(DateFormat.getDateTimeInstance().format(new Date(jarEntry.getTime())));
                stringBuffer.append(' ').append(jarEntry.getName());
                System.out.println(stringBuffer.toString());
                if (certificateArray == null || !this.showcerts) continue;
                System.out.println();
                for (n = 0; n < certificateArray.length; ++n) {
                    System.out.println(rb.getString("      ") + this.printCert(certificateArray[n]));
                }
                System.out.println();
            }
        }
        if (this.verbose) {
            System.out.println();
            System.out.println(rb.getString("  s = signature was verified "));
            System.out.println(rb.getString("  m = entry is listed in manifest"));
            System.out.println(rb.getString("  k = at least one certificate was found in keystore"));
            System.out.println(rb.getString("  i = at least one certificate was found in identity scope"));
            System.out.println();
        }
        if (cloneable == null) {
            System.out.println(rb.getString("no manifest."));
        }
        if (!bl) {
            System.out.println(rb.getString("jar is unsigned. (signatures missing or not parsable)"));
        } else {
            System.out.println(rb.getString("jar verified."));
            if (bl2) {
                System.out.println();
                System.out.println("Note: This jar contains unsigned entries which are not integrity-checked. Re-run with -verbose to list unsigned entries.");
            }
        }
    }

    String printCert(Certificate certificate) {
        String string = certificate instanceof X509Certificate ? certificate.getType() + rb.getString(", ") + ((X509Certificate)certificate).getSubjectDN().getName() : certificate.getType();
        String string2 = (String)this.storeHash.get(certificate);
        if (string2 != null) {
            return string + rb.getString(" ") + string2;
        }
        return string;
    }

    int inKeyStore(Certificate[] certificateArray) {
        int n = 0;
        if (certificateArray == null) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < certificateArray.length; ++i) {
            Identity identity;
            Certificate certificate = certificateArray[i];
            bl = false;
            String string = (String)this.storeHash.get(certificate);
            if (string != null) {
                if (string.startsWith("(")) {
                    n |= 1;
                    continue;
                }
                if (!string.startsWith("[")) continue;
                n |= 2;
                continue;
            }
            if (this.store != null) {
                block8: {
                    try {
                        string = this.store.getCertificateAlias(certificate);
                    }
                    catch (KeyStoreException keyStoreException) {
                        if (jarDebug == null) break block8;
                        jarDebug.println("Unexpected exception in inKeyStore : " + keyStoreException.getMessage());
                    }
                }
                if (string != null) {
                    this.storeHash.put(certificate, "(" + string + ")");
                    bl = true;
                    n |= 1;
                }
            }
            if (bl || this.scope == null || (identity = this.scope.getIdentity(certificate.getPublicKey())) == null) continue;
            n |= 2;
            this.storeHash.put(certificate, "[" + identity.getName() + "]");
        }
        return n;
    }

    void signJar(String string, String string2) throws Exception {
        boolean bl = false;
        if (this.sigfile == null) {
            this.sigfile = string2;
            bl = true;
        }
        this.sigfile = this.sigfile.length() > 8 ? this.sigfile.substring(0, 8).toUpperCase() : this.sigfile.toUpperCase();
        StringBuffer stringBuffer = new StringBuffer(this.sigfile.length());
        for (int i = 0; i < this.sigfile.length(); ++i) {
            int n = this.sigfile.charAt(i);
            if (!(n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 45 || n == 95)) {
                if (bl) {
                    n = 95;
                } else {
                    this.error(rb.getString("signature filename must consist of the following characters: A-Z, 0-9, _ or -"));
                }
            }
            stringBuffer.append((char)n);
        }
        this.sigfile = stringBuffer.toString();
        String string3 = this.signedjar == null ? string + ".sig" : this.signedjar;
        File file = new File(string);
        File file2 = new File(string3);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(string);
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable to open jar file: ") + string, iOException);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable to create: ") + string3, iOException);
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        Manifest manifest = new Manifest();
        Map<String, Attributes> map = manifest.getEntries();
        boolean bl2 = false;
        boolean bl3 = false;
        byte[] byArray = null;
        try {
            Cloneable cloneable;
            Attributes attributes;
            ZipEntry zipEntry;
            Object object;
            Object object2;
            Attributes attributes2;
            MessageDigest[] messageDigestArray = new MessageDigest[]{MessageDigest.getInstance("SHA1")};
            ZipEntry zipEntry2 = this.getManifestFile(zipFile);
            if (zipEntry2 != null) {
                byArray = this.getBytes(zipFile, zipEntry2);
                manifest.read(new ByteArrayInputStream(byArray));
            } else {
                attributes2 = manifest.getMainAttributes();
                attributes2.putValue(Attributes.Name.MANIFEST_VERSION.toString(), VERSION);
                object2 = System.getProperty("java.vendor");
                object = System.getProperty("java.version");
                attributes2.putValue("Created-By", (String)object + " (" + (String)object2 + ")");
                zipEntry2 = new ZipEntry("META-INF/MANIFEST.MF");
                bl3 = true;
            }
            attributes2 = new BASE64Encoder();
            object2 = new Vector();
            object = zipFile.entries();
            while (object.hasMoreElements()) {
                zipEntry = (ZipEntry)object.nextElement();
                if (zipEntry.getName().startsWith("META-INF")) {
                    ((Vector)object2).addElement(zipEntry);
                    continue;
                }
                if (manifest.getAttributes(zipEntry.getName()) != null) {
                    if (!this.updateDigests(zipEntry, zipFile, messageDigestArray, (BASE64Encoder)attributes2, manifest)) continue;
                    bl2 = true;
                    continue;
                }
                if (zipEntry.isDirectory()) continue;
                attributes = this.getDigestAttributes(zipEntry, zipFile, messageDigestArray, (BASE64Encoder)attributes2);
                map.put(zipEntry.getName(), attributes);
                bl2 = true;
            }
            if (bl2) {
                object = new ByteArrayOutputStream();
                manifest.write((OutputStream)object);
                byArray = ((ByteArrayOutputStream)object).toByteArray();
            }
            if (bl2) {
                zipEntry2 = new ZipEntry("META-INF/MANIFEST.MF");
            }
            if (this.verbose) {
                if (bl3) {
                    System.out.println(rb.getString("   adding: ") + zipEntry2.getName());
                } else if (bl2) {
                    System.out.println(rb.getString(" updating: ") + zipEntry2.getName());
                }
            }
            zipOutputStream.putNextEntry(zipEntry2);
            zipOutputStream.write(byArray);
            object = new ManifestDigester(byArray);
            zipEntry = new SignatureFile(messageDigestArray, manifest, (ManifestDigester)object, this.sigfile, this.signManifest);
            attributes = zipEntry.generateBlock(this.privateKey, this.certChain, this.externalSF);
            String string4 = zipEntry.getMetaName();
            String string5 = attributes.getMetaName();
            ZipEntry zipEntry3 = new ZipEntry(string4);
            ZipEntry zipEntry4 = new ZipEntry(string5);
            long l = System.currentTimeMillis();
            zipEntry3.setTime(l);
            zipEntry4.setTime(l);
            zipOutputStream.putNextEntry(zipEntry3);
            zipEntry.write(zipOutputStream);
            if (this.verbose) {
                if (zipFile.getEntry(string4) != null) {
                    System.out.println(rb.getString(" updating: ") + string4);
                } else {
                    System.out.println(rb.getString("   adding: ") + string4);
                }
            }
            zipOutputStream.putNextEntry(zipEntry4);
            attributes.write(zipOutputStream);
            if (this.verbose) {
                if (zipFile.getEntry(string5) != null) {
                    System.out.println(rb.getString(" updating: ") + string5);
                } else {
                    System.out.println(rb.getString("   adding: ") + string5);
                }
            }
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                cloneable = (ZipEntry)((Vector)object2).elementAt(i);
                if (((ZipEntry)cloneable).getName().toUpperCase(Locale.US).equalsIgnoreCase("META-INF/MANIFEST.MF") || ((ZipEntry)cloneable).getName().equalsIgnoreCase(string4) || ((ZipEntry)cloneable).getName().equalsIgnoreCase(string5)) continue;
                this.writeEntry(zipFile, zipOutputStream, (ZipEntry)cloneable);
            }
            Object object3 = zipFile.entries();
            while (object3.hasMoreElements()) {
                cloneable = object3.nextElement();
                if (((ZipEntry)cloneable).getName().startsWith("META-INF")) continue;
                if (this.verbose) {
                    if (manifest.getAttributes(((ZipEntry)cloneable).getName()) != null) {
                        System.out.println(rb.getString("  signing: ") + ((ZipEntry)cloneable).getName());
                    } else {
                        System.out.println(rb.getString("   adding: ") + ((ZipEntry)cloneable).getName());
                    }
                }
                this.writeEntry(zipFile, zipOutputStream, (ZipEntry)cloneable);
            }
            zipFile.close();
            zipOutputStream.close();
            if (this.signedjar == null && !file2.renameTo(file)) {
                object3 = new File(string + ".orig");
                if (file.renameTo((File)object3)) {
                    if (file2.renameTo(file)) {
                        ((File)object3).delete();
                    } else {
                        cloneable = new MessageFormat(rb.getString("attempt to rename signedJarFile to jarFile failed"));
                        Object[] objectArray = new Object[]{file2, file};
                        this.error(((Format)cloneable).format(objectArray));
                    }
                } else {
                    cloneable = new MessageFormat(rb.getString("attempt to rename jarFile to origJar failed"));
                    Object[] objectArray = new Object[]{file, object3};
                    this.error(((Format)cloneable).format(objectArray));
                }
            }
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable to sign jar: "), iOException);
        }
    }

    private void writeEntry(ZipFile zipFile, ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        byte[] byArray = this.getBytes(zipFile, zipEntry);
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setMethod(zipEntry.getMethod());
        zipEntry2.setTime(zipEntry.getTime());
        zipEntry2.setComment(zipEntry.getComment());
        zipEntry2.setExtra(zipEntry.getExtra());
        if (zipEntry.getMethod() == 0) {
            zipEntry2.setSize(zipEntry.getSize());
            zipEntry2.setCrc(zipEntry.getCrc());
        }
        zipOutputStream.putNextEntry(zipEntry2);
        if (byArray.length > 0) {
            zipOutputStream.write(byArray);
        }
    }

    void loadKeyStore(String string, boolean bl) throws Exception {
        if (string == null) {
            string = System.getProperty("user.home") + File.separator + Constants.keystore;
        }
        if (jarDebug != null) {
            jarDebug.println("keystore load: file=" + string);
        }
        try {
            this.store = this.storetype != null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(KeyStore.getDefaultType());
            if (jarDebug != null) {
                jarDebug.println("keystore load: loader type=" + this.store.getType());
                jarDebug.println("keystore load: loader provider=" + this.store.getProvider());
            }
            if (this.storepass == null && bl) {
                this.storepass = this.getPass(rb.getString("Enter Passphrase for keystore: "));
            }
            string = string.replace(File.separatorChar, '/');
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                File file = new File(string);
                uRL = new URL("file:" + file.getCanonicalPath());
            }
            InputStream inputStream = uRL.openStream();
            this.store.load(inputStream, this.storepass);
            inputStream.close();
        }
        catch (IOException iOException) {
            this.store = null;
            throw new RuntimeException(rb.getString("keystore load: ") + iOException.getMessage());
        }
        catch (CertificateException certificateException) {
            this.store = null;
            throw new RuntimeException(rb.getString("certificate exception: ") + certificateException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.store = null;
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        catch (KeyStoreException keyStoreException) {
            this.store = null;
            throw new RuntimeException(rb.getString("unable to instantiate keystore class: ") + keyStoreException.getMessage());
        }
    }

    void getAliasInfo(String string) {
        Object object;
        Object object2;
        Key key;
        block18: {
            key = null;
            try {
                Object object3;
                Object[] objectArray;
                object2 = null;
                try {
                    object2 = this.store.getCertificateChain(string);
                }
                catch (KeyStoreException keyStoreException) {
                    this.error(rb.getString("unexpected exception."), keyStoreException);
                }
                if (object2 == null) {
                    MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate chain not found for: alias.  alias must reference a valid KeyStore key entry containing a private key and corresponding public key certificate chain."));
                    objectArray = new Object[]{string, string};
                    this.error(messageFormat.format(objectArray));
                }
                this.certChain = new X509Certificate[((Certificate[])object2).length];
                for (int i = 0; i < ((Certificate[])object2).length; ++i) {
                    if (!(object2[i] instanceof X509Certificate)) {
                        this.error(rb.getString("found non-X.509 certificate in signer's chain"));
                    }
                    this.certChain[i] = (X509Certificate)object2[i];
                }
                object = (X509Certificate)this.store.getCertificate(string);
                if (!((Certificate)object).equals(this.certChain[0])) {
                    objectArray = new X509Certificate[this.certChain.length];
                    objectArray[0] = object;
                    object3 = ((X509Certificate)object).getIssuerDN();
                    for (int i = 1; i < this.certChain.length; ++i) {
                        int n;
                        for (n = 0; n < objectArray.length; ++n) {
                            Principal principal;
                            if (objectArray[n] == null || !object3.equals(principal = ((X509Certificate)objectArray[n]).getSubjectDN())) continue;
                            this.certChain[i] = objectArray[n];
                            object3 = ((X509Certificate)objectArray[n]).getIssuerDN();
                            objectArray[n] = null;
                            break;
                        }
                        if (n != objectArray.length) continue;
                        this.error(rb.getString("incomplete certificate chain"));
                    }
                    this.certChain = objectArray;
                }
                try {
                    if (this.keypass == null) {
                        key = this.store.getKey(string, this.storepass);
                        break block18;
                    }
                    key = this.store.getKey(string, this.keypass);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    if (this.keypass == null) {
                        object3 = new MessageFormat(rb.getString("Enter key password for alias: "));
                        Object[] objectArray2 = new Object[]{string};
                        this.keypass = this.getPass(((Format)object3).format(objectArray2));
                        key = this.store.getKey(string, this.keypass);
                    }
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.error(rb.getString("unexpected exception."), noSuchAlgorithmException);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                this.error(rb.getString("unable to recover key from keystore"));
            }
            catch (KeyStoreException keyStoreException) {
                this.error(rb.getString("unexpected exception."), keyStoreException);
            }
        }
        if (!(key instanceof PrivateKey)) {
            object2 = new MessageFormat(rb.getString("key associated with alias not a private key"));
            object = new Object[]{string};
            this.error(((Format)object2).format(object));
        } else {
            this.privateKey = (PrivateKey)key;
        }
    }

    void error(String string) {
        System.out.println(rb.getString("jarsigner: ") + string);
        System.exit(1);
    }

    void error(String string, Exception exception) {
        System.out.println(rb.getString("jarsigner: ") + string);
        System.out.println(rb.getString("jarsigner exception text: ") + exception.getMessage());
        if (this.debug) {
            exception.printStackTrace();
        }
        System.exit(1);
    }

    char[] getPass(String string) {
        System.err.print(string);
        System.err.flush();
        try {
            char[] cArray = this.readPasswd(System.in);
            if (cArray != null) {
                return cArray;
            }
            this.error(rb.getString("you must enter key password"));
        }
        catch (IOException iOException) {
            this.error(rb.getString("unable to read password: "), iOException);
        }
        return null;
    }

    private char[] readPasswd(InputStream inputStream) throws IOException {
        char[] cArray;
        char[] cArray2 = cArray = new char[128];
        int n = cArray2.length;
        int n2 = 0;
        block4: while (true) {
            int n3 = inputStream.read();
            switch (n3) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n4 = inputStream.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    if (!(inputStream instanceof PushbackInputStream)) {
                        inputStream = new PushbackInputStream(inputStream);
                    }
                    ((PushbackInputStream)inputStream).unread(n4);
                }
                default: {
                    if (--n < 0) {
                        cArray2 = new char[n2 + 128];
                        n = cArray2.length - n2 - 1;
                        System.arraycopy(cArray, 0, cArray2, 0, n2);
                        Arrays.fill(cArray, ' ');
                        cArray = cArray2;
                    }
                    cArray2[n2++] = (char)n3;
                    continue block4;
                }
            }
            break;
        }
        if (n2 == 0) {
            return null;
        }
        char[] cArray3 = new char[n2];
        System.arraycopy(cArray2, 0, cArray3, 0, n2);
        Arrays.fill(cArray2, ' ');
        return cArray3;
    }

    private synchronized byte[] getBytes(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        int n;
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        this.baos.reset();
        for (long i = zipEntry.getSize(); i > 0L && (n = inputStream.read(this.buffer, 0, this.buffer.length)) != -1; i -= (long)n) {
            this.baos.write(this.buffer, 0, n);
        }
        inputStream.close();
        return this.baos.toByteArray();
    }

    private ZipEntry getManifestFile(ZipFile zipFile) {
        ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
        if (zipEntry == null) {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements() && zipEntry == null) {
                zipEntry = enumeration.nextElement();
                if ("META-INF/MANIFEST.MF".equals(zipEntry.getName().toUpperCase(Locale.US))) continue;
                zipEntry = null;
            }
        }
        return zipEntry;
    }

    private synchronized String[] getDigests(ZipEntry zipEntry, ZipFile zipFile, MessageDigest[] messageDigestArray, BASE64Encoder bASE64Encoder) throws IOException {
        int n;
        int n2;
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        for (long i = zipEntry.getSize(); i > 0L && (n2 = inputStream.read(this.buffer, 0, this.buffer.length)) != -1; i -= (long)n2) {
            for (n = 0; n < messageDigestArray.length; ++n) {
                messageDigestArray[n].update(this.buffer, 0, n2);
            }
        }
        inputStream.close();
        String[] stringArray = new String[messageDigestArray.length];
        for (n = 0; n < messageDigestArray.length; ++n) {
            stringArray[n] = bASE64Encoder.encode(messageDigestArray[n].digest());
        }
        return stringArray;
    }

    private Attributes getDigestAttributes(ZipEntry zipEntry, ZipFile zipFile, MessageDigest[] messageDigestArray, BASE64Encoder bASE64Encoder) throws IOException {
        String[] stringArray = this.getDigests(zipEntry, zipFile, messageDigestArray, bASE64Encoder);
        Attributes attributes = new Attributes();
        for (int i = 0; i < messageDigestArray.length; ++i) {
            attributes.putValue(messageDigestArray[i].getAlgorithm() + "-Digest", stringArray[i]);
        }
        return attributes;
    }

    private boolean updateDigests(ZipEntry zipEntry, ZipFile zipFile, MessageDigest[] messageDigestArray, BASE64Encoder bASE64Encoder, Manifest manifest) throws IOException {
        boolean bl = false;
        Attributes attributes = manifest.getAttributes(zipEntry.getName());
        String[] stringArray = this.getDigests(zipEntry, zipFile, messageDigestArray, bASE64Encoder);
        for (int i = 0; i < messageDigestArray.length; ++i) {
            String string = messageDigestArray[i].getAlgorithm() + "-Digest";
            String string2 = attributes.getValue(string);
            if (string2 == null && messageDigestArray[i].getAlgorithm().equalsIgnoreCase("SHA")) {
                string2 = attributes.getValue("SHA-Digest");
            }
            if (string2 == null) {
                attributes.putValue(string, stringArray[i]);
                bl = true;
                continue;
            }
            if (string2.equalsIgnoreCase(stringArray[i])) continue;
            attributes.putValue(string, stringArray[i]);
            bl = true;
        }
        return bl;
    }

    static {
        collator.setStrength(0);
        jarDebug = Debug.getInstance("jarSigner");
    }
}

