/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.jgss.mech.spnego;

import com.ibm.security.jgss.Debug;
import com.ibm.security.jgss.GSSManagerImpl;
import com.ibm.security.jgss.mech.spnego.SPNEGOName;
import com.ibm.security.jgss.spi.GSSCredentialSpi;
import com.ibm.security.jgss.spi.GSSNameSpi;
import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class SPNEGOCredential
implements GSSCredentialSpi {
    private SPNEGOName name;
    private int initTime;
    private int acceptTime;
    private int usage;
    private Provider provider;
    private boolean disposed;
    private int startTime;
    private Debug debug = new Debug();

    public SPNEGOCredential(GSSNameSpi gSSNameSpi, int n, int n2, int n3) throws GSSException {
        if (gSSNameSpi == null) {
            gSSNameSpi = new SPNEGOName("default", null);
        }
        if (!(gSSNameSpi instanceof SPNEGOName)) {
            throw new GSSException(3);
        }
        if (n <= 0) {
            throw new GSSException(11, 0, "Desired initLifetime zero or less");
        }
        if (n2 <= 0) {
            throw new GSSException(11, 0, "Desired acceptLifetime zero or less");
        }
        if (n3 != 0 && n3 != 2 && n3 != 1) {
            throw new GSSException(11, 0, "Improper value for usage");
        }
        this.name = (SPNEGOName)gSSNameSpi;
        this.initTime = n;
        this.acceptTime = n2;
        this.usage = n3;
        this.startTime = (int)(System.currentTimeMillis() / 1000L);
    }

    public Provider getProvider() {
        return this.provider;
    }

    void setProvider(Provider provider) {
        this.provider = provider;
    }

    public void dispose() throws GSSException {
        this.name = null;
        this.disposed = true;
    }

    public GSSNameSpi getName() throws GSSException {
        return this.name;
    }

    public int getInitLifetime() throws GSSException {
        if (this.disposed) {
            throw new GSSException(16, 0, "Credential disposed of");
        }
        if (!this.isInitiatorCredential()) {
            this.debug.out(5, "Not initiator cred");
            return 0;
        }
        if (this.initTime == Integer.MAX_VALUE) {
            return this.initTime;
        }
        long l = (long)(this.startTime + this.initTime) - System.currentTimeMillis() / 1000L;
        if (l < 0L) {
            l = 0L;
        }
        return (int)l;
    }

    public int getAcceptLifetime() throws GSSException {
        if (this.disposed) {
            throw new GSSException(16, 0, "Credential disposed of");
        }
        if (this.isInitiatorCredential()) {
            this.debug.out(5, "Not acceptor cred");
            return 0;
        }
        if (this.acceptTime == Integer.MAX_VALUE) {
            return this.acceptTime;
        }
        long l = (long)(this.startTime + this.acceptTime) - System.currentTimeMillis() / 1000L;
        if (l < 0L) {
            l = 0L;
        }
        return (int)l;
    }

    public boolean isInitiatorCredential() throws GSSException {
        return this.usage == 1 || this.usage == 0;
    }

    public boolean isAcceptorCredential() throws GSSException {
        return this.usage == 2 || this.usage == 0;
    }

    public Oid getMechanism() {
        return GSSManagerImpl.MECH_TYPE_SPNEGO;
    }

    boolean isDisposed() {
        return this.disposed;
    }
}

