/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.jgss.mech.spnego;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

class TargNegToken {
    private Integer negResult;
    public static final int ACCEPT_COMPLETED = 0;
    public static final int ACCEPT_INCOMPLETE = 1;
    public static final int REJECT = 2;
    private Oid supportedMech;
    private byte[] responseToken;
    private byte[] mechListMIC;

    public TargNegToken(Integer n, Oid oid, byte[] byArray, byte[] byArray2) {
        this.negResult = n;
        this.supportedMech = oid;
        if (byArray != null) {
            this.responseToken = (byte[])byArray.clone();
        }
        if (byArray2 != null) {
            this.mechListMIC = (byte[])byArray2.clone();
        }
    }

    public TargNegToken(DerInputStream derInputStream) throws IOException, GSSException {
        this.decode(derInputStream);
    }

    private void decode(DerInputStream derInputStream) throws IOException, GSSException {
        DerValue[] derValueArray = derInputStream.getSequence(3);
        if (derValueArray.length > 0) {
            block6: for (int i = 0; i < derValueArray.length; ++i) {
                int n = derValueArray[i].getTag() & 0x1F;
                switch (n) {
                    case 0: {
                        this.negResult = new Integer(derValueArray[i].getData().getEnumerated().intValue());
                        continue block6;
                    }
                    case 1: {
                        this.supportedMech = new Oid(derValueArray[i].getData().getOID().toString());
                        continue block6;
                    }
                    case 2: {
                        this.responseToken = derValueArray[i].getData().getOctetString();
                        continue block6;
                    }
                    case 3: {
                        this.mechListMIC = derValueArray[i].getData().getOctetString();
                        continue block6;
                    }
                    default: {
                        throw new IOException("Invalid tag number");
                    }
                }
            }
        }
    }

    public byte[] encode() throws IOException {
        DerValue derValue;
        DerOutputStream derOutputStream;
        ArrayList<DerValue> arrayList = new ArrayList<DerValue>();
        if (this.negResult != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putEnumerated(new BigInteger(this.negResult.toString()));
            derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream.toByteArray());
            arrayList.add(derValue);
        }
        if (this.supportedMech != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOID(new ObjectIdentifier(this.supportedMech.toString()));
            derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream.toByteArray());
            arrayList.add(derValue);
        }
        if (this.responseToken != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.responseToken);
            derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream.toByteArray());
            arrayList.add(derValue);
        }
        if (this.mechListMIC != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.mechListMIC);
            derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream.toByteArray());
            arrayList.add(derValue);
        }
        DerValue[] derValueArray = new DerValue[arrayList.size()];
        arrayList.toArray(derValueArray);
        derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    public Integer getResult() {
        return this.negResult;
    }

    public Oid getSelectedMech() {
        return this.supportedMech;
    }

    public byte[] getResponse() {
        return this.responseToken;
    }

    public byte[] getMIC() {
        return this.mechListMIC;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TargNegToken: [");
        if (this.negResult != null) {
            stringBuffer.append("\n\tnegResult:" + this.negResult.toString());
        }
        if (this.supportedMech != null) {
            stringBuffer.append("\n\tsupportedMech: " + this.supportedMech.toString());
        }
        if (this.responseToken != null) {
            stringBuffer.append("\n\tresponseToken: " + this.getBytesString(this.responseToken));
        }
        if (this.mechListMIC != null) {
            stringBuffer.append("\n\tmechListMIC: " + this.getBytesString(this.mechListMIC));
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    private String getBytesString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Byte.toString(byArray[i]) + " ");
        }
        return stringBuffer.toString();
    }
}

