/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream;
import com.ibm.websphere.management.filetransfer.client.FileUploadInputStream;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.migration.common.CommonDeclares;
import com.ibm.websphere.migration.exceptions.WASUpgradeException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceImpl;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ConfigRepositoryHelper {
    private static TraceComponent _tc = Tr.register((Class)ConfigRepositoryHelper.class, null, (String)"com.ibm.websphere.migration.WASUpgrade");
    public static Properties _DMConnectionProps = null;
    private static final String CONNECTION_TYPE_SERVER = "remote";
    private static final String CONNECTION_TYPE_STANDALONE = "local";
    private static final String SERVER_NAME = "SERVER_NAME";
    private static final String SOAP_PORT = "SOAP_PORT";
    private static final String SOAP_HOST = "SOAP_HOST";
    private static final String RMI_PORT = "RMI_PORT";
    private static final String RMI_HOST = "RMI_HOST";
    private ArrayList _dCSConfig = new ArrayList();
    private ArrayList _dCSConfigNewEntries = new ArrayList();
    private ArrayList _dConfigDeletedEntries = new ArrayList();
    private ConfigRepository _localRepository = null;
    private ConfigRepository _remoteRepository = null;
    private ConfigRepository _activeRepository = null;
    private boolean _isGlobalSecurityEnabled = false;
    private String _globalSecurityUserID = null;
    private String _globalSecurityPassword = null;
    private ArrayList _validConnectionProps = new ArrayList();
    private String _cellName = null;
    private ResourceSet _resourceSet = null;
    private String _configRoot = null;
    private ArrayList _originalNodeLevelFiles = new ArrayList();

    public ConfigRepository getActiveRepository() {
        return this._activeRepository;
    }

    public ConfigRepositoryHelper() throws WASUpgradeException {
        try {
            Properties properties = new Properties();
            properties.put("location", CONNECTION_TYPE_STANDALONE);
            _DMConnectionProps = properties;
            this._activeRepository = this._localRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)properties);
            this._resourceSet = new WASResourceSetImpl();
        }
        catch (AdminException adminException) {
            throw new WASUpgradeException();
        }
    }

    public ConfigRepositoryHelper(String string) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"ConfigRepositoryHelper", (Object)new Object[]{string});
        this._configRoot = string;
        try {
            Properties properties = new Properties();
            properties.put("location", CONNECTION_TYPE_STANDALONE);
            properties.put("was.repository.root", string);
            _DMConnectionProps = properties;
            this._activeRepository = this._localRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)properties);
            this._cellName = (String)CommonDeclares._cmdLineArgs.get("-cellName");
            if (this._cellName == null || this._cellName.equals("")) {
                this._cellName = this.getCellName();
            }
            Repository repository = RepositoryFactory.createRepository((String)string, (String)this._cellName, null, null);
            this._resourceSet = new WASResourceSetImpl();
            this.gatherAllValidConnectionInfoSets();
            this.getActiveConnectionConfigRepository();
            if (this._remoteRepository != null) {
                this._activeRepository = this._remoteRepository;
            }
            this._dCSConfigNewEntries.clear();
            this._dCSConfig.clear();
            this._dConfigDeletedEntries.clear();
            this._resourceSet.getResources().clear();
        }
        catch (AdminException adminException) {
            throw new WASUpgradeException();
        }
    }

    protected void updateConfig() throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"updateConfig");
        String string = System.getProperty("line.separator");
        HashMap hashMap = null;
        String[] stringArray = this._activeRepository.listResourceNames("cells/" + this._cellName + "/" + "nodes" + "/" + (String)CommonDeclares._cmdLineArgs.get("-nodeName"), 1, Integer.MAX_VALUE);
        for (int i = 0; i < stringArray.length; ++i) {
            this._originalNodeLevelFiles.add(stringArray[i]);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = this._configRoot + "cells" + File.separator + this._cellName + File.separator + "nodes" + File.separator + (String)CommonDeclares._cmdLineArgs.get("-nodeName") + File.separator;
            string3 = string3 + string2;
            Tr.debug((TraceComponent)_tc, (String)("Updating: " + string3));
            if (!this.doesOriginalNodeLevelFileExist(string3)) {
                this.createConfigurationDirFile(string3);
            }
            String[] stringArray2 = (String[])hashMap.get(string2);
            String string4 = CommonDeclares._backupDirectory + File.separator + "temp_new_config_files" + File.separator + string2;
            File file = CommonDeclares._oldOSInfo.deserializeTextFile(string4, stringArray2);
            this.updateFile(string3, file);
        }
    }

    protected boolean doesOriginalNodeLevelFileExist(String string) {
        Tr.entry((TraceComponent)_tc, (String)"doesOriginalNodeLevelFileExist", (Object)string);
        string = this.parseLongFileName(string);
        DocumentContentSource documentContentSource = null;
        try {
            documentContentSource = this._activeRepository.extract(string);
            this._dCSConfig.add(documentContentSource);
            this._originalNodeLevelFiles.remove(string);
            return true;
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    public String getCellName() {
        Tr.entry((TraceComponent)_tc, (String)"getCellName");
        String[] stringArray = this._activeRepository.listResourceNames("cells/", 2, 1);
        return stringArray[0].substring(stringArray[0].lastIndexOf("/") + 1);
    }

    public boolean doesFileExistInConfigurationDir(String string) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"doesFileExistInConfigurationDir", (Object)string);
        string = new File(string).getAbsolutePath();
        Iterator iterator = this._dCSConfig.iterator();
        DocumentContentSource documentContentSource = null;
        while (iterator.hasNext()) {
            documentContentSource = (DocumentContentSource)iterator.next();
            if (!string.replace('\\', '/').endsWith(documentContentSource.getDocument().getURI())) continue;
            return true;
        }
        iterator = this._dCSConfigNewEntries.iterator();
        documentContentSource = null;
        while (iterator.hasNext()) {
            documentContentSource = (DocumentContentSource)iterator.next();
            if (!string.replace('\\', '/').endsWith(documentContentSource.getDocument().getURI())) continue;
            return true;
        }
        string = this.parseLongFileName(string);
        try {
            documentContentSource = this._activeRepository.extract(string);
            this._dCSConfig.add(documentContentSource);
            return !this._originalNodeLevelFiles.contains(string);
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    private String parseLongFileName(String string) {
        Tr.entry((TraceComponent)_tc, (String)"parseLongFileName", (Object)string);
        string = string.replace('\\', '/');
        string = string.substring(string.lastIndexOf("/config/") + "/config/".length());
        return string;
    }

    private DocumentContentSource getDocumentContentSourceOfFile(String string) {
        Tr.entry((TraceComponent)_tc, (String)"getDocumentContentSourceOfConfigurationDirFile", (Object)string);
        Iterator iterator = this._dCSConfig.iterator();
        DocumentContentSource documentContentSource = null;
        while (iterator.hasNext()) {
            documentContentSource = (DocumentContentSource)iterator.next();
            if (!string.replace('\\', '/').endsWith(documentContentSource.getDocument().getURI())) continue;
            return documentContentSource;
        }
        iterator = this._dCSConfigNewEntries.iterator();
        documentContentSource = null;
        while (iterator.hasNext()) {
            documentContentSource = (DocumentContentSource)iterator.next();
            if (!string.replace('\\', '/').endsWith(documentContentSource.getDocument().getURI())) continue;
            return documentContentSource;
        }
        string = this.parseLongFileName(string);
        try {
            documentContentSource = this._activeRepository.extract(string);
            return documentContentSource;
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    public InputStream openConfigurationDirFile(String string) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"openConfigurationDirFile", (Object)string);
        string = new File(string).getAbsolutePath();
        Iterator iterator = this._dCSConfig.iterator();
        DocumentContentSource documentContentSource = null;
        while (iterator.hasNext()) {
            documentContentSource = (DocumentContentSource)iterator.next();
            if (!string.replace('\\', '/').endsWith(documentContentSource.getDocument().getURI())) continue;
            return documentContentSource.getSource();
        }
        iterator = this._dCSConfigNewEntries.iterator();
        documentContentSource = null;
        while (iterator.hasNext()) {
            documentContentSource = (DocumentContentSource)iterator.next();
            if (!string.replace('\\', '/').endsWith(documentContentSource.getDocument().getURI())) continue;
            return documentContentSource.getSource();
        }
        string = this.parseLongFileName(string);
        try {
            documentContentSource = this._activeRepository.extract(string);
            return documentContentSource.getSource();
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    public InputStream openFileForReadOnly(String string) throws WASUpgradeException {
        Tr.debug((TraceComponent)_tc, (String)"openFileForReadOnly", (Object)string);
        try {
            string = this.parseLongFileName(string);
            DocumentContentSource documentContentSource = this._activeRepository.extract(string);
            return documentContentSource.getSource();
        }
        catch (RepositoryException repositoryException) {
            Tr.debug((TraceComponent)_tc, (String)repositoryException.toString());
            return null;
        }
    }

    public void updateFile(String string, File file) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"updateFile", (Object)string);
        try {
            DocumentContentSource documentContentSource = this.getDocumentContentSourceOfFile(string);
            FileUploadInputStream fileUploadInputStream = new FileUploadInputStream();
            fileUploadInputStream.setStream((InputStream)new FileInputStream(file));
            documentContentSource.setSource((InputStream)fileUploadInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WASUpgradeException();
        }
    }

    public void updateFile(String string, ByteArrayInputStream byteArrayInputStream) {
        Tr.entry((TraceComponent)_tc, (String)"updateFile", (Object)string);
        DocumentContentSource documentContentSource = this.getDocumentContentSourceOfFile(string);
        FileUploadInputStream fileUploadInputStream = new FileUploadInputStream();
        fileUploadInputStream.setStream((InputStream)byteArrayInputStream);
        documentContentSource.setSource((InputStream)fileUploadInputStream);
    }

    public void updateNewEntries() throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"updateNewEntries");
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[this._dCSConfigNewEntries.size()];
        this._dCSConfigNewEntries.toArray(documentContentSourceArray);
        try {
            this._activeRepository.create(documentContentSourceArray);
        }
        catch (RepositoryException repositoryException) {
            throw new WASUpgradeException();
        }
    }

    public void updateAll() throws WASUpgradeException {
        DocumentContentSource documentContentSource;
        int n;
        Tr.entry((TraceComponent)_tc, (String)"updateAll");
        for (n = 0; n < this._dCSConfig.size(); ++n) {
            documentContentSource = (DocumentContentSource)this._dCSConfig.get(n);
            if (!(documentContentSource.getSource() instanceof FileDownloadInputStream)) continue;
            Tr.debug((TraceComponent)_tc, (String)("No changes have been detected in file " + documentContentSource.getDocument().getURI() + " so will not be saving file."));
            this._dCSConfig.remove(n--);
        }
        for (n = 0; n < this._dCSConfig.size(); ++n) {
            documentContentSource = (DocumentContentSource)this._dCSConfig.get(n);
            if (!documentContentSource.getDocument().getURI().startsWith("templates")) continue;
            this._dCSConfig.remove(n--);
        }
        for (n = 0; n < this._dCSConfig.size(); ++n) {
            documentContentSource = (DocumentContentSource)this._dCSConfig.get(n);
            if (!documentContentSource.getDocument().getURI().endsWith(".policy")) continue;
            this._dCSConfig.remove(n--);
        }
        for (n = 0; n < this._dCSConfig.size(); ++n) {
            documentContentSource = (DocumentContentSource)this._dCSConfig.get(n);
            if (!documentContentSource.getDocument().getURI().endsWith(".properties")) continue;
            this._dCSConfig.remove(n--);
        }
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[this._dCSConfig.size()];
        this._dCSConfig.toArray(documentContentSourceArray);
        documentContentSource = new DocumentContentSource[this._dCSConfigNewEntries.size()];
        this._dCSConfigNewEntries.toArray((T[])documentContentSource);
        Document[] documentArray = new Document[this._dConfigDeletedEntries.size()];
        this._dConfigDeletedEntries.toArray(documentArray);
        try {
            this._activeRepository.update((DocumentContentSource[])documentContentSource, documentContentSourceArray, documentArray);
            this._dCSConfig.clear();
            this._dCSConfigNewEntries.clear();
            this._dConfigDeletedEntries.clear();
        }
        catch (RepositoryException repositoryException) {
            throw new WASUpgradeException();
        }
    }

    public InputStream createConfigurationDirFile(String string) {
        Tr.entry((TraceComponent)_tc, (String)"createConfigurationDirFile", (Object)string);
        Object var2_2 = null;
        DocumentContentSource documentContentSource = null;
        string = new File(string).getAbsolutePath();
        string = string.replace('\\', '/');
        String string2 = string.substring(string.indexOf("cells/"));
        documentContentSource = new DocumentContentSource(new Document(string2), new byte[0]);
        if (this._originalNodeLevelFiles.contains(string2)) {
            Iterator iterator = this._dCSConfig.iterator();
            Object var6_6 = null;
            while (iterator.hasNext()) {
                documentContentSource = (DocumentContentSource)iterator.next();
                if (!string.replace('\\', '/').endsWith(documentContentSource.getDocument().getURI())) continue;
                documentContentSource.setSource(new byte[0]);
            }
        } else {
            this._dCSConfigNewEntries.add(documentContentSource);
        }
        return documentContentSource.getSource();
    }

    public Resource getResource(InputStream inputStream, String string) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getResource", (Object)new Object[]{inputStream, string});
        Repository repository = RepositoryFactory.createRepository((String)this._configRoot, (String)this._cellName, null, null);
        Resource resource = null;
        try {
            URI uRI = URI.createFileURI((String)string);
            Tr.debug((TraceComponent)_tc, (String)("uri path=" + uRI.devicePath()));
            resource = this._resourceSet.getResource(uRI, false);
            if (resource == null) {
                Tr.debug((TraceComponent)_tc, (String)"resource=null");
                resource = new WASResourceImpl(URI.createFileURI((String)string));
                this._resourceSet.getResources().add((Object)resource);
                Tr.debug((TraceComponent)_tc, (String)("in.available=" + inputStream.available()));
                resource.load(inputStream, new HashMap());
            }
            Tr.debug((TraceComponent)_tc, (String)("Closing InputStream on file " + string));
            inputStream.close();
            return resource;
        }
        catch (IOException iOException) {
            Tr.debug((TraceComponent)_tc, (String)("Problem opening file: " + string));
            Tr.debug((TraceComponent)_tc, (String)iOException.toString());
            if (iOException instanceof Resource.IOWrappedException) {
                Resource.IOWrappedException iOWrappedException = (Resource.IOWrappedException)iOException;
                Tr.debug((TraceComponent)_tc, (String)"Resource.IOWrappedException Stack Trace to follow", (Object)iOWrappedException);
            }
            return resource;
        }
    }

    public Resource getResource(String string) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getResource", (Object)string);
        DocumentContentSource documentContentSource = null;
        try {
            documentContentSource = this._activeRepository.extract(string);
        }
        catch (RepositoryException repositoryException) {
            throw new WASUpgradeException();
        }
        return this.getResource(documentContentSource);
    }

    public Resource getResource(DocumentContentSource documentContentSource) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getResource", (Object)documentContentSource);
        try {
            Resource resource = this._resourceSet.getResource(URI.createFileURI((String)documentContentSource.getDocument().getURI()), false);
            if (resource == null) {
                resource = new WASResourceImpl(URI.createFileURI((String)documentContentSource.getDocument().getURI()));
                resource.load(documentContentSource.getSource(), new HashMap());
            }
            Tr.debug((TraceComponent)_tc, (String)("Closing InputStream on file " + documentContentSource.getDocument().getURI()));
            documentContentSource.getSource().close();
            return resource;
        }
        catch (IOException iOException) {
            throw new WASUpgradeException();
        }
    }

    private void gatherAllValidConnectionInfoSets() throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"gatherAllValidConnections");
        Resource resource = null;
        String[] stringArray = null;
        if (this._cellName != null) {
            stringArray = this._localRepository.listResourceNames("cells/" + this._cellName + "/" + "nodes" + "/", 2, 1);
        }
        block2: for (int i = 0; i < stringArray.length; ++i) {
            resource = this.getResource((String)stringArray[i] + "/" + "serverindex.xml");
            ServerIndex serverIndex = this.locateServerIndex(resource);
            EList eList = serverIndex.getServerEntries();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry = (ServerEntry)iterator.next();
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                this._validConnectionProps.add(hashtable);
                EList eList2 = serverEntry.getSpecialEndpoints();
                Iterator iterator2 = eList2.iterator();
                while (iterator2.hasNext()) {
                    EndPoint endPoint;
                    NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                    String string = namedEndPoint.getEndPointName();
                    if (string.equals("SOAP_CONNECTOR_ADDRESS")) {
                        endPoint = namedEndPoint.getEndPoint();
                        hashtable.put(SOAP_PORT, new Integer(endPoint.getPort()).toString());
                        hashtable.put(SOAP_HOST, endPoint.getHost());
                    }
                    if (!string.equals("BOOTSTRAP_ADDRESS")) continue;
                    endPoint = namedEndPoint.getEndPoint();
                    hashtable.put(RMI_PORT, new Integer(endPoint.getPort()).toString());
                    hashtable.put(RMI_HOST, endPoint.getHost());
                }
                if (!serverEntry.getServerType().equals("DEPLOYMENT_MANAGER")) continue;
                this._validConnectionProps.clear();
                this._validConnectionProps.add(hashtable);
                i = stringArray.length;
                continue block2;
            }
        }
        if (this._validConnectionProps.size() != 0) {
            this.processSecurityFile();
        }
    }

    private void getActiveConnectionConfigRepository() {
        int n;
        Tr.entry((TraceComponent)_tc, (String)"getActiveConnectionConfigRepository");
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Thread thread = null;
        for (n = 0; n < this._validConnectionProps.size(); ++n) {
            ConfigRepositoryConnection configRepositoryConnection = new ConfigRepositoryConnection((Hashtable)this._validConnectionProps.get(n));
            thread = new Thread(configRepositoryConnection);
            thread.start();
            arrayList.add(thread);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            try {
                ((Thread)arrayList.get(n)).join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                Tr.debug((TraceComponent)_tc, (String)interruptedException.toString());
            }
        }
    }

    private void processSecurityFile() throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"processSecurityFile");
        Resource resource = this.getResource("cells/" + this._cellName + "/" + "security.xml");
        Security security = this.locateSecurity(resource);
        this._isGlobalSecurityEnabled = security.isEnabled();
    }

    private Security locateSecurity(Resource resource) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"locateSecurity", (Object)resource);
        EList eList = resource.getContents();
        Iterator iterator = eList.iterator();
        Object var4_4 = null;
        while (iterator.hasNext() && var4_4 == null) {
            Object e = iterator.next();
            if (!(e instanceof Security)) continue;
            return (Security)e;
        }
        return null;
    }

    private ServerIndex locateServerIndex(Resource resource) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"locateServerIndex", (Object)resource);
        EList eList = resource.getContents();
        Iterator iterator = eList.iterator();
        Object var4_4 = null;
        while (iterator.hasNext() && var4_4 == null) {
            Object e = iterator.next();
            if (!(e instanceof ServerIndex)) continue;
            return (ServerIndex)e;
        }
        return null;
    }

    private class ConfigRepositoryConnection
    implements Runnable {
        private Hashtable _connInfo = null;

        ConfigRepositoryConnection(Hashtable hashtable) {
            this._connInfo = hashtable;
        }

        public void run() {
            this.initializeConfigRepository();
        }

        private void initializeConfigRepository() {
            Tr.entry((TraceComponent)_tc, (String)"initializeConfigRepository");
            Properties properties = new Properties();
            properties.setProperty("location", ConfigRepositoryHelper.CONNECTION_TYPE_SERVER);
            if (this._connInfo.containsKey(ConfigRepositoryHelper.SOAP_PORT)) {
                properties.setProperty("type", "SOAP");
                properties.setProperty("port", (String)this._connInfo.get(ConfigRepositoryHelper.SOAP_PORT));
                properties.setProperty("host", (String)this._connInfo.get(ConfigRepositoryHelper.SOAP_HOST));
            } else if (this._connInfo.containsKey(ConfigRepositoryHelper.RMI_PORT)) {
                properties.setProperty("type", "RMI");
                properties.setProperty("port", (String)this._connInfo.get(ConfigRepositoryHelper.RMI_PORT));
                properties.setProperty("host", (String)this._connInfo.get(ConfigRepositoryHelper.RMI_HOST));
            }
            if (ConfigRepositoryHelper.this._isGlobalSecurityEnabled) {
                properties.setProperty("username", ConfigRepositoryHelper.this._globalSecurityUserID);
                properties.setProperty("password", ConfigRepositoryHelper.this._globalSecurityPassword);
            }
            try {
                if (ConfigRepositoryHelper.this._remoteRepository == null) {
                    Tr.debug((TraceComponent)_tc, (String)"DeploymentManager Connection Set settings");
                    Iterator<Object> iterator = properties.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = (String)properties.get(string);
                        if (UtilityImpl.containPassword(string)) {
                            Tr.debug((TraceComponent)_tc, (String)("key=" + string + " value=" + "xxxxxx"));
                            continue;
                        }
                        Tr.debug((TraceComponent)_tc, (String)("key=" + string + " value=" + string2));
                    }
                    ConfigRepositoryHelper.this._remoteRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)properties);
                    ConfigRepositoryHelper.this._remoteRepository.initialize(new Properties());
                    Tr.debug((TraceComponent)_tc, (String)"DeploymentManager Connection Established");
                    _DMConnectionProps = properties;
                }
            }
            catch (AdminException adminException) {
                Tr.debug((TraceComponent)_tc, (String)"AdminException to follow from method initializeConfigRepository()");
                Tr.debug((TraceComponent)_tc, (String)adminException.toString());
            }
        }
    }
}

